/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mohistmc.util.i18n.i18n;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldOptimizer {
    private static final Logger field_212219_a = LogManager.getLogger();
    private static final ThreadFactory field_212220_b = new ThreadFactoryBuilder().setDaemon(true).build();
    private final ImmutableSet<RegistryKey<World>> field_233529_c_;
    private final boolean field_219957_d;
    private final SaveFormat.LevelSave field_212221_c;
    private final Thread field_212223_e;
    private final DataFixer field_233530_g_;
    private volatile boolean field_212224_f = true;
    private volatile boolean field_212225_g;
    private volatile float field_212232_n;
    private volatile int field_212233_o;
    private volatile int field_212234_p;
    private volatile int field_212235_q;
    private final Object2FloatMap<RegistryKey<World>> field_212544_m = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(Util.func_212443_g()));
    private volatile ITextComponent field_212236_r = new TranslationTextComponent("optimizeWorld.stage.counting");
    private static final Pattern field_219959_p = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final DimensionSavedDataManager field_219960_q;

    public WorldOptimizer(SaveFormat.LevelSave p_i231486_1_, DataFixer p_i231486_2_, ImmutableSet<RegistryKey<World>> p_i231486_3_, boolean p_i231486_4_) {
        this.field_233529_c_ = p_i231486_3_;
        this.field_219957_d = p_i231486_4_;
        this.field_233530_g_ = p_i231486_2_;
        this.field_212221_c = p_i231486_1_;
        this.field_219960_q = new DimensionSavedDataManager(new File(this.field_212221_c.func_237291_a_(World.field_234918_g_), "data"), p_i231486_2_);
        this.field_212223_e = field_212220_b.newThread(this::func_212216_o);
        this.field_212223_e.setUncaughtExceptionHandler((p_219956_1_, p_219956_2_) -> {
            field_212219_a.error(i18n.get((String)"worldoptimizer.1", (Object[])new Object[]{p_219956_2_}));
            this.field_212236_r = new TranslationTextComponent("optimizeWorld.stage.failed");
            this.field_212225_g = true;
        });
        this.field_212223_e.start();
    }

    public void func_212217_a() {
        this.field_212224_f = false;
        try {
            this.field_212223_e.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void func_212216_o() {
        this.field_212233_o = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RegistryKey registrykey : this.field_233529_c_) {
            List<ChunkPos> list = this.func_233532_b_(registrykey);
            builder.put((Object)registrykey, list.listIterator());
            this.field_212233_o += list.size();
        }
        if (this.field_212233_o == 0) {
            this.field_212225_g = true;
        } else {
            float f1 = this.field_212233_o;
            ImmutableMap immutablemap = builder.build();
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            for (RegistryKey registrykey1 : this.field_233529_c_) {
                File file1 = this.field_212221_c.func_237291_a_(registrykey1);
                builder1.put((Object)registrykey1, (Object)new ChunkLoader(new File(file1, "region"), this.field_233530_g_, true));
            }
            ImmutableMap immutablemap1 = builder1.build();
            long i = Util.func_211177_b();
            this.field_212236_r = new TranslationTextComponent("optimizeWorld.stage.upgrading");
            while (this.field_212224_f) {
                boolean flag = false;
                float f = 0.0f;
                for (RegistryKey registrykey2 : this.field_233529_c_) {
                    ListIterator listiterator = (ListIterator)immutablemap.get((Object)registrykey2);
                    ChunkLoader chunkloader = (ChunkLoader)immutablemap1.get((Object)registrykey2);
                    if (listiterator.hasNext()) {
                        ChunkPos chunkpos = (ChunkPos)listiterator.next();
                        boolean flag1 = false;
                        try {
                            CompoundNBT compoundnbt = chunkloader.func_227078_e_(chunkpos);
                            if (compoundnbt != null) {
                                boolean flag2;
                                int j = ChunkLoader.func_219165_a((CompoundNBT)compoundnbt);
                                CompoundNBT compoundnbt1 = chunkloader.func_235968_a_(registrykey2, () -> this.field_219960_q, compoundnbt);
                                CompoundNBT compoundnbt2 = compoundnbt1.func_74775_l("Level");
                                ChunkPos chunkpos1 = new ChunkPos(compoundnbt2.func_74762_e("xPos"), compoundnbt2.func_74762_e("zPos"));
                                if (!chunkpos1.equals((Object)chunkpos)) {
                                    field_212219_a.warn(i18n.get((String)"worldoptimizer.2", (Object[])new Object[]{chunkpos, chunkpos1}));
                                }
                                boolean bl = flag2 = j < SharedConstants.func_215069_a().getWorldVersion();
                                if (this.field_219957_d) {
                                    flag2 = flag2 || compoundnbt2.func_74764_b("Heightmaps");
                                    compoundnbt2.func_82580_o("Heightmaps");
                                    flag2 = flag2 || compoundnbt2.func_74764_b("isLightOn");
                                    compoundnbt2.func_82580_o("isLightOn");
                                }
                                if (flag2) {
                                    chunkloader.func_219100_a(chunkpos, compoundnbt1);
                                    flag1 = true;
                                }
                            }
                        }
                        catch (ReportedException reportedexception) {
                            Throwable throwable = reportedexception.getCause();
                            if (!(throwable instanceof IOException)) {
                                throw reportedexception;
                            }
                            field_212219_a.error(i18n.get((String)"worldoptimizer.3", (Object[])new Object[]{chunkpos, throwable}));
                        }
                        catch (IOException ioexception1) {
                            field_212219_a.error(i18n.get((String)"worldoptimizer.4", (Object[])new Object[]{chunkpos, ioexception1}));
                        }
                        if (flag1) {
                            ++this.field_212234_p;
                        } else {
                            ++this.field_212235_q;
                        }
                        flag = true;
                    }
                    float f2 = (float)listiterator.nextIndex() / f1;
                    this.field_212544_m.put((Object)registrykey2, f2);
                    f += f2;
                }
                this.field_212232_n = f;
                if (flag) continue;
                this.field_212224_f = false;
            }
            this.field_212236_r = new TranslationTextComponent("optimizeWorld.stage.finished");
            for (ChunkLoader chunkloader1 : immutablemap1.values()) {
                try {
                    chunkloader1.close();
                }
                catch (IOException ioexception) {
                    field_212219_a.error(i18n.get((String)"worldoptimizer.5", (Object[])new Object[]{ioexception}));
                }
            }
            this.field_219960_q.func_212775_b();
            i = Util.func_211177_b() - i;
            field_212219_a.info(i18n.get((String)"worldoptimizer.6", (Object[])new Object[]{i}));
            this.field_212225_g = true;
        }
    }

    private List<ChunkPos> func_233532_b_(RegistryKey<World> p_233532_1_) {
        File file1 = this.field_212221_c.func_237291_a_(p_233532_1_);
        File file2 = new File(file1, "region");
        File[] afile = file2.listFiles((p_219954_0_, p_219954_1_) -> p_219954_1_.endsWith(".mca"));
        if (afile == null) {
            return ImmutableList.of();
        }
        ArrayList list = Lists.newArrayList();
        for (File file3 : afile) {
            Matcher matcher = field_219959_p.matcher(file3.getName());
            if (!matcher.matches()) continue;
            int i = Integer.parseInt(matcher.group(1)) << 5;
            int j = Integer.parseInt(matcher.group(2)) << 5;
            try (RegionFile regionfile = new RegionFile(file3, file2, true);){
                for (int k = 0; k < 32; ++k) {
                    for (int l = 0; l < 32; ++l) {
                        ChunkPos chunkpos = new ChunkPos(k + i, l + j);
                        if (!regionfile.func_222662_b(chunkpos)) continue;
                        list.add(chunkpos);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list;
    }

    public boolean func_212218_b() {
        return this.field_212225_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ImmutableSet<RegistryKey<World>> func_233533_c_() {
        return this.field_233529_c_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_233531_a_(RegistryKey<World> p_233531_1_) {
        return this.field_212544_m.getFloat(p_233531_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_212207_i() {
        return this.field_212232_n;
    }

    public int func_212211_j() {
        return this.field_212233_o;
    }

    public int func_212208_k() {
        return this.field_212234_p;
    }

    public int func_212209_l() {
        return this.field_212235_q;
    }

    public ITextComponent func_212215_m() {
        return this.field_212236_r;
    }
}

