/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mohistmc.util.i18n.i18n;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.fixes.AddNewChoices;
import net.minecraft.util.datafix.fixes.LeavesFix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrappedChestTileEntitySplit
extends DataFix {
    private static final Logger field_212536_a = LogManager.getLogger();

    public TrappedChestTileEntitySplit(Schema p_i49815_1_, boolean p_i49815_2_) {
        super(p_i49815_1_, p_i49815_2_);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(TypeReferences.field_211287_c);
        Type type1 = type.findFieldType("Level");
        Type type2 = type1.findFieldType("TileEntities");
        if (!(type2 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType listtype = (List.ListType)type2;
        OpticFinder opticfinder = DSL.fieldFinder((String)"TileEntities", (Type)listtype);
        Type type3 = this.getInputSchema().getType(TypeReferences.field_211287_c);
        OpticFinder opticfinder1 = type3.findField("Level");
        OpticFinder opticfinder2 = opticfinder1.type().findField("Sections");
        Type type4 = opticfinder2.type();
        if (!(type4 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        Type type5 = ((List.ListType)type4).getElement();
        OpticFinder opticfinder3 = DSL.typeFinder((Type)type5);
        return TypeRewriteRule.seq((TypeRewriteRule)new AddNewChoices(this.getOutputSchema(), "AddTrappedChestFix", TypeReferences.field_211294_j).makeRule(), (TypeRewriteRule)this.fixTypeEverywhereTyped("Trapped Chest fix", type3, p_212533_5_ -> p_212533_5_.updateTyped(opticfinder1, p_212531_4_ -> {
            Optional optional = p_212531_4_.getOptionalTyped(opticfinder2);
            if (!optional.isPresent()) {
                return p_212531_4_;
            }
            List list = ((Typed)optional.get()).getAllTyped(opticfinder3);
            IntOpenHashSet intset = new IntOpenHashSet();
            for (Typed typed : list) {
                Section trappedchesttileentitysplit$section = new Section(typed, this.getInputSchema());
                if (trappedchesttileentitysplit$section.func_208461_a()) continue;
                for (int i = 0; i < 4096; ++i) {
                    int j = trappedchesttileentitysplit$section.func_208453_a(i);
                    if (!trappedchesttileentitysplit$section.func_212511_a(j)) continue;
                    intset.add(trappedchesttileentitysplit$section.func_208456_b() << 12 | i);
                }
            }
            Dynamic dynamic = (Dynamic)p_212531_4_.get(DSL.remainderFinder());
            int k = dynamic.get("xPos").asInt(0);
            int l = dynamic.get("zPos").asInt(0);
            TaggedChoice.TaggedChoiceType taggedchoicetype = this.getInputSchema().findChoiceType(TypeReferences.field_211294_j);
            return p_212531_4_.updateTyped(opticfinder, arg_0 -> TrappedChestTileEntitySplit.lambda$makeRule$3(taggedchoicetype, k, l, (IntSet)intset, arg_0));
        })));
    }

    private static /* synthetic */ Typed lambda$makeRule$3(TaggedChoice.TaggedChoiceType taggedchoicetype, int k, int l, IntSet intset, Typed p_212532_4_) {
        return p_212532_4_.updateTyped(taggedchoicetype.finder(), p_212530_4_ -> {
            int k1;
            int j1;
            Dynamic dynamic1 = (Dynamic)p_212530_4_.getOrCreate(DSL.remainderFinder());
            int i1 = dynamic1.get("x").asInt(0) - (k << 4);
            return intset.contains(LeavesFix.func_208411_a((int)i1, (int)(j1 = dynamic1.get("y").asInt(0)), (int)(k1 = dynamic1.get("z").asInt(0) - (l << 4)))) ? p_212530_4_.update(taggedchoicetype.finder(), p_212534_0_ -> p_212534_0_.mapFirst(p_212535_0_ -> {
                if (!Objects.equals(p_212535_0_, "minecraft:chest")) {
                    field_212536_a.warn(i18n.get((String)"trappedchesttileentitysplit.1"));
                }
                return "minecraft:trapped_chest";
            })) : p_212530_4_;
        });
    }

    public static final class Section
    extends LeavesFix.Section {
        @Nullable
        private IntSet field_212512_f;

        public Section(Typed<?> p_i49831_1_, Schema p_i49831_2_) {
            super(p_i49831_1_, p_i49831_2_);
        }

        protected boolean func_212508_a() {
            this.field_212512_f = new IntOpenHashSet();
            for (int i = 0; i < this.field_208469_d.size(); ++i) {
                Dynamic dynamic = (Dynamic)this.field_208469_d.get(i);
                String s = dynamic.get("Name").asString("");
                if (!Objects.equals(s, "minecraft:trapped_chest")) continue;
                this.field_212512_f.add(i);
            }
            return this.field_212512_f.isEmpty();
        }

        public boolean func_212511_a(int p_212511_1_) {
            return this.field_212512_f.contains(p_212511_1_);
        }
    }
}

