/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math.shapes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.DoubleCubeMergingList;
import net.minecraft.util.math.shapes.DoubleRangeList;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.IDoubleListMerger;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.IndirectMerger;
import net.minecraft.util.math.shapes.NonOverlappingMerger;
import net.minecraft.util.math.shapes.SimpleDoubleMerger;
import net.minecraft.util.math.shapes.SplitVoxelShape;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapeArray;
import net.minecraft.util.math.shapes.VoxelShapeCube;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class VoxelShapes {
    private static final VoxelShape field_197887_b = (VoxelShape)Util.func_199748_a(() -> {
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(1, 1, 1);
        voxelshapepart.func_199625_a(0, 0, 0, true, true);
        return new VoxelShapeCube((VoxelShapePart)voxelshapepart);
    });
    public static final VoxelShape field_216389_a = VoxelShapes.func_197873_a(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape field_197886_a = new VoxelShapeArray((VoxelShapePart)new BitSetVoxelShapePart(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));

    public static VoxelShape func_197880_a() {
        return field_197886_a;
    }

    public static VoxelShape func_197868_b() {
        return field_197887_b;
    }

    public static VoxelShape func_197873_a(double p_197873_0_, double p_197873_2_, double p_197873_4_, double p_197873_6_, double p_197873_8_, double p_197873_10_) {
        return VoxelShapes.func_197881_a(new AxisAlignedBB(p_197873_0_, p_197873_2_, p_197873_4_, p_197873_6_, p_197873_8_, p_197873_10_));
    }

    public static VoxelShape func_197881_a(AxisAlignedBB p_197881_0_) {
        int i = VoxelShapes.func_197885_a(p_197881_0_.field_72340_a, p_197881_0_.field_72336_d);
        int j = VoxelShapes.func_197885_a(p_197881_0_.field_72338_b, p_197881_0_.field_72337_e);
        int k = VoxelShapes.func_197885_a(p_197881_0_.field_72339_c, p_197881_0_.field_72334_f);
        if (i >= 0 && j >= 0 && k >= 0) {
            if (i == 0 && j == 0 && k == 0) {
                return p_197881_0_.func_197744_e(0.5, 0.5, 0.5) ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
            }
            int l = 1 << i;
            int i1 = 1 << j;
            int j1 = 1 << k;
            int k1 = (int)Math.round(p_197881_0_.field_72340_a * (double)l);
            int l1 = (int)Math.round(p_197881_0_.field_72336_d * (double)l);
            int i2 = (int)Math.round(p_197881_0_.field_72338_b * (double)i1);
            int j2 = (int)Math.round(p_197881_0_.field_72337_e * (double)i1);
            int k2 = (int)Math.round(p_197881_0_.field_72339_c * (double)j1);
            int l2 = (int)Math.round(p_197881_0_.field_72334_f * (double)j1);
            BitSetVoxelShapePart bitsetvoxelshapepart = new BitSetVoxelShapePart(l, i1, j1, k1, i2, k2, l1, j2, l2);
            for (long i3 = (long)k1; i3 < (long)l1; ++i3) {
                for (long j3 = (long)i2; j3 < (long)j2; ++j3) {
                    for (long k3 = (long)k2; k3 < (long)l2; ++k3) {
                        bitsetvoxelshapepart.func_199625_a((int)i3, (int)j3, (int)k3, false, true);
                    }
                }
            }
            return new VoxelShapeCube((VoxelShapePart)bitsetvoxelshapepart);
        }
        return new VoxelShapeArray(VoxelShapes.field_197887_b.field_197768_g, new double[]{p_197881_0_.field_72340_a, p_197881_0_.field_72336_d}, new double[]{p_197881_0_.field_72338_b, p_197881_0_.field_72337_e}, new double[]{p_197881_0_.field_72339_c, p_197881_0_.field_72334_f});
    }

    private static int func_197885_a(double p_197885_0_, double p_197885_2_) {
        if (!(p_197885_0_ < -1.0E-7) && !(p_197885_2_ > 1.0000001)) {
            for (int i = 0; i <= 3; ++i) {
                boolean flag1;
                double d0 = p_197885_0_ * (double)(1 << i);
                double d1 = p_197885_2_ * (double)(1 << i);
                boolean flag = Math.abs(d0 - Math.floor(d0)) < 1.0E-7;
                boolean bl = flag1 = Math.abs(d1 - Math.floor(d1)) < 1.0E-7;
                if (!flag || !flag1) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    protected static long func_197877_a(int p_197877_0_, int p_197877_1_) {
        return (long)p_197877_0_ * (long)(p_197877_1_ / IntMath.gcd((int)p_197877_0_, (int)p_197877_1_));
    }

    public static VoxelShape func_197872_a(VoxelShape p_197872_0_, VoxelShape p_197872_1_) {
        return VoxelShapes.func_197878_a(p_197872_0_, p_197872_1_, IBooleanFunction.field_223244_o_);
    }

    public static VoxelShape func_216384_a(VoxelShape p_216384_0_, VoxelShape ... p_216384_1_) {
        return Arrays.stream(p_216384_1_).reduce(p_216384_0_, VoxelShapes::func_197872_a);
    }

    public static VoxelShape func_197878_a(VoxelShape p_197878_0_, VoxelShape p_197878_1_, IBooleanFunction p_197878_2_) {
        return VoxelShapes.func_197882_b(p_197878_0_, p_197878_1_, p_197878_2_).func_197753_c();
    }

    public static VoxelShape func_197882_b(VoxelShape p_197882_0_, VoxelShape p_197882_1_, IBooleanFunction p_197882_2_) {
        if (p_197882_2_.apply(false, false)) {
            throw Util.func_229757_c_(new IllegalArgumentException());
        }
        if (p_197882_0_ == p_197882_1_) {
            return p_197882_2_.apply(true, true) ? p_197882_0_ : VoxelShapes.func_197880_a();
        }
        boolean flag = p_197882_2_.apply(true, false);
        boolean flag1 = p_197882_2_.apply(false, true);
        if (p_197882_0_.func_197766_b()) {
            return flag1 ? p_197882_1_ : VoxelShapes.func_197880_a();
        }
        if (p_197882_1_.func_197766_b()) {
            return flag ? p_197882_0_ : VoxelShapes.func_197880_a();
        }
        IDoubleListMerger idoublelistmerger = VoxelShapes.func_199410_a(1, p_197882_0_.func_197757_a(Direction.Axis.X), p_197882_1_.func_197757_a(Direction.Axis.X), flag, flag1);
        IDoubleListMerger idoublelistmerger1 = VoxelShapes.func_199410_a(idoublelistmerger.func_212435_a().size() - 1, p_197882_0_.func_197757_a(Direction.Axis.Y), p_197882_1_.func_197757_a(Direction.Axis.Y), flag, flag1);
        IDoubleListMerger idoublelistmerger2 = VoxelShapes.func_199410_a((idoublelistmerger.func_212435_a().size() - 1) * (idoublelistmerger1.func_212435_a().size() - 1), p_197882_0_.func_197757_a(Direction.Axis.Z), p_197882_1_.func_197757_a(Direction.Axis.Z), flag, flag1);
        BitSetVoxelShapePart bitsetvoxelshapepart = BitSetVoxelShapePart.func_197852_a((VoxelShapePart)p_197882_0_.field_197768_g, (VoxelShapePart)p_197882_1_.field_197768_g, (IDoubleListMerger)idoublelistmerger, (IDoubleListMerger)idoublelistmerger1, (IDoubleListMerger)idoublelistmerger2, (IBooleanFunction)p_197882_2_);
        return idoublelistmerger instanceof DoubleCubeMergingList && idoublelistmerger1 instanceof DoubleCubeMergingList && idoublelistmerger2 instanceof DoubleCubeMergingList ? new VoxelShapeCube((VoxelShapePart)bitsetvoxelshapepart) : new VoxelShapeArray((VoxelShapePart)bitsetvoxelshapepart, idoublelistmerger.func_212435_a(), idoublelistmerger1.func_212435_a(), idoublelistmerger2.func_212435_a());
    }

    public static boolean func_197879_c(VoxelShape p_197879_0_, VoxelShape p_197879_1_, IBooleanFunction p_197879_2_) {
        if (p_197879_2_.apply(false, false)) {
            throw Util.func_229757_c_(new IllegalArgumentException());
        }
        if (p_197879_0_ == p_197879_1_) {
            return p_197879_2_.apply(true, true);
        }
        if (p_197879_0_.func_197766_b()) {
            return p_197879_2_.apply(false, !p_197879_1_.func_197766_b());
        }
        if (p_197879_1_.func_197766_b()) {
            return p_197879_2_.apply(!p_197879_0_.func_197766_b(), false);
        }
        boolean flag = p_197879_2_.apply(true, false);
        boolean flag1 = p_197879_2_.apply(false, true);
        for (Direction.Axis direction$axis : AxisRotation.field_197521_d) {
            if (p_197879_0_.func_197758_c(direction$axis) < p_197879_1_.func_197762_b(direction$axis) - 1.0E-7) {
                return flag || flag1;
            }
            if (!(p_197879_1_.func_197758_c(direction$axis) < p_197879_0_.func_197762_b(direction$axis) - 1.0E-7)) continue;
            return flag || flag1;
        }
        IDoubleListMerger idoublelistmerger = VoxelShapes.func_199410_a(1, p_197879_0_.func_197757_a(Direction.Axis.X), p_197879_1_.func_197757_a(Direction.Axis.X), flag, flag1);
        IDoubleListMerger idoublelistmerger1 = VoxelShapes.func_199410_a(idoublelistmerger.func_212435_a().size() - 1, p_197879_0_.func_197757_a(Direction.Axis.Y), p_197879_1_.func_197757_a(Direction.Axis.Y), flag, flag1);
        IDoubleListMerger idoublelistmerger2 = VoxelShapes.func_199410_a((idoublelistmerger.func_212435_a().size() - 1) * (idoublelistmerger1.func_212435_a().size() - 1), p_197879_0_.func_197757_a(Direction.Axis.Z), p_197879_1_.func_197757_a(Direction.Axis.Z), flag, flag1);
        return VoxelShapes.func_197874_a(idoublelistmerger, idoublelistmerger1, idoublelistmerger2, p_197879_0_.field_197768_g, p_197879_1_.field_197768_g, p_197879_2_);
    }

    private static boolean func_197874_a(IDoubleListMerger p_197874_0_, IDoubleListMerger p_197874_1_, IDoubleListMerger p_197874_2_, VoxelShapePart p_197874_3_, VoxelShapePart p_197874_4_, IBooleanFunction p_197874_5_) {
        return !p_197874_0_.func_197855_a((p_199861_5_, p_199861_6_, p_199861_7_) -> p_197874_1_.func_197855_a((p_199860_6_, p_199860_7_, p_199860_8_) -> p_197874_2_.func_197855_a((p_199862_7_, p_199862_8_, p_199862_9_) -> !p_197874_5_.apply(p_197874_3_.func_197818_c(p_199861_5_, p_199860_6_, p_199862_7_), p_197874_4_.func_197818_c(p_199861_6_, p_199860_7_, p_199862_8_)))));
    }

    public static double func_212437_a(Direction.Axis p_212437_0_, AxisAlignedBB p_212437_1_, Stream<VoxelShape> p_212437_2_, double p_212437_3_) {
        Iterator iterator = p_212437_2_.iterator();
        while (iterator.hasNext()) {
            if (Math.abs(p_212437_3_) < 1.0E-7) {
                return 0.0;
            }
            p_212437_3_ = ((VoxelShape)iterator.next()).func_212430_a(p_212437_0_, p_212437_1_, p_212437_3_);
        }
        return p_212437_3_;
    }

    public static double func_216383_a(Direction.Axis p_216383_0_, AxisAlignedBB p_216383_1_, IWorldReader p_216383_2_, double p_216383_3_, ISelectionContext p_216383_5_, Stream<VoxelShape> p_216383_6_) {
        return VoxelShapes.func_216386_a(p_216383_1_, p_216383_2_, p_216383_3_, p_216383_5_, AxisRotation.func_197516_a((Direction.Axis)p_216383_0_, (Direction.Axis)Direction.Axis.Z), p_216383_6_);
    }

    private static double func_216386_a(AxisAlignedBB p_216386_0_, IWorldReader p_216386_1_, double p_216386_2_, ISelectionContext p_216386_4_, AxisRotation p_216386_5_, Stream<VoxelShape> p_216386_6_) {
        if (!(p_216386_0_.func_216364_b() < 1.0E-6 || p_216386_0_.func_216360_c() < 1.0E-6 || p_216386_0_.func_216362_d() < 1.0E-6)) {
            if (Math.abs(p_216386_2_) < 1.0E-7) {
                return 0.0;
            }
            AxisRotation axisrotation = p_216386_5_.func_197514_a();
            Direction.Axis direction$axis = axisrotation.func_197513_a(Direction.Axis.X);
            Direction.Axis direction$axis1 = axisrotation.func_197513_a(Direction.Axis.Y);
            Direction.Axis direction$axis2 = axisrotation.func_197513_a(Direction.Axis.Z);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int i = MathHelper.func_76128_c((double)(p_216386_0_.func_197745_a(direction$axis) - 1.0E-7)) - 1;
            int j = MathHelper.func_76128_c((double)(p_216386_0_.func_197742_b(direction$axis) + 1.0E-7)) + 1;
            int k = MathHelper.func_76128_c((double)(p_216386_0_.func_197745_a(direction$axis1) - 1.0E-7)) - 1;
            int l = MathHelper.func_76128_c((double)(p_216386_0_.func_197742_b(direction$axis1) + 1.0E-7)) + 1;
            double d0 = p_216386_0_.func_197745_a(direction$axis2) - 1.0E-7;
            double d1 = p_216386_0_.func_197742_b(direction$axis2) + 1.0E-7;
            boolean flag = p_216386_2_ > 0.0;
            int i1 = flag ? MathHelper.func_76128_c((double)(p_216386_0_.func_197742_b(direction$axis2) - 1.0E-7)) - 1 : MathHelper.func_76128_c((double)(p_216386_0_.func_197745_a(direction$axis2) + 1.0E-7)) + 1;
            int j1 = VoxelShapes.func_216385_a(p_216386_2_, d0, d1);
            int k1 = flag ? 1 : -1;
            int l1 = i1;
            while (!(flag ? l1 > j1 : l1 < j1)) {
                for (int i2 = i; i2 <= j; ++i2) {
                    for (int j2 = k; j2 <= l; ++j2) {
                        int k2 = 0;
                        if (i2 == i || i2 == j) {
                            ++k2;
                        }
                        if (j2 == k || j2 == l) {
                            ++k2;
                        }
                        if (l1 == i1 || l1 == j1) {
                            ++k2;
                        }
                        if (k2 >= 3) continue;
                        blockpos$mutable.func_218295_a(axisrotation, i2, j2, l1);
                        BlockState blockstate = p_216386_1_.func_180495_p(blockpos$mutable);
                        if (k2 == 1 && !blockstate.func_215704_f() || k2 == 2 && !blockstate.func_203425_a(Blocks.field_196603_bb)) continue;
                        p_216386_2_ = blockstate.func_215685_b((IBlockReader)((Object)p_216386_1_), blockpos$mutable, p_216386_4_).func_212430_a(direction$axis2, p_216386_0_.func_72317_d((double)(-blockpos$mutable.func_177958_n()), (double)(-blockpos$mutable.func_177956_o()), (double)(-blockpos$mutable.func_177952_p())), p_216386_2_);
                        if (Math.abs(p_216386_2_) < 1.0E-7) {
                            return 0.0;
                        }
                        j1 = VoxelShapes.func_216385_a(p_216386_2_, d0, d1);
                    }
                }
                l1 += k1;
            }
            double[] adouble = new double[]{p_216386_2_};
            p_216386_6_.forEach(p_216388_3_ -> {
                adouble[0] = p_216388_3_.func_212430_a(direction$axis2, p_216386_0_, adouble[0]);
            });
            return adouble[0];
        }
        return p_216386_2_;
    }

    private static int func_216385_a(double p_216385_0_, double p_216385_2_, double p_216385_4_) {
        return p_216385_0_ > 0.0 ? MathHelper.func_76128_c((double)(p_216385_4_ + p_216385_0_)) + 1 : MathHelper.func_76128_c((double)(p_216385_2_ + p_216385_0_)) - 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean func_197875_a(VoxelShape p_197875_0_, VoxelShape p_197875_1_, Direction p_197875_2_) {
        if (p_197875_0_ == VoxelShapes.func_197868_b() && p_197875_1_ == VoxelShapes.func_197868_b()) {
            return true;
        }
        if (p_197875_1_.func_197766_b()) {
            return false;
        }
        Direction.Axis direction$axis = p_197875_2_.func_176740_k();
        Direction.AxisDirection direction$axisdirection = p_197875_2_.func_176743_c();
        VoxelShape voxelshape = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_197875_0_ : p_197875_1_;
        VoxelShape voxelshape1 = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_197875_1_ : p_197875_0_;
        IBooleanFunction ibooleanfunction = direction$axisdirection == Direction.AxisDirection.POSITIVE ? IBooleanFunction.field_223234_e_ : IBooleanFunction.field_223232_c_;
        return DoubleMath.fuzzyEquals((double)voxelshape.func_197758_c(direction$axis), (double)1.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)voxelshape1.func_197762_b(direction$axis), (double)0.0, (double)1.0E-7) && !VoxelShapes.func_197879_c((VoxelShape)new SplitVoxelShape(voxelshape, direction$axis, voxelshape.field_197768_g.func_197819_a(direction$axis) - 1), (VoxelShape)new SplitVoxelShape(voxelshape1, direction$axis, 0), ibooleanfunction);
    }

    public static VoxelShape func_216387_a(VoxelShape p_216387_0_, Direction p_216387_1_) {
        int i;
        boolean flag;
        if (p_216387_0_ == VoxelShapes.func_197868_b()) {
            return VoxelShapes.func_197868_b();
        }
        Direction.Axis direction$axis = p_216387_1_.func_176740_k();
        if (p_216387_1_.func_176743_c() == Direction.AxisDirection.POSITIVE) {
            flag = DoubleMath.fuzzyEquals((double)p_216387_0_.func_197758_c(direction$axis), (double)1.0, (double)1.0E-7);
            i = p_216387_0_.field_197768_g.func_197819_a(direction$axis) - 1;
        } else {
            flag = DoubleMath.fuzzyEquals((double)p_216387_0_.func_197762_b(direction$axis), (double)0.0, (double)1.0E-7);
            i = 0;
        }
        return !flag ? VoxelShapes.func_197880_a() : new SplitVoxelShape(p_216387_0_, direction$axis, i);
    }

    public static boolean func_204642_b(VoxelShape p_204642_0_, VoxelShape p_204642_1_, Direction p_204642_2_) {
        if (p_204642_0_ != VoxelShapes.func_197868_b() && p_204642_1_ != VoxelShapes.func_197868_b()) {
            VoxelShape voxelshape1;
            Direction.Axis direction$axis = p_204642_2_.func_176740_k();
            Direction.AxisDirection direction$axisdirection = p_204642_2_.func_176743_c();
            VoxelShape voxelshape = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_204642_0_ : p_204642_1_;
            VoxelShape voxelShape = voxelshape1 = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_204642_1_ : p_204642_0_;
            if (!DoubleMath.fuzzyEquals((double)voxelshape.func_197758_c(direction$axis), (double)1.0, (double)1.0E-7)) {
                voxelshape = VoxelShapes.func_197880_a();
            }
            if (!DoubleMath.fuzzyEquals((double)voxelshape1.func_197762_b(direction$axis), (double)0.0, (double)1.0E-7)) {
                voxelshape1 = VoxelShapes.func_197880_a();
            }
            return !VoxelShapes.func_197879_c(VoxelShapes.func_197868_b(), VoxelShapes.func_197882_b((VoxelShape)new SplitVoxelShape(voxelshape, direction$axis, voxelshape.field_197768_g.func_197819_a(direction$axis) - 1), (VoxelShape)new SplitVoxelShape(voxelshape1, direction$axis, 0), IBooleanFunction.field_223244_o_), IBooleanFunction.field_223234_e_);
        }
        return true;
    }

    public static boolean func_223416_b(VoxelShape p_223416_0_, VoxelShape p_223416_1_) {
        if (p_223416_0_ != VoxelShapes.func_197868_b() && p_223416_1_ != VoxelShapes.func_197868_b()) {
            if (p_223416_0_.func_197766_b() && p_223416_1_.func_197766_b()) {
                return false;
            }
            return !VoxelShapes.func_197879_c(VoxelShapes.func_197868_b(), VoxelShapes.func_197882_b(p_223416_0_, p_223416_1_, IBooleanFunction.field_223244_o_), IBooleanFunction.field_223234_e_);
        }
        return true;
    }

    @VisibleForTesting
    private static IDoubleListMerger func_199410_a(int p_199410_0_, DoubleList p_199410_1_, DoubleList p_199410_2_, boolean p_199410_3_, boolean p_199410_4_) {
        if (p_199410_1_.getDouble(0) == Double.NEGATIVE_INFINITY && p_199410_1_.getDouble(p_199410_1_.size() - 1) == Double.POSITIVE_INFINITY) {
            return new IndirectMerger(p_199410_1_, p_199410_2_, p_199410_3_, p_199410_4_);
        }
        return VoxelShapes.lessCommonMerge(p_199410_0_, p_199410_1_, p_199410_2_, p_199410_3_, p_199410_4_);
    }

    private static IDoubleListMerger lessCommonMerge(int p_199410_0_, DoubleList list1, DoubleList list2, boolean p_199410_3_, boolean p_199410_4_) {
        long k;
        int i = list1.size() - 1;
        int j = list2.size() - 1;
        if (list1 instanceof DoubleRangeList && list2 instanceof DoubleRangeList && (long)p_199410_0_ * (k = VoxelShapes.func_197877_a(i, j)) <= 256L) {
            return new DoubleCubeMergingList(i, j);
        }
        if (i == j && Objects.equals(list1, list2)) {
            if (list1 instanceof SimpleDoubleMerger) {
                return (IDoubleListMerger)list1;
            }
            if (list2 instanceof SimpleDoubleMerger) {
                return (IDoubleListMerger)list2;
            }
            return new SimpleDoubleMerger(list1);
        }
        if (list1.getDouble(i) < list2.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(list1, list2, false);
        }
        if (list2.getDouble(j) < list1.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(list2, list1, true);
        }
        return new IndirectMerger(list1, list2, p_199410_3_, p_199410_4_);
    }

    public static interface ILineConsumer {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

