/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistryCodec;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.LenientUnboundedMapCodec;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleRegistry<T>
extends MutableRegistry<T> {
    protected static final Logger field_148743_a = LogManager.getLogger();
    private final ObjectList<T> field_243533_bf = new ObjectArrayList(256);
    private final Object2IntMap<T> field_243534_bg = new Object2IntOpenCustomHashMap(Util.func_212443_g());
    private final BiMap<ResourceLocation, T> field_82596_a;
    private final BiMap<RegistryKey<T>, T> field_239649_bb_;
    private final Map<T, Lifecycle> field_243535_bj;
    private Lifecycle field_243536_bk;
    protected Object[] field_186802_b;
    private int field_195869_d;

    public SimpleRegistry(RegistryKey<? extends Registry<T>> p_i232509_1_, Lifecycle p_i232509_2_) {
        super(p_i232509_1_, p_i232509_2_);
        this.field_243534_bg.defaultReturnValue(-1);
        this.field_82596_a = HashBiMap.create();
        this.field_239649_bb_ = HashBiMap.create();
        this.field_243535_bj = Maps.newIdentityHashMap();
        this.field_243536_bk = p_i232509_2_;
    }

    public static <T> MapCodec<Entry<T>> func_243541_a(RegistryKey<? extends Registry<T>> p_243541_0_, MapCodec<T> p_243541_1_) {
        return RecordCodecBuilder.mapCodec(p_243542_2_ -> p_243542_2_.group((App)ResourceLocation.field_240908_a_.xmap(RegistryKey.func_240902_a_(p_243541_0_), RegistryKey::func_240901_a_).fieldOf("name").forGetter(p_243545_0_ -> p_243545_0_.field_243546_a), (App)Codec.INT.fieldOf("id").forGetter(p_243543_0_ -> p_243543_0_.field_243547_b), (App)p_243541_1_.forGetter(p_243538_0_ -> p_243538_0_.field_243548_c)).apply((Applicative)p_243542_2_, Entry::new));
    }

    public <V extends T> V func_218382_a(int p_218382_1_, RegistryKey<T> p_218382_2_, V p_218382_3_, Lifecycle p_218382_4_) {
        return this.func_243537_a(p_218382_1_, p_218382_2_, p_218382_3_, p_218382_4_, true);
    }

    private <V extends T> V func_243537_a(int p_243537_1_, RegistryKey<T> p_243537_2_, V p_243537_3_, Lifecycle p_243537_4_, boolean p_243537_5_) {
        Validate.notNull(p_243537_2_);
        Validate.notNull(p_243537_3_);
        this.field_243533_bf.size(Math.max(this.field_243533_bf.size(), p_243537_1_ + 1));
        this.field_243533_bf.set(p_243537_1_, p_243537_3_);
        this.field_243534_bg.put(p_243537_3_, p_243537_1_);
        this.field_186802_b = null;
        if (p_243537_5_ && this.field_239649_bb_.containsKey(p_243537_2_)) {
            field_148743_a.debug("Adding duplicate key '{}' to registry", p_243537_2_);
        }
        if (this.field_82596_a.containsValue(p_243537_3_)) {
            field_148743_a.error("Adding duplicate value '{}' to registry", p_243537_3_);
        }
        this.field_82596_a.put((Object)p_243537_2_.func_240901_a_(), p_243537_3_);
        this.field_239649_bb_.put(p_243537_2_, p_243537_3_);
        this.field_243535_bj.put(p_243537_3_, p_243537_4_);
        this.field_243536_bk = this.field_243536_bk.add(p_243537_4_);
        if (this.field_195869_d <= p_243537_1_) {
            this.field_195869_d = p_243537_1_ + 1;
        }
        return p_243537_3_;
    }

    public <V extends T> V func_218381_a(RegistryKey<T> p_218381_1_, V p_218381_2_, Lifecycle p_218381_3_) {
        return this.func_218382_a(this.field_195869_d, p_218381_1_, p_218381_2_, p_218381_3_);
    }

    public <V extends T> V func_241874_a(OptionalInt p_241874_1_, RegistryKey<T> p_241874_2_, V p_241874_3_, Lifecycle p_241874_4_) {
        int i;
        Validate.notNull(p_241874_2_);
        Validate.notNull(p_241874_3_);
        Object t = this.field_239649_bb_.get(p_241874_2_);
        if (t == null) {
            i = p_241874_1_.isPresent() ? p_241874_1_.getAsInt() : this.field_195869_d;
        } else {
            i = this.field_243534_bg.getInt(t);
            if (p_241874_1_.isPresent() && p_241874_1_.getAsInt() != i) {
                throw new IllegalStateException("ID mismatch");
            }
            this.field_243534_bg.removeInt(t);
            this.field_243535_bj.remove(t);
        }
        return this.func_243537_a(i, p_241874_2_, p_241874_3_, p_241874_4_, false);
    }

    @Nullable
    public ResourceLocation func_177774_c(T p_177774_1_) {
        return (ResourceLocation)this.field_82596_a.inverse().get(p_177774_1_);
    }

    public Optional<RegistryKey<T>> func_230519_c_(T p_230519_1_) {
        return Optional.ofNullable((RegistryKey)this.field_239649_bb_.inverse().get(p_230519_1_));
    }

    public int func_148757_b(@Nullable T p_148757_1_) {
        return this.field_243534_bg.getInt(p_148757_1_);
    }

    @Nullable
    public T func_230516_a_(@Nullable RegistryKey<T> p_230516_1_) {
        return (T)this.field_239649_bb_.get(p_230516_1_);
    }

    @Nullable
    public T func_148745_a(int p_148745_1_) {
        return (T)(p_148745_1_ >= 0 && p_148745_1_ < this.field_243533_bf.size() ? this.field_243533_bf.get(p_148745_1_) : null);
    }

    public Lifecycle func_241876_d(T p_241876_1_) {
        return this.field_243535_bj.get(p_241876_1_);
    }

    public Lifecycle func_241875_b() {
        return this.field_243536_bk;
    }

    public Iterator<T> iterator() {
        return Iterators.filter((Iterator)this.field_243533_bf.iterator(), Objects::nonNull);
    }

    @Nullable
    public T func_82594_a(@Nullable ResourceLocation p_82594_1_) {
        return (T)this.field_82596_a.get((Object)p_82594_1_);
    }

    public Set<ResourceLocation> func_148742_b() {
        return Collections.unmodifiableSet(this.field_82596_a.keySet());
    }

    public Set<Map.Entry<RegistryKey<T>, T>> func_239659_c_() {
        return Collections.unmodifiableMap(this.field_239649_bb_).entrySet();
    }

    @Nullable
    public T func_186801_a(Random p_186801_1_) {
        if (this.field_186802_b == null) {
            Set collection = this.field_82596_a.values();
            if (collection.isEmpty()) {
                return null;
            }
            this.field_186802_b = collection.toArray(new Object[collection.size()]);
        }
        return (T)Util.func_240989_a_(this.field_186802_b, p_186801_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_212607_c(ResourceLocation p_212607_1_) {
        return this.field_82596_a.containsKey((Object)p_212607_1_);
    }

    public static <T> Codec<SimpleRegistry<T>> func_243539_a(RegistryKey<? extends Registry<T>> p_243539_0_, Lifecycle p_243539_1_, Codec<T> p_243539_2_) {
        return SimpleRegistry.func_243541_a(p_243539_0_, p_243539_2_.fieldOf("element")).codec().listOf().xmap(p_243540_2_ -> {
            SimpleRegistry simpleregistry = new SimpleRegistry(p_243539_0_, p_243539_1_);
            for (Entry entry : p_243540_2_) {
                simpleregistry.func_218382_a(entry.field_243547_b, entry.field_243546_a, entry.field_243548_c, p_243539_1_);
            }
            return simpleregistry;
        }, p_243544_0_ -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            Iterator iterator = p_243544_0_.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                builder.add(new Entry(p_243544_0_.func_230519_c_(t).get(), p_243544_0_.func_148757_b(t), t));
            }
            return builder.build();
        });
    }

    public static <T> Codec<SimpleRegistry<T>> func_241744_b_(RegistryKey<? extends Registry<T>> p_241744_0_, Lifecycle p_241744_1_, Codec<T> p_241744_2_) {
        return SimpleRegistryCodec.func_241793_a_(p_241744_0_, (Lifecycle)p_241744_1_, p_241744_2_);
    }

    public static <T> Codec<SimpleRegistry<T>> func_241745_c_(RegistryKey<? extends Registry<T>> p_241745_0_, Lifecycle p_241745_1_, Codec<T> p_241745_2_) {
        return new LenientUnboundedMapCodec(ResourceLocation.field_240908_a_.xmap(RegistryKey.func_240902_a_(p_241745_0_), RegistryKey::func_240901_a_), p_241745_2_).xmap(p_239656_2_ -> {
            SimpleRegistry simpleregistry = new SimpleRegistry(p_241745_0_, p_241745_1_);
            p_239656_2_.forEach((p_239653_2_, p_239653_3_) -> simpleregistry.func_218381_a((RegistryKey)p_239653_2_, (Object)p_239653_3_, p_241745_1_));
            return simpleregistry;
        }, p_239651_0_ -> ImmutableMap.copyOf(p_239651_0_.field_239649_bb_));
    }

    public static class Entry<T> {
        public final RegistryKey<T> field_243546_a;
        public final int field_243547_b;
        public final T field_243548_c;

        public Entry(RegistryKey<T> p_i242072_1_, int p_i242072_2_, T p_i242072_3_) {
            this.field_243546_a = p_i242072_1_;
            this.field_243547_b = p_i242072_2_;
            this.field_243548_c = p_i242072_3_;
        }
    }
}

