/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.NBTTextComponent;
import net.minecraft.util.text.ScoreTextComponent;
import net.minecraft.util.text.SelectorTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface ITextComponent
extends Message,
ITextProperties,
Iterable<ITextComponent> {
    default public Stream<ITextComponent> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.func_150253_a().stream().flatMap(ITextComponent::stream)});
    }

    @Override
    default public Iterator<ITextComponent> iterator() {
        return this.stream().iterator();
    }

    public Style func_150256_b();

    public String func_150261_e();

    default public String getString() {
        return super.getString();
    }

    default public String func_212636_a(int p_212636_1_) {
        StringBuilder stringbuilder = new StringBuilder();
        this.func_230438_a_(p_240639_2_ -> {
            int i = p_212636_1_ - stringbuilder.length();
            if (i <= 0) {
                return field_240650_b_;
            }
            stringbuilder.append(p_240639_2_.length() <= i ? p_240639_2_ : p_240639_2_.substring(0, i));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<ITextComponent> func_150253_a();

    public IFormattableTextComponent func_230531_f_();

    public IFormattableTextComponent func_230532_e_();

    @OnlyIn(value=Dist.CLIENT)
    public IReorderingProcessor func_241878_f();

    @OnlyIn(value=Dist.CLIENT)
    default public <T> Optional<T> func_230439_a_(ITextProperties.IStyledTextAcceptor<T> p_230439_1_, Style p_230439_2_) {
        Style style = this.func_150256_b().func_240717_a_(p_230439_2_);
        Optional<T> optional = this.func_230534_b_(p_230439_1_, style);
        if (optional.isPresent()) {
            return optional;
        }
        for (ITextComponent itextcomponent : this.func_150253_a()) {
            Optional<T> optional1 = itextcomponent.func_230439_a_(p_230439_1_, style);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    default public <T> Optional<T> func_230438_a_(ITextProperties.ITextAcceptor<T> p_230438_1_) {
        Optional<T> optional = this.func_230533_b_(p_230438_1_);
        if (optional.isPresent()) {
            return optional;
        }
        for (ITextComponent itextcomponent : this.func_150253_a()) {
            Optional<T> optional1 = itextcomponent.func_230438_a_(p_230438_1_);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public <T> Optional<T> func_230534_b_(ITextProperties.IStyledTextAcceptor<T> p_230534_1_, Style p_230534_2_) {
        return p_230534_1_.accept(p_230534_2_, this.func_150261_e());
    }

    default public <T> Optional<T> func_230533_b_(ITextProperties.ITextAcceptor<T> p_230533_1_) {
        return p_230533_1_.accept(this.func_150261_e());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ITextComponent func_244388_a(@Nullable String p_244388_0_) {
        return p_244388_0_ != null ? new StringTextComponent(p_244388_0_) : StringTextComponent.field_240750_d_;
    }

    public static class Serializer
    implements JsonDeserializer<IFormattableTextComponent>,
    JsonSerializer<ITextComponent> {
        private static final Gson field_150700_a = Util.func_199748_a(() -> {
            GsonBuilder gsonbuilder = new GsonBuilder();
            gsonbuilder.disableHtmlEscaping();
            gsonbuilder.registerTypeHierarchyAdapter(ITextComponent.class, (Object)new Serializer());
            gsonbuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
            gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory());
            return gsonbuilder.create();
        });
        private static final Field field_197674_b = Util.func_199748_a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", nosuchfieldexception);
            }
        });
        private static final Field field_200530_c = Util.func_199748_a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", nosuchfieldexception);
            }
        });

        public IFormattableTextComponent deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            Object iformattabletextcomponent;
            if (p_deserialize_1_.isJsonPrimitive()) {
                return new StringTextComponent(p_deserialize_1_.getAsString());
            }
            if (!p_deserialize_1_.isJsonObject()) {
                if (p_deserialize_1_.isJsonArray()) {
                    JsonArray jsonarray1 = p_deserialize_1_.getAsJsonArray();
                    IFormattableTextComponent iformattabletextcomponent1 = null;
                    for (JsonElement jsonelement : jsonarray1) {
                        IFormattableTextComponent iformattabletextcomponent2 = this.deserialize(jsonelement, jsonelement.getClass(), p_deserialize_3_);
                        if (iformattabletextcomponent1 == null) {
                            iformattabletextcomponent1 = iformattabletextcomponent2;
                            continue;
                        }
                        iformattabletextcomponent1.func_230529_a_((ITextComponent)iformattabletextcomponent2);
                    }
                    return iformattabletextcomponent1;
                }
                throw new JsonParseException("Don't know how to turn " + p_deserialize_1_ + " into a Component");
            }
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            if (jsonobject.has("text")) {
                iformattabletextcomponent = new StringTextComponent(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"text"));
            } else if (jsonobject.has("translate")) {
                String s = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"translate");
                if (jsonobject.has("with")) {
                    JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)jsonobject, (String)"with");
                    Object[] aobject = new Object[jsonarray.size()];
                    for (int i = 0; i < aobject.length; ++i) {
                        StringTextComponent stringtextcomponent;
                        aobject[i] = this.deserialize(jsonarray.get(i), p_deserialize_2_, p_deserialize_3_);
                        if (!(aobject[i] instanceof StringTextComponent) || !(stringtextcomponent = (StringTextComponent)aobject[i]).func_150256_b().func_150229_g() || !stringtextcomponent.func_150253_a().isEmpty()) continue;
                        aobject[i] = stringtextcomponent.func_150265_g();
                    }
                    iformattabletextcomponent = new TranslationTextComponent(s, aobject);
                } else {
                    iformattabletextcomponent = new TranslationTextComponent(s);
                }
            } else if (jsonobject.has("score")) {
                JsonObject jsonobject1 = JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"score");
                if (!jsonobject1.has("name") || !jsonobject1.has("objective")) {
                    throw new JsonParseException("A score component needs a least a name and an objective");
                }
                iformattabletextcomponent = new ScoreTextComponent(JSONUtils.func_151200_h((JsonObject)jsonobject1, (String)"name"), JSONUtils.func_151200_h((JsonObject)jsonobject1, (String)"objective"));
            } else if (jsonobject.has("selector")) {
                iformattabletextcomponent = new SelectorTextComponent(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"selector"));
            } else if (jsonobject.has("keybind")) {
                iformattabletextcomponent = new KeybindTextComponent(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"keybind"));
            } else {
                if (!jsonobject.has("nbt")) {
                    throw new JsonParseException("Don't know how to turn " + p_deserialize_1_ + " into a Component");
                }
                String s1 = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"nbt");
                boolean flag = JSONUtils.func_151209_a((JsonObject)jsonobject, (String)"interpret", (boolean)false);
                if (jsonobject.has("block")) {
                    iformattabletextcomponent = new NBTTextComponent.Block(s1, flag, JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"block"));
                } else if (jsonobject.has("entity")) {
                    iformattabletextcomponent = new NBTTextComponent.Entity(s1, flag, JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"entity"));
                } else {
                    if (!jsonobject.has("storage")) {
                        throw new JsonParseException("Don't know how to turn " + p_deserialize_1_ + " into a Component");
                    }
                    iformattabletextcomponent = new NBTTextComponent.Storage(s1, flag, new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"storage")));
                }
            }
            if (jsonobject.has("extra")) {
                JsonArray jsonarray2 = JSONUtils.func_151214_t((JsonObject)jsonobject, (String)"extra");
                if (jsonarray2.size() <= 0) {
                    throw new JsonParseException("Unexpected empty array of components");
                }
                for (int j = 0; j < jsonarray2.size(); ++j) {
                    iformattabletextcomponent.func_230529_a_((ITextComponent)this.deserialize(jsonarray2.get(j), p_deserialize_2_, p_deserialize_3_));
                }
            }
            iformattabletextcomponent.func_230530_a_((Style)p_deserialize_3_.deserialize(p_deserialize_1_, Style.class));
            return iformattabletextcomponent;
        }

        private void func_150695_a(Style p_150695_1_, JsonObject p_150695_2_, JsonSerializationContext p_150695_3_) {
            JsonElement jsonelement = p_150695_3_.serialize((Object)p_150695_1_);
            if (jsonelement.isJsonObject()) {
                JsonObject jsonobject = (JsonObject)jsonelement;
                for (Map.Entry entry : jsonobject.entrySet()) {
                    p_150695_2_.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        public JsonElement serialize(ITextComponent p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            if (!p_serialize_1_.func_150256_b().func_150229_g()) {
                this.func_150695_a(p_serialize_1_.func_150256_b(), jsonobject, p_serialize_3_);
            }
            if (!p_serialize_1_.func_150253_a().isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (ITextComponent itextcomponent : p_serialize_1_.func_150253_a()) {
                    jsonarray.add(this.serialize(itextcomponent, itextcomponent.getClass(), p_serialize_3_));
                }
                jsonobject.add("extra", (JsonElement)jsonarray);
            }
            if (p_serialize_1_ instanceof StringTextComponent) {
                jsonobject.addProperty("text", ((StringTextComponent)p_serialize_1_).func_150265_g());
            } else if (p_serialize_1_ instanceof TranslationTextComponent) {
                TranslationTextComponent translationtextcomponent = (TranslationTextComponent)((Object)p_serialize_1_);
                jsonobject.addProperty("translate", translationtextcomponent.func_150268_i());
                if (translationtextcomponent.func_150271_j() != null && translationtextcomponent.func_150271_j().length > 0) {
                    JsonArray jsonarray1 = new JsonArray();
                    for (Object object : translationtextcomponent.func_150271_j()) {
                        if (object instanceof ITextComponent) {
                            jsonarray1.add(this.serialize((ITextComponent)object, object.getClass(), p_serialize_3_));
                            continue;
                        }
                        jsonarray1.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                    }
                    jsonobject.add("with", (JsonElement)jsonarray1);
                }
            } else if (p_serialize_1_ instanceof ScoreTextComponent) {
                ScoreTextComponent scoretextcomponent = (ScoreTextComponent)p_serialize_1_;
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("name", scoretextcomponent.func_179995_g());
                jsonobject1.addProperty("objective", scoretextcomponent.func_179994_h());
                jsonobject.add("score", (JsonElement)jsonobject1);
            } else if (p_serialize_1_ instanceof SelectorTextComponent) {
                SelectorTextComponent selectortextcomponent = (SelectorTextComponent)((Object)p_serialize_1_);
                jsonobject.addProperty("selector", selectortextcomponent.func_179992_g());
            } else if (p_serialize_1_ instanceof KeybindTextComponent) {
                KeybindTextComponent keybindtextcomponent = (KeybindTextComponent)p_serialize_1_;
                jsonobject.addProperty("keybind", keybindtextcomponent.func_193633_h());
            } else {
                if (!(p_serialize_1_ instanceof NBTTextComponent)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + p_serialize_1_ + " as a Component");
                }
                NBTTextComponent nbttextcomponent = (NBTTextComponent)p_serialize_1_;
                jsonobject.addProperty("nbt", nbttextcomponent.func_218676_i());
                jsonobject.addProperty("interpret", Boolean.valueOf(nbttextcomponent.func_218677_j()));
                if (p_serialize_1_ instanceof NBTTextComponent.Block) {
                    NBTTextComponent.Block nbttextcomponent$block = (NBTTextComponent.Block)p_serialize_1_;
                    jsonobject.addProperty("block", nbttextcomponent$block.func_218683_k());
                } else if (p_serialize_1_ instanceof NBTTextComponent.Entity) {
                    NBTTextComponent.Entity nbttextcomponent$entity = (NBTTextComponent.Entity)p_serialize_1_;
                    jsonobject.addProperty("entity", nbttextcomponent$entity.func_218687_k());
                } else {
                    if (!(p_serialize_1_ instanceof NBTTextComponent.Storage)) {
                        throw new IllegalArgumentException("Don't know how to serialize " + p_serialize_1_ + " as a Component");
                    }
                    NBTTextComponent.Storage nbttextcomponent$storage = (NBTTextComponent.Storage)p_serialize_1_;
                    jsonobject.addProperty("storage", nbttextcomponent$storage.func_229726_k_().toString());
                }
            }
            return jsonobject;
        }

        public static String func_150696_a(ITextComponent p_150696_0_) {
            return field_150700_a.toJson((Object)p_150696_0_);
        }

        public static JsonElement func_200528_b(ITextComponent p_200528_0_) {
            return field_150700_a.toJsonTree((Object)p_200528_0_);
        }

        @Nullable
        public static IFormattableTextComponent func_240643_a_(String p_240643_0_) {
            return (IFormattableTextComponent)JSONUtils.func_188176_a((Gson)field_150700_a, (String)p_240643_0_, IFormattableTextComponent.class, (boolean)false);
        }

        @Nullable
        public static IFormattableTextComponent func_240641_a_(JsonElement p_240641_0_) {
            return (IFormattableTextComponent)field_150700_a.fromJson(p_240641_0_, IFormattableTextComponent.class);
        }

        @Nullable
        public static IFormattableTextComponent func_240644_b_(String p_240644_0_) {
            return (IFormattableTextComponent)JSONUtils.func_188176_a((Gson)field_150700_a, (String)p_240644_0_, IFormattableTextComponent.class, (boolean)true);
        }

        public static IFormattableTextComponent func_240642_a_(com.mojang.brigadier.StringReader p_240642_0_) {
            try {
                JsonReader jsonreader = new JsonReader((Reader)new StringReader(p_240642_0_.getRemaining()));
                jsonreader.setLenient(false);
                IFormattableTextComponent iformattabletextcomponent = (IFormattableTextComponent)field_150700_a.getAdapter(IFormattableTextComponent.class).read(jsonreader);
                p_240642_0_.setCursor(p_240642_0_.getCursor() + Serializer.func_197673_a(jsonreader));
                return iformattabletextcomponent;
            }
            catch (IOException | StackOverflowError ioexception) {
                throw new JsonParseException(ioexception);
            }
        }

        private static int func_197673_a(JsonReader p_197673_0_) {
            try {
                return field_197674_b.getInt(p_197673_0_) - field_200530_c.getInt(p_197673_0_) + 1;
            }
            catch (IllegalAccessException illegalaccessexception) {
                throw new IllegalStateException("Couldn't read position of JsonReader", illegalaccessexception);
            }
        }
    }
}

