/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum TextFormatting {
    BLACK("BLACK", '0', 0, 0),
    DARK_BLUE("DARK_BLUE", '1', 1, 170),
    DARK_GREEN("DARK_GREEN", '2', 2, 43520),
    DARK_AQUA("DARK_AQUA", '3', 3, 43690),
    DARK_RED("DARK_RED", '4', 4, 0xAA0000),
    DARK_PURPLE("DARK_PURPLE", '5', 5, 0xAA00AA),
    GOLD("GOLD", '6', 6, 0xFFAA00),
    GRAY("GRAY", '7', 7, 0xAAAAAA),
    DARK_GRAY("DARK_GRAY", '8', 8, 0x555555),
    BLUE("BLUE", '9', 9, 0x5555FF),
    GREEN("GREEN", 'a', 10, 0x55FF55),
    AQUA("AQUA", 'b', 11, 0x55FFFF),
    RED("RED", 'c', 12, 0xFF5555),
    LIGHT_PURPLE("LIGHT_PURPLE", 'd', 13, 0xFF55FF),
    YELLOW("YELLOW", 'e', 14, 0xFFFF55),
    WHITE("WHITE", 'f', 15, 0xFFFFFF),
    OBFUSCATED("OBFUSCATED", 'k', true),
    BOLD("BOLD", 'l', true),
    STRIKETHROUGH("STRIKETHROUGH", 'm', true),
    UNDERLINE("UNDERLINE", 'n', true),
    ITALIC("ITALIC", 'o', true),
    RESET("RESET", 'r', -1, null);

    private static final Map<String, TextFormatting> field_96331_x;
    private static final Pattern field_96330_y;
    private final String field_175748_y;
    public final char field_96329_z;
    private final boolean field_96303_A;
    private final String field_96304_B;
    private final int field_175747_C;
    @Nullable
    private final Integer field_211167_D;

    private static String func_175745_c(String p_175745_0_) {
        return p_175745_0_.toLowerCase(Locale.ROOT).replaceAll("[^a-z]", "");
    }

    private TextFormatting(String p_i49745_3_, @Nullable char p_i49745_4_, int p_i49745_5_, Integer p_i49745_6_) {
        this(p_i49745_3_, p_i49745_4_, false, p_i49745_5_, p_i49745_6_);
    }

    private TextFormatting(String p_i46292_3_, char p_i46292_4_, boolean p_i46292_5_) {
        this(p_i46292_3_, p_i46292_4_, p_i46292_5_, -1, null);
    }

    private TextFormatting(String p_i49746_3_, char p_i49746_4_, @Nullable boolean p_i49746_5_, int p_i49746_6_, Integer p_i49746_7_) {
        this.field_175748_y = p_i49746_3_;
        this.field_96329_z = p_i49746_4_;
        this.field_96303_A = p_i49746_5_;
        this.field_175747_C = p_i49746_6_;
        this.field_211167_D = p_i49746_7_;
        this.field_96304_B = "\u00a7" + p_i49746_4_;
    }

    public int func_175746_b() {
        return this.field_175747_C;
    }

    public boolean func_96301_b() {
        return this.field_96303_A;
    }

    public boolean func_96302_c() {
        return !this.field_96303_A && this != RESET;
    }

    @Nullable
    public Integer func_211163_e() {
        return this.field_211167_D;
    }

    public String func_96297_d() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.field_96304_B;
    }

    @Nullable
    public static String func_110646_a(@Nullable String p_110646_0_) {
        return p_110646_0_ == null ? null : field_96330_y.matcher(p_110646_0_).replaceAll("");
    }

    @Nullable
    public static TextFormatting func_96300_b(@Nullable String p_96300_0_) {
        return p_96300_0_ == null ? null : field_96331_x.get(TextFormatting.func_175745_c(p_96300_0_));
    }

    @Nullable
    public static TextFormatting func_175744_a(int p_175744_0_) {
        if (p_175744_0_ < 0) {
            return RESET;
        }
        for (TextFormatting textformatting : TextFormatting.values()) {
            if (textformatting.func_175746_b() != p_175744_0_) continue;
            return textformatting;
        }
        return null;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static TextFormatting func_211165_a(char p_211165_0_) {
        char c0 = Character.toString(p_211165_0_).toLowerCase(Locale.ROOT).charAt(0);
        for (TextFormatting textformatting : TextFormatting.values()) {
            if (textformatting.field_96329_z != c0) continue;
            return textformatting;
        }
        return null;
    }

    public static Collection<String> func_96296_a(boolean p_96296_0_, boolean p_96296_1_) {
        ArrayList list = Lists.newArrayList();
        for (TextFormatting textformatting : TextFormatting.values()) {
            if (textformatting.func_96302_c() && !p_96296_0_ || textformatting.func_96301_b() && !p_96296_1_) continue;
            list.add(textformatting.func_96297_d());
        }
        return list;
    }

    static {
        field_96331_x = Arrays.stream(TextFormatting.values()).collect(Collectors.toMap(p_199746_0_ -> TextFormatting.func_175745_c(p_199746_0_.field_175748_y), p_199747_0_ -> p_199747_0_));
        field_96330_y = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    }
}

