/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mohistmc.util.i18n.i18n;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicLike;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.event.Event;

public class GameRules {
    private static final Logger field_223622_y = LogManager.getLogger();
    private static final Map<RuleKey<?>, RuleType<?>> field_223623_z = Maps.newTreeMap(Comparator.comparing(p_223597_0_ -> p_223597_0_.field_223578_a));
    public static final RuleKey<BooleanValue> field_223598_a = GameRules.func_234903_a_("doFireTick", Category.UPDATES, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223599_b = GameRules.func_234903_a_("mobGriefing", Category.MOBS, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223600_c = GameRules.func_234903_a_("keepInventory", Category.PLAYER, BooleanValue.func_223568_b(false));
    public static final RuleKey<BooleanValue> field_223601_d = GameRules.func_234903_a_("doMobSpawning", Category.SPAWNING, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223602_e = GameRules.func_234903_a_("doMobLoot", Category.DROPS, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223603_f = GameRules.func_234903_a_("doTileDrops", Category.DROPS, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223604_g = GameRules.func_234903_a_("doEntityDrops", Category.DROPS, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223605_h = GameRules.func_234903_a_("commandBlockOutput", Category.CHAT, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223606_i = GameRules.func_234903_a_("naturalRegeneration", Category.PLAYER, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223607_j = GameRules.func_234903_a_("doDaylightCycle", Category.UPDATES, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223608_k = GameRules.func_234903_a_("logAdminCommands", Category.CHAT, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223609_l = GameRules.func_234903_a_("showDeathMessages", Category.CHAT, BooleanValue.func_223568_b(true));
    public static final RuleKey<IntegerValue> field_223610_m = GameRules.func_234903_a_("randomTickSpeed", Category.UPDATES, IntegerValue.func_223559_b(3));
    public static final RuleKey<BooleanValue> field_223611_n = GameRules.func_234903_a_("sendCommandFeedback", Category.CHAT, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223612_o = GameRules.func_234903_a_("reducedDebugInfo", Category.MISC, BooleanValue.func_223567_b(false, (p_223589_0_, p_223589_1_) -> {
        byte b0 = (byte)(p_223589_1_.func_223572_a() ? 22 : 23);
        for (ServerPlayerEntity serverplayerentity : p_223589_0_.func_184103_al().func_181057_v()) {
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SEntityStatusPacket((Entity)serverplayerentity, b0));
        }
    }));
    public static final RuleKey<BooleanValue> field_223613_p = GameRules.func_234903_a_("spectatorsGenerateChunks", Category.PLAYER, BooleanValue.func_223568_b(true));
    public static final RuleKey<IntegerValue> field_223614_q = GameRules.func_234903_a_("spawnRadius", Category.PLAYER, IntegerValue.func_223559_b(10));
    public static final RuleKey<BooleanValue> field_223615_r = GameRules.func_234903_a_("disableElytraMovementCheck", Category.PLAYER, BooleanValue.func_223568_b(false));
    public static final RuleKey<IntegerValue> field_223616_s = GameRules.func_234903_a_("maxEntityCramming", Category.MOBS, IntegerValue.func_223559_b(24));
    public static final RuleKey<BooleanValue> field_223617_t = GameRules.func_234903_a_("doWeatherCycle", Category.UPDATES, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223618_u = GameRules.func_234903_a_("doLimitedCrafting", Category.PLAYER, BooleanValue.func_223568_b(false));
    public static final RuleKey<IntegerValue> field_223619_v = GameRules.func_234903_a_("maxCommandChainLength", Category.MISC, IntegerValue.func_223559_b(65536));
    public static final RuleKey<BooleanValue> field_223620_w = GameRules.func_234903_a_("announceAdvancements", Category.CHAT, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_223621_x = GameRules.func_234903_a_("disableRaids", Category.MOBS, BooleanValue.func_223568_b(false));
    public static final RuleKey<BooleanValue> field_226682_y_ = GameRules.func_234903_a_("doInsomnia", Category.SPAWNING, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_226683_z_ = GameRules.func_234903_a_("doImmediateRespawn", Category.PLAYER, BooleanValue.func_223567_b(false, (p_226686_0_, p_226686_1_) -> {
        for (ServerPlayerEntity serverplayerentity : p_226686_0_.func_184103_al().func_181057_v()) {
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241775_l_, p_226686_1_.func_223572_a() ? 1.0f : 0.0f));
        }
    }));
    public static final RuleKey<BooleanValue> field_226679_A_ = GameRules.func_234903_a_("drowningDamage", Category.PLAYER, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_226680_B_ = GameRules.func_234903_a_("fallDamage", Category.PLAYER, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_226681_C_ = GameRules.func_234903_a_("fireDamage", Category.PLAYER, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_230127_D_ = GameRules.func_234903_a_("doPatrolSpawning", Category.SPAWNING, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_230128_E_ = GameRules.func_234903_a_("doTraderSpawning", Category.SPAWNING, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_234895_F_ = GameRules.func_234903_a_("forgiveDeadPlayers", Category.MOBS, BooleanValue.func_223568_b(true));
    public static final RuleKey<BooleanValue> field_234896_G_ = GameRules.func_234903_a_("universalAnger", Category.MOBS, BooleanValue.func_223568_b(false));
    private final Map<RuleKey<?>, RuleValue<?>> field_82771_a;
    public static RuleKey<?> ruleKey;

    public static <T extends RuleValue<T>> RuleKey<T> func_234903_a_(String p_234903_0_, Category p_234903_1_, RuleType<T> p_234903_2_) {
        RuleKey rulekey = new RuleKey(p_234903_0_, p_234903_1_);
        RuleType<T> ruletype = field_223623_z.put(rulekey, p_234903_2_);
        if (ruletype != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + p_234903_0_);
        }
        return rulekey;
    }

    public GameRules(DynamicLike<?> p_i231611_1_) {
        this();
        this.func_234901_a_(p_i231611_1_);
    }

    public GameRules() {
        this.field_82771_a = (Map)field_223623_z.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_226684_0_ -> ((RuleType)p_226684_0_.getValue()).func_223579_a()));
    }

    private GameRules(Map<RuleKey<?>, RuleValue<?>> p_i231612_1_) {
        this.field_82771_a = p_i231612_1_;
    }

    public <T extends RuleValue<T>> T func_223585_a(RuleKey<T> p_223585_1_) {
        return (T)this.field_82771_a.get(p_223585_1_);
    }

    public CompoundNBT func_82770_a() {
        CompoundNBT compoundnbt = new CompoundNBT();
        this.field_82771_a.forEach((p_226688_1_, p_226688_2_) -> compoundnbt.func_74778_a(p_226688_1_.field_223578_a, p_226688_2_.func_223552_b()));
        return compoundnbt;
    }

    private void func_234901_a_(DynamicLike<?> p_234901_1_) {
        this.field_82771_a.forEach((p_234902_1_, p_234902_2_) -> p_234901_1_.get(p_234902_1_.field_223578_a).asString().result().ifPresent(p_234902_2_::func_223553_a));
    }

    public GameRules func_234905_b_() {
        return new GameRules((Map)this.field_82771_a.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_234904_0_ -> ((RuleValue)p_234904_0_.getValue()).func_230314_f_())));
    }

    public static void func_223590_a(IRuleEntryVisitor p_223590_0_) {
        field_223623_z.forEach((p_234906_1_, p_234906_2_) -> GameRules.func_234897_a_(p_223590_0_, p_234906_1_, p_234906_2_));
    }

    private static <T extends RuleValue<T>> void func_234897_a_(IRuleEntryVisitor p_234897_0_, RuleKey<?> p_234897_1_, RuleType<?> p_234897_2_) {
        p_234897_0_.func_223481_a(p_234897_1_, p_234897_2_);
        p_234897_2_.func_234914_a_(p_234897_0_, p_234897_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_234899_a_(GameRules p_234899_1_, @Nullable MinecraftServer p_234899_2_) {
        p_234899_1_.field_82771_a.keySet().forEach(p_234900_3_ -> this.func_234898_a_((RuleKey)p_234900_3_, p_234899_1_, p_234899_2_));
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T extends RuleValue<T>> void func_234898_a_(RuleKey<T> p_234898_1_, GameRules p_234898_2_, @Nullable MinecraftServer p_234898_3_) {
        T t = p_234898_2_.func_223585_a(p_234898_1_);
        ((RuleValue)this.func_223585_a(p_234898_1_)).func_230313_a_(t, p_234898_3_);
    }

    public boolean func_223586_b(RuleKey<BooleanValue> p_223586_1_) {
        return this.func_223585_a(p_223586_1_).func_223572_a();
    }

    public int func_223592_c(RuleKey<IntegerValue> p_223592_1_) {
        return this.func_223585_a(p_223592_1_).func_223560_a();
    }

    public static abstract class RuleValue<T extends RuleValue<T>> {
        protected final RuleType<T> field_223558_a;

        public RuleValue(RuleType<T> p_i51530_1_) {
            this.field_223558_a = p_i51530_1_;
        }

        protected abstract void func_223555_a(CommandContext<CommandSource> var1, String var2);

        public void func_223554_b(CommandContext<CommandSource> p_223554_1_, String p_223554_2_) {
            this.func_223555_a(p_223554_1_, p_223554_2_);
            this.func_223556_a(((CommandSource)p_223554_1_.getSource()).func_197028_i());
        }

        public void setPaperRuleKey(RuleKey<T> paperRuleKey) {
            ruleKey = paperRuleKey;
        }

        public void func_223556_a(@Nullable MinecraftServer p_223556_1_) {
            if (p_223556_1_ != null) {
                this.field_223558_a.field_223584_c.accept(p_223556_1_, (MinecraftServer)this.func_223213_e_());
            }
        }

        public abstract void func_223553_a(String var1);

        public abstract String func_223552_b();

        public String toString() {
            return this.func_223552_b();
        }

        public abstract int func_223557_c();

        protected abstract T func_223213_e_();

        protected abstract T func_230314_f_();

        @OnlyIn(value=Dist.CLIENT)
        public abstract void func_230313_a_(T var1, @Nullable MinecraftServer var2);
    }

    public static class RuleType<T extends RuleValue<T>> {
        private final Supplier<ArgumentType<?>> field_223582_a;
        private final Function<RuleType<T>, T> field_223583_b;
        private final BiConsumer<MinecraftServer, T> field_223584_c;
        private final IRule<T> field_234913_d_;

        private RuleType(Supplier<ArgumentType<?>> p_i231615_1_, Function<RuleType<T>, T> p_i231615_2_, BiConsumer<MinecraftServer, T> p_i231615_3_, IRule<T> p_i231615_4_) {
            this.field_223582_a = p_i231615_1_;
            this.field_223583_b = p_i231615_2_;
            this.field_223584_c = p_i231615_3_;
            this.field_234913_d_ = p_i231615_4_;
        }

        public RequiredArgumentBuilder<CommandSource, ?> func_223581_a(String p_223581_1_) {
            return Commands.func_197056_a(p_223581_1_, this.field_223582_a.get());
        }

        public T func_223579_a() {
            return (T)((RuleValue)this.field_223583_b.apply(this));
        }

        public void func_234914_a_(IRuleEntryVisitor p_234914_1_, RuleKey<T> p_234914_2_) {
            this.field_234913_d_.call(p_234914_1_, p_234914_2_, this);
        }
    }

    public static final class RuleKey<T extends RuleValue<T>> {
        private final String field_223578_a;
        private final Category field_234910_b_;

        public RuleKey(String p_i231614_1_, Category p_i231614_2_) {
            this.field_223578_a = p_i231614_1_;
            this.field_234910_b_ = p_i231614_2_;
        }

        public String toString() {
            return this.field_223578_a;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            return p_equals_1_ instanceof RuleKey && ((RuleKey)p_equals_1_).field_223578_a.equals(this.field_223578_a);
        }

        public int hashCode() {
            return this.field_223578_a.hashCode();
        }

        public String func_223576_a() {
            return this.field_223578_a;
        }

        public String func_234911_b_() {
            return "gamerule." + this.field_223578_a;
        }

        @OnlyIn(value=Dist.CLIENT)
        public Category func_234912_c_() {
            return this.field_234910_b_;
        }
    }

    public static class IntegerValue
    extends RuleValue<IntegerValue> {
        private int field_223566_a;

        private static RuleType<IntegerValue> func_223564_a(int p_223564_0_, BiConsumer<MinecraftServer, IntegerValue> p_223564_1_) {
            return new RuleType<IntegerValue>(IntegerArgumentType::integer, p_223565_1_ -> new IntegerValue((RuleType<IntegerValue>)p_223565_1_, p_223564_0_), p_223564_1_, IRuleEntryVisitor::func_230483_c_);
        }

        private static RuleType<IntegerValue> func_223559_b(int p_223559_0_) {
            return IntegerValue.func_223564_a(p_223559_0_, (p_223561_0_, p_223561_1_) -> {});
        }

        public IntegerValue(RuleType<IntegerValue> p_i51534_1_, int p_i51534_2_) {
            super(p_i51534_1_);
            this.field_223566_a = p_i51534_2_;
        }

        @Override
        protected void func_223555_a(CommandContext<CommandSource> p_223555_1_, String p_223555_2_) {
            if (ruleKey != null) {
                WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)((CommandSource)p_223555_1_.getSource()).func_197023_e().getWorld(), ((CommandSource)p_223555_1_.getSource()).getBukkitSender(), GameRule.getByName((String)ruleKey.toString()), String.valueOf(IntegerArgumentType.getInteger(p_223555_1_, (String)p_223555_2_)));
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.field_223566_a = Integer.parseInt(event.getValue());
            } else {
                this.field_223566_a = IntegerArgumentType.getInteger(p_223555_1_, (String)p_223555_2_);
            }
        }

        public int func_223560_a() {
            return this.field_223566_a;
        }

        @Override
        public String func_223552_b() {
            return Integer.toString(this.field_223566_a);
        }

        @Override
        public void func_223553_a(String p_223553_1_) {
            this.field_223566_a = IntegerValue.func_223563_b(p_223553_1_);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_234909_b_(String p_234909_1_) {
            try {
                this.field_223566_a = Integer.parseInt(p_234909_1_);
                return true;
            }
            catch (NumberFormatException numberformatexception) {
                return false;
            }
        }

        private static int func_223563_b(String p_223563_0_) {
            if (!p_223563_0_.isEmpty()) {
                try {
                    return Integer.parseInt(p_223563_0_);
                }
                catch (NumberFormatException numberformatexception) {
                    field_223622_y.warn(i18n.get((String)"gamerules.1", (Object[])new Object[]{p_223563_0_}));
                }
            }
            return 0;
        }

        @Override
        public int func_223557_c() {
            return this.field_223566_a;
        }

        @Override
        protected IntegerValue func_223213_e_() {
            return this;
        }

        @Override
        protected IntegerValue func_230314_f_() {
            return new IntegerValue(this.field_223558_a, this.field_223566_a);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void func_230313_a_(IntegerValue p_230313_1_, @Nullable MinecraftServer p_230313_2_) {
            this.field_223566_a = p_230313_1_.field_223566_a;
            this.func_223556_a(p_230313_2_);
        }
    }

    public static interface IRuleEntryVisitor {
        default public <T extends RuleValue<T>> void func_223481_a(RuleKey<T> p_223481_1_, RuleType<T> p_223481_2_) {
        }

        default public void func_230482_b_(RuleKey<BooleanValue> p_230482_1_, RuleType<BooleanValue> p_230482_2_) {
        }

        default public void func_230483_c_(RuleKey<IntegerValue> p_230483_1_, RuleType<IntegerValue> p_230483_2_) {
        }
    }

    static interface IRule<T extends RuleValue<T>> {
        public void call(IRuleEntryVisitor var1, RuleKey<T> var2, RuleType<T> var3);
    }

    public static enum Category {
        PLAYER("gamerule.category.player"),
        MOBS("gamerule.category.mobs"),
        SPAWNING("gamerule.category.spawning"),
        DROPS("gamerule.category.drops"),
        UPDATES("gamerule.category.updates"),
        CHAT("gamerule.category.chat"),
        MISC("gamerule.category.misc");

        private final String field_234907_h_;

        private Category(String p_i231613_3_) {
            this.field_234907_h_ = p_i231613_3_;
        }

        @OnlyIn(value=Dist.CLIENT)
        public String func_234908_a_() {
            return this.field_234907_h_;
        }
    }

    public static class BooleanValue
    extends RuleValue<BooleanValue> {
        private boolean field_223575_a;

        private static RuleType<BooleanValue> func_223567_b(boolean p_223567_0_, BiConsumer<MinecraftServer, BooleanValue> p_223567_1_) {
            return new RuleType<BooleanValue>(BoolArgumentType::bool, p_223574_1_ -> new BooleanValue((RuleType<BooleanValue>)p_223574_1_, p_223567_0_), p_223567_1_, IRuleEntryVisitor::func_230482_b_);
        }

        private static RuleType<BooleanValue> func_223568_b(boolean p_223568_0_) {
            return BooleanValue.func_223567_b(p_223568_0_, (p_223569_0_, p_223569_1_) -> {});
        }

        public BooleanValue(RuleType<BooleanValue> p_i51535_1_, boolean p_i51535_2_) {
            super(p_i51535_1_);
            this.field_223575_a = p_i51535_2_;
        }

        @Override
        protected void func_223555_a(CommandContext<CommandSource> p_223555_1_, String p_223555_2_) {
            if (ruleKey != null) {
                WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)((CommandSource)p_223555_1_.getSource()).func_197023_e().getWorld(), ((CommandSource)p_223555_1_.getSource()).getBukkitSender(), GameRule.getByName((String)ruleKey.toString()), String.valueOf(BoolArgumentType.getBool(p_223555_1_, (String)p_223555_2_)));
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.field_223575_a = Boolean.parseBoolean(event.getValue());
            } else {
                this.field_223575_a = BoolArgumentType.getBool(p_223555_1_, (String)p_223555_2_);
            }
        }

        public boolean func_223572_a() {
            return this.field_223575_a;
        }

        public void func_223570_a(boolean p_223570_1_, @Nullable MinecraftServer p_223570_2_) {
            this.field_223575_a = p_223570_1_;
            this.func_223556_a(p_223570_2_);
        }

        @Override
        public String func_223552_b() {
            return Boolean.toString(this.field_223575_a);
        }

        @Override
        public void func_223553_a(String p_223553_1_) {
            this.field_223575_a = Boolean.parseBoolean(p_223553_1_);
        }

        @Override
        public int func_223557_c() {
            return this.field_223575_a ? 1 : 0;
        }

        @Override
        protected BooleanValue func_223213_e_() {
            return this;
        }

        @Override
        protected BooleanValue func_230314_f_() {
            return new BooleanValue(this.field_223558_a, this.field_223575_a);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void func_230313_a_(BooleanValue p_230313_1_, @Nullable MinecraftServer p_230313_2_) {
            this.field_223575_a = p_230313_1_.field_223575_a;
            this.func_223556_a(p_230313_2_);
        }
    }
}

