/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Comparator;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.util.ITeleporter;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.util.BlockStateListPopulator;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class Teleporter
implements ITeleporter {
    protected final ServerWorld field_85192_a;

    public Teleporter(ServerWorld p_i1963_1_) {
        this.field_85192_a = p_i1963_1_;
    }

    public Optional<TeleportationRepositioner.Result> func_242957_a(BlockPos p_242957_1_, boolean p_242957_2_) {
        return this.findPortal(p_242957_1_, p_242957_2_ ? 16 : 128);
    }

    public Optional<TeleportationRepositioner.Result> findPortal(BlockPos pos, int i) {
        PointOfInterestManager pointofinterestmanager = this.field_85192_a.func_217443_B();
        pointofinterestmanager.func_226347_a_((IWorldReader)((Object)this.field_85192_a), pos, i);
        Optional<PointOfInterest> optional = pointofinterestmanager.func_226353_b_(p_242952_0_ -> p_242952_0_ == PointOfInterestType.field_226358_u_, pos, i, PointOfInterestManager.Status.ANY).sorted(Comparator.comparingDouble(p_242954_1_ -> p_242954_1_.func_218261_f().func_177951_i(pos)).thenComparingInt(p_242959_0_ -> p_242959_0_.func_218261_f().func_177956_o())).filter(p_242958_1_ -> this.field_85192_a.func_180495_p(p_242958_1_.func_218261_f()).func_235901_b_(BlockStateProperties.field_208199_z)).findFirst();
        return optional.map(p_242951_1_ -> {
            BlockPos blockpos = p_242951_1_.func_218261_f();
            this.field_85192_a.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(blockpos), 3, blockpos);
            BlockState blockstate = this.field_85192_a.func_180495_p(blockpos);
            return TeleportationRepositioner.func_243676_a((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.func_177229_b(BlockStateProperties.field_208199_z)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_242953_2_ -> this.field_85192_a.func_180495_p((BlockPos)((Object)((Object)p_242953_2_))) == blockstate);
        });
    }

    public Optional<TeleportationRepositioner.Result> func_242956_a(BlockPos p_242956_1_, Direction.Axis p_242956_2_) {
        return this.createPortal(p_242956_1_, p_242956_2_, null, 16);
    }

    public Optional<TeleportationRepositioner.Result> createPortal(BlockPos pos, Direction.Axis axis, Entity entity, int createRadius) {
        Direction direction = Direction.func_181076_a(Direction.AxisDirection.POSITIVE, axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = this.field_85192_a.func_175723_af();
        int i = this.field_85192_a.func_234938_ad_() - 1;
        BlockPos.Mutable blockpos$mutable = pos.func_239590_i_();
        for (BlockPos.Mutable blockpos$mutable1 : BlockPos.func_243514_a(pos, createRadius, Direction.EAST, Direction.SOUTH)) {
            int j = Math.min(i, this.field_85192_a.func_201676_a(Heightmap.Type.MOTION_BLOCKING, blockpos$mutable1.func_177958_n(), blockpos$mutable1.func_177952_p()));
            boolean k = true;
            if (!worldborder.func_177746_a(blockpos$mutable1) || !worldborder.func_177746_a(blockpos$mutable1.func_189534_c(direction, 1))) continue;
            blockpos$mutable1.func_189534_c(direction.func_176734_d(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                blockpos$mutable1.func_185336_p(l);
                if (!this.field_85192_a.func_175623_d(blockpos$mutable1)) continue;
                int i1 = l;
                while (l > 0 && this.field_85192_a.func_175623_d(blockpos$mutable1.func_189536_c(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutable1.func_185336_p(l);
                if (!this.func_242955_a(blockpos$mutable1, blockpos$mutable, direction, 0)) continue;
                double d2 = pos.func_177951_i(blockpos$mutable1);
                if (this.func_242955_a(blockpos$mutable1, blockpos$mutable, direction, -1) && this.func_242955_a(blockpos$mutable1, blockpos$mutable, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutable1.func_185334_h();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutable1.func_185334_h();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        BlockStateListPopulator blockList = new BlockStateListPopulator((World)this.field_85192_a);
        if (d0 == -1.0) {
            blockpos = new BlockPos(pos.func_177958_n(), MathHelper.func_76125_a((int)pos.func_177956_o(), (int)70, (int)(this.field_85192_a.func_234938_ad_() - 10)), pos.func_177952_p()).func_185334_h();
            Direction direction1 = direction.func_176746_e();
            if (!worldborder.func_177746_a(blockpos)) {
                return Optional.empty();
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        BlockState blockstate1 = i3 < 0 ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P();
                        blockpos$mutable.func_239621_a_(blockpos, k2 * direction.func_82601_c() + l1 * direction1.func_82601_c(), i3, k2 * direction.func_82599_e() + l1 * direction1.func_82599_e());
                        blockList.func_180501_a((BlockPos)blockpos$mutable, blockstate1, 3);
                    }
                }
            }
        }
        for (int k1 = -1; k1 < 3; ++k1) {
            for (int i2 = -1; i2 < 4; ++i2) {
                if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                blockpos$mutable.func_239621_a_(blockpos, k1 * direction.func_82601_c(), i2, k1 * direction.func_82599_e());
                blockList.func_180501_a((BlockPos)blockpos$mutable, Blocks.field_150343_Z.func_176223_P(), 3);
            }
        }
        BlockState blockstate = (BlockState)Blocks.field_150427_aO.func_176223_P().func_206870_a(NetherPortalBlock.field_176550_a, axis);
        for (int j2 = 0; j2 < 2; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                blockpos$mutable.func_239621_a_(blockpos, j2 * direction.func_82601_c(), l2, j2 * direction.func_82599_e());
                blockList.func_180501_a((BlockPos)blockpos$mutable, blockstate, 18);
            }
        }
        CraftWorld bworld = this.field_85192_a.getWorld();
        PortalCreateEvent event = new PortalCreateEvent(blockList.getList(), (org.bukkit.World)bworld, (org.bukkit.entity.Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.NETHER_PAIR);
        this.field_85192_a.getCBServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        blockList.updateList();
        return Optional.of(new TeleportationRepositioner.Result(blockpos.func_185334_h(), 2, 3));
    }

    private boolean func_242955_a(BlockPos p_242955_1_, BlockPos.Mutable p_242955_2_, Direction p_242955_3_, int p_242955_4_) {
        Direction direction = p_242955_3_.func_176746_e();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                p_242955_2_.func_239621_a_(p_242955_1_, p_242955_3_.func_82601_c() * i + direction.func_82601_c() * p_242955_4_, j, p_242955_3_.func_82599_e() * i + direction.func_82599_e() * p_242955_4_);
                if (j < 0 && !this.field_85192_a.func_180495_p(p_242955_2_).func_185904_a().func_76220_a()) {
                    return false;
                }
                if (j < 0 || this.field_85192_a.func_175623_d(p_242955_2_)) continue;
                return false;
            }
        }
        return true;
    }
}

