/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.papermc.paper.event.world.StructureLocateEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.gen.settings.StructureSpreadSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.Location;
import org.bukkit.StructureType;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.spigotmc.SpigotWorldConfig;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> field_235948_a_ = Registry.field_239690_aB_.dispatchStable(ChunkGenerator::func_230347_a_, Function.identity());
    protected final BiomeProvider field_222542_c;
    protected final BiomeProvider field_235949_c_;
    private final DimensionStructuresSettings field_222543_d;
    private final long field_235950_e_;
    private final List<ChunkPos> field_235951_f_ = Lists.newArrayList();
    private volatile boolean injected;

    public ChunkGenerator(BiomeProvider p_i231888_1_, DimensionStructuresSettings p_i231888_2_) {
        this(p_i231888_1_, p_i231888_1_, p_i231888_2_, 0L);
    }

    public ChunkGenerator(BiomeProvider p_i231887_1_, BiomeProvider p_i231887_2_, DimensionStructuresSettings p_i231887_3_, long p_i231887_4_) {
        this.field_222542_c = p_i231887_1_;
        this.field_235949_c_ = p_i231887_2_;
        this.field_222543_d = p_i231887_3_;
        this.field_235950_e_ = p_i231887_4_;
    }

    private void func_235958_g_() {
        StructureSpreadSettings structurespreadsettings;
        if (this.field_235951_f_.isEmpty() && (structurespreadsettings = this.field_222543_d.func_236199_b_()) != null && structurespreadsettings.func_236663_c_() != 0) {
            ArrayList list = Lists.newArrayList();
            for (Biome biome : this.field_222542_c.func_235203_c_()) {
                if (!biome.func_242440_e().func_242493_a(Structure.field_236375_k_)) continue;
                list.add(biome);
            }
            int k1 = structurespreadsettings.func_236660_a_();
            int l1 = structurespreadsettings.func_236663_c_();
            int i = structurespreadsettings.func_236662_b_();
            Random random = new Random();
            random.setSeed(this.field_235950_e_);
            double d0 = random.nextDouble() * Math.PI * 2.0;
            int j = 0;
            int k = 0;
            for (int l = 0; l < l1; ++l) {
                double d1 = (double)(4 * k1 + k1 * k * 6) + (random.nextDouble() - 0.5) * (double)k1 * 2.5;
                int i1 = (int)Math.round(Math.cos(d0) * d1);
                int j1 = (int)Math.round(Math.sin(d0) * d1);
                BlockPos blockpos = this.field_222542_c.func_225531_a_((i1 << 4) + 8, 0, (j1 << 4) + 8, 112, list::contains, random);
                if (blockpos != null) {
                    i1 = blockpos.func_177958_n() >> 4;
                    j1 = blockpos.func_177952_p() >> 4;
                }
                this.field_235951_f_.add(new ChunkPos(i1, j1));
                d0 += Math.PI * 2 / (double)i;
                if (++j != i) continue;
                j = 0;
                i += 2 * i / (++k + 1);
                i = Math.min(i, l1 - l);
                d0 += random.nextDouble() * Math.PI * 2.0;
            }
        }
    }

    protected abstract Codec<? extends ChunkGenerator> func_230347_a_();

    @OnlyIn(value=Dist.CLIENT)
    public abstract ChunkGenerator func_230349_a_(long var1);

    public void func_242706_a(Registry<Biome> p_242706_1_, IChunk p_242706_2_) {
        ChunkPos chunkpos = p_242706_2_.func_76632_l();
        ((ChunkPrimer)p_242706_2_).func_225548_a_(new BiomeContainer(p_242706_1_, chunkpos, this.field_235949_c_));
    }

    public void func_230350_a_(long p_230350_1_, BiomeManager p_230350_3_, IChunk p_230350_4_, GenerationStage.Carving p_230350_5_) {
        BiomeManager biomemanager = p_230350_3_.func_226835_a_(this.field_222542_c);
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        int i = 8;
        ChunkPos chunkpos = p_230350_4_.func_76632_l();
        int j = chunkpos.field_77276_a;
        int k = chunkpos.field_77275_b;
        BiomeGenerationSettings biomegenerationsettings = this.field_222542_c.func_225526_b_(chunkpos.field_77276_a << 2, 0, chunkpos.field_77275_b << 2).func_242440_e();
        BitSet bitset = ((ChunkPrimer)p_230350_4_).func_230345_b_(p_230350_5_);
        for (int l = j - 8; l <= j + 8; ++l) {
            for (int i1 = k - 8; i1 <= k + 8; ++i1) {
                List<Supplier<ConfiguredCarver<?>>> list = biomegenerationsettings.func_242489_a(p_230350_5_);
                ListIterator<Supplier<ConfiguredCarver<?>>> listiterator = list.listIterator();
                while (listiterator.hasNext()) {
                    int j1 = listiterator.nextIndex();
                    ConfiguredCarver<?> configuredcarver = listiterator.next().get();
                    sharedseedrandom.func_202425_c(p_230350_1_ + (long)j1, l, i1);
                    if (!configuredcarver.func_222730_a((Random)sharedseedrandom, l, i1)) continue;
                    configuredcarver.func_227207_a_(p_230350_4_, arg_0 -> ((BiomeManager)biomemanager).func_226836_a_(arg_0), (Random)sharedseedrandom, this.func_230356_f_(), l, i1, j, k, bitset);
                }
            }
        }
    }

    @Nullable
    public BlockPos func_235956_a_(ServerWorld p_235956_1_, Structure<?> p_235956_2_, BlockPos p_235956_3_, int p_235956_4_, boolean p_235956_5_) {
        Location bukkitOrigin;
        CraftWorld bukkitWorld = p_235956_1_.getWorld();
        StructureLocateEvent event = new StructureLocateEvent((org.bukkit.World)bukkitWorld, bukkitOrigin = new Location((org.bukkit.World)bukkitWorld, (double)p_235956_3_.func_177958_n(), (double)p_235956_3_.func_177956_o(), (double)p_235956_3_.func_177952_p()), (StructureType)StructureType.getStructureTypes().get(p_235956_2_.func_143025_a()), p_235956_4_, p_235956_5_);
        if (!event.callEvent()) {
            return null;
        }
        if (event.getResult() != null) {
            return new BlockPos(event.getResult().getBlockX(), event.getResult().getBlockY(), event.getResult().getBlockZ());
        }
        p_235956_3_ = new BlockPos(event.getOrigin().getBlockX(), event.getOrigin().getBlockY(), event.getOrigin().getBlockZ());
        p_235956_1_ = ((CraftWorld)event.getOrigin().getWorld()).getHandle();
        p_235956_4_ = event.getRadius();
        p_235956_5_ = event.shouldFindUnexplored();
        if (event.getType() != null) {
            p_235956_2_ = (Structure)((Object)Structure.field_236365_a_.get((Object)event.getType().getName()));
        }
        if (!this.field_222542_c.func_205004_a(p_235956_2_)) {
            return null;
        }
        if (p_235956_2_ == Structure.field_236375_k_) {
            this.func_235958_g_();
            BlockPos blockpos = null;
            double d0 = Double.MAX_VALUE;
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (ChunkPos chunkpos : this.field_235951_f_) {
                blockpos$mutable.func_181079_c((chunkpos.field_77276_a << 4) + 8, 32, (chunkpos.field_77275_b << 4) + 8);
                double d1 = blockpos$mutable.func_177951_i(p_235956_3_);
                if (blockpos == null) {
                    blockpos = new BlockPos(blockpos$mutable);
                    d0 = d1;
                    continue;
                }
                if (!(d1 < d0)) continue;
                blockpos = new BlockPos(blockpos$mutable);
                d0 = d1;
            }
            return blockpos;
        }
        this.updateStructureSettings(p_235956_1_, this.field_222543_d);
        StructureSeparationSettings structureseparationsettings = this.field_222543_d.func_236197_a_(p_235956_2_);
        return structureseparationsettings == null ? null : p_235956_2_.func_236388_a_((IWorldReader)((Object)p_235956_1_), p_235956_1_.func_241112_a_(), p_235956_3_, p_235956_4_, p_235956_5_, p_235956_1_.func_72905_C(), structureseparationsettings);
    }

    public void func_230351_a_(WorldGenRegion p_230351_1_, StructureManager p_230351_2_) {
        int i = p_230351_1_.func_201679_a();
        int j = p_230351_1_.func_201680_b();
        int k = i * 16;
        int l = j * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        Biome biome = this.field_222542_c.func_225526_b_((i << 2) + 2, 2, (j << 2) + 2);
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        long i1 = sharedseedrandom.func_202424_a(p_230351_1_.func_72905_C(), k, l);
        try {
            biome.func_242427_a(p_230351_2_, this, p_230351_1_, i1, sharedseedrandom, blockpos);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.func_85055_a(exception, "Biome decoration");
            crashreport.func_85058_a("Generation").func_71507_a("CenterX", i).func_71507_a("CenterZ", j).func_71507_a("Seed", i1).func_71507_a("Biome", (Object)biome);
            throw new ReportedException(crashreport);
        }
    }

    public abstract void func_225551_a_(WorldGenRegion var1, IChunk var2);

    public void func_230354_a_(WorldGenRegion p_230354_1_) {
    }

    public DimensionStructuresSettings func_235957_b_() {
        return this.field_222543_d;
    }

    public int func_205470_d() {
        return 64;
    }

    public BiomeProvider func_202090_b() {
        return this.field_235949_c_;
    }

    public int func_230355_e_() {
        return 256;
    }

    public List<MobSpawnInfo.Spawners> func_230353_a_(Biome p_230353_1_, StructureManager p_230353_2_, EntityClassification p_230353_3_, BlockPos p_230353_4_) {
        return p_230353_1_.func_242433_b().func_242559_a(p_230353_3_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_242707_a(DynamicRegistries p_242707_1_, StructureManager p_242707_2_, IChunk p_242707_3_, TemplateManager p_242707_4_, long p_242707_5_) {
        ChunkPos chunkpos = p_242707_3_.func_76632_l();
        Biome biome = this.field_222542_c.func_225526_b_((chunkpos.field_77276_a << 2) + 2, 0, (chunkpos.field_77275_b << 2) + 2);
        this.func_242705_a(StructureFeatures.field_244145_k, p_242707_1_, p_242707_2_, p_242707_3_, p_242707_4_, p_242707_5_, chunkpos, biome);
        for (Supplier<StructureFeature<?, ?>> supplier : biome.func_242440_e().func_242487_a()) {
            StructureFeature<?, ?> structurefeature = supplier.get();
            if (structurefeature.field_236269_c_ == Structure.field_236375_k_) {
                StructureFeature<?, ?> structureFeature = structurefeature;
                synchronized (structureFeature) {
                    this.func_242705_a(structurefeature, p_242707_1_, p_242707_2_, p_242707_3_, p_242707_4_, p_242707_5_, chunkpos, biome);
                    continue;
                }
            }
            this.func_242705_a(structurefeature, p_242707_1_, p_242707_2_, p_242707_3_, p_242707_4_, p_242707_5_, chunkpos, biome);
        }
    }

    private void func_242705_a(StructureFeature<?, ?> p_242705_1_, DynamicRegistries p_242705_2_, StructureManager p_242705_3_, IChunk p_242705_4_, TemplateManager p_242705_5_, long p_242705_6_, ChunkPos p_242705_8_, Biome p_242705_9_) {
        StructureStart<?> structurestart = p_242705_3_.func_235013_a_(SectionPos.func_218156_a((ChunkPos)p_242705_4_.func_76632_l(), (int)0), p_242705_1_.field_236268_b_, p_242705_4_);
        int i = structurestart != null ? structurestart.func_227457_j_() : 0;
        this.updateStructureSettings(p_242705_3_.getWorld(), this.field_222543_d);
        StructureSeparationSettings structureseparationsettings = this.field_222543_d.func_236197_a_(p_242705_1_.field_236268_b_);
        if (structureseparationsettings != null) {
            StructureStart structurestart1 = p_242705_1_.func_242771_a(p_242705_2_, this, this.field_222542_c, p_242705_5_, p_242705_6_, p_242705_8_, p_242705_9_, i, structureseparationsettings);
            p_242705_3_.func_235014_a_(SectionPos.func_218156_a((ChunkPos)p_242705_4_.func_76632_l(), (int)0), p_242705_1_.field_236268_b_, structurestart1, p_242705_4_);
        }
    }

    public void func_235953_a_(ISeedReader p_235953_1_, StructureManager p_235953_2_, IChunk p_235953_3_) {
        int i = 8;
        int j = p_235953_3_.func_76632_l().field_77276_a;
        int k = p_235953_3_.func_76632_l().field_77275_b;
        int l = j << 4;
        int i1 = k << 4;
        SectionPos sectionpos = SectionPos.func_218156_a((ChunkPos)p_235953_3_.func_76632_l(), (int)0);
        for (int j1 = j - 8; j1 <= j + 8; ++j1) {
            for (int k1 = k - 8; k1 <= k + 8; ++k1) {
                long l1 = ChunkPos.func_77272_a((int)j1, (int)k1);
                for (StructureStart<?> structurestart : p_235953_1_.func_212866_a_(j1, k1).func_201609_c().values()) {
                    try {
                        if (structurestart == StructureStart.field_214630_a || !structurestart.func_75071_a().func_78885_a(l, i1, l + 15, i1 + 15)) continue;
                        p_235953_2_.func_235012_a_(sectionpos, structurestart.func_214627_k(), l1, p_235953_3_);
                        DebugPacketSender.func_218804_a((ISeedReader)p_235953_1_, structurestart);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.func_85055_a(exception, "Generating structure reference");
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Structure");
                        crashreportcategory.func_189529_a("Id", (ICrashReportDetail<String>)((ICrashReportDetail)() -> Registry.field_218361_B.func_177774_c(structurestart.func_214627_k()).toString()));
                        crashreportcategory.func_189529_a("Name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> structurestart.func_214627_k().func_143025_a()));
                        crashreportcategory.func_189529_a("Class", (ICrashReportDetail<String>)((ICrashReportDetail)() -> ((Object)structurestart.func_214627_k()).getClass().getCanonicalName()));
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStructureSettings(World world, DimensionStructuresSettings settings) {
        if (this.injected) {
            return;
        }
        DimensionStructuresSettings dimensionStructuresSettings = settings;
        synchronized (dimensionStructuresSettings) {
            if (this.injected) {
                return;
            }
            Map<Structure<?>, StructureSeparationSettings> original = settings.func_236195_a_();
            HashMap updated = new HashMap();
            SpigotWorldConfig conf = world.spigotConfig;
            for (Map.Entry<Structure<?>, StructureSeparationSettings> entry : original.entrySet()) {
                String name = Registry.field_218361_B.func_177774_c(entry.getKey()).func_110623_a();
                StructureSeparationSettings feature = entry.getValue();
                int seed = feature.func_236673_c_();
                switch (name) {
                    case "bastion_remnant": {
                        seed = conf.bastionSeed;
                        break;
                    }
                    case "desert_pyramid": {
                        seed = conf.desertSeed;
                        break;
                    }
                    case "endcity": {
                        seed = conf.endCitySeed;
                        break;
                    }
                    case "fortress": {
                        seed = conf.fortressSeed;
                        break;
                    }
                    case "igloo": {
                        seed = conf.iglooSeed;
                        break;
                    }
                    case "jungle_pyramid": {
                        seed = conf.jungleSeed;
                        break;
                    }
                    case "mansion": {
                        seed = conf.mansionSeed;
                        break;
                    }
                    case "monument": {
                        seed = conf.monumentSeed;
                        break;
                    }
                    case "nether_fossil": {
                        seed = conf.fossilSeed;
                        break;
                    }
                    case "ocean_ruin": {
                        seed = conf.oceanSeed;
                        break;
                    }
                    case "pillager_outpost": {
                        seed = conf.outpostSeed;
                        break;
                    }
                    case "ruined_portal": {
                        seed = conf.portalSeed;
                        break;
                    }
                    case "shipwreck": {
                        seed = conf.shipwreckSeed;
                        break;
                    }
                    case "swamp_hut": {
                        seed = conf.swampSeed;
                        break;
                    }
                    case "village": {
                        seed = conf.villageSeed;
                    }
                }
                updated.put(entry.getKey(), new StructureSeparationSettings(feature.func_236668_a_(), feature.func_236671_b_(), seed));
            }
            original.clear();
            original.putAll(updated);
            this.injected = true;
        }
    }

    public abstract void func_230352_b_(IWorld var1, StructureManager var2, IChunk var3);

    public int func_230356_f_() {
        return 63;
    }

    public abstract int func_222529_a(int var1, int var2, Heightmap.Type var3);

    public abstract IBlockReader func_230348_a_(int var1, int var2);

    public int func_222532_b(int p_222532_1_, int p_222532_2_, Heightmap.Type p_222532_3_) {
        return this.func_222529_a(p_222532_1_, p_222532_2_, p_222532_3_);
    }

    public int func_222531_c(int p_222531_1_, int p_222531_2_, Heightmap.Type p_222531_3_) {
        return this.func_222529_a(p_222531_1_, p_222531_2_, p_222531_3_) - 1;
    }

    public boolean func_235952_a_(ChunkPos p_235952_1_) {
        this.func_235958_g_();
        return this.field_235951_f_.contains(p_235952_1_);
    }

    static {
        Registry.func_218325_a(Registry.field_239690_aB_, "noise", NoiseChunkGenerator.field_236079_d_);
        Registry.func_218325_a(Registry.field_239690_aB_, "flat", FlatChunkGenerator.field_236069_d_);
        Registry.func_218325_a(Registry.field_239690_aB_, "debug", DebugChunkGenerator.field_236066_e_);
    }
}

