/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mohistmc.util.i18n.i18n;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.FillLayerConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlatGenerationSettings {
    private static final Logger field_211404_q = LogManager.getLogger();
    public static final Codec<FlatGenerationSettings> field_236932_a_ = RecordCodecBuilder.create(p_236938_0_ -> p_236938_0_.group((App)RegistryLookupCodec.func_244331_a(Registry.field_239720_u_).forGetter(p_242874_0_ -> p_242874_0_.field_242867_d), (App)DimensionStructuresSettings.field_236190_a_.fieldOf("structures").forGetter(FlatGenerationSettings::func_236943_d_), (App)FlatLayerInfo.field_236929_a_.listOf().fieldOf("layers").forGetter(FlatGenerationSettings::func_82650_c), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(p_241528_0_ -> p_241528_0_.field_236935_l_), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(p_242871_0_ -> p_242871_0_.field_236934_k_), (App)Biome.field_235051_b_.optionalFieldOf("biome").orElseGet(Optional::empty).forGetter(p_242868_0_ -> Optional.of(p_242868_0_.field_82654_c))).apply((Applicative)p_236938_0_, FlatGenerationSettings::new)).stable();
    private static final Map<Structure<?>, StructureFeature<?, ?>> field_202247_j = Util.func_200696_a(Maps.newHashMap(), p_236940_0_ -> {
        p_236940_0_.put(Structure.field_236367_c_, StructureFeatures.field_244136_b);
        p_236940_0_.put(Structure.field_236381_q_, StructureFeatures.field_244154_t);
        p_236940_0_.put(Structure.field_236375_k_, StructureFeatures.field_244145_k);
        p_236940_0_.put(Structure.field_236374_j_, StructureFeatures.field_244144_j);
        p_236940_0_.put(Structure.field_236370_f_, StructureFeatures.field_244140_f);
        p_236940_0_.put(Structure.field_236369_e_, StructureFeatures.field_244139_e);
        p_236940_0_.put(Structure.field_236371_g_, StructureFeatures.field_244141_g);
        p_236940_0_.put(Structure.field_236377_m_, StructureFeatures.field_244147_m);
        p_236940_0_.put(Structure.field_236373_i_, StructureFeatures.field_244142_h);
        p_236940_0_.put(Structure.field_236376_l_, StructureFeatures.field_244146_l);
        p_236940_0_.put(Structure.field_236379_o_, StructureFeatures.field_244151_q);
        p_236940_0_.put(Structure.field_236368_d_, StructureFeatures.field_244138_d);
        p_236940_0_.put(Structure.field_236378_n_, StructureFeatures.field_244149_o);
        p_236940_0_.put(Structure.field_236366_b_, StructureFeatures.field_244135_a);
        p_236940_0_.put(Structure.field_236372_h_, StructureFeatures.field_244159_y);
        p_236940_0_.put(Structure.field_236383_s_, StructureFeatures.field_244153_s);
    });
    private final Registry<Biome> field_242867_d;
    private final DimensionStructuresSettings field_236933_f_;
    private final List<FlatLayerInfo> field_82655_a = Lists.newArrayList();
    private Supplier<Biome> field_82654_c;
    private final BlockState[] field_202244_C = new BlockState[256];
    private boolean field_202245_D;
    private boolean field_236934_k_ = false;
    private boolean field_236935_l_ = false;

    public FlatGenerationSettings(Registry<Biome> p_i242012_1_, DimensionStructuresSettings p_i242012_2_, List<FlatLayerInfo> p_i242012_3_, boolean p_i242012_4_, boolean p_i242012_5_, Optional<Supplier<Biome>> p_i242012_6_) {
        this(p_i242012_2_, p_i242012_1_);
        if (p_i242012_4_) {
            this.func_236941_b_();
        }
        if (p_i242012_5_) {
            this.func_236936_a_();
        }
        this.field_82655_a.addAll(p_i242012_3_);
        this.func_82645_d();
        if (!p_i242012_6_.isPresent()) {
            field_211404_q.error(i18n.get((String)"flatgenerationsettings.1"));
            this.field_82654_c = () -> (Biome)((Object)((Object)p_i242012_1_.func_243576_d(Biomes.field_76772_c)));
        } else {
            this.field_82654_c = p_i242012_6_.get();
        }
    }

    public FlatGenerationSettings(DimensionStructuresSettings p_i242011_1_, Registry<Biome> p_i242011_2_) {
        this.field_242867_d = p_i242011_2_;
        this.field_236933_f_ = p_i242011_1_;
        this.field_82654_c = () -> (Biome)((Object)((Object)p_i242011_2_.func_243576_d(Biomes.field_76772_c)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlatGenerationSettings func_236937_a_(DimensionStructuresSettings p_236937_1_) {
        return this.func_241527_a_(this.field_82655_a, p_236937_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlatGenerationSettings func_241527_a_(List<FlatLayerInfo> p_241527_1_, DimensionStructuresSettings p_241527_2_) {
        FlatGenerationSettings flatgenerationsettings = new FlatGenerationSettings(p_241527_2_, this.field_242867_d);
        for (FlatLayerInfo flatlayerinfo : p_241527_1_) {
            flatgenerationsettings.field_82655_a.add(new FlatLayerInfo(flatlayerinfo.func_82657_a(), flatlayerinfo.func_175900_c().func_177230_c()));
            flatgenerationsettings.func_82645_d();
        }
        flatgenerationsettings.func_242870_a(this.field_82654_c);
        if (this.field_236934_k_) {
            flatgenerationsettings.func_236936_a_();
        }
        if (this.field_236935_l_) {
            flatgenerationsettings.func_236941_b_();
        }
        return flatgenerationsettings;
    }

    public void func_236936_a_() {
        this.field_236934_k_ = true;
    }

    public void func_236941_b_() {
        this.field_236935_l_ = true;
    }

    public Biome func_236942_c_() {
        boolean flag;
        Biome biome = this.func_82648_a();
        BiomeGenerationSettings biomegenerationsettings = biome.func_242440_e();
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder().func_242519_a(biomegenerationsettings.func_242500_d());
        if (this.field_236935_l_) {
            biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.LAKES, Features.field_243789_O);
            biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.LAKES, Features.field_243790_P);
        }
        HashMap map = new HashMap(field_202247_j);
        WorldGenRegistries.field_243654_f.func_201756_e().filter(f -> !map.containsKey((Object)f.field_236268_b_)).forEach(f -> map.put(f.field_236268_b_, (StructureFeature<?, ?>)f));
        for (Map.Entry<Structure<?>, StructureSeparationSettings> entry : this.field_236933_f_.func_236195_a_().entrySet()) {
            if (!map.containsKey(entry.getKey())) {
                field_211404_q.error("FORGE: There's no known StructureFeature for {} when preparing the {} flatworld biome. The structure will be skipped and may not spawn. Please register your StructureFeatures in the WorldGenRegistries!", (Object)entry.getKey().func_143025_a(), (Object)biome.getRegistryName());
                continue;
            }
            biomegenerationsettings$builder.func_242516_a(biomegenerationsettings.func_242491_a((StructureFeature)map.get(entry.getKey())));
        }
        boolean bl = flag = (!this.field_202245_D || this.field_242867_d.func_230519_c_(biome).equals(Optional.of(Biomes.field_185440_P))) && this.field_236934_k_;
        if (flag) {
            List<List<Supplier<ConfiguredFeature<?, ?>>>> list = biomegenerationsettings.func_242498_c();
            for (int i = 0; i < list.size(); ++i) {
                if (i == GenerationStage.Decoration.UNDERGROUND_STRUCTURES.ordinal() || i == GenerationStage.Decoration.SURFACE_STRUCTURES.ordinal()) continue;
                for (Supplier<ConfiguredFeature<?, ?>> supplier : list.get(i)) {
                    biomegenerationsettings$builder.func_242510_a(i, supplier);
                }
            }
        }
        BlockState[] ablockstate = this.func_202233_q();
        for (int j = 0; j < ablockstate.length; ++j) {
            BlockState blockstate = ablockstate[j];
            if (blockstate == null || Heightmap.Type.MOTION_BLOCKING.func_222684_d().test(blockstate)) continue;
            this.field_202244_C[j] = null;
            biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, Feature.field_214486_aN.func_225566_b_(new FillLayerConfig(j, blockstate)));
        }
        return (Biome)new Biome.Builder().func_205415_a(biome.func_201851_b()).func_205419_a(biome.func_201856_r()).func_205421_a(biome.func_185355_j()).func_205420_b(biome.func_185360_m()).func_205414_c(biome.func_242445_k()).func_205417_d(biome.func_76727_i()).func_235097_a_(biome.func_235089_q_()).func_242457_a(biomegenerationsettings$builder.func_242508_a()).func_242458_a(biome.func_242433_b()).func_242455_a().setRegistryName(biome.getRegistryName());
    }

    public DimensionStructuresSettings func_236943_d_() {
        return this.field_236933_f_;
    }

    public Biome func_82648_a() {
        return this.field_82654_c.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_242870_a(Supplier<Biome> p_242870_1_) {
        this.field_82654_c = p_242870_1_;
    }

    public List<FlatLayerInfo> func_82650_c() {
        return this.field_82655_a;
    }

    public BlockState[] func_202233_q() {
        return this.field_202244_C;
    }

    public void func_82645_d() {
        Arrays.fill(this.field_202244_C, 0, this.field_202244_C.length, null);
        int i = 0;
        for (FlatLayerInfo flatlayerinfo : this.field_82655_a) {
            flatlayerinfo.func_82660_d(i);
            i += flatlayerinfo.func_82657_a();
        }
        this.field_202245_D = true;
        for (FlatLayerInfo flatlayerinfo1 : this.field_82655_a) {
            for (int j = flatlayerinfo1.func_82656_d(); j < flatlayerinfo1.func_82656_d() + flatlayerinfo1.func_82657_a(); ++j) {
                BlockState blockstate = flatlayerinfo1.func_175900_c();
                if (blockstate.func_203425_a(Blocks.field_150350_a)) continue;
                this.field_202245_D = false;
                this.field_202244_C[j] = blockstate;
            }
        }
    }

    public static FlatGenerationSettings func_242869_a(Registry<Biome> p_242869_0_) {
        DimensionStructuresSettings dimensionstructuressettings = new DimensionStructuresSettings(Optional.of(DimensionStructuresSettings.field_236192_c_), Maps.newHashMap((Map)ImmutableMap.of(Structure.field_236381_q_, (Object)((StructureSeparationSettings)DimensionStructuresSettings.field_236191_b_.get(Structure.field_236381_q_)))));
        FlatGenerationSettings flatgenerationsettings = new FlatGenerationSettings(dimensionstructuressettings, p_242869_0_);
        flatgenerationsettings.field_82654_c = () -> (Biome)((Object)((Object)p_242869_0_.func_243576_d(Biomes.field_76772_c)));
        flatgenerationsettings.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_150357_h));
        flatgenerationsettings.func_82650_c().add(new FlatLayerInfo(2, Blocks.field_150346_d));
        flatgenerationsettings.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_196658_i));
        flatgenerationsettings.func_82645_d();
        return flatgenerationsettings;
    }
}

