/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.mohistmc.util.i18n.i18n;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.WorldGenTickList;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class WorldGenRegion
implements ISeedReader {
    private static final Logger field_208303_a = LogManager.getLogger();
    private final List<IChunk> field_201684_a;
    private final int field_201685_b;
    private final int field_201686_c;
    private final int field_217380_e;
    private final ServerWorld field_201689_f;
    private final long field_201690_g;
    private final IWorldInfo field_201692_i;
    private final Random field_201693_j;
    private final DimensionType field_241159_j_;
    private final ITickList<Block> field_205336_m = new WorldGenTickList(p_205335_1_ -> this.func_217349_x((BlockPos)((Object)p_205335_1_)).func_205218_i_());
    private final ITickList<Fluid> field_205337_n = new WorldGenTickList(p_205334_1_ -> this.func_217349_x((BlockPos)((Object)p_205334_1_)).func_212247_j());
    private final BiomeManager field_229862_o_;
    private final ChunkPos field_241160_n_;
    private final ChunkPos field_241161_o_;
    private final StructureManager field_244530_p;

    public WorldGenRegion(ServerWorld p_i50698_1_, List<IChunk> p_i50698_2_) {
        int i = MathHelper.func_76128_c((double)Math.sqrt(p_i50698_2_.size()));
        if (i * i != p_i50698_2_.size()) {
            throw Util.func_229757_c_(new IllegalStateException("Cache size is not a square."));
        }
        ChunkPos chunkpos = p_i50698_2_.get(p_i50698_2_.size() / 2).func_76632_l();
        this.field_201684_a = p_i50698_2_;
        this.field_201685_b = chunkpos.field_77276_a;
        this.field_201686_c = chunkpos.field_77275_b;
        this.field_217380_e = i;
        this.field_201689_f = p_i50698_1_;
        this.field_201690_g = p_i50698_1_.func_72905_C();
        this.field_201692_i = p_i50698_1_.func_72912_H();
        this.field_201693_j = p_i50698_1_.func_201674_k();
        this.field_241159_j_ = p_i50698_1_.func_230315_m_();
        this.field_229862_o_ = new BiomeManager((BiomeManager.IBiomeReader)this, BiomeManager.func_235200_a_((long)this.field_201690_g), p_i50698_1_.func_230315_m_().func_227176_e_());
        this.field_241160_n_ = p_i50698_2_.get(0).func_76632_l();
        this.field_241161_o_ = p_i50698_2_.get(p_i50698_2_.size() - 1).func_76632_l();
        this.field_244530_p = p_i50698_1_.func_241112_a_().func_241464_a_(this);
    }

    public int func_201679_a() {
        return this.field_201685_b;
    }

    public int func_201680_b() {
        return this.field_201686_c;
    }

    public IChunk func_212866_a_(int p_212866_1_, int p_212866_2_) {
        return this.func_217348_a(p_212866_1_, p_212866_2_, ChunkStatus.field_223226_a_);
    }

    @Nullable
    public IChunk func_217353_a(int p_217353_1_, int p_217353_2_, ChunkStatus p_217353_3_, boolean p_217353_4_) {
        IChunk ichunk;
        if (this.func_217354_b(p_217353_1_, p_217353_2_)) {
            int i = p_217353_1_ - this.field_241160_n_.field_77276_a;
            int j = p_217353_2_ - this.field_241160_n_.field_77275_b;
            ichunk = this.field_201684_a.get(i + j * this.field_217380_e);
            if (ichunk.func_201589_g().func_209003_a(p_217353_3_)) {
                return ichunk;
            }
        } else {
            ichunk = null;
        }
        if (!p_217353_4_) {
            return null;
        }
        field_208303_a.error(i18n.get((String)"worldgenregion.1", (Object[])new Object[]{p_217353_1_, p_217353_2_}));
        field_208303_a.error(i18n.get((String)"worldgenregion.2", (Object[])new Object[]{this.field_241160_n_.field_77276_a, this.field_241160_n_.field_77275_b, this.field_241161_o_.field_77276_a, this.field_241161_o_.field_77275_b}));
        if (ichunk != null) {
            throw Util.func_229757_c_(new RuntimeException(String.format("Chunk is not of correct status. Expecting %s, got %s | %s %s", new Object[]{p_217353_3_, ichunk.func_201589_g(), p_217353_1_, p_217353_2_})));
        }
        throw Util.func_229757_c_(new RuntimeException(String.format("We are asking a region for a chunk out of bound | %s %s", p_217353_1_, p_217353_2_)));
    }

    public boolean func_217354_b(int p_217354_1_, int p_217354_2_) {
        return p_217354_1_ >= this.field_241160_n_.field_77276_a && p_217354_1_ <= this.field_241161_o_.field_77276_a && p_217354_2_ >= this.field_241160_n_.field_77275_b && p_217354_2_ <= this.field_241161_o_.field_77275_b;
    }

    public BlockState func_180495_p(BlockPos p_180495_1_) {
        return this.func_212866_a_(p_180495_1_.func_177958_n() >> 4, p_180495_1_.func_177952_p() >> 4).func_180495_p(p_180495_1_);
    }

    public FluidState func_204610_c(BlockPos p_204610_1_) {
        return this.func_217349_x(p_204610_1_).func_204610_c(p_204610_1_);
    }

    @Nullable
    public PlayerEntity func_190525_a(double p_190525_1_, double p_190525_3_, double p_190525_5_, double p_190525_7_, Predicate<Entity> p_190525_9_) {
        return null;
    }

    public int func_175657_ab() {
        return 0;
    }

    public BiomeManager func_225523_d_() {
        return this.field_229862_o_;
    }

    public Biome func_225604_a_(int p_225604_1_, int p_225604_2_, int p_225604_3_) {
        return this.field_201689_f.func_225604_a_(p_225604_1_, p_225604_2_, p_225604_3_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        return 1.0f;
    }

    public WorldLightManager func_225524_e_() {
        return this.field_201689_f.func_225524_e_();
    }

    public boolean func_241212_a_(BlockPos p_241212_1_, boolean p_241212_2_, @Nullable Entity p_241212_3_, int p_241212_4_) {
        BlockState blockstate = this.func_180495_p(p_241212_1_);
        if (blockstate.isAir((IBlockReader)((Object)this), p_241212_1_)) {
            return false;
        }
        if (p_241212_2_) {
            TileEntity tileentity = blockstate.hasTileEntity() ? this.func_175625_s(p_241212_1_) : null;
            Block.func_220054_a(blockstate, this.field_201689_f, p_241212_1_, tileentity, p_241212_3_, ItemStack.field_190927_a);
        }
        return this.func_241211_a_(p_241212_1_, Blocks.field_150350_a.func_176223_P(), 3, p_241212_4_);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos p_175625_1_) {
        IChunk ichunk = this.func_217349_x(p_175625_1_);
        TileEntity tileentity = ichunk.func_175625_s(p_175625_1_);
        if (tileentity != null) {
            return tileentity;
        }
        CompoundNBT compoundnbt = ichunk.func_201579_g(p_175625_1_);
        BlockState blockstate = ichunk.func_180495_p(p_175625_1_);
        if (compoundnbt != null) {
            if ("DUMMY".equals(compoundnbt.func_74779_i("id"))) {
                Block block = blockstate.func_177230_c();
                if (!blockstate.hasTileEntity()) {
                    return null;
                }
                tileentity = blockstate.createTileEntity((IBlockReader)((Object)this.field_201689_f));
            } else {
                tileentity = TileEntity.func_235657_b_(blockstate, compoundnbt);
            }
            if (tileentity != null) {
                ichunk.func_177426_a(p_175625_1_, tileentity);
                return tileentity;
            }
        }
        if (blockstate.hasTileEntity()) {
            field_208303_a.warn(i18n.get((String)"worldgenregion.3", (Object[])new Object[]{p_175625_1_, blockstate.func_177230_c().toString()}));
        }
        return null;
    }

    public boolean func_241211_a_(BlockPos p_241211_1_, BlockState p_241211_2_, int p_241211_3_, int p_241211_4_) {
        IChunk ichunk = this.func_217349_x(p_241211_1_);
        BlockState blockstate = ichunk.func_177436_a(p_241211_1_, p_241211_2_, false);
        if (blockstate != null) {
            this.field_201689_f.func_217393_a(p_241211_1_, blockstate, p_241211_2_);
        }
        Block block = p_241211_2_.func_177230_c();
        if (p_241211_2_.hasTileEntity()) {
            if (ichunk.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
                ichunk.func_177426_a(p_241211_1_, p_241211_2_.createTileEntity((IBlockReader)((Object)this)));
            } else {
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_74768_a("x", p_241211_1_.func_177958_n());
                compoundnbt.func_74768_a("y", p_241211_1_.func_177956_o());
                compoundnbt.func_74768_a("z", p_241211_1_.func_177952_p());
                compoundnbt.func_74778_a("id", "DUMMY");
                ichunk.func_201591_a(compoundnbt);
            }
        } else if (blockstate != null && blockstate.hasTileEntity()) {
            ichunk.func_177425_e(p_241211_1_);
        }
        if (p_241211_2_.func_202065_c((IBlockReader)((Object)this), p_241211_1_)) {
            this.func_201683_l(p_241211_1_);
        }
        return true;
    }

    private void func_201683_l(BlockPos p_201683_1_) {
        this.func_217349_x(p_201683_1_).func_201594_d(p_201683_1_);
    }

    public boolean func_217376_c(Entity p_217376_1_) {
        return this.addEntity(p_217376_1_, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addEntity(Entity entityIn, CreatureSpawnEvent.SpawnReason reason) {
        int i = MathHelper.func_76128_c((double)(entityIn.func_226277_ct_() / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.func_226281_cx_() / 16.0));
        this.func_212866_a_(i, j).func_76612_a(entityIn);
        return true;
    }

    public boolean func_217377_a(BlockPos p_217377_1_, boolean p_217377_2_) {
        return this.func_180501_a(p_217377_1_, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public WorldBorder func_175723_af() {
        return this.field_201689_f.func_175723_af();
    }

    public boolean func_201670_d() {
        return false;
    }

    @Deprecated
    public ServerWorld func_201672_e() {
        return this.field_201689_f;
    }

    public DynamicRegistries func_241828_r() {
        return this.field_201689_f.func_241828_r();
    }

    public IWorldInfo func_72912_H() {
        return this.field_201692_i;
    }

    public DifficultyInstance func_175649_E(BlockPos p_175649_1_) {
        if (!this.func_217354_b(p_175649_1_.func_177958_n() >> 4, p_175649_1_.func_177952_p() >> 4)) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyInstance(this.field_201689_f.func_175659_aa(), this.field_201689_f.func_72820_D(), 0L, this.field_201689_f.func_242413_ae());
    }

    public AbstractChunkProvider func_72863_F() {
        return this.field_201689_f.func_72863_F();
    }

    public long func_72905_C() {
        return this.field_201690_g;
    }

    public ITickList<Block> func_205220_G_() {
        return this.field_205336_m;
    }

    public ITickList<Fluid> func_205219_F_() {
        return this.field_205337_n;
    }

    public int func_181545_F() {
        return this.field_201689_f.func_181545_F();
    }

    public Random func_201674_k() {
        return this.field_201693_j;
    }

    public int func_201676_a(Heightmap.Type p_201676_1_, int p_201676_2_, int p_201676_3_) {
        return this.func_212866_a_(p_201676_2_ >> 4, p_201676_3_ >> 4).func_201576_a(p_201676_1_, p_201676_2_ & 0xF, p_201676_3_ & 0xF) + 1;
    }

    public void func_184133_a(@Nullable PlayerEntity p_184133_1_, BlockPos p_184133_2_, SoundEvent p_184133_3_, SoundCategory p_184133_4_, float p_184133_5_, float p_184133_6_) {
    }

    public void func_195594_a(IParticleData p_195594_1_, double p_195594_2_, double p_195594_4_, double p_195594_6_, double p_195594_8_, double p_195594_10_, double p_195594_12_) {
    }

    public void func_217378_a(@Nullable PlayerEntity p_217378_1_, int p_217378_2_, BlockPos p_217378_3_, int p_217378_4_) {
    }

    public DimensionType func_230315_m_() {
        return this.field_241159_j_;
    }

    public boolean func_217375_a(BlockPos p_217375_1_, Predicate<BlockState> p_217375_2_) {
        return p_217375_2_.test(this.func_180495_p(p_217375_1_));
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> p_175647_1_, AxisAlignedBB p_175647_2_, @Nullable Predicate<? super T> p_175647_3_) {
        return Collections.emptyList();
    }

    public List<Entity> func_175674_a(@Nullable Entity p_175674_1_, AxisAlignedBB p_175674_2_, @Nullable Predicate<? super Entity> p_175674_3_) {
        return Collections.emptyList();
    }

    public List<PlayerEntity> func_217369_A() {
        return Collections.emptyList();
    }

    public Stream<? extends StructureStart<?>> func_241827_a(SectionPos p_241827_1_, Structure<?> p_241827_2_) {
        return this.field_244530_p.func_235011_a_(p_241827_1_, p_241827_2_);
    }
}

