/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;

public abstract class StructurePiece {
    protected static final BlockState field_202556_l = Blocks.field_201941_jj.func_176223_P();
    protected MutableBoundingBox field_74887_e;
    @Nullable
    private Direction field_74885_f;
    private Mirror field_186168_b;
    private Rotation field_186169_c;
    protected int field_74886_g;
    private final IStructurePieceType field_214811_d;
    private static final Set<Block> field_211413_d = ImmutableSet.builder().add((Object)Blocks.field_150386_bk).add((Object)Blocks.field_150478_aa).add((Object)Blocks.field_196591_bQ).add((Object)Blocks.field_180407_aO).add((Object)Blocks.field_180408_aP).add((Object)Blocks.field_180406_aS).add((Object)Blocks.field_180405_aT).add((Object)Blocks.field_180404_aQ).add((Object)Blocks.field_180403_aR).add((Object)Blocks.field_150468_ap).add((Object)Blocks.field_150411_aY).build();

    protected StructurePiece(IStructurePieceType p_i51342_1_, int p_i51342_2_) {
        this.field_214811_d = p_i51342_1_;
        this.field_74886_g = p_i51342_2_;
    }

    public StructurePiece(IStructurePieceType p_i51343_1_, CompoundNBT p_i51343_2_) {
        this(p_i51343_1_, p_i51343_2_.func_74762_e("GD"));
        int i;
        if (p_i51343_2_.func_74764_b("BB")) {
            this.field_74887_e = new MutableBoundingBox(p_i51343_2_.func_74759_k("BB"));
        }
        this.func_186164_a((i = p_i51343_2_.func_74762_e("O")) == -1 ? null : Direction.func_176731_b(i));
    }

    public final CompoundNBT func_143010_b() {
        if (Registry.field_218362_C.func_177774_c(this.func_214807_k()) == null) {
            throw new RuntimeException("StructurePiece \"" + this.getClass().getName() + "\": \"" + this.func_214807_k() + "\" missing ID Mapping, Modder see MapGenStructureIO");
        }
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("id", Registry.field_218362_C.func_177774_c(this.func_214807_k()).toString());
        compoundnbt.func_218657_a("BB", (INBT)this.field_74887_e.func_151535_h());
        Direction direction = this.func_186165_e();
        compoundnbt.func_74768_a("O", direction == null ? -1 : direction.func_176736_b());
        compoundnbt.func_74768_a("GD", this.field_74886_g);
        this.func_143011_b(compoundnbt);
        return compoundnbt;
    }

    protected abstract void func_143011_b(CompoundNBT var1);

    public void func_74861_a(StructurePiece p_74861_1_, List<StructurePiece> p_74861_2_, Random p_74861_3_) {
    }

    public abstract boolean func_230383_a_(ISeedReader var1, StructureManager var2, ChunkGenerator var3, Random var4, MutableBoundingBox var5, ChunkPos var6, BlockPos var7);

    public MutableBoundingBox func_74874_b() {
        return this.field_74887_e;
    }

    public int func_74877_c() {
        return this.field_74886_g;
    }

    public boolean func_214810_a(ChunkPos p_214810_1_, int p_214810_2_) {
        int i = p_214810_1_.field_77276_a << 4;
        int j = p_214810_1_.field_77275_b << 4;
        return this.field_74887_e.func_78885_a(i - p_214810_2_, j - p_214810_2_, i + 15 + p_214810_2_, j + 15 + p_214810_2_);
    }

    public static StructurePiece func_74883_a(List<StructurePiece> p_74883_0_, MutableBoundingBox p_74883_1_) {
        for (StructurePiece structurepiece : p_74883_0_) {
            if (structurepiece.func_74874_b() == null || !structurepiece.func_74874_b().func_78884_a(p_74883_1_)) continue;
            return structurepiece;
        }
        return null;
    }

    protected boolean func_74860_a(IBlockReader p_74860_1_, MutableBoundingBox p_74860_2_) {
        int i = Math.max(this.field_74887_e.field_78897_a - 1, p_74860_2_.field_78897_a);
        int j = Math.max(this.field_74887_e.field_78895_b - 1, p_74860_2_.field_78895_b);
        int k = Math.max(this.field_74887_e.field_78896_c - 1, p_74860_2_.field_78896_c);
        int l = Math.min(this.field_74887_e.field_78893_d + 1, p_74860_2_.field_78893_d);
        int i1 = Math.min(this.field_74887_e.field_78894_e + 1, p_74860_2_.field_78894_e);
        int j1 = Math.min(this.field_74887_e.field_78892_f + 1, p_74860_2_.field_78892_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = k; l1 <= j1; ++l1) {
                if (p_74860_1_.func_180495_p(blockpos$mutable.func_181079_c(k1, j, l1)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!p_74860_1_.func_180495_p(blockpos$mutable.func_181079_c(k1, i1, l1)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        for (int i2 = i; i2 <= l; ++i2) {
            for (int k2 = j; k2 <= i1; ++k2) {
                if (p_74860_1_.func_180495_p(blockpos$mutable.func_181079_c(i2, k2, k)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!p_74860_1_.func_180495_p(blockpos$mutable.func_181079_c(i2, k2, j1)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        for (int j2 = k; j2 <= j1; ++j2) {
            for (int l2 = j; l2 <= i1; ++l2) {
                if (p_74860_1_.func_180495_p(blockpos$mutable.func_181079_c(i, l2, j2)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!p_74860_1_.func_180495_p(blockpos$mutable.func_181079_c(l, l2, j2)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        return false;
    }

    protected int func_74865_a(int p_74865_1_, int p_74865_2_) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return p_74865_1_;
        }
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                return this.field_74887_e.field_78897_a + p_74865_1_;
            }
            case WEST: {
                return this.field_74887_e.field_78893_d - p_74865_2_;
            }
            case EAST: {
                return this.field_74887_e.field_78897_a + p_74865_2_;
            }
        }
        return p_74865_1_;
    }

    protected int func_74862_a(int p_74862_1_) {
        return this.func_186165_e() == null ? p_74862_1_ : p_74862_1_ + this.field_74887_e.field_78895_b;
    }

    protected int func_74873_b(int p_74873_1_, int p_74873_2_) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return p_74873_2_;
        }
        switch (direction) {
            case NORTH: {
                return this.field_74887_e.field_78892_f - p_74873_2_;
            }
            case SOUTH: {
                return this.field_74887_e.field_78896_c + p_74873_2_;
            }
            case WEST: 
            case EAST: {
                return this.field_74887_e.field_78896_c + p_74873_1_;
            }
        }
        return p_74873_2_;
    }

    protected void func_175811_a(ISeedReader p_175811_1_, BlockState p_175811_2_, int p_175811_3_, int p_175811_4_, int p_175811_5_, MutableBoundingBox p_175811_6_) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(p_175811_3_, p_175811_5_), this.func_74862_a(p_175811_4_), this.func_74873_b(p_175811_3_, p_175811_5_));
        if (p_175811_6_.func_175898_b((Vector3i)blockpos)) {
            if (this.field_186168_b != Mirror.NONE) {
                p_175811_2_ = p_175811_2_.func_185902_a(this.field_186168_b);
            }
            if (this.field_186169_c != Rotation.NONE) {
                p_175811_2_ = p_175811_2_.func_185907_a(this.field_186169_c);
            }
            p_175811_1_.func_180501_a(blockpos, p_175811_2_, 2);
            FluidState fluidstate = p_175811_1_.func_204610_c(blockpos);
            if (!fluidstate.func_206888_e()) {
                p_175811_1_.func_205219_F_().func_205360_a(blockpos, (Object)fluidstate.func_206886_c(), 0);
            }
            if (field_211413_d.contains((Object)p_175811_2_.func_177230_c())) {
                p_175811_1_.func_217349_x(blockpos).func_201594_d(blockpos);
            }
        }
    }

    protected BlockState func_175807_a(IBlockReader p_175807_1_, int p_175807_2_, int p_175807_3_, int p_175807_4_, MutableBoundingBox p_175807_5_) {
        int k;
        int j;
        int i = this.func_74865_a(p_175807_2_, p_175807_4_);
        BlockPos blockpos = new BlockPos(i, j = this.func_74862_a(p_175807_3_), k = this.func_74873_b(p_175807_2_, p_175807_4_));
        return !p_175807_5_.func_175898_b((Vector3i)blockpos) ? Blocks.field_150350_a.func_176223_P() : p_175807_1_.func_180495_p(blockpos);
    }

    protected boolean func_189916_b(IWorldReader p_189916_1_, int p_189916_2_, int p_189916_3_, int p_189916_4_, MutableBoundingBox p_189916_5_) {
        int k;
        int j;
        int i = this.func_74865_a(p_189916_2_, p_189916_4_);
        BlockPos blockpos = new BlockPos(i, j = this.func_74862_a(p_189916_3_ + 1), k = this.func_74873_b(p_189916_2_, p_189916_4_));
        if (!p_189916_5_.func_175898_b((Vector3i)blockpos)) {
            return false;
        }
        return j < p_189916_1_.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, i, k);
    }

    protected void func_74878_a(ISeedReader p_74878_1_, MutableBoundingBox p_74878_2_, int p_74878_3_, int p_74878_4_, int p_74878_5_, int p_74878_6_, int p_74878_7_, int p_74878_8_) {
        for (int i = p_74878_4_; i <= p_74878_7_; ++i) {
            for (int j = p_74878_3_; j <= p_74878_6_; ++j) {
                for (int k = p_74878_5_; k <= p_74878_8_; ++k) {
                    this.func_175811_a(p_74878_1_, Blocks.field_150350_a.func_176223_P(), j, i, k, p_74878_2_);
                }
            }
        }
    }

    protected void func_175804_a(ISeedReader p_175804_1_, MutableBoundingBox p_175804_2_, int p_175804_3_, int p_175804_4_, int p_175804_5_, int p_175804_6_, int p_175804_7_, int p_175804_8_, BlockState p_175804_9_, BlockState p_175804_10_, boolean p_175804_11_) {
        for (int i = p_175804_4_; i <= p_175804_7_; ++i) {
            for (int j = p_175804_3_; j <= p_175804_6_; ++j) {
                for (int k = p_175804_5_; k <= p_175804_8_; ++k) {
                    if (p_175804_11_ && this.func_175807_a((IBlockReader)p_175804_1_, j, i, k, p_175804_2_).func_196958_f()) continue;
                    if (i != p_175804_4_ && i != p_175804_7_ && j != p_175804_3_ && j != p_175804_6_ && k != p_175804_5_ && k != p_175804_8_) {
                        this.func_175811_a(p_175804_1_, p_175804_10_, j, i, k, p_175804_2_);
                        continue;
                    }
                    this.func_175811_a(p_175804_1_, p_175804_9_, j, i, k, p_175804_2_);
                }
            }
        }
    }

    protected void func_74882_a(ISeedReader p_74882_1_, MutableBoundingBox p_74882_2_, int p_74882_3_, int p_74882_4_, int p_74882_5_, int p_74882_6_, int p_74882_7_, int p_74882_8_, boolean p_74882_9_, Random p_74882_10_, BlockSelector p_74882_11_) {
        for (int i = p_74882_4_; i <= p_74882_7_; ++i) {
            for (int j = p_74882_3_; j <= p_74882_6_; ++j) {
                for (int k = p_74882_5_; k <= p_74882_8_; ++k) {
                    if (p_74882_9_ && this.func_175807_a((IBlockReader)p_74882_1_, j, i, k, p_74882_2_).func_196958_f()) continue;
                    p_74882_11_.func_75062_a(p_74882_10_, j, i, k, i == p_74882_4_ || i == p_74882_7_ || j == p_74882_3_ || j == p_74882_6_ || k == p_74882_5_ || k == p_74882_8_);
                    this.func_175811_a(p_74882_1_, p_74882_11_.func_180780_a(), j, i, k, p_74882_2_);
                }
            }
        }
    }

    protected void func_189914_a(ISeedReader p_189914_1_, MutableBoundingBox p_189914_2_, Random p_189914_3_, float p_189914_4_, int p_189914_5_, int p_189914_6_, int p_189914_7_, int p_189914_8_, int p_189914_9_, int p_189914_10_, BlockState p_189914_11_, BlockState p_189914_12_, boolean p_189914_13_, boolean p_189914_14_) {
        for (int i = p_189914_6_; i <= p_189914_9_; ++i) {
            for (int j = p_189914_5_; j <= p_189914_8_; ++j) {
                for (int k = p_189914_7_; k <= p_189914_10_; ++k) {
                    if (p_189914_3_.nextFloat() > p_189914_4_ || p_189914_13_ && this.func_175807_a((IBlockReader)p_189914_1_, j, i, k, p_189914_2_).func_196958_f() || p_189914_14_ && !this.func_189916_b((IWorldReader)p_189914_1_, j, i, k, p_189914_2_)) continue;
                    if (i != p_189914_6_ && i != p_189914_9_ && j != p_189914_5_ && j != p_189914_8_ && k != p_189914_7_ && k != p_189914_10_) {
                        this.func_175811_a(p_189914_1_, p_189914_12_, j, i, k, p_189914_2_);
                        continue;
                    }
                    this.func_175811_a(p_189914_1_, p_189914_11_, j, i, k, p_189914_2_);
                }
            }
        }
    }

    protected void func_175809_a(ISeedReader p_175809_1_, MutableBoundingBox p_175809_2_, Random p_175809_3_, float p_175809_4_, int p_175809_5_, int p_175809_6_, int p_175809_7_, BlockState p_175809_8_) {
        if (p_175809_3_.nextFloat() < p_175809_4_) {
            this.func_175811_a(p_175809_1_, p_175809_8_, p_175809_5_, p_175809_6_, p_175809_7_, p_175809_2_);
        }
    }

    protected void func_180777_a(ISeedReader p_180777_1_, MutableBoundingBox p_180777_2_, int p_180777_3_, int p_180777_4_, int p_180777_5_, int p_180777_6_, int p_180777_7_, int p_180777_8_, BlockState p_180777_9_, boolean p_180777_10_) {
        float f = p_180777_6_ - p_180777_3_ + 1;
        float f1 = p_180777_7_ - p_180777_4_ + 1;
        float f2 = p_180777_8_ - p_180777_5_ + 1;
        float f3 = (float)p_180777_3_ + f / 2.0f;
        float f4 = (float)p_180777_5_ + f2 / 2.0f;
        for (int i = p_180777_4_; i <= p_180777_7_; ++i) {
            float f5 = (float)(i - p_180777_4_) / f1;
            for (int j = p_180777_3_; j <= p_180777_6_; ++j) {
                float f6 = ((float)j - f3) / (f * 0.5f);
                for (int k = p_180777_5_; k <= p_180777_8_; ++k) {
                    float f8;
                    float f7 = ((float)k - f4) / (f2 * 0.5f);
                    if (p_180777_10_ && this.func_175807_a((IBlockReader)p_180777_1_, j, i, k, p_180777_2_).func_196958_f() || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.func_175811_a(p_180777_1_, p_180777_9_, j, i, k, p_180777_2_);
                }
            }
        }
    }

    protected void func_175808_b(ISeedReader p_175808_1_, BlockState p_175808_2_, int p_175808_3_, int p_175808_4_, int p_175808_5_, MutableBoundingBox p_175808_6_) {
        int k;
        int j;
        int i = this.func_74865_a(p_175808_3_, p_175808_5_);
        if (p_175808_6_.func_175898_b((Vector3i)new BlockPos(i, j = this.func_74862_a(p_175808_4_), k = this.func_74873_b(p_175808_3_, p_175808_5_)))) {
            while ((p_175808_1_.func_175623_d(new BlockPos(i, j, k)) || p_175808_1_.func_180495_p(new BlockPos(i, j, k)).func_185904_a().func_76224_d()) && j > 1) {
                p_175808_1_.func_180501_a(new BlockPos(i, j, k), p_175808_2_, 2);
                --j;
            }
        }
    }

    protected boolean func_186167_a(ISeedReader p_186167_1_, MutableBoundingBox p_186167_2_, Random p_186167_3_, int p_186167_4_, int p_186167_5_, int p_186167_6_, ResourceLocation p_186167_7_) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(p_186167_4_, p_186167_6_), this.func_74862_a(p_186167_5_), this.func_74873_b(p_186167_4_, p_186167_6_));
        return this.func_191080_a((IServerWorld)p_186167_1_, p_186167_2_, p_186167_3_, blockpos, p_186167_7_, null);
    }

    public static BlockState func_197528_a(IBlockReader p_197528_0_, BlockPos p_197528_1_, BlockState p_197528_2_) {
        Direction direction = null;
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_197528_1_.func_177972_a(direction1);
            BlockState blockstate = p_197528_0_.func_180495_p(blockpos);
            if (blockstate.func_203425_a(Blocks.field_150486_ae)) {
                return p_197528_2_;
            }
            if (!blockstate.func_200015_d(p_197528_0_, blockpos)) continue;
            if (direction != null) {
                direction = null;
                break;
            }
            direction = direction1;
        }
        if (direction != null) {
            return (BlockState)p_197528_2_.func_206870_a(HorizontalBlock.field_185512_D, direction.func_176734_d());
        }
        Direction direction2 = (Direction)((Object)p_197528_2_.func_177229_b(HorizontalBlock.field_185512_D));
        BlockPos blockpos1 = p_197528_1_.func_177972_a(direction2);
        if (p_197528_0_.func_180495_p(blockpos1).func_200015_d(p_197528_0_, blockpos1)) {
            direction2 = direction2.func_176734_d();
            blockpos1 = p_197528_1_.func_177972_a(direction2);
        }
        if (p_197528_0_.func_180495_p(blockpos1).func_200015_d(p_197528_0_, blockpos1)) {
            direction2 = direction2.func_176746_e();
            blockpos1 = p_197528_1_.func_177972_a(direction2);
        }
        if (p_197528_0_.func_180495_p(blockpos1).func_200015_d(p_197528_0_, blockpos1)) {
            direction2 = direction2.func_176734_d();
            p_197528_1_.func_177972_a(direction2);
        }
        return (BlockState)p_197528_2_.func_206870_a(HorizontalBlock.field_185512_D, direction2);
    }

    protected boolean func_191080_a(IServerWorld p_191080_1_, MutableBoundingBox p_191080_2_, Random p_191080_3_, BlockPos p_191080_4_, ResourceLocation p_191080_5_, @Nullable BlockState p_191080_6_) {
        if (p_191080_2_.func_175898_b((Vector3i)p_191080_4_) && !p_191080_1_.func_180495_p(p_191080_4_).func_203425_a(Blocks.field_150486_ae)) {
            if (p_191080_6_ == null) {
                p_191080_6_ = StructurePiece.func_197528_a((IBlockReader)((Object)p_191080_1_), p_191080_4_, Blocks.field_150486_ae.func_176223_P());
            }
            p_191080_1_.func_180501_a(p_191080_4_, p_191080_6_, 2);
            TileEntity tileentity = p_191080_1_.func_175625_s(p_191080_4_);
            if (tileentity instanceof ChestTileEntity) {
                ((ChestTileEntity)tileentity).func_189404_a(p_191080_5_, p_191080_3_.nextLong());
            }
            return true;
        }
        return false;
    }

    protected boolean func_189419_a(ISeedReader p_189419_1_, MutableBoundingBox p_189419_2_, Random p_189419_3_, int p_189419_4_, int p_189419_5_, int p_189419_6_, Direction p_189419_7_, ResourceLocation p_189419_8_) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(p_189419_4_, p_189419_6_), this.func_74862_a(p_189419_5_), this.func_74873_b(p_189419_4_, p_189419_6_));
        if (p_189419_2_.func_175898_b((Vector3i)blockpos) && !p_189419_1_.func_180495_p(blockpos).func_203425_a(Blocks.field_150367_z)) {
            this.func_175811_a(p_189419_1_, (BlockState)Blocks.field_150367_z.func_176223_P().func_206870_a(DispenserBlock.field_176441_a, p_189419_7_), p_189419_4_, p_189419_5_, p_189419_6_, p_189419_2_);
            TileEntity tileentity = p_189419_1_.func_175625_s(blockpos);
            if (tileentity instanceof DispenserTileEntity) {
                ((DispenserTileEntity)tileentity).func_189404_a(p_189419_8_, p_189419_3_.nextLong());
            }
            return true;
        }
        return false;
    }

    public void func_181138_a(int p_181138_1_, int p_181138_2_, int p_181138_3_) {
        this.field_74887_e.func_78886_a(p_181138_1_, p_181138_2_, p_181138_3_);
    }

    @Nullable
    public Direction func_186165_e() {
        return this.field_74885_f;
    }

    public void func_186164_a(@Nullable Direction p_186164_1_) {
        this.field_74885_f = p_186164_1_;
        if (p_186164_1_ == null) {
            this.field_186169_c = Rotation.NONE;
            this.field_186168_b = Mirror.NONE;
        } else {
            switch (p_186164_1_) {
                case SOUTH: {
                    this.field_186168_b = Mirror.LEFT_RIGHT;
                    this.field_186169_c = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.field_186168_b = Mirror.LEFT_RIGHT;
                    this.field_186169_c = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.field_186168_b = Mirror.NONE;
                    this.field_186169_c = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.field_186168_b = Mirror.NONE;
                    this.field_186169_c = Rotation.NONE;
                }
            }
        }
    }

    public Rotation func_214809_Y_() {
        return this.field_186169_c;
    }

    public IStructurePieceType func_214807_k() {
        return this.field_214811_d;
    }

    public static abstract class BlockSelector {
        protected BlockState field_151562_a = Blocks.field_150350_a.func_176223_P();

        protected BlockSelector() {
        }

        public abstract void func_75062_a(Random var1, int var2, int var3, int var4, boolean var5);

        public BlockState func_180780_a() {
            return this.field_151562_a;
        }
    }
}

