/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.raid;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class RaidManager
extends WorldSavedData {
    public final Map<Integer, Raid> field_215175_a = Maps.newHashMap();
    private final ServerWorld field_215176_b;
    private int field_215177_c;
    private int field_215178_d;

    public RaidManager(ServerWorld p_i50142_1_) {
        super(RaidManager.func_234620_a_(p_i50142_1_.func_230315_m_()));
        this.field_215176_b = p_i50142_1_;
        this.field_215177_c = 1;
        this.func_76185_a();
    }

    public Raid func_215167_a(int p_215167_1_) {
        return this.field_215175_a.get(p_215167_1_);
    }

    public void func_215171_a() {
        ++this.field_215178_d;
        Iterator<Raid> iterator = this.field_215175_a.values().iterator();
        while (iterator.hasNext()) {
            Raid raid = iterator.next();
            if (this.field_215176_b.func_82736_K().func_223586_b(GameRules.field_223621_x)) {
                raid.func_221295_o();
            }
            if (raid.func_221310_d()) {
                iterator.remove();
                this.func_76185_a();
                continue;
            }
            raid.func_221307_p();
        }
        if (this.field_215178_d % 200 == 0) {
            this.func_76185_a();
        }
        DebugPacketSender.func_222946_a((ServerWorld)this.field_215176_b, this.field_215175_a.values());
    }

    public static boolean func_215165_a(AbstractRaiderEntity p_215165_0_, Raid p_215165_1_) {
        if (p_215165_0_ != null && p_215165_1_ != null && p_215165_1_.func_221316_i() != null) {
            return p_215165_0_.func_70089_S() && p_215165_0_.func_213658_ej() && p_215165_0_.func_70654_ax() <= 2400 && p_215165_0_.field_70170_p.func_230315_m_() == p_215165_1_.func_221316_i().func_230315_m_();
        }
        return false;
    }

    @Nullable
    public Raid func_215170_a(ServerPlayerEntity p_215170_1_) {
        BlockPos blockpos1;
        if (p_215170_1_.func_175149_v()) {
            return null;
        }
        if (this.field_215176_b.func_82736_K().func_223586_b(GameRules.field_223621_x)) {
            return null;
        }
        DimensionType dimensiontype = p_215170_1_.field_70170_p.func_230315_m_();
        if (!dimensiontype.func_241512_l_()) {
            return null;
        }
        BlockPos blockpos = p_215170_1_.func_233580_cy_();
        List list = this.field_215176_b.func_217443_B().func_219146_b(PointOfInterestType.field_221053_a, blockpos, 64, PointOfInterestManager.Status.IS_OCCUPIED).collect(Collectors.toList());
        int i = 0;
        Vector3d vector3d = Vector3d.field_186680_a;
        for (PointOfInterest pointofinterest : list) {
            BlockPos blockpos2 = pointofinterest.func_218261_f();
            vector3d = vector3d.func_72441_c(blockpos2.func_177958_n(), blockpos2.func_177956_o(), blockpos2.func_177952_p());
            ++i;
        }
        if (i > 0) {
            vector3d = vector3d.func_186678_a(1.0 / (double)i);
            blockpos1 = new BlockPos(vector3d);
        } else {
            blockpos1 = blockpos;
        }
        Raid raid = this.func_215168_a(p_215170_1_.func_71121_q(), blockpos1);
        boolean flag = false;
        if (!raid.func_221301_k()) {
            flag = true;
        } else if (raid.isInProgress() && raid.func_221291_n() < raid.func_221327_m()) {
            flag = true;
        } else {
            p_215170_1_.func_195063_d(Effects.field_220309_E);
            p_215170_1_.field_71135_a.func_147359_a((IPacket<?>)new SEntityStatusPacket((Entity)p_215170_1_, 43));
        }
        if (flag) {
            if (!CraftEventFactory.callRaidTriggerEvent((Raid)raid, (ServerPlayerEntity)p_215170_1_)) {
                p_215170_1_.func_195063_d(Effects.field_220309_E);
                return null;
            }
            if (!this.field_215175_a.containsKey(raid.func_221325_u())) {
                this.field_215175_a.put(raid.func_221325_u(), raid);
            }
            raid.func_221309_a(p_215170_1_);
            p_215170_1_.field_71135_a.func_147359_a((IPacket<?>)new SEntityStatusPacket((Entity)p_215170_1_, 43));
            if (!raid.func_221297_c()) {
                p_215170_1_.func_195066_a(Stats.field_219741_ay);
                CriteriaTriggers.field_215102_I.func_192215_a(p_215170_1_);
            }
        }
        this.func_76185_a();
        return raid;
    }

    private Raid func_215168_a(ServerWorld p_215168_1_, BlockPos p_215168_2_) {
        Raid raid = p_215168_1_.func_217475_c_(p_215168_2_);
        return raid != null ? raid : new Raid(this.func_215173_e(), p_215168_1_, p_215168_2_);
    }

    @Override
    public void func_76184_a(CompoundNBT p_76184_1_) {
        this.field_215177_c = p_76184_1_.func_74762_e("NextAvailableID");
        this.field_215178_d = p_76184_1_.func_74762_e("Tick");
        ListNBT listnbt = p_76184_1_.func_150295_c("Raids", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            Raid raid = new Raid(this.field_215176_b, compoundnbt);
            this.field_215175_a.put(raid.func_221325_u(), raid);
        }
    }

    @Override
    public CompoundNBT func_189551_b(CompoundNBT p_189551_1_) {
        p_189551_1_.func_74768_a("NextAvailableID", this.field_215177_c);
        p_189551_1_.func_74768_a("Tick", this.field_215178_d);
        ListNBT listnbt = new ListNBT();
        for (Raid raid : this.field_215175_a.values()) {
            CompoundNBT compoundnbt = new CompoundNBT();
            raid.func_221326_a(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        p_189551_1_.func_218657_a("Raids", (INBT)listnbt);
        return p_189551_1_;
    }

    public static String func_234620_a_(DimensionType p_234620_0_) {
        return "raids" + p_234620_0_.func_186067_c();
    }

    private int func_215173_e() {
        return ++this.field_215177_c;
    }

    @Nullable
    public Raid func_215174_a(BlockPos p_215174_1_, int p_215174_2_) {
        Raid raid = null;
        double d0 = p_215174_2_;
        for (Raid raid1 : this.field_215175_a.values()) {
            double d1 = raid1.func_221304_t().func_177951_i(p_215174_1_);
            if (!raid1.func_221333_v() || !(d1 < d0)) continue;
            raid = raid1;
            d0 = d1;
        }
        return raid;
    }
}

