/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingHistory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mohistmc.api.mc.ChunkMcAPI;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.configuration.TickConfig;
import com.mohistmc.inventory.CraftCustomInventory;
import com.mohistmc.util.i18n.i18n;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateBlockBreakPacket;
import net.minecraft.network.play.server.SBlockActionPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SSpawnMovingSoundEffectPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapIdTracker;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeWorldServer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.WorldCapabilityData;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_16_R3.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_16_R3.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.map.MapView;
import org.spigotmc.ActivationRange;

public class ServerWorld
extends World
implements ISeedReader,
IForgeWorldServer {
    public static final BlockPos field_241108_a_ = new BlockPos(100, 50, 0);
    private static final Logger field_147491_a = LogManager.getLogger();
    public final Int2ObjectMap<net.minecraft.entity.Entity> field_217498_x = new Int2ObjectLinkedOpenHashMap();
    private final Map<UUID, net.minecraft.entity.Entity> field_175741_N = Maps.newHashMap();
    public final Queue<net.minecraft.entity.Entity> field_217499_z = Queues.newArrayDeque();
    private final List<ServerPlayerEntity> field_217491_A = Lists.newArrayList();
    private final ServerChunkProvider field_241102_C_;
    boolean field_217492_a;
    private final MinecraftServer field_73061_a;
    public final IServerWorldInfo field_241103_E_;
    public boolean field_73058_d;
    private boolean field_73068_P;
    private int field_80004_Q;
    private final Teleporter field_85177_Q;
    private final ServerTickList<Block> field_94579_S = new ServerTickList<Block>(this, p_205341_0_ -> p_205341_0_ == null || p_205341_0_.func_176223_P().func_196958_f(), arg_0 -> Registry.field_212618_g.func_177774_c(arg_0), this::func_205338_b, "Blocks");
    private final ServerTickList<Fluid> field_205342_P = new ServerTickList<Fluid>(this, p_205774_0_ -> p_205774_0_ == null || p_205774_0_ == Fluids.field_204541_a, arg_0 -> Registry.field_212619_h.func_177774_c(arg_0), this::func_205339_a, "Fluids");
    private final Set<PathNavigator> field_217495_I = Sets.newHashSet();
    protected final RaidManager field_217494_c;
    private final ObjectLinkedOpenHashSet<BlockEventData> field_147490_S = new ObjectLinkedOpenHashSet();
    private boolean field_211159_Q;
    private final List<ISpecialSpawner> field_241104_N_;
    @Nullable
    private final DragonFightManager field_241105_O_;
    private final StructureManager field_241106_P_;
    private final boolean field_241107_Q_;
    private WorldCapabilityData capabilityData;
    private int tickPosition;
    public ServerWorldInfo worldDataServer;
    public final SaveFormat.LevelSave convertable;
    public final UUID uuid;
    public boolean dummyFreshEntitySpawn = false;
    private static final List<String> IGNORE_EMPTY_TIME_LIST = new ArrayList<String>();
    private final boolean ignoreEmptyTimeThis = IGNORE_EMPTY_TIME_LIST.contains("all_worlds") || IGNORE_EMPTY_TIME_LIST.contains(this.getServerWorldInfo().func_76065_j());
    private final Random randomTickRandom = new Random();
    public CreatureSpawnEvent.SpawnReason pehkuiSpawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;

    public Chunk getChunkIfLoaded(int x, int z) {
        return this.field_241102_C_.func_217205_a(x, z, false);
    }

    public ServerWorld(MinecraftServer p_i241885_1_, Executor p_i241885_2_, SaveFormat.LevelSave p_i241885_3_, IServerWorldInfo p_i241885_4_, RegistryKey<World> p_i241885_5_, DimensionType p_i241885_6_, IChunkStatusListener p_i241885_7_, net.minecraft.world.gen.ChunkGenerator p_i241885_8_, boolean p_i241885_9_, long p_i241885_10_, List<ISpecialSpawner> p_i241885_12_, boolean p_i241885_13_) {
        super((ISpawnWorldInfo)p_i241885_4_, p_i241885_5_, p_i241885_6_, p_i241885_1_::func_213185_aS, false, p_i241885_9_, p_i241885_10_);
        this.pvpMode = p_i241885_1_.func_71219_W();
        this.convertable = p_i241885_3_;
        this.uuid = WorldUUID.getUUID((File)p_i241885_1_.field_71310_m.func_237291_a_(p_i241885_5_));
        if (p_i241885_4_ instanceof ServerWorldInfo) {
            this.worldDataServer = (ServerWorldInfo)p_i241885_4_;
        }
        if (generator != null) {
            p_i241885_8_ = new CustomChunkGenerator(this, p_i241885_8_, generator);
        }
        this.field_241107_Q_ = p_i241885_13_;
        this.field_73061_a = p_i241885_1_;
        this.field_241104_N_ = p_i241885_12_;
        this.field_241103_E_ = p_i241885_4_;
        this.field_241102_C_ = new ServerChunkProvider(this, p_i241885_3_, p_i241885_1_.func_195563_aC(), p_i241885_1_.func_240792_aT_(), p_i241885_2_, p_i241885_8_, p_i241885_1_.func_184103_al().func_72395_o(), p_i241885_1_.func_230540_aS_(), p_i241885_7_, () -> p_i241885_1_.func_241755_D_().func_217481_x());
        this.field_85177_Q = new Teleporter(this);
        this.func_72966_v();
        this.func_72947_a();
        this.func_175723_af().func_177725_a(p_i241885_1_.func_175580_aG());
        this.field_217494_c = this.func_217481_x().func_215752_a(() -> new RaidManager(this), RaidManager.func_234620_a_(this.func_230315_m_()));
        if (!p_i241885_1_.func_71264_H()) {
            p_i241885_4_.func_230392_a_(p_i241885_1_.func_71265_f());
        }
        this.field_241106_P_ = new StructureManager(this, p_i241885_1_.func_240793_aU_().func_230418_z_());
        this.field_241105_O_ = this.func_230315_m_().func_236046_h_() ? new DragonFightManager(this, p_i241885_1_.func_240793_aU_().func_230418_z_().func_236221_b_(), p_i241885_1_.func_240793_aU_().func_230402_B_()) : null;
        this.initCapabilities();
        this.craftWorld = new CraftWorld(this, generator, environment);
        this.func_175723_af().world = this;
        this.getCBServer().addWorld((org.bukkit.World)this.getWorld());
    }

    public ServerWorld(MinecraftServer p_i241885_1_, Executor p_i241885_2_, SaveFormat.LevelSave p_i241885_3_, IServerWorldInfo p_i241885_4_, RegistryKey<World> p_i241885_5_, DimensionType p_i241885_6_, IChunkStatusListener p_i241885_7_, net.minecraft.world.gen.ChunkGenerator p_i241885_8_, boolean p_i241885_9_, long p_i241885_10_, List<ISpecialSpawner> p_i241885_12_, boolean p_i241885_13_, World.Environment env, ChunkGenerator gen) {
        super((ISpawnWorldInfo)p_i241885_4_, p_i241885_5_, p_i241885_6_, p_i241885_1_::func_213185_aS, false, p_i241885_9_, p_i241885_10_);
        ServerWorld.setGeneratorAndEnv(gen, env);
        this.pvpMode = p_i241885_1_.func_71219_W();
        this.convertable = p_i241885_3_;
        this.uuid = WorldUUID.getUUID((File)p_i241885_1_.field_71310_m.func_237291_a_(p_i241885_5_));
        if (p_i241885_4_ instanceof ServerWorldInfo) {
            this.worldDataServer = (ServerWorldInfo)p_i241885_4_;
        }
        if (generator != null) {
            p_i241885_8_ = new CustomChunkGenerator(this, p_i241885_8_, generator);
        }
        this.field_241107_Q_ = p_i241885_13_;
        this.field_73061_a = p_i241885_1_;
        this.field_241104_N_ = p_i241885_12_;
        this.field_241103_E_ = p_i241885_4_;
        this.field_241102_C_ = new ServerChunkProvider(this, p_i241885_3_, p_i241885_1_.func_195563_aC(), p_i241885_1_.func_240792_aT_(), p_i241885_2_, p_i241885_8_, p_i241885_1_.func_184103_al().func_72395_o(), p_i241885_1_.func_230540_aS_(), p_i241885_7_, () -> p_i241885_1_.func_241755_D_().func_217481_x());
        this.field_85177_Q = new Teleporter(this);
        this.func_72966_v();
        this.func_72947_a();
        this.func_175723_af().func_177725_a(p_i241885_1_.func_175580_aG());
        this.field_217494_c = this.func_217481_x().func_215752_a(() -> new RaidManager(this), RaidManager.func_234620_a_(this.func_230315_m_()));
        if (!p_i241885_1_.func_71264_H()) {
            p_i241885_4_.func_230392_a_(p_i241885_1_.func_71265_f());
        }
        this.field_241106_P_ = new StructureManager(this, p_i241885_1_.func_240793_aU_().func_230418_z_());
        this.field_241105_O_ = this.func_230315_m_().func_236046_h_() ? new DragonFightManager(this, p_i241885_1_.func_240793_aU_().func_230418_z_().func_236221_b_(), p_i241885_1_.func_240793_aU_().func_230402_B_()) : null;
        this.initCapabilities();
        this.craftWorld = new CraftWorld(this, generator, environment);
        this.func_175723_af().world = this;
        this.getCBServer().addWorld((org.bukkit.World)this.getWorld());
    }

    public boolean isPosLoaded(BlockPos pos) {
        return ChunkMcAPI.isBorderChunkLoaded((ServerWorld)this, (int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
    }

    @Override
    public TileEntity getTileEntity(BlockPos pos, boolean validate) {
        TileEntity result = super.getTileEntity(pos, validate);
        if (!validate || Thread.currentThread() != this.field_217407_c) {
            return result;
        }
        Block type = this.func_180495_p(pos).func_177230_c();
        if (result != null && type != Blocks.field_150350_a && !result.func_200662_C().func_223045_a(type)) {
            result = this.fixTileEntity(pos, type, result);
        }
        return result;
    }

    private TileEntity fixTileEntity(BlockPos pos, Block type, TileEntity found) {
        return found;
    }

    public void func_241113_a_(int p_241113_1_, int p_241113_2_, boolean p_241113_3_, boolean p_241113_4_) {
        this.field_241103_E_.func_230391_a_(p_241113_1_);
        this.field_241103_E_.func_76080_g(p_241113_2_);
        this.field_241103_E_.func_76090_f(p_241113_2_);
        this.field_241103_E_.func_76084_b(p_241113_3_);
        this.field_241103_E_.func_76069_a(p_241113_4_);
    }

    public Biome getBiomeBySeed(int x, int y, int z) {
        return this.func_225604_a_(x, y, z);
    }

    public Biome func_225604_a_(int p_225604_1_, int p_225604_2_, int p_225604_3_) {
        return this.func_72863_F().func_201711_g().func_202090_b().func_225526_b_(p_225604_1_, p_225604_2_, p_225604_3_);
    }

    public StructureManager func_241112_a_() {
        return this.field_241106_P_;
    }

    public void func_72835_b(BooleanSupplier p_72835_1_) {
        boolean flag3;
        IProfiler iprofiler = this.func_217381_Z();
        this.field_211159_Q = true;
        iprofiler.func_76320_a("world border");
        this.func_175723_af().func_212673_r();
        iprofiler.func_219895_b("weather");
        boolean flag = this.func_72896_J();
        if (this.func_230315_m_().func_218272_d()) {
            if (this.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                int i = this.field_241103_E_.func_230395_g_();
                int j = this.field_241103_E_.func_76071_n();
                int k = this.field_241103_E_.func_76083_p();
                boolean flag1 = this.field_72986_A.func_76061_m();
                boolean flag2 = this.field_72986_A.func_76059_o();
                if (i > 0) {
                    --i;
                    j = flag1 ? 0 : 1;
                    k = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j > 0) {
                        if (--j == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j = flag1 ? this.field_73012_v.nextInt(12000) + 3600 : this.field_73012_v.nextInt(168000) + 12000;
                    }
                    if (k > 0) {
                        if (--k == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k = flag2 ? this.field_73012_v.nextInt(12000) + 12000 : this.field_73012_v.nextInt(168000) + 12000;
                    }
                }
                this.field_241103_E_.func_76090_f(j);
                this.field_241103_E_.func_76080_g(k);
                this.field_241103_E_.func_230391_a_(i);
                this.field_241103_E_.func_76069_a(flag1);
                this.field_241103_E_.func_76084_b(flag2);
            }
            this.field_73018_p = this.field_73017_q;
            this.field_73017_q = this.field_72986_A.func_76061_m() ? (float)((double)this.field_73017_q + 0.01) : (float)((double)this.field_73017_q - 0.01);
            this.field_73017_q = MathHelper.func_76131_a((float)this.field_73017_q, (float)0.0f, (float)1.0f);
            this.field_73003_n = this.field_73004_o;
            this.field_73004_o = this.field_72986_A.func_76059_o() ? (float)((double)this.field_73004_o + 0.01) : (float)((double)this.field_73004_o - 0.01);
            this.field_73004_o = MathHelper.func_76131_a((float)this.field_73004_o, (float)0.0f, (float)1.0f);
        }
        if (this.field_73003_n != this.field_73004_o) {
            this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, this.field_73004_o), this.func_234923_W_());
        }
        if (this.field_73018_p != this.field_73017_q) {
            this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, this.field_73017_q), this.func_234923_W_());
        }
        if (flag != this.func_72896_J()) {
            if (flag) {
                this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241766_c_, 0.0f), this.func_234923_W_());
            } else {
                this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241765_b_, 0.0f), this.func_234923_W_());
            }
            this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, this.field_73004_o), this.func_234923_W_());
            this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, this.field_73017_q), this.func_234923_W_());
        }
        if (this.field_73068_P && this.field_217491_A.stream().noneMatch(p_241132_0_ -> !p_241132_0_.func_175149_v() && !p_241132_0_.func_71026_bH() && !p_241132_0_.fauxSleeping)) {
            long l = this.field_72986_A.func_76073_f() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((org.bukkit.World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, l - l % 24000L - this.func_72820_D());
            if (this.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
                this.getCBServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.func_241114_a_(ForgeEventFactory.onSleepFinished((ServerWorld)this, (long)(this.func_72820_D() + event.getSkipAmount()), (long)this.func_72820_D()));
                }
            }
            if (!event.isCancelled()) {
                this.field_73068_P = false;
                this.func_229856_ab_();
            }
            if (this.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                this.func_73051_P();
            }
        }
        this.func_72966_v();
        this.func_241126_b_();
        iprofiler.func_219895_b("chunkSource");
        this.timings.chunkProviderTick.startTiming();
        this.func_72863_F().func_217207_a(p_72835_1_);
        this.timings.chunkProviderTick.stopTiming();
        iprofiler.func_219895_b("tickPending");
        this.timings.scheduledBlocks.startTiming();
        if (!this.func_234925_Z_()) {
            this.field_94579_S.func_205365_a();
            this.field_205342_P.func_205365_a();
        }
        this.timings.scheduledBlocks.stopTiming();
        iprofiler.func_219895_b("raid");
        this.timings.raids.startTiming();
        this.field_217494_c.func_215171_a();
        this.timings.raids.stopTiming();
        iprofiler.func_219895_b("blockEvents");
        this.timings.doSounds.startTiming();
        this.func_147488_Z();
        this.timings.doSounds.stopTiming();
        this.field_211159_Q = false;
        iprofiler.func_219895_b("entities");
        boolean bl = flag3 = !this.field_217491_A.isEmpty() || ForgeChunkManager.hasForcedChunks((ServerWorld)this);
        if (flag3) {
            this.func_82742_i();
        }
        if (flag3 || this.field_80004_Q++ < 300 || this.ignoreEmptyTimeThis) {
            this.timings.tickEntities.startTiming();
            if (this.field_241105_O_ != null) {
                this.field_241105_O_.func_186105_b();
            }
            this.field_217492_a = true;
            ObjectIterator objectiterator = this.field_217498_x.int2ObjectEntrySet().iterator();
            ActivationRange.activateEntities((World)this);
            this.timings.entityTick.startTiming();
            while (true) {
                if (!objectiterator.hasNext()) {
                    net.minecraft.entity.Entity entity;
                    this.field_217492_a = false;
                    this.timings.entityTick.stopTiming();
                    while ((entity = this.field_217499_z.poll()) != null) {
                        this.func_217465_m(entity);
                    }
                    this.timings.tickEntities.stopTiming();
                    this.func_217391_K();
                    this.spigotConfig.currentPrimedTnt = 0;
                    break;
                }
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectiterator.next();
                net.minecraft.entity.Entity entity1 = (net.minecraft.entity.Entity)entry.getValue();
                net.minecraft.entity.Entity entity2 = entity1.func_184187_bx();
                if (!this.field_73061_a.func_230537_U_() && (entity1 instanceof AnimalEntity || entity1 instanceof WaterMobEntity)) {
                    entity1.func_70106_y();
                }
                if (!this.field_73061_a.func_230538_V_() && entity1 instanceof INPC) {
                    entity1.func_70106_y();
                }
                iprofiler.func_76320_a("checkDespawn");
                if (!entity1.field_70128_L) {
                    entity1.func_70623_bb();
                }
                iprofiler.func_76319_b();
                if (entity2 != null) {
                    if (!entity2.field_70128_L && entity2.func_184196_w(entity1)) continue;
                    entity1.func_184210_p();
                }
                iprofiler.func_76320_a("tick");
                if (!entity1.field_70128_L && !(entity1 instanceof PartEntity)) {
                    this.func_217390_a(this::func_217479_a, entity1);
                }
                iprofiler.func_76319_b();
                iprofiler.func_76320_a("remove");
                if (entity1.field_70128_L) {
                    this.func_217454_n(entity1);
                    objectiterator.remove();
                    this.removeEntityComplete(entity1, entity1 instanceof ServerPlayerEntity);
                }
                iprofiler.func_76319_b();
            }
        }
        iprofiler.func_76319_b();
    }

    protected void func_241126_b_() {
        if (this.field_241107_Q_) {
            long i = this.field_72986_A.func_82573_f() + 1L;
            this.field_241103_E_.func_82572_b(i);
            this.field_241103_E_.func_215763_z().func_216331_a(this.field_73061_a, i);
            if (this.field_72986_A.func_82574_x().func_223586_b(GameRules.field_223607_j)) {
                this.func_241114_a_(this.field_72986_A.func_76073_f() + 1L);
            }
        }
    }

    public void func_241114_a_(long p_241114_1_) {
        this.field_241103_E_.func_76068_b(p_241114_1_);
    }

    public void func_241123_a_(boolean p_241123_1_, boolean p_241123_2_) {
        for (ISpecialSpawner ispecialspawner : this.field_241104_N_) {
            ispecialspawner.func_230253_a_(this, p_241123_1_, p_241123_2_);
        }
    }

    private void func_229856_ab_() {
        this.field_217491_A.stream().filter(LivingEntity::func_70608_bn).collect(Collectors.toList()).forEach(p_241131_0_ -> p_241131_0_.func_225652_a_(false, false));
    }

    public void func_217441_a(Chunk p_217441_1_, int p_217441_2_) {
        BlockPos blockpos;
        ChunkPos chunkpos = p_217441_1_.func_76632_l();
        boolean flag = this.func_72896_J();
        int i = chunkpos.func_180334_c();
        int j = chunkpos.func_180333_d();
        IProfiler iprofiler = this.func_217381_Z();
        iprofiler.func_76320_a("thunder");
        if (flag && this.func_72911_I() && this.field_73012_v.nextInt(100000) == 0 && this.func_175727_C(blockpos = this.func_175736_a(this.func_217383_a(i, 0, j, 15)))) {
            boolean flag1;
            DifficultyInstance difficultyinstance = this.func_175649_E(blockpos);
            boolean bl = flag1 = this.func_82736_K().func_223586_b(GameRules.field_223601_d) && this.field_73012_v.nextDouble() < (double)difficultyinstance.func_180168_b() * 0.01;
            if (flag1) {
                SkeletonHorseEntity skeletonhorseentity = EntityType.field_200742_ah.func_200721_a(this);
                skeletonhorseentity.func_190691_p(true);
                skeletonhorseentity.func_70873_a(0);
                skeletonhorseentity.func_70107_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
                this.addEntity((net.minecraft.entity.Entity)skeletonhorseentity, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            LightningBoltEntity lightningboltentity = EntityType.field_200728_aG.func_200721_a(this);
            lightningboltentity.func_233576_c_(Vector3d.func_237492_c_(blockpos));
            lightningboltentity.func_233623_a_(flag1);
            this.strikeLightning(lightningboltentity, LightningStrikeEvent.Cause.WEATHER);
        }
        iprofiler.func_219895_b("iceandsnow");
        if (this.field_73012_v.nextInt(16) == 0) {
            BlockPos blockpos2 = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_217383_a(i, 0, j, 15));
            BlockPos blockpos3 = blockpos2.func_177977_b();
            Biome biome = this.func_226691_t_(blockpos2);
            if (this.isAreaLoaded(blockpos2, 1) && biome.func_201848_a((IWorldReader)((Object)this), blockpos3)) {
                CraftEventFactory.handleBlockFormEvent((World)this, (BlockPos)blockpos3, (BlockState)Blocks.field_150432_aD.func_176223_P(), null);
            }
            if (flag && biome.func_201850_b((IWorldReader)((Object)this), blockpos2)) {
                CraftEventFactory.handleBlockFormEvent((World)this, (BlockPos)blockpos2, (BlockState)Blocks.field_150433_aE.func_176223_P(), null);
            }
            if (flag && this.func_226691_t_(blockpos3).func_201851_b() == Biome.RainType.RAIN) {
                this.func_180495_p(blockpos3).func_177230_c().func_176224_k(this, blockpos3);
            }
        }
        iprofiler.func_219895_b("tickBlocks");
        this.timings.chunkTicksBlocks.startTiming();
        if (p_217441_2_ > 0) {
            ChunkSection[] secs = p_217441_1_.func_76587_i();
            for (int iSec = 0; iSec < secs.length; ++iSec) {
                ChunkSection sec = secs[iSec];
                if (sec == Chunk.field_186036_a || sec.tickableLocations.isEmpty()) continue;
                for (int loop = 0; loop < p_217441_2_; ++loop) {
                    int iRnd = this.randomTickRandom.nextInt(4096);
                    if (iRnd >= sec.tickableLocations.size()) continue;
                    int key = sec.tickableLocations.get(iRnd);
                    int rndX = key & 0xF;
                    int rndY = key >>> 8 & 0xFF;
                    int rndZ = key >>> 4 & 0xF;
                    BlockPos rndPos = new BlockPos(p_217441_1_.func_76632_l().func_180334_c() + rndX, iSec * 16 + rndY, p_217441_1_.func_76632_l().func_180333_d() + rndZ);
                    BlockState rndState = sec.func_177485_a(rndX, rndY, rndZ);
                    rndState.func_227034_b_(this, rndPos, this.randomTickRandom);
                }
            }
        }
        this.timings.chunkTicksBlocks.stopTiming();
        iprofiler.func_76319_b();
    }

    protected BlockPos func_175736_a(BlockPos p_175736_1_) {
        BlockPos blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, p_175736_1_);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos, new BlockPos(blockpos.func_177958_n(), this.func_217301_I(), blockpos.func_177952_p())).func_186662_g(3.0);
        List<LivingEntity> list = this.func_175647_a(LivingEntity.class, axisalignedbb, p_241115_1_ -> p_241115_1_ != null && p_241115_1_.func_70089_S() && this.func_226660_f_(p_241115_1_.func_233580_cy_()));
        if (!list.isEmpty()) {
            return list.get(this.field_73012_v.nextInt(list.size())).func_233580_cy_();
        }
        if (blockpos.func_177956_o() == -1) {
            blockpos = blockpos.func_177981_b(2);
        }
        return blockpos;
    }

    public boolean func_211158_j_() {
        return this.field_211159_Q;
    }

    public void func_72854_c() {
        this.field_73068_P = false;
        if (!this.field_217491_A.isEmpty()) {
            int i = 0;
            int j = 0;
            for (ServerPlayerEntity serverplayerentity : this.field_217491_A) {
                if (serverplayerentity.func_175149_v() || serverplayerentity.fauxSleeping && !serverplayerentity.func_70608_bn()) {
                    ++i;
                    continue;
                }
                if (!serverplayerentity.func_70608_bn()) continue;
                ++j;
            }
            this.field_73068_P = j > 0 && j >= this.field_217491_A.size() - i;
        }
    }

    @Override
    public ServerScoreboard func_96441_U() {
        return this.field_73061_a.func_200251_aP();
    }

    private void func_73051_P() {
        this.field_241103_E_.func_76084_b(false);
        if (!this.field_241103_E_.func_76059_o()) {
            this.field_241103_E_.func_76080_g(0);
        }
        this.field_241103_E_.func_76069_a(false);
        if (!this.field_241103_E_.func_76061_m()) {
            this.field_241103_E_.func_76090_f(0);
        }
    }

    public void func_82742_i() {
        this.field_80004_Q = 0;
    }

    private void func_205339_a(NextTickListEntry<Fluid> p_205339_1_) {
        BlockPos pos = p_205339_1_.field_180282_a;
        ChunkMcAPI.getTickingChunkNow((ServerWorld)this, (int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4)).ifPresent(chunk -> {
            FluidState state = chunk.func_204610_c(pos);
            if (state.func_206886_c() == p_205339_1_.func_151351_a()) {
                state.func_206880_a(this, pos);
            }
        });
    }

    private void func_205338_b(NextTickListEntry<Block> p_205338_1_) {
        BlockPos pos = p_205338_1_.field_180282_a;
        ChunkMcAPI.getTickingChunkNow((ServerWorld)this, (int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4)).ifPresent(chunk -> {
            BlockState state = chunk.func_180495_p(pos);
            if (state.func_203425_a((Block)((Object)((Object)p_205338_1_.func_151351_a())))) {
                state.func_227033_a_(this, pos, this.field_73012_v);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_217479_a(net.minecraft.entity.Entity p_217479_1_) {
        if (!(p_217479_1_ instanceof PlayerEntity) && !this.func_72863_F().func_217204_a(p_217479_1_)) {
            this.func_217464_b(p_217479_1_);
        } else {
            ++TimingHistory.entityTicks;
            if (!TickConfig.ENTITIES.canTick(p_217479_1_.getClass(), this.func_82737_E()) || !ActivationRange.checkIfActive((net.minecraft.entity.Entity)p_217479_1_)) {
                ++p_217479_1_.field_70173_aa;
                Timing timer = p_217479_1_.func_200600_R().inactiveTickTimer.startTiming();
                try {
                    p_217479_1_.inactiveTick();
                }
                finally {
                    timer.stopTiming();
                }
                return;
            }
            ++TimingHistory.activatedEntityTicks;
            Timing timer = p_217479_1_.func_184187_bx() != null ? p_217479_1_.func_200600_R().passengerTickTimer.startTiming() : p_217479_1_.func_200600_R().tickTimer.startTiming();
            try {
                p_217479_1_.func_226286_f_(p_217479_1_.func_226277_ct_(), p_217479_1_.func_226278_cu_(), p_217479_1_.func_226281_cx_());
                p_217479_1_.field_70126_B = p_217479_1_.field_70177_z;
                p_217479_1_.field_70127_C = p_217479_1_.field_70125_A;
                if (p_217479_1_.field_70175_ag) {
                    ++p_217479_1_.field_70173_aa;
                    IProfiler iprofiler = this.func_217381_Z();
                    iprofiler.func_194340_a(() -> p_217479_1_.func_200600_R().getRegistryName() == null ? p_217479_1_.func_200600_R().toString() : p_217479_1_.func_200600_R().getRegistryName().toString());
                    iprofiler.func_230035_c_("tickNonPassenger");
                    if (p_217479_1_.canUpdate()) {
                        p_217479_1_.func_70071_h_();
                    }
                    p_217479_1_.postTick();
                    iprofiler.func_76319_b();
                }
                this.func_217464_b(p_217479_1_);
                if (p_217479_1_.field_70175_ag) {
                    for (net.minecraft.entity.Entity entity : p_217479_1_.func_184188_bt()) {
                        this.func_217459_a(p_217479_1_, entity);
                    }
                }
            }
            finally {
                timer.stopTiming();
            }
        }
    }

    public void func_217459_a(net.minecraft.entity.Entity p_217459_1_, net.minecraft.entity.Entity p_217459_2_) {
        if (!p_217459_2_.field_70128_L && p_217459_2_.func_184187_bx() == p_217459_1_) {
            if (p_217459_2_ instanceof PlayerEntity || this.func_72863_F().func_217204_a(p_217459_2_)) {
                p_217459_2_.func_226286_f_(p_217459_2_.func_226277_ct_(), p_217459_2_.func_226278_cu_(), p_217459_2_.func_226281_cx_());
                p_217459_2_.field_70126_B = p_217459_2_.field_70177_z;
                p_217459_2_.field_70127_C = p_217459_2_.field_70125_A;
                if (p_217459_2_.field_70175_ag) {
                    ++p_217459_2_.field_70173_aa;
                    IProfiler iprofiler = this.func_217381_Z();
                    iprofiler.func_194340_a(() -> Registry.field_212629_r.func_177774_c(p_217459_2_.func_200600_R()).toString());
                    iprofiler.func_230035_c_("tickPassenger");
                    p_217459_2_.func_70098_U();
                    p_217459_2_.postTick();
                    iprofiler.func_76319_b();
                }
                this.func_217464_b(p_217459_2_);
                if (p_217459_2_.field_70175_ag) {
                    for (net.minecraft.entity.Entity entity : p_217459_2_.func_184188_bt()) {
                        this.func_217459_a(p_217459_2_, entity);
                    }
                }
            }
        } else {
            p_217459_2_.func_184210_p();
        }
    }

    public void func_217464_b(net.minecraft.entity.Entity p_217464_1_) {
        if (p_217464_1_.func_233578_ci_()) {
            this.func_217381_Z().func_76320_a("chunkCheck");
            int i = MathHelper.func_76128_c((double)(p_217464_1_.func_226277_ct_() / 16.0));
            int j = Math.min(15, Math.max(0, MathHelper.func_76128_c((double)(p_217464_1_.func_226278_cu_() / 16.0))));
            int k = MathHelper.func_76128_c((double)(p_217464_1_.func_226281_cx_() / 16.0));
            if (!p_217464_1_.field_70175_ag || p_217464_1_.field_70176_ah != i || p_217464_1_.field_70162_ai != j || p_217464_1_.field_70164_aj != k) {
                if (p_217464_1_.field_70175_ag && this.func_217354_b(p_217464_1_.field_70176_ah, p_217464_1_.field_70164_aj)) {
                    this.func_212866_a_(p_217464_1_.field_70176_ah, p_217464_1_.field_70164_aj).func_76608_a(p_217464_1_, p_217464_1_.field_70162_ai);
                }
                if (!(p_217464_1_.valid || p_217464_1_.func_233577_ch_() || this.func_217354_b(i, k))) {
                    if (p_217464_1_.field_70175_ag) {
                        field_147491_a.warn(i18n.get((String)"serverworld.1", (Object[])new Object[]{p_217464_1_}));
                    }
                    p_217464_1_.field_70175_ag = false;
                } else {
                    this.func_212866_a_(i, k).func_76612_a(p_217464_1_);
                }
            }
            this.func_217381_Z().func_76319_b();
        }
    }

    @Override
    public boolean func_175660_a(PlayerEntity p_175660_1_, BlockPos p_175660_2_) {
        return !this.field_73061_a.func_175579_a(this, p_175660_2_, p_175660_1_) && this.func_175723_af().func_177746_a(p_175660_2_);
    }

    public void func_217445_a(@Nullable IProgressUpdate p_217445_1_, boolean p_217445_2_, boolean p_217445_3_) {
        ServerChunkProvider serverchunkprovider = this.func_72863_F();
        if (!p_217445_3_) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((org.bukkit.World)this.getWorld()));
            try (Timing ignored = this.timings.worldSave.startTiming();){
                if (p_217445_1_ != null) {
                    p_217445_1_.func_200210_a((ITextComponent)((Object)new TranslationTextComponent("menu.savingLevel")));
                }
                this.func_73042_a();
                if (p_217445_1_ != null) {
                    p_217445_1_.func_200209_c((ITextComponent)((Object)new TranslationTextComponent("menu.savingChunks")));
                }
                MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)new WorldEvent.Save((IWorld)this));
                this.timings.worldSaveChunks.startTiming();
                serverchunkprovider.func_217210_a(p_217445_2_);
                this.timings.worldSaveChunks.stopTiming();
            }
        }
    }

    private void func_73042_a() {
        if (this.field_241105_O_ != null) {
            this.field_73061_a.func_240793_aU_().func_230413_a_(this.field_241105_O_.func_186088_a());
        }
        this.func_72863_F().func_217227_h().func_212775_b();
    }

    public List<net.minecraft.entity.Entity> func_217482_a(@Nullable EntityType<?> p_217482_1_, Predicate<? super net.minecraft.entity.Entity> p_217482_2_) {
        ArrayList list = Lists.newArrayList();
        ServerChunkProvider serverchunkprovider = this.func_72863_F();
        for (net.minecraft.entity.Entity entity : this.field_217498_x.values()) {
            if (p_217482_1_ != null && entity.func_200600_R() != p_217482_1_ || !serverchunkprovider.func_73149_a(MathHelper.func_76128_c((double)entity.func_226277_ct_()) >> 4, MathHelper.func_76128_c((double)entity.func_226281_cx_()) >> 4) || !p_217482_2_.test(entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public List<EnderDragonEntity> func_217439_j() {
        ArrayList list = Lists.newArrayList();
        for (net.minecraft.entity.Entity entity : this.field_217498_x.values()) {
            if (!(entity instanceof EnderDragonEntity) || !entity.func_70089_S()) continue;
            list.add((EnderDragonEntity)entity);
        }
        return list;
    }

    public List<ServerPlayerEntity> func_217490_a(Predicate<? super ServerPlayerEntity> p_217490_1_) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayerEntity serverplayerentity : this.field_217491_A) {
            if (!p_217490_1_.test(serverplayerentity)) continue;
            list.add(serverplayerentity);
        }
        return list;
    }

    @Nullable
    public ServerPlayerEntity func_217472_l_() {
        List<ServerPlayerEntity> list = this.func_217490_a(LivingEntity::func_70089_S);
        return list.isEmpty() ? null : list.get(this.field_73012_v.nextInt(list.size()));
    }

    public boolean func_217376_c(net.minecraft.entity.Entity p_217376_1_) {
        return this.addEntity0(p_217376_1_, this.pehkuiSpawnReason);
    }

    public boolean addEntity(net.minecraft.entity.Entity entityIn, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity0(entityIn, reason);
    }

    public boolean func_217470_d(net.minecraft.entity.Entity p_217470_1_) {
        return this.addEntitySerialized(p_217470_1_, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addEntitySerialized(net.minecraft.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity0(entity, reason);
    }

    public void func_217460_e(net.minecraft.entity.Entity p_217460_1_) {
        boolean flag = p_217460_1_.field_98038_p;
        p_217460_1_.field_98038_p = true;
        this.func_217470_d(p_217460_1_);
        p_217460_1_.field_98038_p = flag;
        this.func_217464_b(p_217460_1_);
    }

    public void func_217446_a(ServerPlayerEntity p_217446_1_) {
        this.func_217448_f(p_217446_1_);
        this.func_217464_b(p_217446_1_);
    }

    public void func_217447_b(ServerPlayerEntity p_217447_1_) {
        this.func_217448_f(p_217447_1_);
        this.func_217464_b(p_217447_1_);
    }

    public void func_217435_c(ServerPlayerEntity p_217435_1_) {
        this.func_217448_f(p_217435_1_);
    }

    public void func_217433_d(ServerPlayerEntity p_217433_1_) {
        this.func_217448_f(p_217433_1_);
    }

    private void func_217448_f(ServerPlayerEntity p_217448_1_) {
        if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)new EntityJoinWorldEvent((net.minecraft.entity.Entity)p_217448_1_, (World)this))) {
            return;
        }
        net.minecraft.entity.Entity entity = this.field_175741_N.get(p_217448_1_.func_110124_au());
        if (entity != null) {
            field_147491_a.warn(i18n.get((String)"serverworld.2", (Object[])new Object[]{p_217448_1_.func_110124_au().toString()}));
            entity.func_213319_R();
            this.func_217434_e((ServerPlayerEntity)entity);
        }
        this.field_217491_A.add(p_217448_1_);
        this.func_72854_c();
        IChunk ichunk = this.func_217353_a(MathHelper.func_76128_c((double)(p_217448_1_.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(p_217448_1_.func_226281_cx_() / 16.0)), ChunkStatus.field_222617_m, true);
        if (ichunk instanceof Chunk) {
            ichunk.func_76612_a(p_217448_1_);
        }
        this.func_217465_m(p_217448_1_);
    }

    private boolean func_72838_d(net.minecraft.entity.Entity p_72838_1_) {
        return this.addEntity0(p_72838_1_, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    private boolean addEntity0(net.minecraft.entity.Entity entityIn, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (entityIn.field_70128_L) {
            field_147491_a.warn(i18n.get((String)"serverworld.3", (Object[])new Object[]{EntityType.func_200718_a(entityIn.func_200600_R())}));
            return false;
        }
        if (this.func_217478_l(entityIn)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)new EntityJoinWorldEvent(entityIn, (World)this))) {
            return false;
        }
        if (!CraftEventFactory.doEntityAddEventCalling((World)this, (net.minecraft.entity.Entity)entityIn, (CreatureSpawnEvent.SpawnReason)spawnReason)) {
            return false;
        }
        IChunk ichunk = this.func_217353_a(MathHelper.func_76128_c((double)(entityIn.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(entityIn.func_226281_cx_() / 16.0)), ChunkStatus.field_222617_m, entityIn.field_98038_p);
        if (!(ichunk instanceof Chunk)) {
            return false;
        }
        ichunk.func_76612_a(entityIn);
        this.func_217465_m(entityIn);
        return true;
    }

    public boolean func_217440_f(net.minecraft.entity.Entity p_217440_1_) {
        if (this.func_217478_l(p_217440_1_)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)new EntityJoinWorldEvent(p_217440_1_, (World)this))) {
            return false;
        }
        this.func_217465_m(p_217440_1_);
        return true;
    }

    private boolean func_217478_l(net.minecraft.entity.Entity p_217478_1_) {
        UUID uuid = p_217478_1_.func_110124_au();
        net.minecraft.entity.Entity entity = this.func_242105_c(uuid);
        if (entity == null) {
            return false;
        }
        field_147491_a.warn(i18n.get((String)"serverworld.4", (Object[])new Object[]{uuid, EntityType.func_200718_a(entity.func_200600_R()), entity.func_145782_y(), EntityType.func_200718_a(p_217478_1_.func_200600_R()), p_217478_1_.func_145782_y()}));
        return true;
    }

    @Nullable
    private net.minecraft.entity.Entity func_242105_c(UUID p_242105_1_) {
        net.minecraft.entity.Entity entity = this.field_175741_N.get(p_242105_1_);
        if (entity != null) {
            return entity;
        }
        if (this.field_217492_a) {
            for (net.minecraft.entity.Entity entity1 : this.field_217499_z) {
                if (!entity1.func_110124_au().equals(p_242105_1_)) continue;
                return entity1;
            }
        }
        return null;
    }

    public boolean func_242106_g(net.minecraft.entity.Entity p_242106_1_) {
        return this.addAllEntitiesSafely(p_242106_1_, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addAllEntitiesSafely(net.minecraft.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity.func_226276_cg_().anyMatch(this::func_217478_l)) {
            return false;
        }
        this.addAllEntities(entity, reason);
        return true;
    }

    public void func_217466_a(Chunk p_217466_1_) {
        for (TileEntity tileentity : p_217466_1_.func_177434_r().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h : Lists.newArrayList((Iterable)CraftCustomInventory.getViewers((IInventory)((IInventory)((Object)tileentity))))) {
                h.closeInventory();
            }
        }
        this.field_147483_b.addAll(p_217466_1_.func_177434_r().values());
        ClassInheritanceMultiMap<net.minecraft.entity.Entity>[] aclassinheritancemultimap = p_217466_1_.func_177429_s();
        int i = aclassinheritancemultimap.length;
        for (int j = 0; j < i; ++j) {
            for (net.minecraft.entity.Entity entity : aclassinheritancemultimap[j]) {
                if (entity instanceof ServerPlayerEntity) continue;
                if (this.field_217492_a) {
                    throw Util.func_229757_c_(new IllegalStateException("Removing entity while ticking!"));
                }
                this.field_217498_x.remove(entity.func_145782_y());
                this.func_217484_g(entity);
            }
        }
    }

    @Deprecated
    public void func_217484_g(net.minecraft.entity.Entity p_217484_1_) {
        this.removeEntityComplete(p_217484_1_, false);
    }

    public void removeEntityComplete(net.minecraft.entity.Entity p_217484_1_, boolean keepData) {
        if (p_217484_1_ instanceof PlayerEntity) {
            this.func_73046_m().field_71305_c.values().stream().map(ServerWorld::func_217481_x).forEach(worldData -> {
                for (WorldSavedData o : worldData.field_212778_c.values()) {
                    if (!(o instanceof MapData)) continue;
                    MapData map = (MapData)o;
                    map.field_76196_g.remove((PlayerEntity)p_217484_1_);
                    Iterator<MapData.MapInfo> iter = map.field_76196_g.iterator();
                    while (iter.hasNext()) {
                        if (iter.next().field_76211_a != p_217484_1_) continue;
                        map.field_76203_h.remove(p_217484_1_.func_145748_c_().getString());
                        iter.remove();
                    }
                }
            });
        }
        if (p_217484_1_ instanceof EnderDragonEntity) {
            for (EnderDragonPartEntity enderdragonpartentity : ((EnderDragonEntity)p_217484_1_).func_213404_dT()) {
                enderdragonpartentity.remove(keepData);
            }
        }
        p_217484_1_.remove(keepData);
        this.field_175741_N.remove(p_217484_1_.func_110124_au());
        this.func_72863_F().func_217226_b(p_217484_1_);
        if (p_217484_1_ instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)p_217484_1_;
            this.field_217491_A.remove(serverplayerentity);
        }
        this.func_96441_U().func_181140_a(p_217484_1_);
        if (p_217484_1_ instanceof DrownedEntity) {
            this.field_217495_I.remove(((DrownedEntity)((Object)p_217484_1_)).field_204716_a);
            this.field_217495_I.remove(((DrownedEntity)((Object)p_217484_1_)).field_204717_b);
        } else if (p_217484_1_ instanceof MobEntity) {
            this.field_217495_I.remove(((MobEntity)p_217484_1_).func_70661_as());
        }
        p_217484_1_.onRemovedFromWorld();
        p_217484_1_.valid = false;
        MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)new EntityLeaveWorldEvent(p_217484_1_, (World)this));
    }

    private void func_217465_m(net.minecraft.entity.Entity p_217465_1_) {
        if (p_217465_1_.needsChunkUpdate) {
            this.func_212866_a_((int)Math.floor(p_217465_1_.func_226277_ct_()) >> 4, (int)Math.floor(p_217465_1_.func_226281_cx_()) >> 4).func_76612_a(p_217465_1_);
            p_217465_1_.needsChunkUpdate = false;
        }
        if (this.field_217492_a) {
            this.field_217499_z.add(p_217465_1_);
        } else {
            this.field_217498_x.put(p_217465_1_.func_145782_y(), (Object)p_217465_1_);
            if (p_217465_1_ instanceof EnderDragonEntity) {
                for (EnderDragonPartEntity enderdragonpartentity : ((EnderDragonEntity)p_217465_1_).func_213404_dT()) {
                    this.field_217498_x.put(enderdragonpartentity.func_145782_y(), (Object)enderdragonpartentity);
                }
            }
            this.field_175741_N.put(p_217465_1_.func_110124_au(), p_217465_1_);
            this.func_72863_F().func_217230_c(p_217465_1_);
            if (p_217465_1_ instanceof DrownedEntity) {
                this.field_217495_I.remove(((DrownedEntity)((Object)p_217465_1_)).field_204716_a);
                this.field_217495_I.remove(((DrownedEntity)((Object)p_217465_1_)).field_204717_b);
            } else if (p_217465_1_ instanceof MobEntity) {
                this.field_217495_I.add(((MobEntity)p_217465_1_).func_70661_as());
            }
            p_217465_1_.valid = true;
        }
        p_217465_1_.onAddedToWorld();
    }

    public void func_217467_h(net.minecraft.entity.Entity p_217467_1_) {
        this.removeEntity(p_217467_1_, false);
    }

    public void removeEntity(net.minecraft.entity.Entity p_217467_1_, boolean keepData) {
        if (this.field_217492_a) {
            throw Util.func_229757_c_(new IllegalStateException("Removing entity while ticking!"));
        }
        this.func_217454_n(p_217467_1_);
        this.field_217498_x.remove(p_217467_1_.func_145782_y());
        this.removeEntityComplete(p_217467_1_, keepData);
    }

    private void func_217454_n(net.minecraft.entity.Entity p_217454_1_) {
        IChunk ichunk = this.func_217353_a(p_217454_1_.field_70176_ah, p_217454_1_.field_70164_aj, ChunkStatus.field_222617_m, false);
        if (ichunk instanceof Chunk) {
            ((Chunk)ichunk).func_76622_b(p_217454_1_);
        }
    }

    public void func_217434_e(ServerPlayerEntity p_217434_1_) {
        this.removePlayer(p_217434_1_, false);
    }

    public void removePlayer(ServerPlayerEntity p_217434_1_, boolean keepData) {
        p_217434_1_.remove(keepData);
        this.removeEntity(p_217434_1_, keepData);
        this.func_72854_c();
    }

    public boolean strikeLightning(net.minecraft.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)((LightningStrike)entitylightning.getBukkitEntity()), (LightningStrikeEvent.Cause)cause);
        this.getCBServer().getPluginManager().callEvent((Event)lightning);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.func_217376_c(entitylightning);
    }

    @Override
    public void func_175715_c(int p_175715_1_, BlockPos p_175715_2_, int p_175715_3_) {
        for (ServerPlayerEntity serverplayerentity : this.field_73061_a.func_184103_al().func_181057_v()) {
            PlayerEntity entityhuman = null;
            net.minecraft.entity.Entity entity = this.func_73045_a(p_175715_1_);
            if (entity instanceof PlayerEntity) {
                entityhuman = (PlayerEntity)entity;
            }
            if (serverplayerentity == null || serverplayerentity.field_70170_p != this || serverplayerentity.func_145782_y() == p_175715_1_) continue;
            double d0 = (double)p_175715_2_.func_177958_n() - serverplayerentity.func_226277_ct_();
            double d1 = (double)p_175715_2_.func_177956_o() - serverplayerentity.func_226278_cu_();
            double d2 = (double)p_175715_2_.func_177952_p() - serverplayerentity.func_226281_cx_();
            if (entityhuman != null && entityhuman instanceof ServerPlayerEntity && !serverplayerentity.getBukkitEntity().canSee((Player)((ServerPlayerEntity)entityhuman).getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SAnimateBlockBreakPacket(p_175715_1_, p_175715_2_, p_175715_3_));
        }
    }

    @Override
    public void func_184148_a(@Nullable PlayerEntity p_184148_1_, double p_184148_2_, double p_184148_4_, double p_184148_6_, SoundEvent p_184148_8_, SoundCategory p_184148_9_, float p_184148_10_, float p_184148_11_) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((net.minecraft.entity.Entity)p_184148_1_, (SoundEvent)p_184148_8_, (SoundCategory)p_184148_9_, (float)p_184148_10_, (float)p_184148_11_);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        p_184148_8_ = event.getSound();
        p_184148_9_ = event.getCategory();
        p_184148_10_ = event.getVolume();
        this.field_73061_a.func_184103_al().func_148543_a(p_184148_1_, p_184148_2_, p_184148_4_, p_184148_6_, p_184148_10_ > 1.0f ? (double)(16.0f * p_184148_10_) : 16.0, this.func_234923_W_(), (IPacket<?>)new SPlaySoundEffectPacket(p_184148_8_, p_184148_9_, p_184148_2_, p_184148_4_, p_184148_6_, p_184148_10_, p_184148_11_));
    }

    @Override
    public void func_217384_a(@Nullable PlayerEntity p_217384_1_, net.minecraft.entity.Entity p_217384_2_, SoundEvent p_217384_3_, SoundCategory p_217384_4_, float p_217384_5_, float p_217384_6_) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((net.minecraft.entity.Entity)p_217384_1_, (SoundEvent)p_217384_3_, (SoundCategory)p_217384_4_, (float)p_217384_5_, (float)p_217384_6_);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        p_217384_3_ = event.getSound();
        p_217384_4_ = event.getCategory();
        p_217384_5_ = event.getVolume();
        this.field_73061_a.func_184103_al().func_148543_a(p_217384_1_, p_217384_2_.func_226277_ct_(), p_217384_2_.func_226278_cu_(), p_217384_2_.func_226281_cx_(), p_217384_5_ > 1.0f ? (double)(16.0f * p_217384_5_) : 16.0, this.func_234923_W_(), (IPacket<?>)new SSpawnMovingSoundEffectPacket(p_217384_3_, p_217384_4_, p_217384_2_, p_217384_5_, p_217384_6_));
    }

    @Override
    public void func_175669_a(int p_175669_1_, BlockPos p_175669_2_, int p_175669_3_) {
        this.field_73061_a.func_184103_al().func_148540_a((IPacket<?>)new SPlaySoundEventPacket(p_175669_1_, p_175669_2_, p_175669_3_, true));
    }

    @Override
    public void func_217378_a(@Nullable PlayerEntity p_217378_1_, int p_217378_2_, BlockPos p_217378_3_, int p_217378_4_) {
        this.field_73061_a.func_184103_al().func_148543_a(p_217378_1_, p_217378_3_.func_177958_n(), p_217378_3_.func_177956_o(), p_217378_3_.func_177952_p(), 64.0, this.func_234923_W_(), (IPacket<?>)new SPlaySoundEventPacket(p_217378_2_, p_217378_3_, p_217378_4_, false));
    }

    @Override
    public void func_184138_a(BlockPos p_184138_1_, BlockState p_184138_2_, BlockState p_184138_3_, int p_184138_4_) {
        this.func_72863_F().func_217217_a(p_184138_1_);
        VoxelShape voxelshape = p_184138_2_.func_196952_d((IBlockReader)((Object)this), p_184138_1_);
        VoxelShape voxelshape1 = p_184138_3_.func_196952_d((IBlockReader)((Object)this), p_184138_1_);
        if (VoxelShapes.func_197879_c(voxelshape, voxelshape1, IBooleanFunction.field_223236_g_)) {
            for (PathNavigator pathnavigator : this.field_217495_I) {
                if (pathnavigator.func_188553_i()) continue;
                pathnavigator.func_220970_c(p_184138_1_);
            }
        }
    }

    @Override
    public void func_72960_a(net.minecraft.entity.Entity p_72960_1_, byte p_72960_2_) {
        this.func_72863_F().func_217216_a(p_72960_1_, (IPacket<?>)new SEntityStatusPacket(p_72960_1_, p_72960_2_));
    }

    @Override
    public ServerChunkProvider func_72863_F() {
        return this.field_241102_C_;
    }

    @Override
    public Explosion func_230546_a_(@Nullable net.minecraft.entity.Entity p_230546_1_, @Nullable DamageSource p_230546_2_, @Nullable ExplosionContext p_230546_3_, double p_230546_4_, double p_230546_6_, double p_230546_8_, float p_230546_10_, boolean p_230546_11_, Explosion.Mode p_230546_12_) {
        Explosion explosion = super.func_230546_a_(p_230546_1_, p_230546_2_, p_230546_3_, p_230546_4_, p_230546_6_, p_230546_8_, p_230546_10_, p_230546_11_, p_230546_12_);
        if (explosion.wasCanceled) {
            return explosion;
        }
        if (p_230546_12_ == Explosion.Mode.NONE) {
            explosion.func_180342_d();
        }
        for (ServerPlayerEntity serverplayerentity : this.field_217491_A) {
            if (!(serverplayerentity.func_70092_e(p_230546_4_, p_230546_6_, p_230546_8_) < 4096.0)) continue;
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SExplosionPacket(p_230546_4_, p_230546_6_, p_230546_8_, p_230546_10_, explosion.func_180343_e(), explosion.func_77277_b().get(serverplayerentity)));
        }
        return explosion;
    }

    @Override
    public void func_175641_c(BlockPos p_175641_1_, Block p_175641_2_, int p_175641_3_, int p_175641_4_) {
        this.field_147490_S.add((Object)new BlockEventData(p_175641_1_, p_175641_2_, p_175641_3_, p_175641_4_));
    }

    private void func_147488_Z() {
        while (!this.field_147490_S.isEmpty()) {
            BlockEventData blockeventdata = (BlockEventData)this.field_147490_S.removeFirst();
            if (!this.func_147485_a(blockeventdata)) continue;
            this.field_73061_a.func_184103_al().func_148543_a(null, blockeventdata.func_180328_a().func_177958_n(), blockeventdata.func_180328_a().func_177956_o(), blockeventdata.func_180328_a().func_177952_p(), 64.0, this.func_234923_W_(), (IPacket<?>)new SBlockActionPacket(blockeventdata.func_180328_a(), blockeventdata.func_151337_f(), blockeventdata.func_151339_d(), blockeventdata.func_151338_e()));
        }
    }

    private boolean func_147485_a(BlockEventData p_147485_1_) {
        BlockState blockstate = this.func_180495_p(p_147485_1_.func_180328_a());
        return blockstate.func_203425_a(p_147485_1_.func_151337_f()) ? blockstate.func_235728_a_(this, p_147485_1_.func_180328_a(), p_147485_1_.func_151339_d(), p_147485_1_.func_151338_e()) : false;
    }

    public ServerTickList<Block> func_205220_G_() {
        return this.field_94579_S;
    }

    public ServerTickList<Fluid> func_205219_F_() {
        return this.field_205342_P;
    }

    @Override
    @Nonnull
    public MinecraftServer func_73046_m() {
        return this.field_73061_a;
    }

    public Teleporter func_85176_s() {
        return this.field_85177_Q;
    }

    public TemplateManager func_184163_y() {
        return this.field_73061_a.func_240792_aT_();
    }

    public <T extends IParticleData> int func_195598_a(T p_195598_1_, double p_195598_2_, double p_195598_4_, double p_195598_6_, int p_195598_8_, double p_195598_9_, double p_195598_11_, double p_195598_13_, double p_195598_15_) {
        return this.sendParticles(null, p_195598_1_, p_195598_2_, p_195598_4_, p_195598_6_, p_195598_8_, p_195598_9_, p_195598_11_, p_195598_13_, p_195598_15_, false);
    }

    public <T extends IParticleData> int sendParticles(ServerPlayerEntity sender, T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, boolean force) {
        SSpawnParticlePacket packetplayoutworldparticles = new SSpawnParticlePacket(type, force, posX, posY, posZ, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
        int i = 0;
        for (int j = 0; j < this.field_217491_A.size(); ++j) {
            ServerPlayerEntity serverplayerentity = this.field_217491_A.get(j);
            if (sender != null && !serverplayerentity.getBukkitEntity().canSee((Player)sender.getBukkitEntity()) || !this.func_195601_a(serverplayerentity, force, posX, posY, posZ, (IPacket<?>)packetplayoutworldparticles)) continue;
            ++i;
        }
        return i;
    }

    public <T extends IParticleData> boolean func_195600_a(ServerPlayerEntity p_195600_1_, T p_195600_2_, boolean p_195600_3_, double p_195600_4_, double p_195600_6_, double p_195600_8_, int p_195600_10_, double p_195600_11_, double p_195600_13_, double p_195600_15_, double p_195600_17_) {
        SSpawnParticlePacket ipacket = new SSpawnParticlePacket(p_195600_2_, p_195600_3_, p_195600_4_, p_195600_6_, p_195600_8_, (float)p_195600_11_, (float)p_195600_13_, (float)p_195600_15_, (float)p_195600_17_, p_195600_10_);
        return this.func_195601_a(p_195600_1_, p_195600_3_, p_195600_4_, p_195600_6_, p_195600_8_, (IPacket<?>)ipacket);
    }

    private boolean func_195601_a(ServerPlayerEntity p_195601_1_, boolean p_195601_2_, double p_195601_3_, double p_195601_5_, double p_195601_7_, IPacket<?> p_195601_9_) {
        if (p_195601_1_.func_71121_q() != this) {
            return false;
        }
        BlockPos blockpos = p_195601_1_.func_233580_cy_();
        if (blockpos.func_218137_a(new Vector3d(p_195601_3_, p_195601_5_, p_195601_7_), p_195601_2_ ? 512.0 : 32.0)) {
            p_195601_1_.field_71135_a.func_147359_a(p_195601_9_);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.entity.Entity func_73045_a(int p_73045_1_) {
        return (net.minecraft.entity.Entity)this.field_217498_x.get(p_73045_1_);
    }

    @Nullable
    public net.minecraft.entity.Entity func_217461_a(UUID p_217461_1_) {
        return this.field_175741_N.get(p_217461_1_);
    }

    @Nullable
    public BlockPos func_241117_a_(Structure<?> p_241117_1_, BlockPos p_241117_2_, int p_241117_3_, boolean p_241117_4_) {
        return !this.field_73061_a.func_240793_aU_().func_230418_z_().func_236222_c_() ? null : this.func_72863_F().func_201711_g().func_235956_a_(this, p_241117_1_, p_241117_2_, p_241117_3_, p_241117_4_);
    }

    @Nullable
    public BlockPos func_241116_a_(Biome p_241116_1_, BlockPos p_241116_2_, int p_241116_3_, int p_241116_4_) {
        return this.func_72863_F().func_201711_g().func_202090_b().func_230321_a_(p_241116_2_.func_177958_n(), p_241116_2_.func_177956_o(), p_241116_2_.func_177952_p(), p_241116_3_, p_241116_4_, p_242102_1_ -> p_242102_1_ == p_241116_1_, this.field_73012_v, true);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73061_a.func_199529_aN();
    }

    @Override
    public ITagCollectionSupplier func_205772_D() {
        return this.field_73061_a.func_244266_aF();
    }

    @Override
    public boolean func_217402_u() {
        return this.field_73058_d;
    }

    public DynamicRegistries func_241828_r() {
        return this.field_73061_a.func_244267_aX();
    }

    public DimensionSavedDataManager func_217481_x() {
        return this.func_72863_F().func_217227_h();
    }

    @Override
    @Nullable
    public MapData func_217406_a(String p_217406_1_) {
        return this.func_73046_m().func_241755_D_().func_217481_x().func_215753_b(() -> {
            MapData newMap = new MapData(p_217406_1_);
            MapInitializeEvent event = new MapInitializeEvent((MapView)newMap.mapView);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            return newMap;
        }, p_217406_1_);
    }

    @Override
    public void func_217399_a(MapData p_217399_1_) {
        this.func_73046_m().func_241755_D_().func_217481_x().func_215757_a(p_217399_1_);
    }

    @Override
    public int func_217395_y() {
        return this.func_73046_m().func_241755_D_().func_217481_x().func_215752_a(MapIdTracker::new, "idcounts").func_215162_a();
    }

    public void func_241124_a__(BlockPos p_241124_1_, float p_241124_2_) {
        ChunkPos chunkpos = new ChunkPos(new BlockPos(this.field_72986_A.func_76079_c(), 0, this.field_72986_A.func_76074_e()));
        this.field_72986_A.func_176143_a(p_241124_1_, p_241124_2_);
        this.func_72863_F().func_217222_b(TicketType.field_219488_a, chunkpos, 11, Unit.INSTANCE);
        this.func_72863_F().func_217228_a(TicketType.field_219488_a, new ChunkPos(p_241124_1_), 11, Unit.INSTANCE);
        this.func_73046_m().func_184103_al().func_148540_a(new SWorldSpawnChangedPacket(p_241124_1_, p_241124_2_));
    }

    public BlockPos func_241135_u_() {
        BlockPos blockpos = new BlockPos(this.field_72986_A.func_76079_c(), this.field_72986_A.func_76075_d(), this.field_72986_A.func_76074_e());
        if (!this.func_175723_af().func_177746_a(blockpos)) {
            blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(this.func_175723_af().func_230316_a_(), 0.0, this.func_175723_af().func_230317_b_()));
        }
        return blockpos;
    }

    public float func_242107_v() {
        return this.field_72986_A.func_241860_d();
    }

    public LongSet func_217469_z() {
        ForcedChunksSaveData forcedchunkssavedata = this.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
        return forcedchunkssavedata != null ? LongSets.unmodifiable((LongSet)forcedchunkssavedata.func_212438_a()) : LongSets.EMPTY_SET;
    }

    public boolean func_217458_b(int p_217458_1_, int p_217458_2_, boolean p_217458_3_) {
        boolean flag;
        ForcedChunksSaveData forcedchunkssavedata = this.func_217481_x().func_215752_a(ForcedChunksSaveData::new, "chunks");
        ChunkPos chunkpos = new ChunkPos(p_217458_1_, p_217458_2_);
        long i = chunkpos.func_201841_a();
        if (p_217458_3_) {
            flag = forcedchunkssavedata.func_212438_a().add(i);
            if (flag) {
                this.func_212866_a_(p_217458_1_, p_217458_2_);
            }
        } else {
            flag = forcedchunkssavedata.func_212438_a().remove(i);
        }
        forcedchunkssavedata.func_76186_a(flag);
        if (flag) {
            this.func_72863_F().func_217206_a(chunkpos, p_217458_3_);
        }
        return flag;
    }

    public List<ServerPlayerEntity> func_217369_A() {
        return this.field_217491_A;
    }

    @Override
    public void func_217393_a(BlockPos p_217393_1_, BlockState p_217393_2_, BlockState p_217393_3_) {
        Optional<PointOfInterestType> optional1;
        Optional<PointOfInterestType> optional = PointOfInterestType.func_221047_b(p_217393_2_);
        if (!Objects.equals(optional, optional1 = PointOfInterestType.func_221047_b(p_217393_3_))) {
            BlockPos blockpos = p_217393_1_.func_185334_h();
            optional.ifPresent(p_241130_2_ -> this.func_73046_m().execute(() -> {
                this.func_217443_B().func_219140_a(blockpos);
                DebugPacketSender.func_218805_b((ServerWorld)this, (BlockPos)blockpos);
            }));
            optional1.ifPresent(p_217476_2_ -> this.func_73046_m().execute(() -> {
                this.func_217443_B().func_219135_a(blockpos, p_217476_2_);
                DebugPacketSender.func_218799_a((ServerWorld)this, (BlockPos)blockpos);
            }));
        }
    }

    public PointOfInterestManager func_217443_B() {
        return this.func_72863_F().func_217231_i();
    }

    public boolean func_217483_b_(BlockPos p_217483_1_) {
        return this.func_241119_a_(p_217483_1_, 1);
    }

    public boolean func_222887_a(SectionPos p_222887_1_) {
        return this.func_217483_b_(p_222887_1_.func_218160_t());
    }

    public boolean func_241119_a_(BlockPos p_241119_1_, int p_241119_2_) {
        if (p_241119_2_ > 6) {
            return false;
        }
        return this.func_217486_a(SectionPos.func_218167_a((BlockPos)p_241119_1_)) <= p_241119_2_;
    }

    public int func_217486_a(SectionPos p_217486_1_) {
        return this.func_217443_B().func_219150_a(p_217486_1_);
    }

    public RaidManager func_217452_C() {
        return this.field_217494_c;
    }

    @Nullable
    public Raid func_217475_c_(BlockPos p_217475_1_) {
        return this.field_217494_c.func_215174_a(p_217475_1_, 9216);
    }

    public boolean func_217455_d_(BlockPos p_217455_1_) {
        return this.func_217475_c_(p_217455_1_) != null;
    }

    public void func_217489_a(IReputationType p_217489_1_, net.minecraft.entity.Entity p_217489_2_, IReputationTracking p_217489_3_) {
        p_217489_3_.func_213739_a(p_217489_1_, p_217489_2_);
    }

    public void func_225322_a(Path p_225322_1_) throws IOException {
        ChunkManager chunkmanager = this.func_72863_F().field_217237_a;
        try (BufferedWriter writer = Files.newBufferedWriter(p_225322_1_.resolve("stats.txt"), new OpenOption[0]);){
            writer.write(String.format("spawning_chunks: %d\n", chunkmanager.func_219246_e().func_219358_b()));
            WorldEntitySpawner.EntityDensityManager worldentityspawner$entitydensitymanager = this.func_72863_F().func_241101_k_();
            if (worldentityspawner$entitydensitymanager != null) {
                for (Object2IntMap.Entry entry : worldentityspawner$entitydensitymanager.func_234995_b_().object2IntEntrySet()) {
                    writer.write(String.format("spawn_count.%s: %d\n", ((EntityClassification)((Object)entry.getKey())).func_220363_a(), entry.getIntValue()));
                }
            }
            writer.write(String.format("entities: %d\n", this.field_217498_x.size()));
            writer.write(String.format("block_entities: %d\n", this.field_147482_g.size()));
            writer.write(String.format("block_ticks: %d\n", this.func_205220_G_().func_225420_a()));
            writer.write(String.format("fluid_ticks: %d\n", this.func_205219_F_().func_225420_a()));
            writer.write("distance_manager: " + chunkmanager.func_219246_e().func_225412_c() + "\n");
            writer.write(String.format("pending_tasks: %d\n", this.func_72863_F().func_225314_f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.func_72914_a(crashreport);
        try (BufferedWriter writer1 = Files.newBufferedWriter(p_225322_1_.resolve("example_crash.txt"), new OpenOption[0]);){
            writer1.write(crashreport.func_71502_e());
        }
        Path path = p_225322_1_.resolve("chunks.csv");
        try (BufferedWriter writer2 = Files.newBufferedWriter(path, new OpenOption[0]);){
            chunkmanager.func_225406_a(writer2);
        }
        Path path1 = p_225322_1_.resolve("entities.csv");
        try (BufferedWriter writer3 = Files.newBufferedWriter(path1, new OpenOption[0]);){
            ServerWorld.func_225320_a(writer3, (Iterable<net.minecraft.entity.Entity>)this.field_217498_x.values());
        }
        Path path2 = p_225322_1_.resolve("block_entities.csv");
        try (BufferedWriter writer4 = Files.newBufferedWriter(path2, new OpenOption[0]);){
            this.func_225321_a(writer4);
        }
    }

    private static void func_225320_a(Writer p_225320_0_, Iterable<net.minecraft.entity.Entity> p_225320_1_) throws IOException {
        CSVWriter csvwriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("y").func_225423_a("z").func_225423_a("uuid").func_225423_a("type").func_225423_a("alive").func_225423_a("display_name").func_225423_a("custom_name").func_225422_a(p_225320_0_);
        for (net.minecraft.entity.Entity entity : p_225320_1_) {
            ITextComponent itextcomponent = entity.func_200201_e();
            ITextComponent itextcomponent1 = entity.func_145748_c_();
            csvwriter.func_225426_a(new Object[]{entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_110124_au(), Registry.field_212629_r.func_177774_c(entity.func_200600_R()), entity.func_70089_S(), itextcomponent1.getString(), itextcomponent != null ? itextcomponent.getString() : null});
        }
    }

    private void func_225321_a(Writer p_225321_1_) throws IOException {
        CSVWriter csvwriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("y").func_225423_a("z").func_225423_a("type").func_225422_a(p_225321_1_);
        for (TileEntity tileentity : this.field_147482_g) {
            BlockPos blockpos = tileentity.func_174877_v();
            csvwriter.func_225426_a(new Object[]{blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p(), Registry.field_212626_o.func_177774_c(tileentity.func_200662_C())});
        }
    }

    @VisibleForTesting
    public void func_229854_a_(MutableBoundingBox p_229854_1_) {
        this.field_147490_S.removeIf(p_241118_1_ -> p_229854_1_.func_175898_b((Vector3i)p_241118_1_.func_180328_a()));
    }

    @Override
    public void func_230547_a_(BlockPos p_230547_1_, Block p_230547_2_) {
        if (!this.func_234925_Z_()) {
            if (this.populating) {
                return;
            }
            this.func_195593_d(p_230547_1_, p_230547_2_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        return 1.0f;
    }

    public Iterable<net.minecraft.entity.Entity> func_241136_z_() {
        return Iterables.unmodifiableIterable((Iterable)this.field_217498_x.values());
    }

    public String toString() {
        return "ServerLevel[" + this.field_241103_E_.func_76065_j() + "]";
    }

    public boolean func_241109_A_() {
        return this.field_73061_a.func_240793_aU_().func_230418_z_().func_236228_i_();
    }

    public long func_72905_C() {
        return this.field_73061_a.func_240793_aU_().func_230418_z_().func_236221_b_();
    }

    @Nullable
    public DragonFightManager func_241110_C_() {
        return this.field_241105_O_;
    }

    public Stream<? extends StructureStart<?>> func_241827_a(SectionPos p_241827_1_, Structure<?> p_241827_2_) {
        return this.func_241112_a_().func_235011_a_(p_241827_1_, p_241827_2_);
    }

    public ServerWorld func_201672_e() {
        return this;
    }

    @VisibleForTesting
    public String func_244521_F() {
        return String.format("players: %s, entities: %d [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.field_217491_A.size(), this.field_217498_x.size(), ServerWorld.func_244524_a(this.field_217498_x.values(), p_244527_0_ -> Registry.field_212629_r.func_177774_c(p_244527_0_.func_200600_R())), this.field_175730_i.size(), ServerWorld.func_244524_a(this.field_175730_i, p_244526_0_ -> Registry.field_212626_o.func_177774_c(p_244526_0_.func_200662_C())), this.func_205220_G_().func_225420_a(), this.func_205219_F_().func_225420_a(), this.func_72827_u());
    }

    private static <T> String func_244524_a(Collection<T> p_244524_0_, Function<T, ResourceLocation> p_244524_1_) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t : p_244524_0_) {
                ResourceLocation resourcelocation = p_244524_1_.apply(t);
                object2intopenhashmap.addTo((Object)resourcelocation, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(p_244523_0_ -> p_244523_0_.getKey() + ":" + p_244523_0_.getIntValue()).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void func_241121_a_(ServerWorld p_241121_0_) {
        ServerWorld.makeObsidianPlatform(p_241121_0_, null);
    }

    public static void makeObsidianPlatform(ServerWorld worldserver, net.minecraft.entity.Entity entity) {
        BlockPos blockpos = field_241108_a_;
        int i = blockpos.func_177958_n();
        int j = blockpos.func_177956_o() - 2;
        int k = blockpos.func_177952_p();
        BlockStateListPopulator blockList = new BlockStateListPopulator((World)worldserver);
        BlockPos.func_191531_b(i - 2, j + 1, k - 2, i + 2, j + 3, k + 2).forEach(p_241122_1_ -> blockList.func_180501_a(p_241122_1_, Blocks.field_150350_a.func_176223_P(), 3));
        BlockPos.func_191531_b(i - 2, j, k - 2, i + 2, j, k + 2).forEach(p_241122_1_ -> blockList.func_180501_a(p_241122_1_, Blocks.field_150343_Z.func_176223_P(), 3));
        CraftWorld bworld = worldserver.getWorld();
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (org.bukkit.World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.END_PLATFORM);
        worldserver.getCBServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }

    protected void initCapabilities() {
        this.gatherCapabilities();
        this.capabilityData = this.func_217481_x().func_215752_a(() -> new WorldCapabilityData((INBTSerializable)this.getCapabilities()), "capabilities");
        this.capabilityData.setCapabilities((INBTSerializable)this.getCapabilities());
    }

    public Stream<net.minecraft.entity.Entity> getEntities() {
        return this.field_217498_x.values().stream();
    }

    public IServerWorldInfo getServerWorldInfo() {
        return this.func_73046_m().func_240793_aU_().func_230407_G_();
    }

    static {
        String ignoreEmptyTime = MohistConfigUtil.sMohist((String)"ignore_empty_time", (String)"all_worlds");
        if (ignoreEmptyTime.contains(";")) {
            for (String part : ignoreEmptyTime.split(";")) {
                IGNORE_EMPTY_TIME_LIST.add(part);
            }
        } else {
            IGNORE_EMPTY_TIME_LIST.add(ignoreEmptyTime);
        }
    }
}

