/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.spawner;

import com.google.common.collect.Lists;
import com.mohistmc.util.i18n.i18n;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public abstract class AbstractSpawner {
    private static final Logger field_209160_a = LogManager.getLogger();
    public int field_98286_b = 20;
    private final List<WeightedSpawnerEntity> field_98285_e = Lists.newArrayList();
    private WeightedSpawnerEntity field_98282_f = new WeightedSpawnerEntity();
    private double field_98287_c;
    private double field_98284_d;
    public int field_98283_g = 200;
    public int field_98293_h = 800;
    public int field_98294_i = 4;
    @Nullable
    private Entity field_98291_j;
    public int field_98292_k = 6;
    public int field_98289_l = 16;
    public int field_98290_m = 4;

    @Nullable
    public ResourceLocation func_190895_g() {
        String s = this.field_98282_f.func_185277_b().func_74779_i("id");
        try {
            return StringUtils.func_151246_b((String)s) ? null : new ResourceLocation(s);
        }
        catch (ResourceLocationException resourcelocationexception) {
            BlockPos blockpos = this.func_177221_b();
            field_209160_a.warn(i18n.get((String)"abstractspawner.1", (Object[])new Object[]{s, this.func_98271_a().func_234923_W_().func_240901_a_(), blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p()}));
            return null;
        }
    }

    public void func_200876_a(EntityType<?> p_200876_1_) {
        this.field_98282_f.func_185277_b().func_74778_a("id", Registry.field_212629_r.func_177774_c(p_200876_1_).toString());
        this.field_98285_e.clear();
    }

    private boolean func_98279_f() {
        BlockPos blockpos = this.func_177221_b();
        return this.func_98271_a().func_217358_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, this.field_98289_l);
    }

    public void func_98278_g() {
        if (!this.func_98279_f()) {
            this.field_98284_d = this.field_98287_c;
        } else {
            World world = this.func_98271_a();
            BlockPos blockpos = this.func_177221_b();
            if (!(world instanceof ServerWorld)) {
                double d3 = (double)blockpos.func_177958_n() + world.field_73012_v.nextDouble();
                double d4 = (double)blockpos.func_177956_o() + world.field_73012_v.nextDouble();
                double d5 = (double)blockpos.func_177952_p() + world.field_73012_v.nextDouble();
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d3, d4, d5, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d3, d4, d5, 0.0, 0.0, 0.0);
                if (this.field_98286_b > 0) {
                    --this.field_98286_b;
                }
                this.field_98284_d = this.field_98287_c;
                this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.field_98286_b + 200.0f))) % 360.0;
            } else {
                if (this.field_98286_b == -1) {
                    this.func_98273_j();
                }
                if (this.field_98286_b > 0) {
                    --this.field_98286_b;
                    return;
                }
                boolean flag = false;
                for (int i = 0; i < this.field_98294_i; ++i) {
                    double d2;
                    CompoundNBT compoundnbt = this.field_98282_f.func_185277_b();
                    Optional<EntityType<?>> optional = EntityType.func_220347_a(compoundnbt);
                    if (!optional.isPresent()) {
                        this.func_98273_j();
                        return;
                    }
                    ListNBT listnbt = compoundnbt.func_150295_c("Pos", 6);
                    int j = listnbt.size();
                    double d0 = j >= 1 ? listnbt.func_150309_d(0) : (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                    double d1 = j >= 2 ? listnbt.func_150309_d(1) : (double)(blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1);
                    double d = d2 = j >= 3 ? listnbt.func_150309_d(2) : (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                    if (!world.func_226664_a_(optional.get().func_220328_a(d0, d1, d2))) continue;
                    ServerWorld serverworld = (ServerWorld)world;
                    if (!EntitySpawnPlacementRegistry.func_223515_a(optional.get(), (IServerWorld)((Object)serverworld), SpawnReason.SPAWNER, new BlockPos(d0, d1, d2), world.func_201674_k())) continue;
                    Entity entity = EntityType.func_220335_a(compoundnbt, world, p_221408_6_ -> {
                        p_221408_6_.func_70012_b(d0, d1, d2, p_221408_6_.field_70177_z, p_221408_6_.field_70125_A);
                        return p_221408_6_;
                    });
                    if (entity == null) {
                        this.func_98273_j();
                        return;
                    }
                    int k = world.func_217357_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.field_98290_m)).size();
                    if (k >= this.field_98292_k) {
                        this.func_98273_j();
                        return;
                    }
                    entity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof MobEntity) {
                        MobEntity mobentity = (MobEntity)entity;
                        if (!ForgeEventFactory.canEntitySpawnSpawner((MobEntity)mobentity, (World)world, (float)((float)entity.func_226277_ct_()), (float)((float)entity.func_226278_cu_()), (float)((float)entity.func_226281_cx_()), (AbstractSpawner)this)) continue;
                        if (this.field_98282_f.func_185277_b().func_186856_d() == 1 && this.field_98282_f.func_185277_b().func_150297_b("id", 8) && !ForgeEventFactory.doSpecialSpawn((MobEntity)mobentity, (World)world, (float)((float)entity.func_226277_ct_()), (float)((float)entity.func_226278_cu_()), (float)((float)entity.func_226281_cx_()), (AbstractSpawner)this, (SpawnReason)SpawnReason.SPAWNER)) {
                            ((MobEntity)entity).func_213386_a((IServerWorld)((Object)serverworld), world.func_175649_E(entity.func_233580_cy_()), SpawnReason.SPAWNER, null, null);
                        }
                        if (mobentity.field_70170_p.spigotConfig.nerfSpawnerMobs) {
                            mobentity.aware = false;
                        }
                    }
                    if (CraftEventFactory.callSpawnerSpawnEvent((Entity)entity, (BlockPos)blockpos).isCancelled()) {
                        Entity vehicle = entity.func_184187_bx();
                        if (vehicle != null) {
                            vehicle.field_70128_L = true;
                        }
                        for (Entity passenger : entity.func_184182_bu()) {
                            passenger.field_70128_L = true;
                        }
                        continue;
                    }
                    if (!serverworld.addAllEntitiesSafely(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                        this.func_98273_j();
                        return;
                    }
                    world.func_217379_c(2004, blockpos, 0);
                    if (entity instanceof MobEntity) {
                        ((MobEntity)entity).func_70656_aK();
                    }
                    flag = true;
                }
                if (flag) {
                    this.func_98273_j();
                }
            }
        }
    }

    private void func_98273_j() {
        if (this.field_98293_h <= this.field_98283_g) {
            this.field_98286_b = this.field_98283_g;
        } else {
            int i = this.field_98293_h - this.field_98283_g;
            this.field_98286_b = this.field_98283_g + this.func_98271_a().field_73012_v.nextInt(i);
        }
        if (!this.field_98285_e.isEmpty()) {
            this.func_184993_a((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.func_98271_a().field_73012_v, this.field_98285_e));
        }
        this.func_98267_a(1);
    }

    public void func_98270_a(CompoundNBT p_98270_1_) {
        this.field_98286_b = p_98270_1_.func_74765_d("Delay");
        this.field_98285_e.clear();
        if (p_98270_1_.func_150297_b("SpawnPotentials", 9)) {
            ListNBT listnbt = p_98270_1_.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.field_98285_e.add(new WeightedSpawnerEntity(listnbt.func_150305_b(i)));
            }
        }
        if (p_98270_1_.func_150297_b("SpawnData", 10)) {
            this.func_184993_a(new WeightedSpawnerEntity(1, p_98270_1_.func_74775_l("SpawnData")));
        } else if (!this.field_98285_e.isEmpty()) {
            this.func_184993_a((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.func_98271_a().field_73012_v, this.field_98285_e));
        }
        if (p_98270_1_.func_150297_b("MinSpawnDelay", 99)) {
            this.field_98283_g = p_98270_1_.func_74765_d("MinSpawnDelay");
            this.field_98293_h = p_98270_1_.func_74765_d("MaxSpawnDelay");
            this.field_98294_i = p_98270_1_.func_74765_d("SpawnCount");
        }
        if (p_98270_1_.func_150297_b("MaxNearbyEntities", 99)) {
            this.field_98292_k = p_98270_1_.func_74765_d("MaxNearbyEntities");
            this.field_98289_l = p_98270_1_.func_74765_d("RequiredPlayerRange");
        }
        if (p_98270_1_.func_150297_b("SpawnRange", 99)) {
            this.field_98290_m = p_98270_1_.func_74765_d("SpawnRange");
        }
        if (this.func_98271_a() != null) {
            this.field_98291_j = null;
        }
    }

    public CompoundNBT func_189530_b(CompoundNBT p_189530_1_) {
        ResourceLocation resourcelocation = this.func_190895_g();
        if (resourcelocation == null) {
            return p_189530_1_;
        }
        p_189530_1_.func_74777_a("Delay", (short)this.field_98286_b);
        p_189530_1_.func_74777_a("MinSpawnDelay", (short)this.field_98283_g);
        p_189530_1_.func_74777_a("MaxSpawnDelay", (short)this.field_98293_h);
        p_189530_1_.func_74777_a("SpawnCount", (short)this.field_98294_i);
        p_189530_1_.func_74777_a("MaxNearbyEntities", (short)this.field_98292_k);
        p_189530_1_.func_74777_a("RequiredPlayerRange", (short)this.field_98289_l);
        p_189530_1_.func_74777_a("SpawnRange", (short)this.field_98290_m);
        p_189530_1_.func_218657_a("SpawnData", this.field_98282_f.func_185277_b().func_74737_b());
        ListNBT listnbt = new ListNBT();
        if (this.field_98285_e.isEmpty()) {
            listnbt.add((Object)this.field_98282_f.func_185278_a());
        } else {
            for (WeightedSpawnerEntity weightedspawnerentity : this.field_98285_e) {
                listnbt.add((Object)weightedspawnerentity.func_185278_a());
            }
        }
        p_189530_1_.func_218657_a("SpawnPotentials", (INBT)listnbt);
        return p_189530_1_;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Entity func_184994_d() {
        if (this.field_98291_j == null) {
            this.field_98291_j = EntityType.func_220335_a(this.field_98282_f.func_185277_b(), this.func_98271_a(), Function.identity());
            if (this.field_98282_f.func_185277_b().func_186856_d() != 1 || !this.field_98282_f.func_185277_b().func_150297_b("id", 8) || this.field_98291_j instanceof MobEntity) {
                // empty if block
            }
        }
        return this.field_98291_j;
    }

    public boolean func_98268_b(int p_98268_1_) {
        if (p_98268_1_ == 1 && this.func_98271_a().field_72995_K) {
            this.field_98286_b = this.field_98283_g;
            return true;
        }
        return false;
    }

    public void func_184993_a(WeightedSpawnerEntity p_184993_1_) {
        this.field_98282_f = p_184993_1_;
    }

    public abstract void func_98267_a(int var1);

    public abstract World func_98271_a();

    public abstract BlockPos func_177221_b();

    @OnlyIn(value=Dist.CLIENT)
    public double func_177222_d() {
        return this.field_98287_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_177223_e() {
        return this.field_98284_d;
    }

    @Nullable
    public Entity getSpawnerEntity() {
        return null;
    }
}

