/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.mohistmc.util.i18n.i18n;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.spigotmc.SpigotConfig;

public class PlayerData {
    private static final Logger field_237332_b_ = LogManager.getLogger();
    private final File field_237333_c_;
    protected final DataFixer field_237331_a_;

    public PlayerData(SaveFormat.LevelSave p_i232157_1_, DataFixer p_i232157_2_) {
        this.field_237331_a_ = p_i232157_2_;
        this.field_237333_c_ = p_i232157_1_.func_237285_a_(FolderName.field_237247_c_).toFile();
        this.field_237333_c_.mkdirs();
    }

    public void func_237335_a_(PlayerEntity p_237335_1_) {
        if (SpigotConfig.disablePlayerDataSaving) {
            return;
        }
        try {
            CompoundNBT compoundnbt = p_237335_1_.func_189511_e(new CompoundNBT());
            File file1 = File.createTempFile(p_237335_1_.func_189512_bd() + "-", ".dat", this.field_237333_c_);
            CompressedStreamTools.func_244264_a(compoundnbt, file1);
            File file2 = new File(this.field_237333_c_, p_237335_1_.func_189512_bd() + ".dat");
            File file3 = new File(this.field_237333_c_, p_237335_1_.func_189512_bd() + ".dat_old");
            Util.func_240977_a_(file2, file1, file3);
            ForgeEventFactory.firePlayerSavingEvent((PlayerEntity)p_237335_1_, (File)this.field_237333_c_, (String)p_237335_1_.func_189512_bd());
        }
        catch (Exception exception) {
            field_237332_b_.warn(i18n.get((String)"playerdata.1", (Object[])new Object[]{p_237335_1_.func_200200_C_().getString()}));
        }
    }

    @Nullable
    public CompoundNBT func_237336_b_(PlayerEntity p_237336_1_) {
        CompoundNBT compoundnbt = null;
        try {
            File file1 = new File(this.field_237333_c_, p_237336_1_.func_189512_bd() + ".dat");
            boolean usingWrongFile = false;
            if (!file1.exists() && (file1 = new File(this.field_237333_c_, UUID.nameUUIDFromBytes(("OfflinePlayer:" + p_237336_1_.func_200200_C_()).getBytes("UTF-8")).toString() + ".dat")).exists()) {
                usingWrongFile = true;
                Bukkit.getServer().getLogger().warning("Using offline mode UUID file for player " + p_237336_1_.func_200200_C_() + " as it is the only copy we can find.");
            }
            if (file1.exists() && file1.isFile()) {
                compoundnbt = CompressedStreamTools.func_244263_a(file1);
            }
            if (usingWrongFile) {
                file1.renameTo(new File(file1.getPath() + ".offline-read"));
            }
        }
        catch (Exception exception) {
            field_237332_b_.warn(i18n.get((String)"playerdata.2", (Object[])new Object[]{p_237336_1_.func_200200_C_().getString()}));
        }
        if (compoundnbt != null) {
            if (p_237336_1_ instanceof ServerPlayerEntity) {
                CraftPlayer cplayer = (CraftPlayer)p_237336_1_.getBukkitEntity();
                long modified = new File(this.field_237333_c_, String.valueOf(p_237336_1_.func_110124_au().toString()) + ".dat").lastModified();
                if (modified < cplayer.getFirstPlayed()) {
                    cplayer.setFirstPlayed(modified);
                }
            }
            int i = compoundnbt.func_150297_b("DataVersion", 3) ? compoundnbt.func_74762_e("DataVersion") : -1;
            p_237336_1_.func_70020_e(NBTUtil.func_210822_a(this.field_237331_a_, DefaultTypeReferences.PLAYER, compoundnbt, i));
        }
        ForgeEventFactory.firePlayerLoadingEvent((PlayerEntity)p_237336_1_, (File)this.field_237333_c_, (String)p_237336_1_.func_189512_bd());
        return compoundnbt;
    }

    public CompoundNBT getPlayerData(String s) {
        try {
            File file1 = new File(this.field_237333_c_, s + ".dat");
            if (file1.exists()) {
                return CompressedStreamTools.func_74796_a(new FileInputStream(file1));
            }
        }
        catch (Exception exception) {
            field_237332_b_.warn("Failed to load player data for " + s);
        }
        return null;
    }

    public String[] func_237334_a_() {
        String[] astring = this.field_237333_c_.list();
        if (astring == null) {
            astring = new String[]{};
        }
        for (int i = 0; i < astring.length; ++i) {
            if (!astring[i].endsWith(".dat")) continue;
            astring[i] = astring[i].substring(0, astring[i].length() - 4);
        }
        return astring;
    }

    public File getPlayerDataFolder() {
        return this.field_237333_c_;
    }
}

