/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.TimerCallbackManager;
import net.minecraft.command.TimerCallbackSerializers;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.UUIDCodec;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.VersionData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;

public class ServerWorldInfo
implements IServerWorldInfo,
IServerConfiguration {
    private static final Logger field_237341_a_ = LogManager.getLogger();
    public WorldSettings field_237342_b_;
    private final DimensionGeneratorSettings field_237343_c_;
    private final Lifecycle field_237344_d_;
    private int field_237345_e_;
    private int field_237346_f_;
    private int field_237347_g_;
    private float field_242984_h;
    private long field_237348_h_;
    private long field_237349_i_;
    @Nullable
    private final DataFixer field_237350_j_;
    private final int field_237351_k_;
    private boolean field_237352_l_;
    @Nullable
    private CompoundNBT field_237353_m_;
    private final int field_237354_n_;
    private int field_237355_o_;
    private boolean field_237356_p_;
    private int field_237357_q_;
    private boolean field_237358_r_;
    private int field_237359_s_;
    private boolean field_237360_t_;
    private boolean field_237361_u_;
    private WorldBorder.Serializer field_237362_v_;
    private CompoundNBT field_237363_w_;
    @Nullable
    private CompoundNBT field_237364_x_;
    private int field_237365_y_;
    private int field_237366_z_;
    @Nullable
    private UUID field_237337_A_;
    private final Set<String> field_237338_B_;
    private boolean field_237339_C_;
    private final TimerCallbackManager<MinecraftServer> field_237340_D_;
    public ServerWorld world;

    private ServerWorldInfo(@Nullable DataFixer p_i242043_1_, int p_i242043_2_, @Nullable CompoundNBT p_i242043_3_, boolean p_i242043_4_, int p_i242043_5_, int p_i242043_6_, int p_i242043_7_, float p_i242043_8_, long p_i242043_9_, long p_i242043_11_, int p_i242043_13_, int p_i242043_14_, int p_i242043_15_, boolean p_i242043_16_, int p_i242043_17_, boolean p_i242043_18_, boolean p_i242043_19_, boolean p_i242043_20_, WorldBorder.Serializer p_i242043_21_, int p_i242043_22_, int p_i242043_23_, @Nullable UUID p_i242043_24_, LinkedHashSet<String> p_i242043_25_, TimerCallbackManager<MinecraftServer> p_i242043_26_, @Nullable CompoundNBT p_i242043_27_, CompoundNBT p_i242043_28_, WorldSettings p_i242043_29_, DimensionGeneratorSettings p_i242043_30_, Lifecycle p_i242043_31_) {
        this.field_237350_j_ = p_i242043_1_;
        this.field_237339_C_ = p_i242043_4_;
        this.field_237345_e_ = p_i242043_5_;
        this.field_237346_f_ = p_i242043_6_;
        this.field_237347_g_ = p_i242043_7_;
        this.field_242984_h = p_i242043_8_;
        this.field_237348_h_ = p_i242043_9_;
        this.field_237349_i_ = p_i242043_11_;
        this.field_237354_n_ = p_i242043_13_;
        this.field_237355_o_ = p_i242043_14_;
        this.field_237357_q_ = p_i242043_15_;
        this.field_237356_p_ = p_i242043_16_;
        this.field_237359_s_ = p_i242043_17_;
        this.field_237358_r_ = p_i242043_18_;
        this.field_237360_t_ = p_i242043_19_;
        this.field_237361_u_ = p_i242043_20_;
        this.field_237362_v_ = p_i242043_21_;
        this.field_237365_y_ = p_i242043_22_;
        this.field_237366_z_ = p_i242043_23_;
        this.field_237337_A_ = p_i242043_24_;
        this.field_237338_B_ = p_i242043_25_;
        this.field_237353_m_ = p_i242043_3_;
        this.field_237351_k_ = p_i242043_2_;
        this.field_237340_D_ = p_i242043_26_;
        this.field_237364_x_ = p_i242043_27_;
        this.field_237363_w_ = p_i242043_28_;
        this.field_237342_b_ = p_i242043_29_;
        this.field_237343_c_ = p_i242043_30_;
        this.field_237344_d_ = p_i242043_31_;
    }

    public ServerWorldInfo(WorldSettings p_i232158_1_, DimensionGeneratorSettings p_i232158_2_, Lifecycle p_i232158_3_) {
        this(null, SharedConstants.func_215069_a().getWorldVersion(), null, false, 0, 0, 0, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.field_235925_b_, 0, 0, null, Sets.newLinkedHashSet(), new TimerCallbackManager<MinecraftServer>(TimerCallbackSerializers.field_216342_a), null, new CompoundNBT(), p_i232158_1_.func_234959_h_(), p_i232158_2_, p_i232158_3_);
    }

    public static ServerWorldInfo func_237369_a_(Dynamic<INBT> p_237369_0_, DataFixer p_237369_1_, int p_237369_2_, @Nullable CompoundNBT p_237369_3_, WorldSettings p_237369_4_, VersionData p_237369_5_, DimensionGeneratorSettings p_237369_6_, Lifecycle p_237369_7_) {
        long i = p_237369_0_.get("Time").asLong(0L);
        CompoundNBT compoundnbt = (CompoundNBT)p_237369_0_.get("DragonFight").result().map(Dynamic::getValue).orElseGet(() -> (INBT)p_237369_0_.get("DimensionData").get("1").get("DragonFight").orElseEmptyMap().getValue());
        return new ServerWorldInfo(p_237369_1_, p_237369_2_, p_237369_3_, p_237369_0_.get("WasModded").asBoolean(false), p_237369_0_.get("SpawnX").asInt(0), p_237369_0_.get("SpawnY").asInt(0), p_237369_0_.get("SpawnZ").asInt(0), p_237369_0_.get("SpawnAngle").asFloat(0.0f), i, p_237369_0_.get("DayTime").asLong(i), p_237369_5_.func_237323_a_(), p_237369_0_.get("clearWeatherTime").asInt(0), p_237369_0_.get("rainTime").asInt(0), p_237369_0_.get("raining").asBoolean(false), p_237369_0_.get("thunderTime").asInt(0), p_237369_0_.get("thundering").asBoolean(false), p_237369_0_.get("initialized").asBoolean(true), p_237369_0_.get("DifficultyLocked").asBoolean(false), WorldBorder.Serializer.func_235938_a_(p_237369_0_, WorldBorder.field_235925_b_), p_237369_0_.get("WanderingTraderSpawnDelay").asInt(0), p_237369_0_.get("WanderingTraderSpawnChance").asInt(0), p_237369_0_.get("WanderingTraderId").read((Decoder)UUIDCodec.field_239775_a_).result().orElse(null), p_237369_0_.get("ServerBrands").asStream().flatMap(p_237368_0_ -> Util.func_215081_a(p_237368_0_.asString().result())).collect(Collectors.toCollection(Sets::newLinkedHashSet)), new TimerCallbackManager<MinecraftServer>(TimerCallbackSerializers.field_216342_a, p_237369_0_.get("ScheduledEvents").asStream()), (CompoundNBT)p_237369_0_.get("CustomBossEvents").orElseEmptyMap().getValue(), compoundnbt, p_237369_4_, p_237369_6_, p_237369_7_);
    }

    public CompoundNBT func_230411_a_(DynamicRegistries p_230411_1_, @Nullable CompoundNBT p_230411_2_) {
        this.func_237367_I_();
        if (p_230411_2_ == null) {
            p_230411_2_ = this.field_237353_m_;
        }
        CompoundNBT compoundnbt = new CompoundNBT();
        this.func_237370_a_(p_230411_1_, compoundnbt, p_230411_2_);
        return compoundnbt;
    }

    private void func_237370_a_(DynamicRegistries p_237370_1_, CompoundNBT p_237370_2_, @Nullable CompoundNBT p_237370_3_) {
        ListNBT listnbt = new ListNBT();
        this.field_237338_B_.stream().map(StringNBT::func_229705_a_).forEach(arg_0 -> listnbt.add(arg_0));
        p_237370_2_.func_218657_a("ServerBrands", (INBT)listnbt);
        p_237370_2_.func_74757_a("WasModded", this.field_237339_C_);
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("Name", SharedConstants.func_215069_a().getName());
        compoundnbt.func_74768_a("Id", SharedConstants.func_215069_a().getWorldVersion());
        compoundnbt.func_74757_a("Snapshot", !SharedConstants.func_215069_a().isStable());
        p_237370_2_.func_218657_a("Version", compoundnbt);
        p_237370_2_.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        WorldGenSettingsExport worldgensettingsexport = WorldGenSettingsExport.func_240896_a_((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicRegistries)p_237370_1_);
        DimensionGeneratorSettings.field_236201_a_.encodeStart((DynamicOps)worldgensettingsexport, (Object)this.field_237343_c_).resultOrPartial(Util.func_240982_a_("WorldGenSettings: ", arg_0 -> ((Logger)field_237341_a_).error(arg_0))).ifPresent(p_237373_1_ -> p_237370_2_.func_218657_a("WorldGenSettings", (INBT)p_237373_1_));
        p_237370_2_.func_74768_a("GameType", this.field_237342_b_.func_234953_b_().func_77148_a());
        p_237370_2_.func_74768_a("SpawnX", this.field_237345_e_);
        p_237370_2_.func_74768_a("SpawnY", this.field_237346_f_);
        p_237370_2_.func_74768_a("SpawnZ", this.field_237347_g_);
        p_237370_2_.func_74776_a("SpawnAngle", this.field_242984_h);
        p_237370_2_.func_74772_a("Time", this.field_237348_h_);
        p_237370_2_.func_74772_a("DayTime", this.field_237349_i_);
        p_237370_2_.func_74772_a("LastPlayed", Util.func_211179_d());
        p_237370_2_.func_74778_a("LevelName", this.field_237342_b_.func_234947_a_());
        p_237370_2_.func_74768_a("version", 19133);
        p_237370_2_.func_74768_a("clearWeatherTime", this.field_237355_o_);
        p_237370_2_.func_74768_a("rainTime", this.field_237357_q_);
        p_237370_2_.func_74757_a("raining", this.field_237356_p_);
        p_237370_2_.func_74768_a("thunderTime", this.field_237359_s_);
        p_237370_2_.func_74757_a("thundering", this.field_237358_r_);
        p_237370_2_.func_74757_a("hardcore", this.field_237342_b_.func_234954_c_());
        p_237370_2_.func_74757_a("allowCommands", this.field_237342_b_.func_234956_e_());
        p_237370_2_.func_74757_a("initialized", this.field_237360_t_);
        this.field_237362_v_.func_235939_a_(p_237370_2_);
        p_237370_2_.func_74774_a("Difficulty", (byte)this.field_237342_b_.func_234955_d_().func_151525_a());
        p_237370_2_.func_74757_a("DifficultyLocked", this.field_237361_u_);
        p_237370_2_.func_218657_a("GameRules", this.field_237342_b_.func_234957_f_().func_82770_a());
        p_237370_2_.func_218657_a("DragonFight", this.field_237363_w_);
        if (p_237370_3_ != null) {
            p_237370_2_.func_218657_a("Player", p_237370_3_);
        }
        DatapackCodec.field_234881_b_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.field_237342_b_.func_234958_g_()).result().ifPresent(p_237371_1_ -> p_237370_2_.func_218657_a("DataPacks", (INBT)p_237371_1_));
        if (this.field_237364_x_ != null) {
            p_237370_2_.func_218657_a("CustomBossEvents", this.field_237364_x_);
        }
        p_237370_2_.func_218657_a("ScheduledEvents", (INBT)this.field_237340_D_.func_216327_b());
        p_237370_2_.func_74768_a("WanderingTraderSpawnDelay", this.field_237365_y_);
        p_237370_2_.func_74768_a("WanderingTraderSpawnChance", this.field_237366_z_);
        if (this.field_237337_A_ != null) {
            p_237370_2_.func_186854_a("WanderingTraderId", this.field_237337_A_);
        }
        p_237370_2_.func_74778_a("Bukkit.Version", "Mohist/1.16.5/1.16.5");
    }

    public int func_76079_c() {
        return this.field_237345_e_;
    }

    public int func_76075_d() {
        return this.field_237346_f_;
    }

    public int func_76074_e() {
        return this.field_237347_g_;
    }

    public float func_241860_d() {
        return this.field_242984_h;
    }

    public long func_82573_f() {
        return this.field_237348_h_;
    }

    public long func_76073_f() {
        return this.field_237349_i_;
    }

    private void func_237367_I_() {
        if (!this.field_237352_l_ && this.field_237353_m_ != null) {
            if (this.field_237351_k_ < SharedConstants.func_215069_a().getWorldVersion()) {
                if (this.field_237350_j_ == null) {
                    throw Util.func_229757_c_(new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded."));
                }
                this.field_237353_m_ = NBTUtil.func_210822_a(this.field_237350_j_, DefaultTypeReferences.PLAYER, this.field_237353_m_, this.field_237351_k_);
            }
            this.field_237352_l_ = true;
        }
    }

    public CompoundNBT func_230416_x_() {
        this.func_237367_I_();
        return this.field_237353_m_;
    }

    public void func_76058_a(int p_76058_1_) {
        this.field_237345_e_ = p_76058_1_;
    }

    public void func_76056_b(int p_76056_1_) {
        this.field_237346_f_ = p_76056_1_;
    }

    public void func_76087_c(int p_76087_1_) {
        this.field_237347_g_ = p_76087_1_;
    }

    public void func_241859_a(float p_241859_1_) {
        this.field_242984_h = p_241859_1_;
    }

    public void func_82572_b(long p_82572_1_) {
        this.field_237348_h_ = p_82572_1_;
    }

    public void func_76068_b(long p_76068_1_) {
        this.field_237349_i_ = p_76068_1_;
    }

    public void func_176143_a(BlockPos p_176143_1_, float p_176143_2_) {
        this.field_237345_e_ = p_176143_1_.func_177958_n();
        this.field_237346_f_ = p_176143_1_.func_177956_o();
        this.field_237347_g_ = p_176143_1_.func_177952_p();
        this.field_242984_h = p_176143_2_;
    }

    public String func_76065_j() {
        return this.field_237342_b_.func_234947_a_();
    }

    public int func_230417_y_() {
        return this.field_237354_n_;
    }

    public int func_230395_g_() {
        return this.field_237355_o_;
    }

    public void func_230391_a_(int p_230391_1_) {
        this.field_237355_o_ = p_230391_1_;
    }

    public boolean func_76061_m() {
        return this.field_237358_r_;
    }

    public void func_76069_a(boolean p_76069_1_) {
        if (this.field_237358_r_ == p_76069_1_) {
            return;
        }
        World world = Bukkit.getWorld((String)this.func_76065_j());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, p_76069_1_);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.field_237358_r_ = p_76069_1_;
    }

    public int func_76071_n() {
        return this.field_237359_s_;
    }

    public void func_76090_f(int p_76090_1_) {
        this.field_237359_s_ = p_76090_1_;
    }

    public boolean func_76059_o() {
        return this.field_237356_p_;
    }

    public void func_76084_b(boolean p_76084_1_) {
        if (this.field_237356_p_ == p_76084_1_) {
            return;
        }
        World world = Bukkit.getWorld((String)this.func_76065_j());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, p_76084_1_);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.field_237356_p_ = p_76084_1_;
    }

    public int func_76083_p() {
        return this.field_237357_q_;
    }

    public void func_76080_g(int p_76080_1_) {
        this.field_237357_q_ = p_76080_1_;
    }

    public GameType func_76077_q() {
        return this.field_237342_b_.func_234953_b_();
    }

    public void func_230392_a_(GameType p_230392_1_) {
        this.field_237342_b_ = this.field_237342_b_.func_234950_a_(p_230392_1_);
    }

    public boolean func_76093_s() {
        return this.field_237342_b_.func_234954_c_();
    }

    public boolean func_76086_u() {
        return this.field_237342_b_.func_234956_e_();
    }

    public boolean func_76070_v() {
        return this.field_237360_t_;
    }

    public void func_76091_d(boolean p_76091_1_) {
        this.field_237360_t_ = p_76091_1_;
    }

    public GameRules func_82574_x() {
        return this.field_237342_b_.func_234957_f_();
    }

    public WorldBorder.Serializer func_230398_q_() {
        return this.field_237362_v_;
    }

    public void func_230393_a_(WorldBorder.Serializer p_230393_1_) {
        this.field_237362_v_ = p_230393_1_;
    }

    public Difficulty func_176130_y() {
        return this.field_237342_b_.func_234955_d_();
    }

    public void func_230409_a_(Difficulty p_230409_1_) {
        this.field_237342_b_ = this.field_237342_b_.func_234948_a_(p_230409_1_);
    }

    public boolean func_176123_z() {
        return this.field_237361_u_;
    }

    public void func_230415_d_(boolean p_230415_1_) {
        this.field_237361_u_ = p_230415_1_;
    }

    public TimerCallbackManager<MinecraftServer> func_215763_z() {
        return this.field_237340_D_;
    }

    public void func_85118_a(CrashReportCategory p_85118_1_) {
        super.func_85118_a(p_85118_1_);
        super.func_85118_a(p_85118_1_);
    }

    public DimensionGeneratorSettings func_230418_z_() {
        return this.field_237343_c_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Lifecycle func_230401_A_() {
        return this.field_237344_d_;
    }

    public CompoundNBT func_230402_B_() {
        return this.field_237363_w_;
    }

    public void func_230413_a_(CompoundNBT p_230413_1_) {
        this.field_237363_w_ = p_230413_1_;
    }

    public DatapackCodec func_230403_C_() {
        return this.field_237342_b_.func_234958_g_();
    }

    public void func_230410_a_(DatapackCodec p_230410_1_) {
        this.field_237342_b_ = this.field_237342_b_.func_234949_a_(p_230410_1_);
    }

    @Nullable
    public CompoundNBT func_230404_D_() {
        return this.field_237364_x_;
    }

    public void func_230414_b_(@Nullable CompoundNBT p_230414_1_) {
        this.field_237364_x_ = p_230414_1_;
    }

    public int func_230399_u_() {
        return this.field_237365_y_;
    }

    public void func_230396_g_(int p_230396_1_) {
        this.field_237365_y_ = p_230396_1_;
    }

    public int func_230400_v_() {
        return this.field_237366_z_;
    }

    public void func_230397_h_(int p_230397_1_) {
        this.field_237366_z_ = p_230397_1_;
    }

    public void func_230394_a_(UUID p_230394_1_) {
        this.field_237337_A_ = p_230394_1_;
    }

    public void func_230412_a_(String p_230412_1_, boolean p_230412_2_) {
        this.field_237338_B_.add(p_230412_1_);
        this.field_237339_C_ |= p_230412_2_;
    }

    public boolean func_230405_E_() {
        return this.field_237339_C_;
    }

    public Set<String> func_230406_F_() {
        return ImmutableSet.copyOf(this.field_237338_B_);
    }

    public IServerWorldInfo func_230407_G_() {
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public WorldSettings func_230408_H_() {
        return this.field_237342_b_.func_234959_h_();
    }

    public void checkName(String name) {
        if (!this.field_237342_b_.field_234943_a_.equals(name)) {
            this.field_237342_b_.field_234943_a_ = name;
        }
    }
}

