/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.contributor.client.RewardLayer;

public interface ITierProvider {
    public String getAuthor();

    public Set<String> getTiers();

    public List<String> getRenderableTiers();

    public Set<String> getPlayerTiers(String var1);

    default public CompletableFuture<Void> refresh() {
        return CompletableFuture.completedFuture(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public RewardLayer createRenderer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> var1, String var2);

    default public boolean isContributor(String playerName) {
        return !this.getPlayerTiers(playerName).isEmpty();
    }

    default public boolean isContributor(String playerName, String tier) {
        return this.getPlayerTiers(playerName).contains(tier);
    }

    public static enum Empty implements ITierProvider
    {
        INSTANCE;


        @Override
        public String getAuthor() {
            return "";
        }

        @Override
        public Set<String> getTiers() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<String> getPlayerTiers(String playerName) {
            return Collections.EMPTY_SET;
        }

        @Override
        public List<String> getRenderableTiers() {
            return Collections.EMPTY_LIST;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public RewardLayer createRenderer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRenderer, String tier) {
            return null;
        }
    }
}

