/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.contributor.Contributors;

@OnlyIn(value=Dist.CLIENT)
public class RewardScreen
extends Screen {
    private List list;
    @Nullable
    private ResourceLocation currentReward;
    private Entry selectedEntry;

    public RewardScreen() {
        super((ITextComponent)new TranslationTextComponent("gui.kiwi.reward"));
    }

    protected void func_231160_c_() {
        this.currentReward = Contributors.PLAYER_EFFECTS.get(RewardScreen.getPlayerName());
        this.list = new List(this.field_230706_i_, 150, this.field_230709_l_, 0, this.field_230709_l_, 20);
        this.list.func_230959_g_(20);
        this.selectedEntry = new Entry(this, null);
        this.list.addEntry(this.selectedEntry);
        String playerName = RewardScreen.getPlayerName();
        boolean added = false;
        for (ResourceLocation tier : Contributors.getRenderableTiers()) {
            if (!Contributors.isContributor(tier.func_110624_b(), playerName, tier.func_110623_a())) continue;
            Entry entry = new Entry(this, tier);
            this.list.addEntry(entry);
            added = true;
            if (!tier.equals((Object)this.currentReward)) continue;
            this.selectedEntry = entry;
        }
        if (!added) {
            this.field_230706_i_.func_147108_a(null);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float pTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, pTicks);
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, pTicks);
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.list.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        return super.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        this.list.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        return super.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.list.func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        return super.func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        this.list.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
        return super.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        this.list.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.list = null;
        ConfigHandler cfg = KiwiConfigManager.getHandler(KiwiClientConfig.class);
        ForgeConfigSpec.ConfigValue<?> val = cfg.getValueByPath("contributorEffect");
        if (this.currentReward != null && this.selectedEntry.id == null) {
            val.set((Object)"");
            cfg.refresh();
            Contributors.changeEffect();
        } else if (this.selectedEntry != null && !Objects.equals(this.selectedEntry.id, this.currentReward)) {
            val.set((Object)this.selectedEntry.id.toString());
            cfg.refresh();
            Contributors.changeEffect();
        }
    }

    private static String getPlayerName() {
        return Minecraft.func_71410_x().func_110432_I().func_111285_a();
    }

    private static class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
        private final RewardScreen parent;
        @Nullable
        private final ResourceLocation id;
        private final String name;

        public Entry(RewardScreen parent, ResourceLocation id) {
            this.parent = parent;
            this.id = id;
            this.name = id == null ? "-" : I18n.func_135052_a((String)Util.func_200697_a((String)"reward", (ResourceLocation)id), (Object[])new Object[0]);
        }

        public void func_230432_a_(MatrixStack matrixStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hover, float partialTicks) {
            int color;
            int n = color = hover ? 0xFFFFAA : 0xFFFFFF;
            if (this == this.parent.selectedEntry) {
                color = 0xFFFF77;
            }
            this.parent.field_230712_o_.func_238421_b_(matrixStack, this.name, (float)(left + 43), (float)(top + 2), color);
        }

        public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.parent.selectedEntry = this;
            return false;
        }
    }

    private static class List
    extends ExtendedList<Entry> {
        public List(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
            super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        }

        public int addEntry(Entry p_addEntry_1_) {
            return super.func_230513_b_((AbstractList.AbstractListEntry)p_addEntry_1_);
        }
    }
}

