/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.network;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import snownee.kiwi.network.Packet;

public enum NetworkChannel {
    INSTANCE;

    private static final String PROTOCOL_VERSION;
    private final Map<Class<?>, SimpleChannel> packet2channel = Maps.newConcurrentMap();
    private final Map<ResourceLocation, Pair<SimpleChannel, AtomicInteger>> channels = Maps.newConcurrentMap();
    public static final PacketDistributor<ServerPlayerEntity> ALL_EXCEPT;

    public static <T extends Packet> void register(Class<T> klass, Packet.PacketHandler<T> handler) {
        NetworkChannel.register(klass, handler, "main");
    }

    public static <T extends Packet> void register(Class<T> klass, Packet.PacketHandler<T> handler, String channelName) {
        String modid = ModLoadingContext.get().getActiveNamespace();
        if ("minecraft".equals(modid)) {
            throw new IllegalStateException("ModLoadingContext cannot detect modid while registering packet: " + klass);
        }
        ResourceLocation id = new ResourceLocation(modid, channelName);
        Pair pair = NetworkChannel.INSTANCE.channels.computeIfAbsent(id, $ -> {
            SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)id).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
            return Pair.of((Object)channel, (Object)new AtomicInteger());
        });
        NetworkChannel.INSTANCE.packet2channel.put(klass, (SimpleChannel)pair.getKey());
        ((SimpleChannel)pair.getKey()).registerMessage(((AtomicInteger)pair.getValue()).getAndIncrement(), klass, handler::encode, handler::decode, handler::handle);
    }

    public static SimpleChannel channel(Class<?> klass) {
        return NetworkChannel.INSTANCE.packet2channel.get(klass);
    }

    public static void send(PacketDistributor.PacketTarget target, Packet packet) {
        NetworkChannel.channel(packet.getClass()).send(target, (Object)packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(Packet packet) {
        NetworkChannel.channel(packet.getClass()).sendToServer((Object)packet);
    }

    private static MinecraftServer getServer() {
        return (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
    }

    public static void sendToAllExcept(ServerPlayerEntity player, Packet packet) {
        NetworkChannel.send(ALL_EXCEPT.with(() -> player), packet);
    }

    private static /* synthetic */ void lambda$static$3(Supplier player, IPacket p) {
        NetworkChannel.getServer().func_184103_al().func_181057_v().forEach(arg_0 -> NetworkChannel.lambda$static$2((Supplier)player, p, arg_0));
    }

    private static /* synthetic */ void lambda$static$2(Supplier player, IPacket p, ServerPlayerEntity player2) {
        if (player.get() != player2) {
            player2.field_71135_a.field_147371_a.func_179290_a(p);
        }
    }

    static {
        PROTOCOL_VERSION = Integer.toString(1);
        ALL_EXCEPT = new PacketDistributor((dist, player) -> arg_0 -> NetworkChannel.lambda$static$3((Supplier)player, arg_0), NetworkDirection.PLAY_TO_CLIENT);
    }
}

