/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.ai.brain.task.FarmerWorkTask;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLModIdMappingEvent;
import snownee.kiwi.Kiwi;

public final class DeferredActions {
    private static boolean executed;
    private static final Queue<Runnable> actions;

    private DeferredActions() {
    }

    public static void add(Runnable action) {
        actions.add(action);
    }

    public static void setFireInfo(Block blockIn, int encouragement, int flammability) {
        DeferredActions.add(() -> ((FireBlock)Blocks.field_150480_ab).func_180686_a(blockIn, encouragement, flammability));
    }

    public static void registerHoeConversion(Block k, BlockState v) {
        DeferredActions.add(() -> HoeItem.field_195973_b.put(k, v));
    }

    public static void registerAxeConversion(Block k, Block v) {
        DeferredActions.add(() -> {
            if (AxeItem.field_203176_a instanceof ImmutableMap) {
                AxeItem.field_203176_a = Maps.newHashMap((Map)AxeItem.field_203176_a);
            }
            AxeItem.field_203176_a.put(k, v);
        });
    }

    public static void registerCompostable(float chance, IItemProvider itemIn) {
        DeferredActions.add(() -> ComposterBlock.field_220299_b.put((Object)itemIn.func_199767_j(), chance));
    }

    public static void registerVillagerPickupable(IItemProvider item) {
        DeferredActions.add(() -> {
            if (VillagerEntity.field_213776_bD instanceof ImmutableSet) {
                VillagerEntity.field_213776_bD = Sets.newHashSet((Iterable)VillagerEntity.field_213776_bD);
            }
            VillagerEntity.field_213776_bD.add(item.func_199767_j());
        });
    }

    public static void registerVillagerCompostable(IItemProvider item) {
        DeferredActions.add(() -> {
            if (FarmerWorkTask.field_234014_b_ instanceof ImmutableList) {
                FarmerWorkTask.field_234014_b_ = Lists.newArrayList((Iterable)FarmerWorkTask.field_234014_b_);
            }
            FarmerWorkTask.field_234014_b_.add(item.func_199767_j());
        });
    }

    private static void execute(FMLModIdMappingEvent event) {
        if (executed) {
            return;
        }
        executed = true;
        if (actions.isEmpty()) {
            return;
        }
        Kiwi.logger.debug("Executing {} deferred actions", (Object)actions.size());
        actions.forEach(Runnable::run);
        actions.clear();
    }

    static {
        actions = new ConcurrentLinkedQueue<Runnable>();
        MinecraftForge.EVENT_BUS.addListener(DeferredActions::execute);
    }
}

