/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public final class MathUtil {
    private MathUtil() {
    }

    public static List<Vector3d> fibonacciSphere(Vector3d start, double radius, int samples, boolean randomize) {
        double rnd = 1.0;
        if (randomize) {
            rnd = Math.random() * (double)samples;
        }
        double offset = 2.0 / (double)samples;
        double increment = Math.PI * (3.0 - Math.sqrt(5.0));
        ArrayList points = Lists.newArrayListWithCapacity((int)samples);
        for (int i = 0; i < samples; ++i) {
            double y = (double)i * offset - 1.0 + offset / 2.0;
            double r = Math.sqrt(1.0 - y * y) * radius;
            double phi = ((double)i + rnd) % (double)samples * increment;
            double x = Math.cos(phi) * r;
            double z = Math.sin(phi) * r;
            points.add(new Vector3d(start.field_72450_a + x, start.field_72448_b + y * radius, start.field_72449_c + z));
        }
        return points;
    }

    public static int posOnLine(Vector3d start, Vector3d end, Collection<BlockPos> list) {
        list.add(new BlockPos(start));
        if (start.equals((Object)end)) {
            return 1;
        }
        int c = 1;
        double ex = MathHelper.func_219803_d((double)-1.0E-7, (double)end.field_72450_a, (double)start.field_72450_a);
        double ey = MathHelper.func_219803_d((double)-1.0E-7, (double)end.field_72448_b, (double)start.field_72448_b);
        double ez = MathHelper.func_219803_d((double)-1.0E-7, (double)end.field_72449_c, (double)start.field_72449_c);
        double sx = MathHelper.func_219803_d((double)-1.0E-7, (double)start.field_72450_a, (double)end.field_72450_a);
        double sy = MathHelper.func_219803_d((double)-1.0E-7, (double)start.field_72448_b, (double)end.field_72448_b);
        double sz = MathHelper.func_219803_d((double)-1.0E-7, (double)start.field_72449_c, (double)end.field_72449_c);
        int x = MathHelper.func_76128_c((double)sx);
        int y = MathHelper.func_76128_c((double)sy);
        int z = MathHelper.func_76128_c((double)sz);
        double subX = ex - sx;
        double subY = ey - sy;
        double subZ = ez - sz;
        int signX = MathHelper.func_219802_k((double)subX);
        int signY = MathHelper.func_219802_k((double)subY);
        int signZ = MathHelper.func_219802_k((double)subZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / subX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / subY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / subZ;
        double d12 = d9 * (signX > 0 ? 1.0 - MathHelper.func_181162_h((double)sx) : MathHelper.func_181162_h((double)sx));
        double d13 = d10 * (signY > 0 ? 1.0 - MathHelper.func_181162_h((double)sy) : MathHelper.func_181162_h((double)sy));
        double d14 = d11 * (signZ > 0 ? 1.0 - MathHelper.func_181162_h((double)sz) : MathHelper.func_181162_h((double)sz));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            if (d12 < d13) {
                if (d12 < d14) {
                    x += signX;
                    d12 += d9;
                } else {
                    z += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                y += signY;
                d13 += d10;
            } else {
                z += signZ;
                d14 += d11;
            }
            list.add(new BlockPos(x, y, z));
            ++c;
        }
        return c;
    }

    public static Vector3f RGBtoHSV(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int max = Math.max(r, Math.max(g, b));
        int min = Math.min(r, Math.min(g, b));
        float v = max;
        float delta = max - min;
        if (max == 0) {
            float s = 0.0f;
            float h = -1.0f;
            return new Vector3f(h, s, 0.0f);
        }
        float s = delta / (float)max;
        float h = r == max ? (float)(g - b) / delta : (g == max ? 2.0f + (float)(b - r) / delta : 4.0f + (float)(r - g) / delta);
        h /= 6.0f;
        if (h < 0.0f) {
            h += 1.0f;
        }
        return new Vector3f(h, s, v / 255.0f);
    }
}

