/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.awt.geom.Point2D;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public final class VoxelUtil {
    private VoxelUtil() {
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, Direction facing) {
        Point2D.Double pointMin = VoxelUtil.rotate(new Point2D.Double(aabb.field_72340_a, aabb.field_72339_c), facing);
        Point2D.Double pointMax = VoxelUtil.rotate(new Point2D.Double(aabb.field_72336_d, aabb.field_72334_f), facing);
        return new AxisAlignedBB(pointMin.x, aabb.field_72338_b, pointMin.y, pointMax.x, aabb.field_72337_e, pointMax.y);
    }

    public static VoxelShape rotate(VoxelShape shape, Direction facing) {
        VSBuilder builder = new VSBuilder();
        shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            Point2D.Double pointMin = VoxelUtil.rotate(new Point2D.Double(Math.min(x1, x2), Math.min(z1, z2)), facing);
            Point2D.Double pointMax = VoxelUtil.rotate(new Point2D.Double(Math.max(x1, x2), Math.max(z1, z2)), facing);
            builder.add(VoxelShapes.func_197873_a((double)pointMin.x, (double)Math.min(y1, y2), (double)pointMin.y, (double)pointMax.x, (double)Math.max(y1, y2), (double)pointMax.y));
        });
        return builder.get();
    }

    public static Point2D.Double rotate(Point2D.Double point, Direction facing) {
        double x = point.x - 0.5;
        double y = point.y - 0.5;
        Point2D.Double pointNew = new Point2D.Double();
        double d = pointNew.x = facing.func_176736_b() % 2 == 0 ? x : y;
        if (facing.func_176736_b() < 2) {
            pointNew.x *= -1.0;
        }
        double d2 = pointNew.y = facing.func_176736_b() % 2 == 0 ? y : x;
        if (facing.func_176736_b() == 1 || facing.func_176736_b() == 2) {
            pointNew.y *= -1.0;
        }
        pointNew.x += 0.5;
        pointNew.y += 0.5;
        return pointNew;
    }

    private static class VSBuilder {
        VoxelShape shape;

        public void add(VoxelShape newShape) {
            this.shape = this.shape == null ? newShape : VoxelShapes.func_197882_b((VoxelShape)this.shape, (VoxelShape)newShape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }

        public VoxelShape get() {
            return this.shape.func_197753_c();
        }
    }
}

