/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.chat;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.chat.ChatStore;
import java.util.Map;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import net.ess3.api.IUser;
import org.bukkit.Server;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public abstract class EssentialsChatPlayer
implements Listener {
    static final Logger logger = Logger.getLogger("EssentialsChat");
    final transient IEssentials ess;
    final transient Server server;
    private final transient Map<AsyncPlayerChatEvent, ChatStore> chatStorage;

    EssentialsChatPlayer(Server server, IEssentials ess, Map<AsyncPlayerChatEvent, ChatStore> chatStorage) {
        this.ess = ess;
        this.server = server;
        this.chatStorage = chatStorage;
    }

    public abstract void onPlayerChat(AsyncPlayerChatEvent var1);

    boolean isAborted(AsyncPlayerChatEvent event) {
        return event.isCancelled();
    }

    String getChatType(User user, String message) {
        if (message.length() == 0) {
            return "";
        }
        char prefix = message.charAt(0);
        if (prefix == this.ess.getSettings().getChatShout() || user.isToggleShout()) {
            return message.length() > 1 ? "shout" : "";
        }
        if (prefix == this.ess.getSettings().getChatQuestion()) {
            return message.length() > 1 ? "question" : "";
        }
        return "";
    }

    ChatStore getChatStore(AsyncPlayerChatEvent event) {
        return this.chatStorage.get(event);
    }

    void setChatStore(AsyncPlayerChatEvent event, ChatStore chatStore) {
        this.chatStorage.put(event, chatStore);
    }

    ChatStore delChatStore(AsyncPlayerChatEvent event) {
        return this.chatStorage.remove(event);
    }

    private void charge(User user, Trade charge) throws ChargeException {
        charge.charge((IUser)user);
    }

    boolean charge(AsyncPlayerChatEvent event, ChatStore chatStore) {
        try {
            this.charge(chatStore.getUser(), chatStore.getCharge());
        }
        catch (ChargeException e) {
            this.ess.showError(chatStore.getUser().getSource(), (Throwable)e, "\\ chat " + chatStore.getLongType());
            event.setCancelled(true);
            return false;
        }
        return true;
    }
}

