/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModEntityTypes;
import mod.beethoven92.betterendforge.common.init.ModSoundEvents;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class DragonflyEntity
extends AnimalEntity
implements IFlyingAnimal {
    public DragonflyEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.field_70749_g = new DragonflyLookControl((MobEntity)this);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.field_70728_aV = 1;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new WanderAroundGoal());
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.1).func_233815_a_(Attributes.field_233822_e_, 1.0);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingNavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                BlockState state = this.field_75513_b.func_180495_p(pos);
                return state.func_196958_f() || !state.func_185904_a().func_76230_c();
            }

            public void func_75501_e() {
                super.func_75501_e();
            }
        };
        flyingNavigator.func_192878_b(false);
        flyingNavigator.func_212239_d(false);
        flyingNavigator.func_192879_a(false);
        return flyingNavigator;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.ENTITY_DRAGONFLY.get();
    }

    protected float func_70599_aP() {
        return ModMathHelper.randRange(0.25f, 0.5f, this.field_70146_Z);
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)((EntityType)ModEntityTypes.DRAGONFLY.get()).func_200721_a(this.field_70170_p);
    }

    public static boolean canSpawn(EntityType<DragonflyEntity> type, IServerWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        AxisAlignedBB box = new AxisAlignedBB(pos).func_186662_g(16.0);
        List list = world.func_175647_a(DragonflyEntity.class, box, entity -> true);
        int y = world.func_217349_x(pos).func_201576_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF);
        return y > 0 && pos.func_177956_o() >= y && list.size() < 9;
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return DragonflyEntity.this.field_70699_by.func_75500_f() && DragonflyEntity.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return DragonflyEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Path path;
            BlockPos pos;
            Vector3d vec3d = this.getRandomLocation();
            if (vec3d != null && !(pos = new BlockPos(vec3d)).equals((Object)DragonflyEntity.this.func_233580_cy_()) && (path = DragonflyEntity.this.field_70699_by.func_179680_a(new BlockPos(vec3d), 1)) != null) {
                DragonflyEntity.this.field_70699_by.func_75484_a(path, 1.0);
            }
            super.func_75249_e();
        }

        private Vector3d getRandomLocation() {
            int h = BlockHelper.downRay((IWorldReader)DragonflyEntity.this.field_70170_p, DragonflyEntity.this.func_233580_cy_(), 16);
            Vector3d rotation = DragonflyEntity.this.func_70676_i(0.0f);
            Vector3d airPos = RandomPositionGenerator.func_226340_a_((CreatureEntity)DragonflyEntity.this, (int)8, (int)7, (Vector3d)rotation, (float)1.5707964f, (int)2, (int)1);
            if (airPos != null) {
                if (this.isInVoid(airPos)) {
                    for (int i = 0; i < 8; ++i) {
                        airPos = RandomPositionGenerator.func_226340_a_((CreatureEntity)DragonflyEntity.this, (int)16, (int)7, (Vector3d)rotation, (float)((float)Math.PI * 2), (int)2, (int)1);
                        if (airPos == null || this.isInVoid(airPos)) continue;
                        return airPos;
                    }
                    return null;
                }
                if (h > 5 && airPos.func_82617_b() >= (double)DragonflyEntity.this.func_233580_cy_().func_177956_o()) {
                    airPos = new Vector3d(airPos.field_72450_a, airPos.field_72448_b - (double)h * 0.5, airPos.field_72449_c);
                }
                return airPos;
            }
            return RandomPositionGenerator.func_226338_a_((CreatureEntity)DragonflyEntity.this, (int)8, (int)4, (int)-2, (Vector3d)rotation, (double)1.5707963705062866);
        }

        private boolean isInVoid(Vector3d pos) {
            int h = BlockHelper.downRay((IWorldReader)DragonflyEntity.this.field_70170_p, new BlockPos(pos), 128);
            return h > 100;
        }
    }

    public class DragonflyLookControl
    extends LookController {
        DragonflyLookControl(MobEntity entity) {
            super(entity);
        }

        protected boolean func_220680_b() {
            return true;
        }
    }
}

