/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.integration.jei.anvil;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mod.beethoven92.betterendforge.common.block.template.EndAnvilBlock;
import mod.beethoven92.betterendforge.common.recipes.AnvilSmithingRecipe;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class AnvilSmithingRecipeCategory
implements IRecipeCategory<AnvilSmithingRecipe> {
    protected static final int LEFT_INPUT_SLOT = 0;
    protected static final int RIGHT_INPUT_SLOT = 1;
    protected static final int OUTPUT_SLOT = 2;
    protected static final int ANVIL_SLOT = 3;
    private final IDrawable background;
    private final IDrawable icon;
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("betterendforge", "textures/gui/jei/jei_anvil_smithing_gui.png");
    public static final ResourceLocation UID = new ResourceLocation("betterendforge", "anvil_smithing");

    public AnvilSmithingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_TEXTURE, 0, 0, 125, 38).addPadding(0, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Blocks.field_150467_bQ));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends AnvilSmithingRecipe> getRecipeClass() {
        return AnvilSmithingRecipe.class;
    }

    public String getTitle() {
        return new TranslationTextComponent("gui.jei.category.anvil_smithing").getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(AnvilSmithingRecipe recipe, IIngredients ingredients) {
        NonNullList inputs = NonNullList.func_191196_a();
        inputs.addAll(recipe.func_192400_c());
        inputs.add((Object)Ingredient.func_234819_a_(BlockTags.field_200572_k.func_230236_b_().stream().filter(anvil -> {
            if (anvil instanceof EndAnvilBlock) {
                return ((EndAnvilBlock)((Object)anvil)).getCraftingLevel() >= recipe.anvilLevel;
            }
            return recipe.anvilLevel == 1;
        }).map(ItemStack::new)));
        ingredients.setInputIngredients((List)inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, AnvilSmithingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(1, true, 49, 0);
        guiItemStacks.init(3, true, 24, 20);
        guiItemStacks.init(2, false, 107, 0);
        guiItemStacks.set(ingredients);
    }

    protected void drawToolDamage(AnvilSmithingRecipe recipe, MatrixStack matrixStack, int y) {
        int damage = recipe.damage;
        if (damage > 0) {
            TranslationTextComponent timeString = new TranslationTextComponent("gui.jei.category.anvil_smithing.damage", new Object[]{damage});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_238414_a_((ITextProperties)timeString);
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)timeString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    public void draw(AnvilSmithingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.drawToolDamage(recipe, matrixStack, 27);
    }
}

