/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mod.beethoven92.betterendforge.common.recipes.AlloyingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AlloyingRecipeSerializer<T extends AlloyingRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public AlloyingRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public T read(ResourceLocation id, JsonObject json) {
        ItemStack output;
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
        Ingredient primaryInput = Ingredient.func_199802_a((JsonElement)ingredients.get(0));
        Ingredient secondaryInput = Ingredient.func_199802_a((JsonElement)ingredients.get(1));
        if (json.get("result").isJsonObject()) {
            output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        } else {
            String result = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(result);
            output = new ItemStack((IItemProvider)Registry.field_212630_s.func_241873_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
        }
        float experience = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int smeltTime = JSONUtils.func_151208_a((JsonObject)json, (String)"smelttime", (int)350);
        return this.factory.create(id, group, primaryInput, secondaryInput, output, experience, smeltTime);
    }

    public T read(ResourceLocation id, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient primary = Ingredient.func_199566_b((PacketBuffer)buffer);
        Ingredient secondary = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack output = buffer.func_150791_c();
        float experience = buffer.readFloat();
        int smeltTime = buffer.func_150792_a();
        return this.factory.create(id, group, primary, secondary, output, experience, smeltTime);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((AlloyingRecipe)recipe).group);
        ((AlloyingRecipe)recipe).primaryInput.func_199564_a(buffer);
        ((AlloyingRecipe)recipe).secondaryInput.func_199564_a(buffer);
        buffer.func_150788_a(((AlloyingRecipe)recipe).output);
        buffer.writeFloat(((AlloyingRecipe)recipe).experience);
        buffer.func_150787_b(((AlloyingRecipe)recipe).smeltTime);
    }

    public static interface IFactory<T extends AlloyingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, Ingredient var4, ItemStack var5, float var6, int var7);
    }
}

