/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.recipes;

import mod.beethoven92.betterendforge.common.init.ModRecipeSerializers;
import mod.beethoven92.betterendforge.common.init.ModTags;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AnvilSmithingRecipe
implements IRecipe<IInventory> {
    public static final String GROUP = "anvil_smithing";
    public static final IRecipeType<AnvilSmithingRecipe> TYPE = ModRecipeSerializers.registerRecipeType("anvil_smithing");
    private final ResourceLocation id;
    public final Ingredient input;
    public final ItemStack output;
    public final int damage;
    public final int inputCount;
    public final int level;
    public final int anvilLevel;

    public AnvilSmithingRecipe(ResourceLocation identifier, Ingredient input, ItemStack output, int inputCount, int level, int damage, int anvilLevel) {
        this.id = identifier;
        this.input = input;
        this.output = output;
        this.inputCount = inputCount;
        this.level = level;
        this.damage = damage;
        this.anvilLevel = anvilLevel;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ItemStack hammer = inv.func_70301_a(0);
        if (hammer.func_190926_b() || !ModTags.HAMMERS.func_230235_a_((Object)hammer.func_77973_b())) {
            return false;
        }
        ItemStack material = inv.func_70301_a(1);
        int materialCount = material.func_190916_E();
        int level = ((ToolItem)hammer.func_77973_b()).func_200891_e().func_200925_d();
        return level >= this.level && this.input.test(inv.func_70301_a(1)) && materialCount >= this.inputCount;
    }

    public boolean checkHammerDurability(IInventory craftingInventory, PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        ItemStack hammer = craftingInventory.func_70301_a(0);
        int damage = hammer.func_77952_i() + this.damage;
        return damage < hammer.func_77958_k();
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList defaultedList = NonNullList.func_191196_a();
        defaultedList.add((Object)Ingredient.func_234819_a_(ModTags.HAMMERS.func_230236_b_().stream().filter(hammer -> ((ToolItem)hammer).func_200891_e().func_200925_d() >= this.level).map(ItemStack::new)));
        ItemStack amount = new ItemStack((IItemProvider)this.input.func_193365_a()[0].func_77973_b(), this.inputCount);
        defaultedList.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{amount}));
        return defaultedList;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.output.func_77946_l();
    }

    public ItemStack craft(IInventory craftingInventory, PlayerEntity player) {
        if (!player.func_184812_l_()) {
            if (!this.checkHammerDurability(craftingInventory, player)) {
                return ItemStack.field_190927_a;
            }
            ItemStack hammer = craftingInventory.func_70301_a(0);
            hammer.func_222118_a(this.damage, (LivingEntity)player, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return this.func_77572_b(craftingInventory);
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.ANVIL_SMITHING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public boolean func_192399_d() {
        return true;
    }
}

