/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.recipes;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import mod.beethoven92.betterendforge.BetterEnd;
import mod.beethoven92.betterendforge.common.init.ModRecipeSerializers;
import mod.beethoven92.betterendforge.common.recipes.ModRecipeManager;
import mod.beethoven92.betterendforge.common.rituals.InfusionRitual;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class InfusionRecipe
implements IRecipe<InfusionRitual> {
    public static final String GROUP = "infusion";
    public static final IRecipeType<InfusionRecipe> TYPE = ModRecipeSerializers.registerRecipeType("infusion");
    public final ResourceLocation id;
    public Ingredient input;
    public ItemStack output;
    public int time = 1;
    public Ingredient[] catalysts = new Ingredient[8];
    public Map<Integer, Ingredient> ingredientPositions = Maps.newHashMap();

    public InfusionRecipe(ResourceLocation id) {
        this(id, null, null);
    }

    public InfusionRecipe(ResourceLocation id, Ingredient input, ItemStack output) {
        this.id = id;
        this.input = input;
        this.output = output;
        Arrays.fill(this.catalysts, Ingredient.field_193370_a);
    }

    public int getInfusionTime() {
        return this.time;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)this.input);
        for (Ingredient catalyst : this.catalysts) {
            list.add((Object)catalyst);
        }
        return list;
    }

    public boolean matches(InfusionRitual inv, World worldIn) {
        boolean valid = this.input.test(inv.func_70301_a(0));
        if (!valid) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            valid &= this.catalysts[i].test(inv.func_70301_a(i + 1));
        }
        return valid;
    }

    public ItemStack getCraftingResult(InfusionRitual inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.INFUSION.get();
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public static class Builder {
        private static final Builder INSTANCE = new Builder();
        private ResourceLocation id;
        private Ingredient input;
        private ItemStack output;
        private int time = 1;
        private Ingredient[] catalysts = new Ingredient[8];

        public static Builder create(String id) {
            return Builder.create(new ResourceLocation("betterendforge", id));
        }

        public static Builder create(ResourceLocation id) {
            Builder.INSTANCE.id = id;
            Builder.INSTANCE.input = null;
            Builder.INSTANCE.output = null;
            Builder.INSTANCE.time = 1;
            Arrays.fill(Builder.INSTANCE.catalysts, Ingredient.field_193370_a);
            return INSTANCE;
        }

        private Builder() {
            Arrays.fill(this.catalysts, Ingredient.field_193370_a);
        }

        public Builder setGroup(String group) {
            return this;
        }

        public Builder setInput(IItemProvider input) {
            this.input = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input});
            return this;
        }

        public Builder setOutput(IItemProvider output) {
            this.output = new ItemStack(output);
            this.output.func_190920_e(1);
            return this;
        }

        public Builder setOutput(ItemStack output) {
            this.output = output;
            this.output.func_190920_e(1);
            return this;
        }

        public Builder setTime(int time) {
            this.time = time;
            return this;
        }

        public Builder addCatalyst(int slot, IItemProvider ... items) {
            if (slot > 7) {
                return this;
            }
            this.catalysts[slot] = Ingredient.func_199804_a((IItemProvider[])items);
            return this;
        }

        public void build() {
            if (this.input == null) {
                BetterEnd.LOGGER.warn("BETTER_END_FORGE: Input for Infusion recipe can't be 'null', recipe {} will be ignored!", (Object)this.id);
                return;
            }
            if (this.output == null) {
                BetterEnd.LOGGER.warn("BETTER_END_FORGE: Output for Infusion recipe can't be 'null', recipe {} will be ignored!", (Object)this.id);
                return;
            }
            InfusionRecipe recipe = new InfusionRecipe(this.id, this.input, this.output);
            recipe.time = this.time;
            int empty = 0;
            for (int i = 0; i < this.catalysts.length; ++i) {
                if (this.catalysts[i].func_203189_d()) {
                    ++empty;
                    continue;
                }
                recipe.catalysts[i] = this.catalysts[i];
            }
            if (empty == this.catalysts.length) {
                BetterEnd.LOGGER.warn("BETTER_END_FORGE: At least one catalyst must be non empty, recipe {} will be ignored!", (Object)this.id);
                return;
            }
            ModRecipeManager.addRecipe(TYPE, recipe);
        }
    }
}

