/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.rituals;

import java.awt.Point;
import mod.beethoven92.betterendforge.common.particles.InfusionParticleData;
import mod.beethoven92.betterendforge.common.recipes.InfusionRecipe;
import mod.beethoven92.betterendforge.common.tileentity.InfusionPedestalTileEntity;
import mod.beethoven92.betterendforge.common.tileentity.PedestalTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class InfusionRitual
implements IInventory {
    private static final Point[] PEDESTALS_MAP = new Point[]{new Point(0, 3), new Point(2, 2), new Point(3, 0), new Point(2, -2), new Point(0, -3), new Point(-2, -2), new Point(-3, 0), new Point(-2, 2)};
    private World world;
    private BlockPos worldPos;
    private InfusionRecipe activeRecipe;
    private boolean isDirty = false;
    private boolean hasRecipe = false;
    private int progress = 0;
    private int time = 0;
    private InfusionPedestalTileEntity input;
    private PedestalTileEntity[] catalysts = new PedestalTileEntity[8];

    public InfusionRitual(World world, BlockPos pos) {
        this.world = world;
        this.worldPos = pos;
        this.configure();
    }

    public static Point[] getMap() {
        return PEDESTALS_MAP;
    }

    public void configure() {
        if (this.world == null || this.world.field_72995_K || this.worldPos == null) {
            return;
        }
        TileEntity inputEntity = this.world.func_175625_s(this.worldPos);
        if (inputEntity instanceof InfusionPedestalTileEntity) {
            this.input = (InfusionPedestalTileEntity)inputEntity;
        }
        int i = 0;
        for (Point point : PEDESTALS_MAP) {
            BlockPos.Mutable checkPos = this.worldPos.func_239590_i_().func_189534_c(Direction.EAST, point.x).func_189534_c(Direction.NORTH, point.y);
            TileEntity catalystEntity = this.world.func_175625_s((BlockPos)checkPos);
            if (!(catalystEntity instanceof PedestalTileEntity)) break;
            this.catalysts[i] = (PedestalTileEntity)catalystEntity;
            ++i;
        }
    }

    public boolean checkRecipe() {
        if (!this.isValid()) {
            return false;
        }
        InfusionRecipe recipe = this.world.func_199532_z().func_215371_a(InfusionRecipe.TYPE, (IInventory)this, this.world).orElse(null);
        if (this.hasRecipe()) {
            if (recipe == null) {
                this.stop();
                return false;
            }
            if (recipe.getInfusionTime() != this.time) {
                this.activeRecipe = recipe;
                this.time = this.activeRecipe.getInfusionTime();
                this.progress = 0;
                this.func_70296_d();
            } else if (this.activeRecipe == null) {
                this.activeRecipe = recipe;
            }
            return true;
        }
        if (recipe != null) {
            this.activeRecipe = recipe;
            this.time = this.activeRecipe.getInfusionTime();
            this.hasRecipe = true;
            this.progress = 0;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void stop() {
        this.activeRecipe = null;
        this.hasRecipe = false;
        this.progress = 0;
        this.time = 0;
        this.func_70296_d();
    }

    public void tick() {
        if (this.isDirty) {
            this.configure();
            this.isDirty = false;
        }
        if (!this.isValid() || !this.hasRecipe()) {
            return;
        }
        if (!this.checkRecipe()) {
            return;
        }
        ++this.progress;
        if (this.progress == this.time) {
            BlockState inputState = this.world.func_180495_p(this.input.func_174877_v());
            this.input.removeStack(this.world, inputState);
            this.input.setStack(this.activeRecipe.getCraftingResult(this));
            for (PedestalTileEntity catalyst : this.catalysts) {
                catalyst.removeStack(this.world, this.world.func_180495_p(catalyst.func_174877_v()));
            }
            this.stop();
        } else {
            ServerWorld world = (ServerWorld)this.world;
            BlockPos target = this.worldPos.func_177984_a();
            double tx = (double)target.func_177958_n() + 0.5;
            double ty = (double)target.func_177956_o() + 0.5;
            double tz = (double)target.func_177952_p() + 0.5;
            for (PedestalTileEntity catalyst : this.catalysts) {
                ItemStack stack = catalyst.getStack();
                if (stack.func_190926_b()) continue;
                BlockPos start = catalyst.func_174877_v();
                double sx = (double)start.func_177958_n() + 0.5;
                double sy = (double)start.func_177956_o() + 1.25;
                double sz = (double)start.func_177952_p() + 0.5;
                world.func_195598_a((IParticleData)new InfusionParticleData(stack), sx, sy, sz, 0, tx - sx, ty - sy, tz - sz, 0.5);
            }
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isValid();
    }

    public boolean isValid() {
        if (this.world == null || this.world.field_72995_K || this.worldPos == null || this.input == null) {
            return false;
        }
        for (PedestalTileEntity catalyst : this.catalysts) {
            if (catalyst != null) continue;
            return false;
        }
        return true;
    }

    public boolean hasRecipe() {
        return this.hasRecipe;
    }

    public void setLocation(World world, BlockPos pos) {
        this.world = world;
        this.worldPos = pos;
        this.isDirty = true;
    }

    public void func_174888_l() {
        if (!this.isValid()) {
            return;
        }
        this.input.clear();
        for (PedestalTileEntity catalyst : this.catalysts) {
            catalyst.clear();
        }
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70301_a(int index) {
        if (index > 8) {
            return ItemStack.field_190927_a;
        }
        if (index == 0) {
            return this.input.getStack();
        }
        return this.catalysts[index - 1].getStack();
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.func_70304_b(index);
    }

    public ItemStack func_70304_b(int index) {
        if (index > 8) {
            return ItemStack.field_190927_a;
        }
        if (index == 0) {
            return this.input.removeStack();
        }
        return this.catalysts[index - 1].getStack();
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index > 8) {
            return;
        }
        if (index == 0) {
            this.input.setStack(stack);
        } else {
            this.catalysts[index - 1].setStack(stack);
        }
    }

    public void func_70296_d() {
        if (this.isValid()) {
            this.input.func_70296_d();
            for (PedestalTileEntity catalyst : this.catalysts) {
                catalyst.func_70296_d();
            }
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void read(CompoundNBT tag) {
        if (tag.func_74764_b("recipe")) {
            this.hasRecipe = tag.func_74767_n("recipe");
            this.progress = tag.func_74762_e("progress");
            this.time = tag.func_74762_e("time");
        }
    }

    public CompoundNBT write(CompoundNBT tag) {
        if (this.hasRecipe()) {
            tag.func_74757_a("recipe", this.hasRecipe);
            tag.func_74768_a("progress", this.progress);
            tag.func_74768_a("time", this.time);
        }
        return tag;
    }
}

