/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class StructureHelper {
    private static final Direction[] DIR = BlockHelper.makeHorizontal();

    public static Template readStructure(ResourceLocation resource) {
        String ns = resource.func_110624_b();
        String nm = resource.func_110623_a();
        return StructureHelper.readStructure("/data/" + ns + "/structures/" + nm + ".nbt");
    }

    public static Template readStructure(File datapack, String path) {
        if (datapack.isDirectory()) {
            return StructureHelper.readStructure(datapack.toString() + "/" + path);
        }
        if (datapack.isFile() && datapack.getName().endsWith(".zip")) {
            try {
                ZipFile zipFile = new ZipFile(datapack);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    long compressedSize = entry.getCompressedSize();
                    long normalSize = entry.getSize();
                    String type = entry.isDirectory() ? "DIR" : "FILE";
                    System.out.println(name);
                    System.out.format("\t %s - %d - %d\n", type, compressedSize, normalSize);
                }
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Template readStructure(String path) {
        try {
            InputStream inputstream = StructureHelper.class.getResourceAsStream(path);
            return StructureHelper.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Template readStructureFromStream(InputStream stream) throws IOException {
        CompoundNBT nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        Template template = new Template();
        template.func_186256_b(nbttagcompound);
        return template;
    }

    public static BlockPos offsetPos(BlockPos pos, Template structure, Rotation rotation, Mirror mirror) {
        BlockPos offset = Template.func_207669_a((BlockPos)structure.func_186259_a(), (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.field_177992_a);
        return pos.func_177963_a((double)(-offset.func_177958_n()) * 0.5, 0.0, (double)(-offset.func_177952_p()) * 0.5);
    }

    public static void placeCenteredBottom(ISeedReader world, BlockPos pos, Template structure, Rotation rotation, Mirror mirror, Random random) {
        StructureHelper.placeCenteredBottom(world, pos, structure, rotation, mirror, StructureHelper.makeBox(pos), random);
    }

    public static void placeCenteredBottom(ISeedReader world, BlockPos pos, Template structure, Rotation rotation, Mirror mirror, MutableBoundingBox bounds, Random random) {
        BlockPos offset = StructureHelper.offsetPos(pos, structure, rotation, mirror);
        PlacementSettings placementData = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_186223_a(bounds);
        structure.func_237144_a_((IServerWorld)world, offset, placementData, random);
    }

    private static MutableBoundingBox makeBox(BlockPos pos) {
        int sx = (pos.func_177958_n() >> 4 << 4) - 16;
        int sz = (pos.func_177952_p() >> 4 << 4) - 16;
        int ex = sx + 47;
        int ez = sz + 47;
        return MutableBoundingBox.func_175899_a((int)sx, (int)0, (int)sz, (int)ex, (int)255, (int)ez);
    }

    public static MutableBoundingBox getStructureBounds(BlockPos pos, Template structure, Rotation rotation, Mirror mirror) {
        BlockPos max = structure.func_186259_a();
        BlockPos min = Template.func_207669_a((BlockPos)structure.func_186259_a(), (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.field_177992_a);
        max = max.func_177973_b((Vector3i)min);
        return new MutableBoundingBox((Vector3i)min.func_177971_a((Vector3i)pos), (Vector3i)max.func_177971_a((Vector3i)pos));
    }

    public static MutableBoundingBox intersectBoxes(MutableBoundingBox box1, MutableBoundingBox box2) {
        int x1 = ModMathHelper.max(box1.field_78897_a, box2.field_78897_a);
        int y1 = ModMathHelper.max(box1.field_78895_b, box2.field_78895_b);
        int z1 = ModMathHelper.max(box1.field_78896_c, box2.field_78896_c);
        int x2 = ModMathHelper.min(box1.field_78893_d, box2.field_78893_d);
        int y2 = ModMathHelper.min(box1.field_78894_e, box2.field_78894_e);
        int z2 = ModMathHelper.min(box1.field_78892_f, box2.field_78892_f);
        return MutableBoundingBox.func_175899_a((int)x1, (int)y1, (int)z1, (int)x2, (int)y2, (int)z2);
    }

    public static void erode(ISeedReader world, MutableBoundingBox bounds, int iterations, Random random) {
        BlockPos.Mutable mut = new BlockPos.Mutable();
        boolean canDestruct = true;
        for (int i = 0; i < iterations; ++i) {
            for (int x = bounds.field_78897_a; x <= bounds.field_78893_d; ++x) {
                mut.func_223471_o(x);
                block2: for (int z = bounds.field_78896_c; z <= bounds.field_78892_f; ++z) {
                    mut.func_223472_q(z);
                    for (int y = bounds.field_78894_e; y >= bounds.field_78895_b; --y) {
                        mut.func_185336_p(y);
                        BlockState state = world.func_180495_p((BlockPos)mut);
                        if (canDestruct && state.func_203425_a((Block)ModBlocks.FLAVOLITE_RUNED_ETERNAL.get()) && random.nextInt(8) == 0 && world.func_175623_d(mut.func_177979_c(2))) {
                            int r = ModMathHelper.randRange(1, 4, random);
                            int cx = mut.func_177958_n();
                            int cy = mut.func_177956_o();
                            int cz = mut.func_177952_p();
                            int x1 = cx - r;
                            int y1 = cy - r;
                            int z1 = cz - r;
                            int x2 = cx + r;
                            int y2 = cy + r;
                            int z2 = cz + r;
                            for (int px = x1; px <= x2; ++px) {
                                int dx = px - cx;
                                dx *= dx;
                                mut.func_223471_o(px);
                                for (int py = y1; py <= y2; ++py) {
                                    int dy = py - cy;
                                    dy *= dy;
                                    mut.func_185336_p(py);
                                    for (int pz = z1; pz <= z2; ++pz) {
                                        int dz = pz - cz;
                                        dz *= dz;
                                        mut.func_223472_q(pz);
                                        if (dx + dy + dz > r || !world.func_180495_p((BlockPos)mut).func_203425_a((Block)ModBlocks.FLAVOLITE_RUNED_ETERNAL.get())) continue;
                                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150350_a);
                                    }
                                }
                            }
                            mut.func_223471_o(cx);
                            mut.func_185336_p(cy);
                            mut.func_223472_q(cz);
                            canDestruct = false;
                            continue;
                        }
                        if (StructureHelper.ignore(state)) continue;
                        if (!state.func_196958_f() && random.nextBoolean()) {
                            StructureHelper.shuffle(random);
                            block7: for (Direction dir : DIR) {
                                if (!world.func_175623_d(mut.func_177972_a(dir)) || !world.func_175623_d(mut.func_177977_b().func_177972_a(dir))) continue;
                                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150350_a);
                                mut.func_189536_c(dir).func_189536_c(Direction.DOWN);
                                int py = mut.func_177956_o();
                                while (y >= bounds.field_78895_b - 10) {
                                    mut.func_185336_p(py - 1);
                                    if (!world.func_175623_d((BlockPos)mut)) {
                                        mut.func_185336_p(py);
                                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, state);
                                        continue block7;
                                    }
                                    --y;
                                }
                            }
                            continue block2;
                        }
                        if (random.nextInt(8) != 0 || world.func_180495_p(mut.func_177984_a()).func_203425_a((Block)ModBlocks.ETERNAL_PEDESTAL.get())) continue;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150350_a);
                    }
                }
            }
        }
        for (int x = bounds.field_78897_a; x <= bounds.field_78893_d; ++x) {
            mut.func_223471_o(x);
            for (int z = bounds.field_78896_c; z <= bounds.field_78892_f; ++z) {
                mut.func_223472_q(z);
                block11: for (int y = bounds.field_78894_e; y >= bounds.field_78895_b; --y) {
                    mut.func_185336_p(y);
                    BlockState state = world.func_180495_p((BlockPos)mut);
                    if (StructureHelper.ignore(state) || !world.func_175623_d(mut.func_177977_b())) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150350_a);
                    for (int py = mut.func_177956_o(); py >= bounds.field_78895_b - 10; --py) {
                        mut.func_185336_p(py - 1);
                        if (world.func_175623_d((BlockPos)mut)) continue;
                        mut.func_185336_p(py);
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, state);
                        continue block11;
                    }
                }
            }
        }
    }

    public static void erodeIntense(ISeedReader world, MutableBoundingBox bounds, Random random) {
        BlockPos.Mutable mut = new BlockPos.Mutable();
        BlockPos.Mutable mut2 = new BlockPos.Mutable();
        int minY = bounds.field_78895_b - 10;
        for (int x = bounds.field_78897_a; x <= bounds.field_78893_d; ++x) {
            mut.func_223471_o(x);
            for (int z = bounds.field_78896_c; z <= bounds.field_78892_f; ++z) {
                mut.func_223472_q(z);
                for (int y = bounds.field_78894_e; y >= bounds.field_78895_b; --y) {
                    mut.func_185336_p(y);
                    BlockState state = world.func_180495_p((BlockPos)mut);
                    if (StructureHelper.ignore(state)) continue;
                    if (random.nextInt(6) == 0) {
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150350_a);
                        if (!random.nextBoolean()) continue;
                        int px = ModMathHelper.floor(random.nextGaussian() * 2.0 + (double)x + 0.5);
                        int pz = ModMathHelper.floor(random.nextGaussian() * 2.0 + (double)z + 0.5);
                        mut2.func_181079_c(px, y, pz);
                        while (world.func_180495_p((BlockPos)mut2).func_185904_a().func_76222_j() && mut2.func_177956_o() > minY) {
                            mut2.func_185336_p(mut2.func_177956_o() - 1);
                        }
                        if (world.func_180495_p((BlockPos)mut2).func_196958_f() || !state.func_196955_c((IWorldReader)world, (BlockPos)mut2)) continue;
                        mut2.func_185336_p(mut2.func_177956_o() + 1);
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut2, state);
                        continue;
                    }
                    if (random.nextInt(8) != 0 || world.func_180495_p(mut.func_177984_a()).func_203425_a((Block)ModBlocks.ETERNAL_PEDESTAL.get())) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150350_a);
                }
            }
        }
        StructureHelper.drop(world, bounds);
    }

    private static boolean isTerrainNear(ISeedReader world, BlockPos pos) {
        for (Direction dir : BlockHelper.HORIZONTAL_DIRECTIONS) {
            if (!world.func_180495_p(pos.func_177972_a(dir)).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
            return true;
        }
        return false;
    }

    private static void drop(ISeedReader world, MutableBoundingBox bounds) {
        BlockPos.Mutable mut = new BlockPos.Mutable();
        HashSet blocks = Sets.newHashSet();
        HashSet edge = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        for (int x = bounds.field_78897_a; x <= bounds.field_78893_d; ++x) {
            mut.func_223471_o(x);
            for (int z = bounds.field_78896_c; z <= bounds.field_78892_f; ++z) {
                mut.func_223472_q(z);
                for (int y = bounds.field_78895_b; y <= bounds.field_78894_e; ++y) {
                    mut.func_185336_p(y);
                    BlockState state = world.func_180495_p((BlockPos)mut);
                    if (StructureHelper.ignore(state) || !StructureHelper.isTerrainNear(world, (BlockPos)mut)) continue;
                    edge.add(mut.func_185334_h());
                }
            }
        }
        if (edge.isEmpty()) {
            return;
        }
        while (!edge.isEmpty()) {
            for (BlockPos center : edge) {
                for (Direction dir : BlockHelper.HORIZONTAL_DIRECTIONS) {
                    BlockState state = world.func_180495_p(center);
                    if (!state.func_215686_e((IBlockReader)world, center)) continue;
                    mut.func_181079_c(center.func_177958_n(), center.func_177956_o(), center.func_177952_p()).func_189536_c(dir);
                    if (!bounds.func_175898_b((Vector3i)mut.func_185334_h()) || StructureHelper.ignore(state = world.func_180495_p((BlockPos)mut)) || blocks.contains(mut)) continue;
                    add.add(mut.func_185334_h());
                }
            }
            blocks.addAll(edge);
            edge.clear();
            edge.addAll(add);
            add.clear();
        }
        int minY = bounds.field_78895_b - 10;
        for (int x = bounds.field_78897_a; x <= bounds.field_78893_d; ++x) {
            mut.func_223471_o(x);
            for (int z = bounds.field_78896_c; z <= bounds.field_78892_f; ++z) {
                mut.func_223472_q(z);
                for (int y = bounds.field_78895_b; y <= bounds.field_78894_e; ++y) {
                    mut.func_185336_p(y);
                    BlockState state = world.func_180495_p((BlockPos)mut);
                    if (StructureHelper.ignore(state) || blocks.contains(mut)) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150350_a);
                    while (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j() && mut.func_177956_o() > minY) {
                        mut.func_185336_p(mut.func_177956_o() - 1);
                    }
                    if (mut.func_177956_o() <= minY) continue;
                    mut.func_185336_p(mut.func_177956_o() + 1);
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, state);
                }
            }
        }
    }

    private static boolean ignore(BlockState state) {
        return state.func_185904_a().func_76222_j() || !state.func_204520_s().func_206888_e() || state.func_235714_a_(ModTags.END_GROUND) || state.func_203425_a((Block)ModBlocks.ETERNAL_PEDESTAL.get()) || state.func_203425_a((Block)ModBlocks.FLAVOLITE_RUNED_ETERNAL.get()) || state.func_235714_a_((ITag)BlockTags.field_200031_h) || state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_185904_a().equals(Material.field_151585_k) || state.func_185904_a().equals(Material.field_151584_j);
    }

    private static void shuffle(Random random) {
        for (int i = 0; i < 4; ++i) {
            int j = random.nextInt(4);
            Direction d = DIR[i];
            StructureHelper.DIR[i] = DIR[j];
            StructureHelper.DIR[j] = d;
        }
    }

    public static void cover(ISeedReader world, MutableBoundingBox bounds, Random random) {
        BlockPos.Mutable mut = new BlockPos.Mutable();
        for (int x = bounds.field_78897_a; x <= bounds.field_78893_d; ++x) {
            mut.func_223471_o(x);
            for (int z = bounds.field_78896_c; z <= bounds.field_78892_f; ++z) {
                mut.func_223472_q(z);
                BlockState top = world.func_226691_t_((BlockPos)mut).func_242440_e().func_242502_e().func_204108_a();
                for (int y = bounds.field_78894_e; y >= bounds.field_78895_b; --y) {
                    mut.func_185336_p(y);
                    BlockState state = world.func_180495_p((BlockPos)mut);
                    if (!state.func_235714_a_(ModTags.END_GROUND) || world.func_180495_p(mut.func_177984_a()).func_185904_a().func_76218_k()) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, top);
                }
            }
        }
    }
}

