/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.StructureHelper;
import mod.beethoven92.betterendforge.common.world.feature.NBTFeature;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class CrashedShipFeature
extends NBTFeature {
    private static final StructureProcessor REPLACER = new StructureProcessor(){

        public Template.BlockInfo process(IWorldReader worldView, BlockPos pos, BlockPos blockPos, Template.BlockInfo structureBlockInfo, Template.BlockInfo structureBlockInfo2, PlacementSettings structurePlacementData, Template template) {
            BlockState state = structureBlockInfo2.field_186243_b;
            if (state.func_203425_a(Blocks.field_150474_ac) || state.func_185904_a().equals(Material.field_151580_n)) {
                return new Template.BlockInfo(structureBlockInfo2.field_186242_a, Blocks.field_150350_a.func_176223_P(), null);
            }
            return structureBlockInfo2;
        }

        protected IStructureProcessorType<?> func_215192_a() {
            return IStructureProcessorType.field_214925_g;
        }
    };
    private static final String STRUCTURE_PATH = "/data/minecraft/structures/end_city/ship.nbt";
    private Template structure;

    @Override
    protected Template getStructure(ISeedReader world, BlockPos pos, Random random) {
        if (this.structure == null) {
            this.structure = world.func_201672_e().func_184163_y().func_200219_b(new ResourceLocation("end_city/ship"));
            if (this.structure == null) {
                this.structure = StructureHelper.readStructure(STRUCTURE_PATH);
            }
        }
        return this.structure;
    }

    @Override
    protected boolean canSpawn(ISeedReader world, BlockPos pos, Random random) {
        return pos.func_177956_o() > 58 && world.func_180495_p(pos.func_177977_b()).func_235714_a_(ModTags.GEN_TERRAIN);
    }

    @Override
    protected Rotation getRotation(ISeedReader world, BlockPos pos, Random random) {
        return Rotation.func_222466_a((Random)random);
    }

    @Override
    protected Mirror getMirror(ISeedReader world, BlockPos pos, Random random) {
        return Mirror.values()[random.nextInt(3)];
    }

    @Override
    protected int getYOffset(Template structure, ISeedReader world, BlockPos pos, Random random) {
        int min = structure.func_186259_a().func_177956_o() >> 3;
        int max = structure.func_186259_a().func_177956_o() >> 2;
        return -ModMathHelper.randRange(min, max, random);
    }

    @Override
    protected NBTFeature.TerrainMerge getTerrainMerge(ISeedReader world, BlockPos pos, Random random) {
        return NBTFeature.TerrainMerge.NONE;
    }

    @Override
    protected void addStructureData(PlacementSettings data) {
        data.func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c).func_215222_a(REPLACER).func_186222_a(true);
    }

    @Override
    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos center, NoFeatureConfig config) {
        center = new BlockPos(center.func_177958_n() >> 4 << 4 | 8, 128, center.func_177952_p() >> 4 << 4 | 8);
        center = this.getGround(world, center);
        MutableBoundingBox bounds = this.makeBox(center);
        if (!this.canSpawn(world, center, rand)) {
            return false;
        }
        Template structure = this.getStructure(world, center, rand);
        Rotation rotation = this.getRotation(world, center, rand);
        Mirror mirror = this.getMirror(world, center, rand);
        BlockPos offset = Template.func_207669_a((BlockPos)structure.func_186259_a(), (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.field_177992_a);
        center = center.func_177963_a(0.0, (double)this.getYOffset(structure, world, center, rand) + 0.5, 0.0);
        PlacementSettings placementData = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror);
        center = center.func_177963_a((double)(-offset.func_177958_n()) * 0.5, 0.0, (double)(-offset.func_177952_p()) * 0.5);
        MutableBoundingBox structB = structure.func_215388_b(placementData, center);
        bounds = StructureHelper.intersectBoxes(bounds, structB);
        this.addStructureData(placementData);
        structure.func_237152_b_((IServerWorld)world, center, placementData.func_186223_a(bounds), rand);
        StructureHelper.erodeIntense(world, bounds, rand);
        BlockHelper.fixBlocks((IWorld)world, new BlockPos(bounds.field_78897_a, bounds.field_78895_b, bounds.field_78896_c), new BlockPos(bounds.field_78893_d, bounds.field_78894_e, bounds.field_78892_f));
        return true;
    }
}

