/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.SplineHelper;
import mod.beethoven92.betterendforge.common.util.sdf.PosInfo;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PythadendronFeature
extends Feature<NoFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.func_235714_a_(ModTags.END_GROUND)) {
            return true;
        }
        if (state.func_177230_c() == ModBlocks.PYTHADENDRON_LEAVES.get()) {
            return true;
        }
        if (state.func_185904_a().equals(Material.field_151585_k)) {
            return true;
        }
        return state.func_185904_a().func_76222_j();
    };
    private static final Function<BlockState, Boolean> IGNORE = state -> ModBlocks.PYTHADENDRON.isTreeLog((BlockState)state);
    private static final Function<PosInfo, BlockState> POST = info -> {
        if (ModBlocks.PYTHADENDRON.isTreeLog(info.getStateUp()) && ModBlocks.PYTHADENDRON.isTreeLog(info.getStateDown())) {
            return ((Block)ModBlocks.PYTHADENDRON.log.get()).func_176223_P();
        }
        return info.getState();
    };

    public PythadendronFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != ModBlocks.CHORUS_NYLIUM.get() && world.func_180495_p(pos.func_177977_b()).func_177230_c() != ModBlocks.ENDSTONE_DUST.get()) {
            return false;
        }
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, Blocks.field_150350_a);
        float size = ModMathHelper.randRange(10, 20, random);
        List<Vector3f> spline = SplineHelper.makeSpline(0.0f, 0.0f, 0.0f, 0.0f, size, 0.0f, 4);
        SplineHelper.offsetParts(spline, random, 0.7f, 0.0f, 0.7f);
        Vector3f last = spline.get(spline.size() - 1);
        int depth = ModMathHelper.floor((size - 10.0f) * 3.0f / 10.0f + 1.0f);
        float bsize = (10.0f - (size - 10.0f)) / 10.0f + 1.5f;
        this.branch(last.func_195899_a(), last.func_195900_b(), last.func_195902_c(), size * bsize, ModMathHelper.randRange(0.0f, (float)Math.PI * 2, random), random, depth, world, pos);
        SDF function = SplineHelper.buildSDF(spline, 1.7f, 1.1f, bpos -> ((Block)ModBlocks.PYTHADENDRON.bark.get()).func_176223_P());
        function.setReplaceFunction(REPLACE);
        function.addPostProcess(POST);
        function.fillRecursive((IWorld)world, pos);
        return true;
    }

    private void branch(float x, float y, float z, float size, float angle, Random random, int depth, ISeedReader world, BlockPos pos) {
        if (depth == 0) {
            return;
        }
        float dx = (float)Math.cos(angle) * size * 0.15f;
        float dz = (float)Math.sin(angle) * size * 0.15f;
        float x1 = x + dx;
        float z1 = z + dz;
        float x2 = x - dx;
        float z2 = z - dz;
        List<Vector3f> spline = SplineHelper.makeSpline(x, y, z, x1, y, z1, 5);
        SplineHelper.powerOffset(spline, size * ModMathHelper.randRange(1.0f, 2.0f, random), 4.0f);
        SplineHelper.offsetParts(spline, random, 0.3f, 0.0f, 0.3f);
        Vector3f pos1 = spline.get(spline.size() - 1);
        boolean s1 = SplineHelper.fillSpline(spline, (IWorld)world, ((Block)ModBlocks.PYTHADENDRON.bark.get()).func_176223_P(), pos, REPLACE);
        spline = SplineHelper.makeSpline(x, y, z, x2, y, z2, 5);
        SplineHelper.powerOffset(spline, size * ModMathHelper.randRange(1.0f, 2.0f, random), 4.0f);
        SplineHelper.offsetParts(spline, random, 0.3f, 0.0f, 0.3f);
        Vector3f pos2 = spline.get(spline.size() - 1);
        boolean s2 = SplineHelper.fillSpline(spline, (IWorld)world, ((Block)ModBlocks.PYTHADENDRON.bark.get()).func_176223_P(), pos, REPLACE);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextInt());
        if (depth < 3) {
            if (s1) {
                this.leavesBall(world, pos.func_177963_a((double)pos1.func_195899_a(), (double)pos1.func_195900_b(), (double)pos1.func_195902_c()), random, noise);
            }
            if (s2) {
                this.leavesBall(world, pos.func_177963_a((double)pos2.func_195899_a(), (double)pos2.func_195900_b(), (double)pos2.func_195902_c()), random, noise);
            }
        }
        float size1 = size * ModMathHelper.randRange(0.75f, 0.95f, random);
        float size2 = size * ModMathHelper.randRange(0.75f, 0.95f, random);
        float angle1 = angle + 1.5707964f + ModMathHelper.randRange(-0.1f, 0.1f, random);
        float angle2 = angle + 1.5707964f + ModMathHelper.randRange(-0.1f, 0.1f, random);
        if (s1) {
            this.branch(pos1.func_195899_a(), pos1.func_195900_b(), pos1.func_195902_c(), size1, angle1, random, depth - 1, world, pos);
        }
        if (s2) {
            this.branch(pos2.func_195899_a(), pos2.func_195900_b(), pos2.func_195902_c(), size2, angle2, random, depth - 1, world, pos);
        }
    }

    private void leavesBall(ISeedReader world, BlockPos pos, Random random, OpenSimplexNoise noise) {
        float radius = ModMathHelper.randRange(4.5f, 6.5f, random);
        SDF sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)((Block)ModBlocks.PYTHADENDRON_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(6)));
        sphere = new SDFScale3D().setScale(1.0f, 0.6f, 1.0f).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.func_195899_a() * 0.2, (double)vec.func_195900_b() * 0.2, (double)vec.func_195902_c() * 0.2) * 3.0f)).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.nextFloat() * 3.0f - 1.5f)).setSource(sphere);
        sphere = new SDFSubtraction().setSourceA(sphere).setSourceB(new SDFTranslate().setTranslate(0.0f, -radius, 0.0f).setSource(sphere));
        BlockPos.Mutable mut = new BlockPos.Mutable();
        sphere.addPostProcess(info -> {
            if (random.nextInt(5) == 0) {
                for (Direction dir : Direction.values()) {
                    BlockState state = info.getState(dir, 2);
                    if (!state.func_196958_f()) continue;
                    return info.getState();
                }
                info.setState(((Block)ModBlocks.PYTHADENDRON.bark.get()).func_176223_P());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.func_223471_o(x + info.getPos().func_177958_n());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.func_223472_q(z + info.getPos().func_177952_p());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.func_185336_p(y + info.getPos().func_177956_o());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.func_177230_c() instanceof LeavesBlock) || d >= (distance = ((Integer)state.func_177229_b((Property)LeavesBlock.field_208494_a)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((IWorld)world, pos, IGNORE);
    }
}

