/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.FeatureHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public abstract class ScatterFeature
extends Feature<NoFeatureConfig> {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private final int radius;

    public ScatterFeature(int radius) {
        super(NoFeatureConfig.field_236558_a_);
        this.radius = radius;
    }

    public abstract boolean canGenerate(ISeedReader var1, Random var2, BlockPos var3, BlockPos var4, float var5);

    public abstract void generate(ISeedReader var1, Random var2, BlockPos var3);

    protected BlockPos getCenterGround(ISeedReader world, BlockPos pos) {
        return FeatureHelper.getPosOnSurfaceWG((IWorldReader)world, pos);
    }

    protected boolean canSpawn(ISeedReader world, BlockPos pos) {
        if (pos.func_177956_o() < 5) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_235714_a_(ModTags.END_GROUND);
    }

    protected boolean getGroundPlant(ISeedReader world, BlockPos.Mutable pos) {
        int down = BlockHelper.downRay((IWorldReader)world, (BlockPos)pos, 16);
        if (down > Math.abs(this.getYOffset() * 2)) {
            return false;
        }
        pos.func_185336_p(pos.func_177956_o() - down);
        return true;
    }

    protected int getYOffset() {
        return 5;
    }

    protected int getChance() {
        return 1;
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!this.canSpawn(world, pos = this.getCenterGround(world, pos))) {
            return false;
        }
        float r = ModMathHelper.randRange((float)this.radius * 0.5f, (float)this.radius, rand);
        int count = (int)Math.floor(r * r * ModMathHelper.randRange(1.5f, 3.0f, rand));
        for (int i = 0; i < count; ++i) {
            float pr = r * (float)Math.sqrt(rand.nextFloat());
            float theta = rand.nextFloat() * ((float)Math.PI * 2);
            float x = pr * (float)Math.cos(theta);
            float z = pr * (float)Math.sin(theta);
            POS.func_189532_c((double)((float)pos.func_177958_n() + x), (double)(pos.func_177956_o() + this.getYOffset()), (double)((float)pos.func_177952_p() + z));
            if (!this.getGroundPlant(world, POS) || !this.canGenerate(world, rand, pos, (BlockPos)POS, r) || this.getChance() >= 2 && rand.nextInt(this.getChance()) != 0) continue;
            this.generate(world, rand, (BlockPos)POS);
        }
        return true;
    }
}

