/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.config.jsons;

import net.minecraft.util.ResourceLocation;

public class JsonConfigKey {
    private final String[] path;
    private final String entry;
    private final boolean root;

    public JsonConfigKey(String entry, String ... path) {
        this.validate(entry);
        this.path = path;
        this.entry = entry;
        this.root = path.length == 0 || path.length == 1 && path[0].isEmpty();
    }

    public JsonConfigKey(String entry, ResourceLocation path) {
        this(entry, path.func_110624_b(), path.func_110623_a());
    }

    public String[] getPath() {
        return this.path;
    }

    public String getEntry() {
        return this.entry;
    }

    public boolean isRoot() {
        return this.root;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.entry.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonConfigKey)) {
            return false;
        }
        JsonConfigKey other = (JsonConfigKey)obj;
        if (other.path.length != this.path.length) {
            return false;
        }
        for (int i = 0; i < this.path.length; ++i) {
            if (this.path[i].equals(other.path[i])) continue;
            return false;
        }
        return this.entry.equals(other.entry);
    }

    public String toString() {
        if (this.root) {
            return String.format("[root]:%s", this.entry);
        }
        String p = this.path[0];
        for (int i = 1; i < this.path.length; ++i) {
            p = p + "." + this.path[i];
        }
        return String.format("%s:%s", p, this.entry);
    }

    private void validate(String entry) {
        if (entry == null) {
            throw new NullPointerException("Config key must be not null!");
        }
        if (entry.isEmpty()) {
            throw new IndexOutOfBoundsException("Config key must be not empty!");
        }
    }
}

