/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BiomeColors.class})
public abstract class BiomeColorsMixin {
    private static final int POISON_COLOR = ModMathHelper.color(92, 160, 78);
    private static final int STREAM_COLOR = ModMathHelper.color(105, 213, 244);

    @Inject(method={"getWaterColor"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getWaterColor(IBlockDisplayReader world, BlockPos pos, CallbackInfoReturnable<Integer> info) {
        int color = (Integer)info.getReturnValue();
        boolean scanDeep = true;
        BlockPos.Mutable mut = new BlockPos.Mutable();
        for (Direction d : BlockHelper.HORIZONTAL_DIRECTIONS) {
            mut.func_189533_g((Vector3i)pos).func_189536_c(d);
            if (!world.func_180495_p((BlockPos)mut).func_203425_a((Block)ModBlocks.BRIMSTONE.get())) continue;
            color = POISON_COLOR;
            scanDeep = false;
            break;
        }
        if (scanDeep) {
            int x1 = pos.func_177958_n() - 2;
            int z1 = pos.func_177952_p() - 2;
            int x2 = pos.func_177958_n() + 3;
            int z2 = pos.func_177952_p() + 3;
            mut.func_185336_p(pos.func_177956_o());
            for (int x = x1; x < x2 && scanDeep; ++x) {
                mut.func_223471_o(x);
                for (int z = z1; z < z2 && scanDeep; ++z) {
                    mut.func_223472_q(z);
                    if (Math.abs(pos.func_177958_n() - x) == 2 && Math.abs(pos.func_177952_p() - z) == 2 || !world.func_180495_p((BlockPos)mut).func_203425_a((Block)ModBlocks.BRIMSTONE.get())) continue;
                    color = STREAM_COLOR;
                    scanDeep = false;
                }
            }
        }
        info.setReturnValue((Object)color);
    }
}

