/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import mod.beethoven92.betterendforge.common.util.BackgroundInfo;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public abstract class WorldRendererMixin {
    private static final ResourceLocation NEBULA_1 = new ResourceLocation("betterendforge", "textures/sky/nebula_2.png");
    private static final ResourceLocation NEBULA_2 = new ResourceLocation("betterendforge", "textures/sky/nebula_3.png");
    private static final ResourceLocation HORIZON = new ResourceLocation("betterendforge", "textures/sky/nebula_1.png");
    private static final ResourceLocation FOG = new ResourceLocation("betterendforge", "textures/sky/fog.png");
    private static final ResourceLocation STARS = new ResourceLocation("betterendforge", "textures/sky/stars.png");
    private static VertexBuffer stars1;
    private static VertexBuffer stars2;
    private static VertexBuffer stars3;
    private static VertexBuffer stars4;
    private static VertexBuffer nebulas1;
    private static VertexBuffer nebulas2;
    private static VertexBuffer horizon;
    private static VertexBuffer fog;
    private static Vector3f axis1;
    private static Vector3f axis2;
    private static Vector3f axis3;
    private static Vector3f axis4;
    private static float time;
    private static float time2;
    private static float time3;
    private static float blind02;
    private static float blind06;
    private static boolean directOpenGL;
    @Shadow
    @Final
    private Minecraft field_72777_q;
    @Shadow
    @Final
    private TextureManager field_72770_i;
    @Shadow
    private ClientWorld field_72769_h;
    @Shadow
    private int field_72773_u;

    @Inject(method={"<init>*"}, at={@At(value="TAIL")})
    private void onInit(Minecraft client, RenderTypeBuffers rainTimeBuffersIn, CallbackInfo info) {
        this.initStars();
        Random random = new Random(131L);
        axis1 = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
        axis2 = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
        axis3 = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
        axis4 = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
        axis1.func_229194_d_();
        axis2.func_229194_d_();
        axis3.func_229194_d_();
        axis4.func_229194_d_();
    }

    @Inject(method={"renderSkyEnd"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderSkyEnd(MatrixStack matrices, CallbackInfo info) {
        if (ClientConfig.shouldCustomSkyRender()) {
            float a;
            time = (float)(this.field_72773_u % 360000) * 1.7453292E-5f;
            time2 = time * 2.0f;
            time3 = time * 3.0f;
            FogRenderer.func_228370_a_();
            RenderSystem.enableTexture();
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glEnable((int)3042);
            RenderSystem.depthMask((boolean)false);
            float blindA = 1.0f - BackgroundInfo.blindness;
            blind02 = blindA * 0.2f;
            blind06 = blindA * 0.6f;
            if (blindA > 0.0f) {
                matrices.func_227860_a_();
                matrices.func_227866_c_().func_227870_a_().func_226596_a_(new Quaternion(0.0f, time, 0.0f, false));
                this.field_72770_i.func_110577_a(HORIZON);
                this.renderBuffer(matrices, horizon, DefaultVertexFormats.field_181707_g, 0.77f, 0.31f, 0.73f, 0.7f * blindA);
                matrices.func_227865_b_();
                matrices.func_227860_a_();
                matrices.func_227866_c_().func_227870_a_().func_226596_a_(new Quaternion(0.0f, -time, 0.0f, false));
                this.field_72770_i.func_110577_a(NEBULA_1);
                this.renderBuffer(matrices, nebulas1, DefaultVertexFormats.field_181707_g, 0.77f, 0.31f, 0.73f, blind02);
                matrices.func_227865_b_();
                matrices.func_227860_a_();
                matrices.func_227866_c_().func_227870_a_().func_226596_a_(new Quaternion(0.0f, time2, 0.0f, false));
                this.field_72770_i.func_110577_a(NEBULA_2);
                this.renderBuffer(matrices, nebulas2, DefaultVertexFormats.field_181707_g, 0.77f, 0.31f, 0.73f, blind02);
                matrices.func_227865_b_();
                this.field_72770_i.func_110577_a(STARS);
                matrices.func_227860_a_();
                matrices.func_227866_c_().func_227870_a_().func_226596_a_(axis3.func_229193_c_(time));
                this.renderBuffer(matrices, stars3, DefaultVertexFormats.field_181707_g, 0.77f, 0.31f, 0.73f, blind06);
                matrices.func_227865_b_();
                matrices.func_227860_a_();
                matrices.func_227866_c_().func_227870_a_().func_226596_a_(axis4.func_229193_c_(time2));
                this.renderBuffer(matrices, stars4, DefaultVertexFormats.field_181707_g, 1.0f, 1.0f, 1.0f, blind06);
                matrices.func_227865_b_();
            }
            if ((a = BackgroundInfo.fog - 1.0f) > 0.0f) {
                if (a > 1.0f) {
                    a = 1.0f;
                }
                this.field_72770_i.func_110577_a(FOG);
                this.renderBuffer(matrices, fog, DefaultVertexFormats.field_181707_g, BackgroundInfo.red, BackgroundInfo.green, BackgroundInfo.blue, a);
            }
            RenderSystem.disableTexture();
            if (blindA > 0.0f) {
                matrices.func_227860_a_();
                matrices.func_227866_c_().func_227870_a_().func_226596_a_(axis1.func_229193_c_(time3));
                this.renderBuffer(matrices, stars1, DefaultVertexFormats.field_181705_e, 1.0f, 1.0f, 1.0f, blind06);
                matrices.func_227865_b_();
                matrices.func_227860_a_();
                matrices.func_227866_c_().func_227870_a_().func_226596_a_(axis2.func_229193_c_(time2));
                this.renderBuffer(matrices, stars2, DefaultVertexFormats.field_181705_e, 0.95f, 0.64f, 0.93f, blind06);
                matrices.func_227865_b_();
            }
            RenderSystem.enableTexture();
            RenderSystem.depthMask((boolean)true);
            info.cancel();
        }
    }

    private void renderBuffer(MatrixStack matrixStackIn, VertexBuffer buffer, VertexFormat format, float r, float g, float b, float a) {
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        buffer.func_177359_a();
        format.func_227892_a_(0L);
        buffer.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        format.func_227895_d_();
    }

    private void initStars() {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        stars1 = this.buildBufferStars(buffer, stars1, 0.1, 0.3, 3500, 41315L);
        stars2 = this.buildBufferStars(buffer, stars2, 0.1, 0.35, 2000, 35151L);
        stars3 = this.buildBufferUVStars(buffer, stars3, 0.4, 1.2, 1000, 61354L);
        stars4 = this.buildBufferUVStars(buffer, stars4, 0.4, 1.2, 1000, 61355L);
        nebulas1 = this.buildBufferFarFog(buffer, nebulas1, 40.0, 60.0, 30, 11515L);
        nebulas2 = this.buildBufferFarFog(buffer, nebulas2, 40.0, 60.0, 10, 14151L);
        horizon = this.buildBufferHorizon(buffer, horizon);
        fog = this.buildBufferFog(buffer, fog);
    }

    private VertexBuffer buildBufferStars(BufferBuilder bufferBuilder, VertexBuffer buffer, double minSize, double maxSize, int count, long seed) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new VertexBuffer(DefaultVertexFormats.field_181705_e);
        this.makeStars(bufferBuilder, minSize, maxSize, count, seed);
        bufferBuilder.func_178977_d();
        buffer.func_227875_a_(bufferBuilder);
        return buffer;
    }

    private VertexBuffer buildBufferUVStars(BufferBuilder bufferBuilder, VertexBuffer buffer, double minSize, double maxSize, int count, long seed) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new VertexBuffer(DefaultVertexFormats.field_181707_g);
        this.makeUVStars(bufferBuilder, minSize, maxSize, count, seed);
        bufferBuilder.func_178977_d();
        buffer.func_227875_a_(bufferBuilder);
        return buffer;
    }

    private VertexBuffer buildBufferFarFog(BufferBuilder bufferBuilder, VertexBuffer buffer, double minSize, double maxSize, int count, long seed) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new VertexBuffer(DefaultVertexFormats.field_181707_g);
        this.makeFarFog(bufferBuilder, minSize, maxSize, count, seed);
        bufferBuilder.func_178977_d();
        buffer.func_227875_a_(bufferBuilder);
        return buffer;
    }

    private VertexBuffer buildBufferHorizon(BufferBuilder bufferBuilder, VertexBuffer buffer) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new VertexBuffer(DefaultVertexFormats.field_181707_g);
        this.makeCylinder(bufferBuilder, 16, 50.0, 100.0);
        bufferBuilder.func_178977_d();
        buffer.func_227875_a_(bufferBuilder);
        return buffer;
    }

    private VertexBuffer buildBufferFog(BufferBuilder bufferBuilder, VertexBuffer buffer) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new VertexBuffer(DefaultVertexFormats.field_181707_g);
        this.makeCylinder(bufferBuilder, 16, 50.0, 70.0);
        bufferBuilder.func_178977_d();
        buffer.func_227875_a_(bufferBuilder);
        return buffer;
    }

    private void makeStars(BufferBuilder buffer, double minSize, double maxSize, int count, long seed) {
        Random random = new Random(seed);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < count; ++i) {
            double posX = random.nextDouble() * 2.0 - 1.0;
            double posY = random.nextDouble() * 2.0 - 1.0;
            double posZ = random.nextDouble() * 2.0 - 1.0;
            double size = MathHelper.func_82716_a((Random)random, (double)minSize, (double)maxSize);
            double length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = 1.0 / Math.sqrt(length);
            double j = (posX *= length) * 100.0;
            double k = (posY *= length) * 100.0;
            double l = (posZ *= length) * 100.0;
            double m = Math.atan2(posX, posZ);
            double n = Math.sin(m);
            double o = Math.cos(m);
            double p = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double q = Math.sin(p);
            double r = Math.cos(p);
            double s = random.nextDouble() * Math.PI * 2.0;
            double t = Math.sin(s);
            double u = Math.cos(s);
            for (int v = 0; v < 4; ++v) {
                double x = (double)((v & 2) - 1) * size;
                double y = (double)((v + 1 & 2) - 1) * size;
                double aa = x * u - y * t;
                double ab = y * u + x * t;
                double ad = aa * q + 0.0 * r;
                double ae = 0.0 * q - aa * r;
                double af = ae * n - ab * o;
                double ah = ab * n + ae * o;
                buffer.func_225582_a_(j + af, k + ad, l + ah).func_181675_d();
            }
        }
    }

    private void makeUVStars(BufferBuilder buffer, double minSize, double maxSize, int count, long seed) {
        Random random = new Random(seed);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < count; ++i) {
            double posX = random.nextDouble() * 2.0 - 1.0;
            double posY = random.nextDouble() * 2.0 - 1.0;
            double posZ = random.nextDouble() * 2.0 - 1.0;
            double size = ModMathHelper.randRange(minSize, maxSize, random);
            double length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = 1.0 / Math.sqrt(length);
            double j = (posX *= length) * 100.0;
            double k = (posY *= length) * 100.0;
            double l = (posZ *= length) * 100.0;
            double m = Math.atan2(posX, posZ);
            double n = Math.sin(m);
            double o = Math.cos(m);
            double p = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double q = Math.sin(p);
            double r = Math.cos(p);
            double s = random.nextDouble() * Math.PI * 2.0;
            double t = Math.sin(s);
            double u = Math.cos(s);
            int pos = 0;
            float minV = (float)random.nextInt(4) / 4.0f;
            for (int v = 0; v < 4; ++v) {
                double x = (double)((v & 2) - 1) * size;
                double y = (double)((v + 1 & 2) - 1) * size;
                double aa = x * u - y * t;
                double ab = y * u + x * t;
                double ad = aa * q + 0.0 * r;
                double ae = 0.0 * q - aa * r;
                double af = ae * n - ab * o;
                double ah = ab * n + ae * o;
                float texU = pos >> 1 & 1;
                float texV = (float)(pos + 1 >> 1 & 1) / 4.0f + minV;
                ++pos;
                buffer.func_225582_a_(j + af, k + ad, l + ah).func_225583_a_(texU, texV).func_181675_d();
            }
        }
    }

    private void makeFarFog(BufferBuilder buffer, double minSize, double maxSize, int count, long seed) {
        Random random = new Random(seed);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < count; ++i) {
            double posX = random.nextDouble() * 2.0 - 1.0;
            double posY = random.nextDouble() - 0.5;
            double posZ = random.nextDouble() * 2.0 - 1.0;
            double size = MathHelper.func_82716_a((Random)random, (double)minSize, (double)maxSize);
            double length = posX * posX + posY * posY + posZ * posZ;
            double distance = 2.0;
            double delta = 1.0 / (double)count;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = distance / Math.sqrt(length);
            size *= distance;
            distance -= delta;
            double j = (posX *= length) * 100.0;
            double k = (posY *= length) * 100.0;
            double l = (posZ *= length) * 100.0;
            double m = Math.atan2(posX, posZ);
            double n = Math.sin(m);
            double o = Math.cos(m);
            double p = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double q = Math.sin(p);
            double r = Math.cos(p);
            double s = random.nextDouble() * Math.PI * 2.0;
            double t = Math.sin(s);
            double u = Math.cos(s);
            int pos = 0;
            for (int v = 0; v < 4; ++v) {
                double x = (double)((v & 2) - 1) * size;
                double y = (double)((v + 1 & 2) - 1) * size;
                double aa = x * u - y * t;
                double ab = y * u + x * t;
                double ad = aa * q + 0.0 * r;
                double ae = 0.0 * q - aa * r;
                double af = ae * n - ab * o;
                double ah = ab * n + ae * o;
                float texU = pos >> 1 & 1;
                float texV = pos + 1 >> 1 & 1;
                ++pos;
                buffer.func_225582_a_(j + af, k + ad, l + ah).func_225583_a_(texU, texV).func_181675_d();
            }
        }
    }

    private void makeCylinder(BufferBuilder buffer, int segments, double height, double radius) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < segments; ++i) {
            double a1 = (double)i * Math.PI * 2.0 / (double)segments;
            double a2 = (double)(i + 1) * Math.PI * 2.0 / (double)segments;
            double px1 = Math.sin(a1) * radius;
            double pz1 = Math.cos(a1) * radius;
            double px2 = Math.sin(a2) * radius;
            double pz2 = Math.cos(a2) * radius;
            float u0 = (float)i / (float)segments;
            float u1 = (float)(i + 1) / (float)segments;
            buffer.func_225582_a_(px1, -height, pz1).func_225583_a_(u0, 0.0f).func_181675_d();
            buffer.func_225582_a_(px1, height, pz1).func_225583_a_(u0, 1.0f).func_181675_d();
            buffer.func_225582_a_(px2, height, pz2).func_225583_a_(u1, 1.0f).func_181675_d();
            buffer.func_225582_a_(px2, -height, pz2).func_225583_a_(u1, 0.0f).func_181675_d();
        }
    }

    static {
        directOpenGL = false;
    }
}

