/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.EnergyContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.item.IAugmentableItem;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class EnergyContainerItemAugmentable
extends EnergyContainerItem
implements IAugmentableItem {
    protected IntSupplier numSlots = () -> 0;
    protected BiPredicate<ItemStack, List<ItemStack>> augValidator = (e, f) -> true;

    public EnergyContainerItemAugmentable(Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder, maxEnergy, maxTransfer);
    }

    public EnergyContainerItemAugmentable setNumSlots(IntSupplier numSlots) {
        this.numSlots = numSlots;
        return this;
    }

    public EnergyContainerItemAugmentable setAugValidator(BiPredicate<ItemStack, List<ItemStack>> augValidator) {
        this.augValidator = augValidator;
        return this;
    }

    @Override
    public int getItemEnchantability(ItemStack stack) {
        return Math.round((float)super.getItemEnchantability(stack) * this.getBaseMod(stack));
    }

    protected float getBaseMod(ItemStack stack) {
        return AugmentableHelper.getPropertyWithDefault(stack, "BaseMod", 1.0f);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax(subTag, augmentData, "BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax(subTag, augmentData, "RFMax");
        AugmentableHelper.setAttributeFromAugmentMax(subTag, augmentData, "RFXfer");
        AugmentableHelper.setAttributeFromAugmentMax(subTag, augmentData, "RFCre");
    }

    @Override
    public int getExtract(ItemStack container) {
        float base = AugmentableHelper.getPropertyWithDefault(container, "BaseMod", 1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault(container, "RFXfer", 1.0f);
        return Math.round((float)this.extract * mod * base);
    }

    @Override
    public int getReceive(ItemStack container) {
        float base = AugmentableHelper.getPropertyWithDefault(container, "BaseMod", 1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault(container, "RFXfer", 1.0f);
        return Math.round((float)this.receive * mod * base);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        float base = AugmentableHelper.getPropertyWithDefault(container, "BaseMod", 1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault(container, "RFMax", 1.0f);
        return this.getMaxStored(container, Math.round((float)this.maxEnergy * mod * base));
    }

    @Override
    public int getAugmentSlots(ItemStack augmentable) {
        return this.numSlots.getAsInt();
    }

    @Override
    public boolean validAugment(ItemStack augmentable, ItemStack augment, List<ItemStack> augments) {
        return this.augValidator.test(augment, augments);
    }

    @Override
    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.func_196082_o().func_218657_a("Properties", (INBT)new CompoundNBT());
        for (ItemStack augment : augments) {
            CompoundNBT augmentData = AugmentDataHelper.getAugmentData(augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
        if (this.isCreative(container, ContainerType.ENERGY)) {
            this.setEnergyStored(container, this.getMaxEnergyStored(container));
        } else {
            int energyExcess = this.getEnergyStored(container) - this.getMaxEnergyStored(container);
            if (energyExcess > 0) {
                this.setEnergyStored(container, this.getMaxEnergyStored(container));
            }
        }
    }
}

