/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.FluidContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.item.IAugmentableItem;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidContainerItemAugmentable
extends FluidContainerItem
implements IAugmentableItem {
    protected IntSupplier numSlots = () -> 0;
    protected BiPredicate<ItemStack, List<ItemStack>> augValidator = (e, f) -> true;

    public FluidContainerItemAugmentable(Item.Properties builder, int fluidCapacity, Predicate<FluidStack> validator) {
        super(builder, fluidCapacity, validator);
    }

    public FluidContainerItemAugmentable(Item.Properties builder, int fluidCapacity) {
        super(builder, fluidCapacity);
    }

    public FluidContainerItemAugmentable setNumSlots(IntSupplier numSlots) {
        this.numSlots = numSlots;
        return this;
    }

    public FluidContainerItemAugmentable setAugValidator(BiPredicate<ItemStack, List<ItemStack>> augValidator) {
        this.augValidator = augValidator;
        return this;
    }

    @Override
    public int getItemEnchantability(ItemStack stack) {
        return Math.round((float)super.getItemEnchantability(stack) * this.getBaseMod(stack));
    }

    protected float getBaseMod(ItemStack stack) {
        return AugmentableHelper.getPropertyWithDefault(stack, "BaseMod", 1.0f);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax(subTag, augmentData, "BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax(subTag, augmentData, "FluidMax");
        AugmentableHelper.setAttributeFromAugmentMax(subTag, augmentData, "FluidCre");
    }

    protected int getEffectAmplifier(EffectInstance effect, ItemStack stack) {
        return Math.min(3, Math.round((float)effect.func_76458_c() + this.getPotionAmplifierMod(stack)));
    }

    protected int getEffectDuration(EffectInstance effect, ItemStack stack) {
        return Math.min(72000, Math.round((float)effect.func_76459_b() * this.getPotionDurationMod(stack)));
    }

    protected float getPotionAmplifierMod(ItemStack stack) {
        return AugmentableHelper.getPropertyWithDefault(stack, "PotionAmp", 0.0f);
    }

    protected float getPotionDurationMod(ItemStack stack) {
        return 1.0f + AugmentableHelper.getPropertyWithDefault(stack, "PotionDur", 0.0f);
    }

    @Override
    public int getCapacity(ItemStack container) {
        float base = AugmentableHelper.getPropertyWithDefault(container, "BaseMod", 1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault(container, "FluidMax", 1.0f);
        return this.getMaxStored(container, Math.round((float)this.fluidCapacity * mod * base));
    }

    @Override
    public int getAugmentSlots(ItemStack augmentable) {
        return this.numSlots.getAsInt();
    }

    @Override
    public boolean validAugment(ItemStack augmentable, ItemStack augment, List<ItemStack> augments) {
        return this.augValidator.test(augment, augments);
    }

    @Override
    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.func_196082_o().func_218657_a("Properties", (INBT)new CompoundNBT());
        for (ItemStack augment : augments) {
            CompoundNBT augmentData = AugmentDataHelper.getAugmentData(augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
        FluidStack fluid = this.getFluid(container);
        if (this.isCreative(container, ContainerType.FLUID)) {
            if (!fluid.isEmpty()) {
                this.fill(container, new FluidStack(fluid, this.getSpace(container)), IFluidHandler.FluidAction.EXECUTE);
            }
        } else {
            int fluidExcess = this.getFluidAmount(container) - this.getCapacity(container);
            if (fluidExcess > 0) {
                this.drain(container, fluidExcess, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }
}

