/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.filter.IFilterableTile;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FilterGuiOpenPacket
extends PacketBase
implements IPacketServer {
    public static byte TILE = 0;
    public static byte FILTER = 1;
    protected BlockPos pos;
    protected byte mode;

    public FilterGuiOpenPacket() {
        super(20, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.func_195588_v(this.pos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof IFilterableTile) {
            if (this.mode == TILE) {
                ((IFilterableTile)tile).openGui(player);
            } else if (this.mode == FILTER) {
                ((IFilterableTile)tile).openFilterGui(player);
            }
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeByte((int)this.mode);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.mode = buf.readByte();
    }

    public static void openFilterGui(IFilterableTile tile) {
        FilterGuiOpenPacket.sendToServer(tile, FILTER);
    }

    public static void openTileGui(IFilterableTile tile) {
        FilterGuiOpenPacket.sendToServer(tile, TILE);
    }

    protected static void sendToServer(IFilterableTile tile, byte mode) {
        FilterGuiOpenPacket packet = new FilterGuiOpenPacket();
        packet.pos = tile.pos();
        packet.mode = mode;
        packet.sendToServer();
    }
}

