/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.control;

import cofh.core.network.packet.server.TransferControlPacket;
import cofh.core.util.control.ITransferControllableTile;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.control.ITransferControllable;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class TransferControlModule
implements ITransferControllable {
    protected ITransferControllableTile tile;
    protected BooleanSupplier enabled;
    protected boolean enableAutoInput;
    protected boolean enableAutoOutput;

    public TransferControlModule(ITransferControllableTile tile) {
        this(tile, Constants.TRUE);
    }

    public TransferControlModule(ITransferControllableTile tile, BooleanSupplier enabled) {
        this.tile = tile;
        this.enabled = enabled;
    }

    public TransferControlModule setEnabled(BooleanSupplier enabled) {
        this.enabled = enabled;
        return this;
    }

    public void disable() {
        this.enableAutoInput = false;
        this.enableAutoOutput = false;
    }

    public void readFromBuffer(PacketBuffer buffer) {
        this.enableAutoInput = buffer.readBoolean();
        this.enableAutoOutput = buffer.readBoolean();
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeBoolean(this.enableAutoInput);
        buffer.writeBoolean(this.enableAutoOutput);
    }

    public TransferControlModule read(CompoundNBT nbt) {
        CompoundNBT subTag = nbt.func_74775_l("Xfer");
        if (!subTag.isEmpty()) {
            this.enableAutoInput = subTag.func_74767_n("XferIn");
            this.enableAutoOutput = subTag.func_74767_n("XferOut");
        }
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        CompoundNBT subTag = new CompoundNBT();
        if (this.enabled.getAsBoolean()) {
            subTag.func_74757_a("XferIn", this.enableAutoInput);
            subTag.func_74757_a("XferOut", this.enableAutoOutput);
            nbt.func_218657_a("Xfer", (INBT)subTag);
        }
        return nbt;
    }

    public TransferControlModule readSettings(CompoundNBT nbt) {
        if (this.enabled.getAsBoolean()) {
            return this.read(nbt);
        }
        return this;
    }

    public CompoundNBT writeSettings(CompoundNBT nbt) {
        return this.write(nbt);
    }

    @Override
    public boolean hasTransferIn() {
        return this.enabled.getAsBoolean();
    }

    @Override
    public boolean hasTransferOut() {
        return this.enabled.getAsBoolean();
    }

    @Override
    public boolean getTransferIn() {
        return this.hasTransferIn() && this.enableAutoInput;
    }

    @Override
    public boolean getTransferOut() {
        return this.hasTransferOut() && this.enableAutoOutput;
    }

    @Override
    public void setControl(boolean input, boolean output) {
        boolean curInput = this.enableAutoInput;
        boolean curOutput = this.enableAutoOutput;
        if (this.hasTransferIn()) {
            this.enableAutoInput = input;
        }
        if (this.hasTransferOut()) {
            this.enableAutoOutput = output;
        }
        if (Utils.isClientWorld(this.tile.world())) {
            TransferControlPacket.sendToServer(this.tile);
            this.enableAutoInput = curInput;
            this.enableAutoOutput = curOutput;
        } else {
            this.tile.onControlUpdate();
        }
    }
}

