/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.client.audio;

import cofh.lib.util.constants.Constants;
import java.util.function.BooleanSupplier;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class ConditionalSound
extends TickableSound {
    boolean beginFadeOut;
    boolean field_147668_j;
    int ticks = 0;
    int fadeIn = 50;
    int fadeOut = 50;
    float baseVolume = 1.0f;
    BooleanSupplier condition = Constants.FALSE;

    public ConditionalSound(SoundEvent soundIn, SoundCategory categoryIn, TileEntity tile, BooleanSupplier condition) {
        super(soundIn, categoryIn);
        this.field_147660_d = (double)tile.func_174877_v().func_177958_n() + 0.5;
        this.field_147661_e = (double)tile.func_174877_v().func_177956_o() + 0.5;
        this.field_147658_f = (double)tile.func_174877_v().func_177952_p() + 0.5;
        this.field_147659_g = true;
        this.condition = condition;
    }

    public ConditionalSound(SoundEvent soundIn, SoundCategory categoryIn, Entity entity, BooleanSupplier condition) {
        super(soundIn, categoryIn);
        this.field_147660_d = entity.func_226277_ct_();
        this.field_147661_e = entity.func_226278_cu_();
        this.field_147658_f = entity.func_226281_cx_();
        this.field_147659_g = true;
        this.condition = condition;
    }

    public ConditionalSound setFadeIn(int fadeIn) {
        this.fadeIn = Math.min(0, fadeIn);
        return this;
    }

    public ConditionalSound setFadeOut(int fadeOut) {
        this.fadeOut = Math.min(0, fadeOut);
        return this;
    }

    public float getFadeInMultiplier() {
        return this.ticks >= this.fadeIn ? 1.0f : (float)this.ticks / (float)this.fadeIn;
    }

    public float getFadeOutMultiplier() {
        return this.ticks >= this.fadeOut ? 0.0f : (float)(this.fadeOut - this.ticks) / (float)this.fadeOut;
    }

    public void func_73660_a() {
        if (!this.beginFadeOut) {
            if (this.ticks < this.fadeIn) {
                ++this.ticks;
            }
            if (!this.condition.getAsBoolean()) {
                this.beginFadeOut = true;
                this.ticks = 0;
            }
        } else {
            ++this.ticks;
        }
        float multiplier = this.beginFadeOut ? this.getFadeOutMultiplier() : this.getFadeInMultiplier();
        this.field_147662_b = this.baseVolume * multiplier;
        if (multiplier <= 0.0f) {
            this.field_147668_j = true;
        }
    }

    public boolean func_147667_k() {
        return this.field_147668_j;
    }
}

