/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.storage.WorldSavedData;

public class SocialUtils {
    private static final String TAG_FRIENDS = "cofh:friends";

    private SocialUtils() {
    }

    private static FriendData friends(ServerPlayerEntity player) {
        return (FriendData)player.func_71121_q().func_217481_x().func_215752_a(() -> new FriendData(TAG_FRIENDS), TAG_FRIENDS);
    }

    public static synchronized boolean addFriend(ServerPlayerEntity player, GameProfile friend) {
        return SocialUtils.friends(player).addFriend((PlayerEntity)player, friend);
    }

    public static synchronized boolean removeFriend(ServerPlayerEntity player, GameProfile friend) {
        return SocialUtils.friends(player).removeFriend((PlayerEntity)player, friend);
    }

    public static synchronized boolean clearFriendList(ServerPlayerEntity player) {
        return SocialUtils.friends(player).clearFriendList((PlayerEntity)player);
    }

    public static synchronized boolean clearAllFriendLists(ServerPlayerEntity player) {
        return SocialUtils.friends(player).clearAllFriendLists((PlayerEntity)player);
    }

    public static boolean isFriendOrSelf(GameProfile owner, ServerPlayerEntity player) {
        return SocialUtils.friends(player).isFriendOrSelf(owner, (PlayerEntity)player);
    }

    private static class FriendData
    extends WorldSavedData {
        private final Map<String, Set<GameProfile>> friendLists = new TreeMap<String, Set<GameProfile>>();

        FriendData(String name) {
            super(name);
        }

        boolean addFriend(PlayerEntity player, GameProfile friend) {
            if (player == null || friend == null) {
                return false;
            }
            String playerUUID = player.func_146103_bH().getId().toString();
            ObjectOpenHashSet set = this.friendLists.get(playerUUID);
            if (set == null) {
                set = new ObjectOpenHashSet();
            }
            set.add((GameProfile)friend);
            this.friendLists.put(playerUUID, (Set<GameProfile>)set);
            this.func_76185_a();
            return true;
        }

        boolean removeFriend(PlayerEntity player, GameProfile friend) {
            if (player == null || friend == null) {
                return false;
            }
            String playerUUID = player.func_146103_bH().getId().toString();
            Set<GameProfile> set = this.friendLists.get(playerUUID);
            this.func_76185_a();
            return set != null && set.remove(friend);
        }

        public boolean clearFriendList(PlayerEntity player) {
            if (player == null) {
                return false;
            }
            this.friendLists.remove(player.func_146103_bH().getId().toString());
            this.func_76185_a();
            return true;
        }

        boolean clearAllFriendLists(PlayerEntity player) {
            if (!player.func_211513_k(4)) {
                return false;
            }
            this.friendLists.clear();
            this.func_76185_a();
            return true;
        }

        boolean isFriendOrSelf(GameProfile owner, PlayerEntity player) {
            if (owner == null || player == null) {
                return false;
            }
            String friendName = player.func_146103_bH().getName();
            if (friendName.equals(owner.getName())) {
                return true;
            }
            String playerUUID = owner.getId().toString();
            Set<GameProfile> set = this.friendLists.get(playerUUID);
            return set != null && set.contains(player.func_146103_bH());
        }

        public void func_76184_a(CompoundNBT nbt) {
            for (String player : nbt.func_150296_c()) {
                ListNBT list = nbt.func_150295_c(player, 10);
                ObjectOpenHashSet friendList = new ObjectOpenHashSet();
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT subTag = list.func_150305_b(i);
                    friendList.add(new GameProfile(UUID.fromString(subTag.func_74779_i("UUID")), subTag.func_74779_i("Name")));
                }
                this.friendLists.put(player, (Set<GameProfile>)friendList);
            }
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            for (Map.Entry<String, Set<GameProfile>> friendList : this.friendLists.entrySet()) {
                ListNBT list = new ListNBT();
                for (GameProfile friend : friendList.getValue()) {
                    CompoundNBT subTag = new CompoundNBT();
                    subTag.func_74778_a("UUID", friend.getId().toString());
                    subTag.func_74778_a("Name", friend.getName());
                    list.add((Object)subTag);
                }
                nbt.func_218657_a(friendList.getKey(), (INBT)list);
            }
            return nbt;
        }
    }
}

