/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.buzzier_bees.core.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.minecraftabnormals.buzzier_bees.core.registry.BBBlocks;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BBVillagers {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"buzzier_bees");
    public static final DeferredRegister<PointOfInterestType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"buzzier_bees");
    public static final RegistryObject<PointOfInterestType> HONEY_POT = POI_TYPES.register("honey_pot", () -> new PointOfInterestType("apiarist", PointOfInterestType.func_221042_a((Block)((Block)BBBlocks.HONEY_POT.get())), 1, 1));
    public static final RegistryObject<VillagerProfession> APIARIST = PROFESSIONS.register("apiarist", () -> new VillagerProfession("apiarist", (PointOfInterestType)HONEY_POT.get(), ImmutableSet.of((Object)Items.field_226635_pU_, (Object)Items.field_226638_pX_), ImmutableSet.of(), SoundEvents.field_219701_mI));

    public static void registerVillagers() {
        BBVillagers.registerGifts();
        BBVillagers.registerPointOfInterests();
        BBVillagers.registerVillagerHouses();
    }

    private static void registerGifts() {
        GiveHeroGiftsTask.field_220403_a.put(APIARIST.get(), new ResourceLocation("buzzier_bees", "gameplay/hero_of_the_village/apiarist_gift"));
    }

    private static void registerPointOfInterests() {
        try {
            ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class}).invoke(null, HONEY_POT.get());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void registerVillagerHouses() {
        JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(new ResourceLocation("buzzier_bees", "village/apiarist_bees"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)JigsawPiece.func_242849_a((String)"buzzier_bees:village/apiarist_bees/bees_1"), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            BBVillagers.addToPool(new ResourceLocation("village/" + biome + "/houses"), new ResourceLocation("buzzier_bees", "village/apiarist_house_" + biome + "_1"), 1);
        }
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(pool);
        List shuffled = old.func_214943_b(new Random());
        ArrayList<Pair> newPieces = new ArrayList<Pair>();
        for (JigsawPiece p : shuffled) {
            newPieces.add(new Pair((Object)p, (Object)1));
        }
        newPieces.add(Pair.of((Object)new LegacySingleJigsawPiece(Either.left((Object)toAdd), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID), (Object)weight));
        ResourceLocation name = old.func_214947_b();
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243656_h, (ResourceLocation)pool, (Object)new JigsawPattern(pool, name, newPieces));
    }
}

