/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;

public class WorldFunctions {
    public static void setWorldTime(ServerWorld serverworld, Integer time) {
        if (time < 0 || time > 24000) {
            return;
        }
        Integer days = WorldFunctions.getTotalDaysPassed(serverworld);
        serverworld.func_241114_a_((long)(time + days * 24000));
    }

    public static int getTotalTimePassed(ServerWorld serverworld) {
        return (int)serverworld.func_72820_D();
    }

    public static int getTotalDaysPassed(ServerWorld serverworld) {
        Integer currenttime = WorldFunctions.getTotalTimePassed(serverworld);
        Integer days = (int)Math.floor((double)currenttime.intValue() / 24000.0);
        return days;
    }

    public static int getWorldTime(ServerWorld serverworld) {
        return WorldFunctions.getTotalTimePassed(serverworld) - WorldFunctions.getTotalDaysPassed(serverworld) * 24000;
    }

    public static String getWorldDimensionName(World world) {
        return world.func_234923_W_().func_240901_a_().toString();
    }

    public static boolean isOverworld(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("overworld");
    }

    public static boolean isNether(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("nether");
    }

    public static boolean isEnd(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("end");
    }

    public static World getWorldIfInstanceOfAndNotRemote(IWorld iworld) {
        if (iworld.func_201670_d()) {
            return null;
        }
        if (iworld instanceof World) {
            return (World)iworld;
        }
        return null;
    }

    public static String getWorldPath(ServerWorld serverworld) {
        String worldpath = serverworld.func_73046_m().func_240776_a_(FolderName.field_237253_i_).toString();
        return worldpath.substring(0, worldpath.length() - 2);
    }
}

