/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import com.blamejared.controlling.api.events.KeyEntryListenersEvent;
import com.blamejared.controlling.api.events.KeyEntryMouseClickedEvent;
import com.blamejared.controlling.api.events.KeyEntryMouseReleasedEvent;
import com.blamejared.controlling.api.events.KeyEntryRenderEvent;
import com.blamejared.controlling.client.gui.GuiCustomList;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.KeyBindingList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiNewKeyBindingList
extends GuiCustomList {
    private final ControlsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;

    public GuiNewKeyBindingList(ControlsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.field_230670_d_ = controls.field_230708_k_ + 45;
        this.field_230671_e_ = controls.field_230709_l_;
        this.field_230672_i_ = 43;
        this.field_230673_j_ = controls.field_230709_l_ - 80;
        this.field_230674_k_ = controls.field_230708_k_ + 45;
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.func_231039_at__().clear();
        this.allEntries = new ArrayList();
        Object[] akeybinding = (KeyBinding[])ArrayUtils.clone((Object[])mcIn.field_71474_y.field_74324_K);
        Arrays.sort(akeybinding);
        String s = null;
        for (Object keybinding : akeybinding) {
            int i;
            String s1 = keybinding.func_151466_e();
            if (!s1.equals(s)) {
                s = s1;
                if (!s1.endsWith(".hidden")) {
                    this.add(new CategoryEntry(s1));
                }
            }
            if ((i = mcIn.field_71466_p.func_78256_a(I18n.func_135052_a((String)keybinding.func_151464_g(), (Object[])new Object[0]))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = i;
            }
            if (s1.endsWith(".hidden")) continue;
            this.add(new KeyEntry((KeyBinding)keybinding));
        }
    }

    protected void func_230447_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        KeyBindingList.Entry entry = this.getEntryAtPos(mouseY);
        if (!(entry instanceof KeyEntry)) {
            return;
        }
        KeyEntry keyEntry = (KeyEntry)entry;
        GuiUtils.drawHoveringText((MatrixStack)matrixStack, Collections.singletonList(new TranslationTextComponent(keyEntry.getKeybinding().func_151466_e())), (int)mouseX, (int)mouseY, (int)this.mc.field_71462_r.field_230708_k_, (int)this.mc.field_71462_r.field_230709_l_, (int)0, (FontRenderer)this.mc.field_71466_p);
    }

    public KeyBindingList.Entry getEntryAtPos(double mouseY) {
        if (mouseY <= (double)this.getTop() || mouseY >= (double)this.getBottom()) {
            return null;
        }
        int i1 = MathHelper.func_76128_c((double)(mouseY - (double)this.field_230672_i_)) - this.field_230677_n_ + (int)this.func_230966_l_() - 4;
        int j1 = i1 / this.field_230669_c_;
        return i1 >= 0 && j1 < this.func_230965_k_() ? (KeyBindingList.Entry)this.func_231039_at__().get(j1) : null;
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 15 + 20;
    }

    public int func_230949_c_() {
        return super.func_230949_c_() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends KeyBindingList.Entry {
        private final KeyBinding keybinding;
        private final String keyDesc;
        private final Button btnChangeKeyBinding;
        private final Button btnResetKeyBinding;

        private KeyEntry(final KeyBinding name) {
            this.keybinding = name;
            this.keyDesc = I18n.func_135052_a((String)name.func_151464_g(), (Object[])new Object[0]);
            this.btnChangeKeyBinding = new Button(0, 0, 95, 20, (ITextComponent)new StringTextComponent(this.keyDesc), p_214386_2_ -> {
                ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).controlsScreen.field_146491_f = name;
            }){

                protected IFormattableTextComponent func_230442_c_() {
                    return name.func_197986_j() ? new TranslationTextComponent("narrator.controls.unbound", new Object[]{KeyEntry.this.keyDesc}) : new TranslationTextComponent("narrator.controls.bound", new Object[]{KeyEntry.this.keyDesc, super.func_230442_c_()});
                }
            };
            this.btnResetKeyBinding = new Button(0, 0, 50, 20, (ITextComponent)new TranslationTextComponent("controls.reset"), p_214387_2_ -> {
                this.keybinding.setToDefault();
                ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).field_230668_b_.field_71474_y.func_198014_a(name, name.func_197977_i());
                KeyBinding.func_74508_b();
            }){

                protected IFormattableTextComponent func_230442_c_() {
                    return new TranslationTextComponent("narrator.controls.reset", new Object[]{KeyEntry.this.keyDesc});
                }
            };
        }

        public void func_230432_a_(MatrixStack stack, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            MinecraftForge.EVENT_BUS.post((Event)new KeyEntryRenderEvent(this, stack, slotIndex, y, x, rowLeft, rowWidth, mouseX, mouseY, hovered, partialTicks));
            int i = y;
            int j = x;
            boolean flag = ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).controlsScreen.field_146491_f == this.keybinding;
            int length = Math.max(0, j + 90 - GuiNewKeyBindingList.this.maxListLabelWidth);
            ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_238421_b_(stack, this.keyDesc, (float)length, (float)(y + rowWidth / 2 - 4), 0xFFFFFF);
            this.btnResetKeyBinding.field_230690_l_ = x + 190 + 20;
            this.btnResetKeyBinding.field_230691_m_ = y;
            this.btnResetKeyBinding.field_230693_o_ = !this.keybinding.func_197985_l();
            this.btnResetKeyBinding.func_230430_a_(stack, mouseX, mouseY, partialTicks);
            this.btnChangeKeyBinding.field_230690_l_ = j + 105;
            this.btnChangeKeyBinding.field_230691_m_ = i;
            this.btnChangeKeyBinding.func_238482_a_(this.keybinding.func_238171_j_());
            boolean flag1 = false;
            boolean keyCodeModifierConflict = true;
            if (!this.keybinding.func_197986_j()) {
                for (KeyBinding keybinding : ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71474_y.field_74324_K) {
                    if (keybinding == this.keybinding || !this.keybinding.func_197983_b(keybinding)) continue;
                    flag1 = true;
                    keyCodeModifierConflict &= keybinding.hasKeyCodeModifierConflict(this.keybinding);
                }
            }
            ITextComponent message = this.btnChangeKeyBinding.func_230458_i_();
            if (flag) {
                this.btnChangeKeyBinding.func_238482_a_((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "> " + TextFormatting.YELLOW + message.getString() + TextFormatting.WHITE + " <"));
            } else if (flag1) {
                IFormattableTextComponent modConflict = TextComponentUtils.func_240648_a_((IFormattableTextComponent)message.func_230531_f_(), (Style)message.func_150256_b().func_240718_a_(Color.func_240743_a_((int)0xFFAA00)));
                IFormattableTextComponent keyConflict = TextComponentUtils.func_240648_a_((IFormattableTextComponent)message.func_230531_f_(), (Style)message.func_150256_b().func_240718_a_(Color.func_240743_a_((int)0xFFAA00)));
                this.btnChangeKeyBinding.func_238482_a_((ITextComponent)(keyCodeModifierConflict ? modConflict : keyConflict));
            }
            this.btnChangeKeyBinding.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        }

        public List<IGuiEventListener> func_231039_at__() {
            KeyEntryListenersEvent event = new KeyEntryListenersEvent(this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getListeners();
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int buttonId) {
            KeyEntryMouseClickedEvent event = new KeyEntryMouseClickedEvent(this, mouseX, mouseY, buttonId);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isHandled()) {
                return true;
            }
            if (this.btnChangeKeyBinding.func_231044_a_(mouseX, mouseY, buttonId)) {
                return true;
            }
            return this.btnResetKeyBinding.func_231044_a_(mouseX, mouseY, buttonId);
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int buttonId) {
            KeyEntryMouseReleasedEvent event = new KeyEntryMouseReleasedEvent(this, mouseX, mouseY, buttonId);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isHandled()) {
                return true;
            }
            return this.btnChangeKeyBinding.func_231048_c_(mouseX, mouseY, buttonId);
        }

        public KeyBinding getKeybinding() {
            return this.keybinding;
        }

        public String getKeyDesc() {
            return this.keyDesc;
        }

        public Button getBtnResetKeyBinding() {
            return this.btnResetKeyBinding;
        }

        public Button getBtnChangeKeyBinding() {
            return this.btnChangeKeyBinding;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends KeyBindingList.Entry {
        private final String labelText;
        private final int labelWidth;
        private final String name;

        public CategoryEntry(String name) {
            this.labelText = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            this.labelWidth = ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_78256_a(this.labelText);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of();
        }

        public void func_230432_a_(MatrixStack stack, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).field_230668_b_.field_71466_p.func_238421_b_(stack, this.labelText, (float)(((GuiNewKeyBindingList)GuiNewKeyBindingList.this).field_230668_b_.field_71462_r.field_230708_k_ / 2 - this.labelWidth / 2), (float)(y + rowWidth - 9 - 1), 0xFFFFFF);
        }
    }
}

