/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.traverse.biome;

import epicsquid.traverse.biome.AridHighlandsBiomes;
import epicsquid.traverse.biome.AutumnalWoodsBiomes;
import epicsquid.traverse.biome.BiomeVariants;
import epicsquid.traverse.biome.CliffsBiomes;
import epicsquid.traverse.biome.ConiferousForestBiomes;
import epicsquid.traverse.biome.DesertShrublandBiomes;
import epicsquid.traverse.biome.LushSwampBiomes;
import epicsquid.traverse.biome.MeadowBiomes;
import epicsquid.traverse.biome.MiniJungleBiomes;
import epicsquid.traverse.biome.PlainsPlateauBiomes;
import epicsquid.traverse.biome.RollingHillsBiomes;
import epicsquid.traverse.biome.WoodedIslandBiomes;
import epicsquid.traverse.biome.WoodlandsBiomes;
import epicsquid.traverse.biomebuilder.BiomeTemplate;
import epicsquid.traverse.biomebuilder.DefaultFeature;
import epicsquid.traverse.biomebuilder.TerraformBiomeBuilder;
import epicsquid.traverse.biomebuilder.TerraformSlimeSpawnBiomes;
import epicsquid.traverse.config.ConfigManager;
import epicsquid.traverse.init.ModSurfaceBuilders;
import epicsquid.traverse.villager.TraverseVillagerTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="traverse", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TraverseBiomes {
    private static final Map<ResourceLocation, Biome> BIOMES = new HashMap<ResourceLocation, Biome>();
    static final BiomeTemplate BIOME_TEMPLATE = new BiomeTemplate(((TerraformBiomeBuilder)TerraformBiomeBuilder.create().surfaceBuilder((ConfiguredSurfaceBuilder)ModSurfaceBuilders.CONFIGURED_DEFAULT_GRASS)).addDefaultFeatures(DefaultFeature.LAND_CARVERS, DefaultFeature.DEFAULT_UNDERGROUND_STRUCTURES, DefaultFeature.DUNGEONS, DefaultFeature.MINEABLES, DefaultFeature.ORES, DefaultFeature.DISKS, DefaultFeature.DEFAULT_MUSHROOMS, DefaultFeature.DEFAULT_VEGETATION, DefaultFeature.SPRINGS, DefaultFeature.FROZEN_TOP_LAYER).addStructureFeature((StructureFeature<? extends IFeatureConfig, ? extends Structure<? extends IFeatureConfig>>)StructureFeatures.field_244145_k).addStructureFeature((StructureFeature<? extends IFeatureConfig, ? extends Structure<? extends IFeatureConfig>>)StructureFeatures.field_244136_b).precipitation(Biome.RainType.RAIN).effects(TraverseBiomes.createDefaultBiomeAmbience()));
    public static final RegistryKey<Biome> ARID_HIGHLANDS = TraverseBiomes.add("arid_highlands", AridHighlandsBiomes.ARID_HIGHLANDS);
    public static final RegistryKey<Biome> AUTUMNAL_WOODS = TraverseBiomes.add("autumnal_woods", AutumnalWoodsBiomes.AUTUMNAL_WOODS);
    public static final RegistryKey<Biome> AUTUMNAL_WOODED_HILLS = TraverseBiomes.add("autumnal_wooded_hills", AutumnalWoodsBiomes.AUTUMNAL_WOODED_HILLS);
    public static final RegistryKey<Biome> CLIFFS = TraverseBiomes.add("cliffs", CliffsBiomes.CLIFFS);
    public static final RegistryKey<Biome> SNOWY_CLIFFS = TraverseBiomes.add("snowy_cliffs", CliffsBiomes.SNOWY_CLIFFS);
    public static final RegistryKey<Biome> CONIFEROUS_FOREST = TraverseBiomes.add("coniferous_forest", ConiferousForestBiomes.CONIFEROUS_FOREST);
    public static final RegistryKey<Biome> CONIFEROUS_WOODED_HILLS = TraverseBiomes.add("coniferous_wooded_hills", ConiferousForestBiomes.CONIFEROUS_WOOODED_HILLS);
    public static final RegistryKey<Biome> DESERT_SHRUBLAND = TraverseBiomes.add("desert_shrubland", DesertShrublandBiomes.DESERT_SHRUBLAND);
    public static final RegistryKey<Biome> HIGH_CONIFEROUS_FOREST = TraverseBiomes.add("high_coniferous_forest", ConiferousForestBiomes.HIGH_CONIFEROUS_FOREST);
    public static final RegistryKey<Biome> LUSH_SWAMP = TraverseBiomes.add("lush_swamp", LushSwampBiomes.LUSH_SWAMP);
    public static final RegistryKey<Biome> MEADOW = TraverseBiomes.add("meadow", MeadowBiomes.MEADOW);
    public static final RegistryKey<Biome> MINI_JUNGLE = TraverseBiomes.add("mini_jungle", MiniJungleBiomes.MINI_JUNGLE);
    public static final RegistryKey<Biome> PLAINS_PLATEAU = TraverseBiomes.add("plains_plateau", PlainsPlateauBiomes.PLAINS_PLATEAU);
    public static final RegistryKey<Biome> ROCKY_EDGE = TraverseBiomes.add("rocky_edge", PlainsPlateauBiomes.ROCKY_EDGE);
    public static final RegistryKey<Biome> ROLLING_HILLS = TraverseBiomes.add("rolling_hills", RollingHillsBiomes.ROLLING_HILLS);
    public static final RegistryKey<Biome> SNOWY_CONIFEROUS_FOREST = TraverseBiomes.add("snowy_coniferous_forest", ConiferousForestBiomes.SNOWY_CONIFEROUS_FOREST);
    public static final RegistryKey<Biome> SNOWY_CONIFEROUS_WOODED_HILLS = TraverseBiomes.add("snowy_coniferous_wooded_hills", ConiferousForestBiomes.SNOWY_CONIFEROUS_WOOODED_HILLS);
    public static final RegistryKey<Biome> SNOWY_HIGH_CONIFEROUS_FOREST = TraverseBiomes.add("snowy_high_coniferous_forest", ConiferousForestBiomes.SNOWY_HIGH_CONIFEROUS_FOREST);
    public static final RegistryKey<Biome> WOODED_ISLAND = TraverseBiomes.add("wooded_island", WoodedIslandBiomes.WOODED_ISLAND);
    public static final RegistryKey<Biome> WOODED_PLATEAU = TraverseBiomes.add("wooded_plateau", PlainsPlateauBiomes.WOODED_PLATEAU);
    public static final RegistryKey<Biome> WOODLANDS = TraverseBiomes.add("woodlands", WoodlandsBiomes.WOODLANDS);

    private static int getSkyColor(float temperature) {
        float f = temperature / 3.0f;
        f = MathHelper.func_76131_a((float)f, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }

    public static BiomeAmbience.Builder createDefaultBiomeAmbience() {
        return new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_242539_d(TraverseBiomes.getSkyColor(0.2f)).func_235239_a_(12638463);
    }

    private static RegistryKey<Biome> add(String name, Biome biome) {
        ResourceLocation id = new ResourceLocation("traverse", name);
        biome.setRegistryName(id);
        BIOMES.put(id, biome);
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)id);
    }

    @SubscribeEvent
    public static void onBiomeRegister(RegistryEvent.Register<Biome> event) {
        IForgeRegistry biomeRegistry = event.getRegistry();
        BIOMES.values().forEach(arg_0 -> ((IForgeRegistry)biomeRegistry).register(arg_0));
        TraverseBiomes.registerBiome(ARID_HIGHLANDS, (int)ConfigManager.ARID_HIGHLANDS.weight(), BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(AUTUMNAL_WOODED_HILLS, 0, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(AUTUMNAL_WOODS, (int)ConfigManager.AUTUMNAL_WOODS.weight(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(CLIFFS, (int)ConfigManager.CLIFFS.weight(), BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN);
        TraverseBiomes.registerBiome(SNOWY_CLIFFS, (int)ConfigManager.SNOWY_CLIFFS.weight(), BiomeManager.BiomeType.ICY, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN);
        TraverseBiomes.registerBiome(CONIFEROUS_FOREST, (int)ConfigManager.CONIFEROUS_FOREST.weight(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(CONIFEROUS_WOODED_HILLS, 0, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(DESERT_SHRUBLAND, (int)ConfigManager.DESERT_SHRUBLAND.weight(), BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(HIGH_CONIFEROUS_FOREST, (int)ConfigManager.HIGH_CONIFEROUS_FOREST.weight(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(LUSH_SWAMP, 0, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(MEADOW, (int)ConfigManager.MEADOW.weight(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(MINI_JUNGLE, (int)ConfigManager.MINI_JUNGLE.weight(), BiomeManager.BiomeType.WARM, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(PLAINS_PLATEAU, (int)ConfigManager.PLAINS_PLATEAU.weight(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(ROCKY_EDGE, 0, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(ROLLING_HILLS, (int)ConfigManager.ROLLING_HILLS.weight(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(SNOWY_CONIFEROUS_FOREST, (int)ConfigManager.SNOWY_CONIFEROUS_FOREST.weight(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(SNOWY_CONIFEROUS_WOODED_HILLS, 0, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(SNOWY_HIGH_CONIFEROUS_FOREST, (int)ConfigManager.SNOWY_HIGH_CONIFEROUS_FOREST.weight(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(WOODED_PLATEAU, 0, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(WOODLANDS, (int)ConfigManager.WOODLANDS.weight(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        TraverseBiomes.registerBiome(WOODED_ISLAND, 0, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        TerraformSlimeSpawnBiomes.addSlimeSpawnBiome(LUSH_SWAMP);
        if (ConfigManager.WOODED_ISLAND.shouldSpawn()) {
            BiomeVariants.addReplacement((RegistryKey<Biome>)Biomes.field_203619_Y, WOODED_ISLAND, 0.1, BiomeVariants.VariantType.BIOME);
            BiomeVariants.addReplacement((RegistryKey<Biome>)Biomes.field_203618_X, WOODED_ISLAND, 0.1, BiomeVariants.VariantType.BIOME);
            BiomeVariants.addReplacement((RegistryKey<Biome>)Biomes.field_150575_M, WOODED_ISLAND, 0.1, BiomeVariants.VariantType.BIOME);
        }
        if (ConfigManager.LUSH_SWAMP.shouldSpawn()) {
            BiomeVariants.addReplacement((RegistryKey<Biome>)Biomes.field_76780_h, LUSH_SWAMP, 0.2, BiomeVariants.VariantType.BIOME);
        }
        if (ConfigManager.MINI_JUNGLE.shouldSpawn()) {
            BiomeVariants.addReplacement((RegistryKey<Biome>)Biomes.field_76782_w, MINI_JUNGLE, 0.15, BiomeVariants.VariantType.BIOME);
        }
        if (ConfigManager.MEADOW.shouldSpawn()) {
            BiomeVariants.addReplacement((RegistryKey<Biome>)Biomes.field_76772_c, MEADOW, 0.2, BiomeVariants.VariantType.BIOME);
        }
        BiomeVariants.addReplacement(AUTUMNAL_WOODS, AUTUMNAL_WOODED_HILLS, 1.0, BiomeVariants.VariantType.HILLS);
        BiomeVariants.addReplacement(CONIFEROUS_FOREST, CONIFEROUS_WOODED_HILLS, 1.0, BiomeVariants.VariantType.HILLS);
        BiomeVariants.addReplacement(SNOWY_CONIFEROUS_FOREST, SNOWY_CONIFEROUS_WOODED_HILLS, 1.0, BiomeVariants.VariantType.HILLS);
        BiomeVariants.addReplacement(PLAINS_PLATEAU, WOODED_PLATEAU, 1.0, BiomeVariants.VariantType.HILLS);
        BiomeVariants.addReplacement(PLAINS_PLATEAU, PLAINS_PLATEAU, 1.0, BiomeVariants.VariantType.RIVER);
        BiomeVariants.addReplacement(PLAINS_PLATEAU, ROCKY_EDGE, 1.0, BiomeVariants.VariantType.EDGE);
        BiomeVariants.addReplacement(CLIFFS, ROLLING_HILLS, 1.0, BiomeVariants.VariantType.CENTER);
        BiomeVariants.addReplacement(SNOWY_CLIFFS, (RegistryKey<Biome>)Biomes.field_150579_T, 1.0, BiomeVariants.VariantType.CENTER);
        BiomeVariants.addReplacement(WOODED_ISLAND, WOODED_ISLAND, 1.0, BiomeVariants.VariantType.SHORE);
        TraverseVillagerTypes.register();
    }

    private static void registerBiome(RegistryKey<Biome> key, int weight, BiomeManager.BiomeType type, BiomeDictionary.Type ... types) {
        if (weight > 0) {
            BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(key, weight));
            BiomeDictionary.addTypes(key, (BiomeDictionary.Type[])types);
        }
    }
}

