/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.fluidcollision;

import be.florens.expandability.EventDispatcher;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @ModifyVariable(method={"move"}, ordinal=1, index=3, name={"vec32"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    private Vector3d fluidCollision(Vector3d originalDisplacement) {
        if (!(this instanceof LivingEntity)) {
            return originalDisplacement;
        }
        LivingEntity entity = (LivingEntity)this;
        if (originalDisplacement.field_72448_b <= 0.0 && !EntityMixin.isTouchingFluid(entity, entity.func_174813_aQ().func_186664_h(0.001))) {
            Map<Vector3d, Double> points = EntityMixin.findFluidDistances(entity, originalDisplacement);
            Double highestDistance = null;
            for (Map.Entry<Vector3d, Double> point : points.entrySet()) {
                if (highestDistance != null && (point.getValue() == null || !(point.getValue() > highestDistance))) continue;
                highestDistance = point.getValue();
            }
            if (highestDistance != null) {
                Vector3d finalDisplacement = new Vector3d(originalDisplacement.field_72450_a, highestDistance.doubleValue(), originalDisplacement.field_72449_c);
                AxisAlignedBB finalBox = entity.func_174813_aQ().func_191194_a(finalDisplacement).func_186664_h(0.001);
                if (EntityMixin.isTouchingFluid(entity, finalBox)) {
                    return originalDisplacement;
                }
                entity.field_70143_R = 0.0f;
                entity.func_230245_c_(true);
                return finalDisplacement;
            }
        }
        return originalDisplacement;
    }

    @Unique
    private static Map<Vector3d, Double> findFluidDistances(LivingEntity entity, Vector3d originalDisplacement) {
        AxisAlignedBB box = entity.func_174813_aQ().func_191194_a(originalDisplacement);
        HashMap<Vector3d, Double> points = new HashMap<Vector3d, Double>();
        points.put(new Vector3d(box.field_72340_a, box.field_72338_b, box.field_72339_c), null);
        points.put(new Vector3d(box.field_72340_a, box.field_72338_b, box.field_72334_f), null);
        points.put(new Vector3d(box.field_72336_d, box.field_72338_b, box.field_72339_c), null);
        points.put(new Vector3d(box.field_72336_d, box.field_72338_b, box.field_72334_f), null);
        double fluidStepHeight = entity.func_233570_aj_() ? Math.max(1.0, (double)entity.field_70138_W) : 0.0;
        block0: for (Map.Entry entry : points.entrySet()) {
            int i = 0;
            while (true) {
                double limitingVelocity;
                BlockPos landingPos = new BlockPos((Vector3d)entry.getKey()).func_177963_a(0.0, (double)i + fluidStepHeight, 0.0);
                FluidState landingState = entity.func_130014_f_().func_204610_c(landingPos);
                double distanceToFluidSurface = (double)((float)landingPos.func_177956_o() + landingState.func_223408_f()) - entity.func_226278_cu_();
                if (distanceToFluidSurface < (limitingVelocity = originalDisplacement.field_72448_b) || distanceToFluidSurface > fluidStepHeight) continue block0;
                if (!landingState.func_206888_e() && EventDispatcher.onLivingFluidCollision(entity, landingState)) {
                    entry.setValue(distanceToFluidSurface);
                    continue block0;
                }
                --i;
            }
        }
        return points;
    }

    @Unique
    private static boolean isTouchingFluid(LivingEntity entity, AxisAlignedBB box) {
        int minX = MathHelper.func_76128_c((double)box.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)box.field_72336_d);
        int minY = MathHelper.func_76128_c((double)box.field_72338_b);
        int maxY = MathHelper.func_76143_f((double)box.field_72337_e);
        int minZ = MathHelper.func_76128_c((double)box.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)box.field_72334_f);
        World world = entity.func_130014_f_();
        if (world.func_217344_a(minX, minY, minZ, maxX, maxY, maxZ)) {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int i = minX; i < maxX; ++i) {
                for (int j = minY; j < maxY; ++j) {
                    for (int k = minZ; k < maxZ; ++k) {
                        double surfaceY;
                        mutable.func_181079_c(i, j, k);
                        FluidState fluidState = world.func_204610_c((BlockPos)mutable);
                        if (fluidState.func_206888_e() || !((surfaceY = (double)(fluidState.func_215679_a((IBlockReader)world, (BlockPos)mutable) + (float)j)) >= box.field_72338_b)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

