/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiHolder;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeStringRenderPattern;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerAspectSettings;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;

public class ContainerScreenAspectSettings
extends ContainerScreenExtended<ContainerAspectSettings> {
    private static final int ERROR_WIDTH = 13;
    private static final int ERROR_HEIGHT = 13;
    private static final int OK_WIDTH = 14;
    private static final int OK_HEIGHT = 12;
    private final List<IAspectPropertyTypeInstance> propertyTypes;
    protected final SubGuiHolder subGuiHolder = new SubGuiHolder();
    protected GuiElementValueTypeString<ContainerScreenAspectSettings, ContainerAspectSettings> guiElement = null;
    protected int activePropertyIndex = 0;
    protected GuiElementValueTypeStringRenderPattern propertyConfigPattern = null;
    protected SubGuiValueTypeInfo propertyInfo = null;
    private ButtonText buttonLeft = null;
    private ButtonText buttonRight = null;
    private ButtonText buttonExit = null;
    private ITextComponent lastError;

    public ContainerScreenAspectSettings(ContainerAspectSettings container, PlayerInventory inventory, ITextComponent title) {
        super((ContainerExtended)container, inventory, title);
        this.propertyTypes = Lists.newArrayList(container.getAspect().getDefaultProperties().getTypes());
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/aspect_settings.png");
    }

    public int getActivePropertyIndex() {
        return this.activePropertyIndex;
    }

    protected void saveSetting() {
        if (this.guiElement != null && this.lastError == null) {
            try {
                ((ContainerAspectSettings)this.field_147002_h).setValue(this.getActiveProperty(), (IValue)ValueHelpers.parseString(this.guiElement.getValueType(), this.guiElement.getInputString()));
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
    }

    protected void refreshButtonEnabled() {
        this.buttonLeft.field_230693_o_ = this.getActivePropertyIndex() > 0;
        this.buttonRight.field_230693_o_ = this.getActivePropertyIndex() < this.propertyTypes.size() - 1;
    }

    protected int getBaseYSize() {
        return 213;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.subGuiHolder.init(this.field_147003_i, this.field_147009_r);
        this.buttonExit = new ButtonText(this.field_147003_i + 7, this.field_147009_r + 5, 12, 10, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.up"), (ITextComponent)new StringTextComponent("<<"), this.createServerPressable("button_exit", button -> this.saveSetting()), true);
        this.func_230480_a_((Widget)this.buttonExit);
        this.buttonLeft = new ButtonText(this.field_147003_i + 21, this.field_147009_r + 5, 10, 10, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.left"), (ITextComponent)new StringTextComponent("<"), button -> {
            this.saveSetting();
            if (this.getActivePropertyIndex() > 0) {
                this.setActiveProperty(this.getActivePropertyIndex() - 1);
                this.refreshButtonEnabled();
            }
        }, true);
        this.func_230480_a_((Widget)this.buttonLeft);
        this.buttonRight = new ButtonText(this.field_147003_i + 159, this.field_147009_r + 5, 10, 10, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.right"), (ITextComponent)new StringTextComponent(">"), button -> {
            this.saveSetting();
            if (this.getActivePropertyIndex() < this.propertyTypes.size()) {
                this.setActiveProperty(this.getActivePropertyIndex() + 1);
                this.refreshButtonEnabled();
            }
        }, true);
        this.func_230480_a_((Widget)this.buttonRight);
        this.refreshButtonEnabled();
        this.setActiveProperty(this.activePropertyIndex);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.subGuiHolder.drawGuiContainerBackgroundLayer(matrixStack, this.field_147003_i, this.field_147009_r, this.getMinecraft().func_110434_K(), this.field_230712_o_, partialTicks, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.subGuiHolder.drawGuiContainerForegroundLayer(matrixStack, this.field_147003_i, this.field_147009_r, this.getMinecraft().func_110434_K(), this.field_230712_o_, mouseX, mouseY);
        IAspectPropertyTypeInstance activeProperty = this.getActiveProperty();
        if (activeProperty != null) {
            String unlocalizedInfo;
            String label = L10NHelpers.localize((String)activeProperty.getTranslationKey(), (Object[])new Object[0]);
            RenderHelpers.drawScaledCenteredString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)label, (int)88, (int)10, (int)0, (float)1.0f, (int)140, (int)Helpers.RGBToInt((int)10, (int)10, (int)10));
            if (RenderHelpers.isPointInRegion((int)(this.field_147003_i + 40), (int)this.field_147009_r, (int)110, (int)20, (double)mouseX, (double)mouseY) && I18n.func_188566_a((String)(unlocalizedInfo = activeProperty.getTranslationKey() + ".info"))) {
                this.drawTooltip(Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent(unlocalizedInfo).func_240699_a_(TextFormatting.GRAY)}), mouseX - this.field_147003_i, mouseY - this.field_147009_r + 20);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (!this.subGuiHolder.charTyped(typedChar, keyCode)) {
            if (keyCode != 1 && this.getMinecraft().field_71474_y.field_151445_Q.getKey().func_197937_c() != keyCode) return super.func_231042_a_(typedChar, keyCode);
            this.saveSetting();
            this.getMinecraft().field_71439_g.func_71053_j();
            return false;
        } else {
            if (this.guiElement == null) return false;
            this.onValueChanged();
        }
        return false;
    }

    public boolean func_231046_a_(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            return this.subGuiHolder.keyPressed(typedChar, keyCode, modifiers);
        }
        this.saveSetting();
        return super.func_231046_a_(typedChar, keyCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        return this.subGuiHolder.mouseClicked(mouseX, mouseY, mouseButton) || super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    protected void onValueChanged() {
        this.lastError = this.guiElement.validate();
    }

    protected IAspectPropertyTypeInstance getActiveProperty() {
        return this.propertyTypes.get(Math.max(0, Math.min(this.propertyTypes.size() - 1, this.activePropertyIndex)));
    }

    protected void setActiveProperty(int index) {
        this.activePropertyIndex = index;
        this.onActivateElement(this.propertyTypes.get(this.activePropertyIndex));
    }

    protected void onActivateElement(IAspectPropertyTypeInstance property) {
        if (this.guiElement != null) {
            this.guiElement.deactivate();
            this.subGuiHolder.removeSubGui(this.propertyConfigPattern);
            this.subGuiHolder.removeSubGui(this.propertyInfo);
        }
        this.guiElement = new GuiElementValueTypeString((IValueType)property.getType(), IConfigRenderPattern.NONE);
        this.guiElement.setValidator(property.getValidator());
        this.propertyConfigPattern = this.guiElement.createSubGui(8, 17, 160, 91, (AbstractGui)this, (Container)((ContainerAspectSettings)this.func_212873_a_()));
        this.subGuiHolder.addSubGui(this.propertyConfigPattern);
        this.propertyInfo = new SubGuiValueTypeInfo(this.guiElement);
        this.subGuiHolder.addSubGui(this.propertyInfo);
        this.propertyConfigPattern.init(this.field_147003_i, this.field_147009_r);
        this.guiElement.activate();
        this.syncInputValue();
        this.lastError = this.guiElement.validate();
    }

    protected void syncInputValue() {
        IAspectPropertyTypeInstance property = this.getActiveProperty();
        Object value = ((ContainerAspectSettings)this.field_147002_h).getPropertyValue(property);
        if (value != null) {
            this.guiElement.setInputString(ValueHelpers.toString(value), this.propertyConfigPattern);
        }
    }

    public void onUpdate(int valueId, CompoundNBT value) {
        super.onUpdate(valueId, value);
        IAspectPropertyTypeInstance property = (IAspectPropertyTypeInstance)((ContainerAspectSettings)this.field_147002_h).getPropertyIds().get((Object)valueId);
        if (property != null && this.getActiveProperty() == property) {
            this.syncInputValue();
        }
    }

    public class SubGuiValueTypeInfo
    extends GuiElementValueTypeString.SubGuiValueTypeInfo<RenderPattern, ContainerScreenAspectSettings, ContainerAspectSettings> {
        public SubGuiValueTypeInfo(IGuiInputElement<RenderPattern, ContainerScreenAspectSettings, ContainerAspectSettings> element) {
            super(ContainerScreenAspectSettings.this, (ContainerAspectSettings)ContainerScreenAspectSettings.this.field_147002_h, element, 8, 105, 160, 20);
        }

        @Override
        protected boolean showError() {
            return true;
        }

        @Override
        protected ITextComponent getLastError() {
            return ContainerScreenAspectSettings.this.lastError;
        }

        @Override
        protected ResourceLocation getTexture() {
            return ContainerScreenAspectSettings.this.texture;
        }
    }
}

