/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class ContainerScreenPartSettings<T extends ContainerPartSettings>
extends ContainerScreenExtended<T> {
    private WidgetNumberField numberFieldUpdateInterval = null;
    private WidgetNumberField numberFieldPriority = null;
    private WidgetNumberField numberFieldChannel = null;
    private WidgetTextFieldDropdown<Direction> dropdownFieldSide = null;
    private List<SideDropdownEntry> dropdownEntries;

    public ContainerScreenPartSettings(T container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
    }

    protected void onSave() {
        try {
            if (this.isFieldSideEnabled()) {
                Direction selectedSide = this.dropdownFieldSide.getSelectedDropdownPossibility() == null ? null : this.dropdownFieldSide.getSelectedDropdownPossibility().getValue();
                int side = selectedSide != null && selectedSide != this.getDefaultSide() ? selectedSide.ordinal() : -1;
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerPartSettings)this.func_212873_a_()).getLastSideValueId(), (int)side);
            }
            if (this.isFieldUpdateIntervalEnabled()) {
                int updateInterval = this.numberFieldUpdateInterval.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerPartSettings)this.func_212873_a_()).getLastUpdateValueId(), (int)updateInterval);
            }
            if (this.isFieldPriorityEnabled()) {
                int priority = this.numberFieldPriority.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerPartSettings)this.func_212873_a_()).getLastPriorityValueId(), (int)priority);
            }
            if (this.isFieldChannelEnabled()) {
                int channel = this.numberFieldChannel.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerPartSettings)this.func_212873_a_()).getLastChannelValueId(), (int)channel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/part_settings.png");
    }

    protected Direction getCurrentSide() {
        return ((ContainerPartSettings)this.func_212873_a_()).getTarget().getTarget().getSide();
    }

    protected Direction getDefaultSide() {
        return ((ContainerPartSettings)this.func_212873_a_()).getTarget().getCenter().getSide().func_176734_d();
    }

    protected String getSideText(Direction side) {
        return side.func_176610_l().toLowerCase(Locale.ENGLISH);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        if (this.isFieldSideEnabled()) {
            this.dropdownEntries = Arrays.stream(Direction.values()).map(x$0 -> new SideDropdownEntry((Direction)x$0)).collect(Collectors.toList());
            this.dropdownFieldSide = new WidgetTextFieldDropdown(this.field_230712_o_, this.field_147003_i + 106, this.field_147009_r + this.getFieldSideY(), 70, 14, (ITextComponent)new TranslationTextComponent("gui.integrateddynamics.partsettings.side"), true, Sets.newHashSet(this.dropdownEntries));
            this.setSideInDropdownField(this.getCurrentSide());
            this.dropdownFieldSide.func_146203_f(15);
            this.dropdownFieldSide.func_146189_e(true);
            this.dropdownFieldSide.func_146193_g(0xFFFFFF);
            this.dropdownFieldSide.func_146205_d(true);
        }
        if (this.isFieldUpdateIntervalEnabled()) {
            this.numberFieldUpdateInterval = new WidgetNumberField(this.field_230712_o_, this.field_147003_i + 106, this.field_147009_r + this.getFieldUpdateIntervalY(), 70, 14, true, (ITextComponent)new TranslationTextComponent("gui.integrateddynamics.partsettings.update_interval"), true);
            this.numberFieldUpdateInterval.func_146203_f(15);
            this.numberFieldUpdateInterval.func_146189_e(true);
            this.numberFieldUpdateInterval.func_146193_g(0xFFFFFF);
            this.numberFieldUpdateInterval.func_146205_d(true);
            this.numberFieldUpdateInterval.setMinValue(((ContainerPartSettings)this.field_147002_h).getLastMinUpdateValue());
        }
        if (this.isFieldPriorityEnabled()) {
            this.numberFieldPriority = new WidgetNumberField(this.field_230712_o_, this.field_147003_i + 106, this.field_147009_r + this.getFieldPriorityY(), 70, 14, true, (ITextComponent)new TranslationTextComponent("gui.integrateddynamics.partsettings.priority"), true);
            this.numberFieldPriority.setPositiveOnly(false);
            this.numberFieldPriority.func_146203_f(15);
            this.numberFieldPriority.func_146189_e(true);
            this.numberFieldPriority.func_146193_g(0xFFFFFF);
            this.numberFieldPriority.func_146205_d(true);
        }
        if (this.isFieldChannelEnabled()) {
            this.numberFieldChannel = new WidgetNumberField(this.field_230712_o_, this.field_147003_i + 106, this.field_147009_r + this.getFieldChannelY(), 70, 14, true, (ITextComponent)new TranslationTextComponent("gui.integrateddynamics.partsettings.channel"), true);
            this.numberFieldChannel.setPositiveOnly(false);
            this.numberFieldChannel.func_146203_f(15);
            this.numberFieldChannel.func_146189_e(true);
            this.numberFieldChannel.func_146193_g(0xFFFFFF);
            this.numberFieldChannel.func_146205_d(true);
            this.numberFieldChannel.func_146184_c(this.isChannelEnabled());
        }
        TranslationTextComponent save = new TranslationTextComponent("gui.integrateddynamics.button.save");
        this.func_230480_a_((Widget)new ButtonText(this.field_147003_i + 178, this.field_147009_r + 8, this.field_230712_o_.func_243245_a(save.func_241878_f()) + 6, 16, (ITextComponent)save, (ITextComponent)save, this.createServerPressable("button_save", b -> this.onSave()), true));
        this.refreshValues();
    }

    protected int getFieldSideY() {
        return 9;
    }

    protected int getFieldUpdateIntervalY() {
        return 34;
    }

    protected int getFieldPriorityY() {
        return 59;
    }

    protected int getFieldChannelY() {
        return 84;
    }

    protected boolean isFieldSideEnabled() {
        return true;
    }

    protected boolean isFieldUpdateIntervalEnabled() {
        return true;
    }

    protected boolean isFieldPriorityEnabled() {
        return true;
    }

    protected boolean isFieldChannelEnabled() {
        return true;
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (!(this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.func_231042_a_(typedChar, keyCode) || this.isFieldPriorityEnabled() && this.numberFieldPriority.func_231042_a_(typedChar, keyCode) || this.isFieldChannelEnabled() && this.numberFieldChannel.func_231042_a_(typedChar, keyCode) || this.isFieldSideEnabled() && this.dropdownFieldSide.func_231042_a_(typedChar, keyCode))) {
            return super.func_231042_a_(typedChar, keyCode);
        }
        return true;
    }

    public boolean func_231046_a_(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            if (this.isFieldSideEnabled() && this.dropdownFieldSide.func_231046_a_(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.func_231046_a_(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldPriorityEnabled() && this.numberFieldPriority.func_231046_a_(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldChannelEnabled() && this.numberFieldChannel.func_231046_a_(typedChar, keyCode, modifiers)) {
                return true;
            }
            return true;
        }
        return super.func_231046_a_(typedChar, keyCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.isFieldSideEnabled() && this.dropdownFieldSide.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldPriorityEnabled() && this.numberFieldPriority.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldChannelEnabled() && this.numberFieldChannel.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        if (this.isFieldUpdateIntervalEnabled()) {
            this.field_230712_o_.func_238421_b_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.update_interval", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + this.getFieldUpdateIntervalY() + 3), Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.numberFieldUpdateInterval.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.isFieldPriorityEnabled()) {
            this.field_230712_o_.func_238421_b_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.priority", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + this.getFieldPriorityY() + 3), Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.numberFieldPriority.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.isFieldChannelEnabled()) {
            this.field_230712_o_.func_238421_b_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.channel", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + this.getFieldChannelY() + 3), this.isChannelEnabled() ? Helpers.RGBToInt((int)0, (int)0, (int)0) : Helpers.RGBToInt((int)100, (int)100, (int)100));
            this.numberFieldChannel.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.isFieldSideEnabled()) {
            this.field_230712_o_.func_238421_b_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.side", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + this.getFieldSideY() + 3), Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.dropdownFieldSide.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (!this.isChannelEnabled()) {
            GuiHelpers.renderTooltip((ContainerScreen)this, (int)8, (int)87, (int)100, (int)20, (int)mouseX, (int)mouseY, () -> Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.integrateddynamics.partsettings.channel.disabledinfo")}));
        }
    }

    protected boolean isChannelEnabled() {
        return GeneralConfig.energyConsumptionMultiplier > 0;
    }

    protected int getBaseXSize() {
        return 214;
    }

    protected int getBaseYSize() {
        return 191;
    }

    protected void setSideInDropdownField(Direction side) {
        this.dropdownFieldSide.selectPossibility(this.dropdownEntries.get(side.ordinal()));
    }

    public void onUpdate(int valueId, CompoundNBT value) {
        if (this.isFieldSideEnabled() && valueId == ((ContainerPartSettings)this.func_212873_a_()).getLastSideValueId()) {
            int side = ((ContainerPartSettings)this.func_212873_a_()).getLastSideValue();
            this.setSideInDropdownField(side == -1 ? this.getDefaultSide() : Direction.values()[side]);
        }
        if (this.isFieldUpdateIntervalEnabled() && valueId == ((ContainerPartSettings)this.func_212873_a_()).getLastUpdateValueId()) {
            this.numberFieldUpdateInterval.func_146180_a(Integer.toString(((ContainerPartSettings)this.func_212873_a_()).getLastUpdateValue()));
        }
        if (this.isFieldUpdateIntervalEnabled() && valueId == ((ContainerPartSettings)this.func_212873_a_()).getLastMinUpdateValueId()) {
            this.numberFieldUpdateInterval.setMinValue(((ContainerPartSettings)this.func_212873_a_()).getLastMinUpdateValue());
        }
        if (this.isFieldPriorityEnabled() && valueId == ((ContainerPartSettings)this.func_212873_a_()).getLastPriorityValueId()) {
            this.numberFieldPriority.func_146180_a(Integer.toString(((ContainerPartSettings)this.func_212873_a_()).getLastPriorityValue()));
        }
        if (this.isFieldChannelEnabled() && valueId == ((ContainerPartSettings)this.func_212873_a_()).getLastChannelValueId()) {
            this.numberFieldChannel.func_146180_a(Integer.toString(((ContainerPartSettings)this.func_212873_a_()).getLastChannelValue()));
        }
    }

    public class SideDropdownEntry
    implements IDropdownEntry<Direction> {
        private final Direction side;

        public SideDropdownEntry(Direction side) {
            this.side = side;
        }

        @Override
        public String getMatchString() {
            return ContainerScreenPartSettings.this.getSideText(this.side);
        }

        @Override
        public IFormattableTextComponent getDisplayString() {
            if (ContainerScreenPartSettings.this.getDefaultSide() == this.side) {
                return new StringTextComponent(this.getMatchString()).func_240699_a_(TextFormatting.YELLOW);
            }
            return new StringTextComponent(this.getMatchString());
        }

        @Override
        public List<IFormattableTextComponent> getTooltip() {
            return Collections.emptyList();
        }

        @Override
        public Direction getValue() {
            return this.side;
        }
    }
}

